/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef LINES_H
#define LINES_H

#include "buffers.h"
void Lines_Init(const char *fold_mode, const char *hex_mode,
                const char *lines_above, const char *print_set,
                const char *tab_len);
void Lines_Render(BufPtr Buf_ptr, off_t line_num, int lines_above);
void Lines_Set_unused(int status_lines, int rewrite);
int Lines_Height(void);
void Lines_Write(void);
void Lines_Rewrite(void);
void Lines_Remake(void);
void Lines_Expand(void);
int Lines_Toggle(void);
void Lines_Toggle_hls(void);
int Lines_Scroll(int pos_change, int stop_at_eof);
off_t Lines_Line_num(void);
off_t Lines_Off(int row);
off_t Lines_Screen_end_off(void);
off_t Lines_Jump_start_off(void);
int Lines_Cursor_row(void);
int Lines_Move_cursor(int pos_change);
int Lines_Set_cursor(int row);
void Lines_Move_cursor_off(off_t off);
int Lines_Num_diff(int row);
int Lines_At_EOF(void);

void Lines_Kill(void);

enum { DEFAULT_ROW = 0x4000, VCENTER};
#endif /* LINES_H */
