/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef LINENUMS_H
#include "minitrue.h"

/* This structure records the offset where line number line_num begins */
typedef struct
{   off_t line_num;
    off_t off;
} LineLoc;

typedef struct
{   LineLoc far *line_locs; /* Pointer to first line location */
    int nalloc;             /* Number of LineLoc structures allocated */
    int last_i;             /* Index of last LineLoc */
    int know_total;         /* True if last line number is total # of lines */
}LineNums;

void LineNums_init(LineNums *ln);
void LineNums_reset(LineNums *ln);
void LineNums_add(LineNums *ln, off_t num, off_t loc, int last_line);
LineLoc far *LineNums_nearest(LineNums *ln, off_t line_num, off_t off);
LineLoc far *LineNums_last(LineNums *ln);
void LineNums_adjust(LineNums *ln, off_t replace_off, off_t replace_len,
                      off_t len_diff, off_t line_diff);
off_t LineNums_total(LineNums *ln);
void LineNums_kill(LineNums *ln);

enum { NL_CACHE_GAP = 256 }; /* want to cache every 256th line number */

#endif
