/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

/* This structure is used to implement the Boyer Moore algorithm for
 * searching for fixed strings */
#ifndef FIXEDSTR_H
#define FIXEDSTR_H

#include "minitrue.h"

/* The values in the skip table will be represented with chars in 16-bit
 * DOS, ints otherwise. Using integers results in GCC generating better code
 * for the find routine. */
#ifdef __DOS16__
    typedef uchar skip_t;
#else
    typedef unsigned skip_t;
#endif

typedef struct {
    const char *start;     /* points to start of string to search for */
    const char *penult;    /* points to 2nd-to-last char in string */
    size_t len;            /* length of string */
    skip_t far *table;     /* pointer to skip table used to find last
                            *   character of string */
} FixedStr;

/* Maximum length of string which will be found using memchr, all longer
 * strings will be found using the Boyer-Moore algorithm */
enum {MEMCHR_MAX_LEN = 2};

void FixedStr_init(FixedStr *str, const char *src, size_t len);
void FixedStr_kill(FixedStr *str);
char *FixedStr_find(FixedStr *str, const char *scan_start,
                    const char *scan_end);
void FixedStr_Set_max_skip(size_t max_skip);
#endif /* FIXEDSTR_H */
