/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef FILES_H
#define FILES_H

#include <stdio.h>
#include "minitrue.h"
#include "fileops.h"

typedef struct Fil {
    file_t desc;
    const char *name;
    off_t size, nread; /* total # of chars in file & # of chars read */
    int flags;         /* will be set unless UNIX pipe */
    struct Fil *mod;   /* points to structure for modified file */
    fdata_t fdata;     /* data structure for file information */
} Files;

char * *Files_Init(char * *arg_vect, int nargs, int all_args_files,
                   const char *all_files,  const char *backup_ext,
                   const char *keep_fdates, const char *string_fname,
                   const char *recurse_params, const char *unzip_params,
                   const char *fn_file);
Files *Files_Next(void);
const char *Files_name(Files *files);
off_t Files_size(Files *files);
int Files_eof(Files *files);
int Files_seekable(Files *files);
Files *Files_mod(Files *files);
size_t Files_read(Files *files, char *start, size_t len);
size_t Files_mmap(Files *files, char * *start, char * *end);
size_t Files_write(Files *files, const charf *buf, size_t len);
size_t Files_read_off(Files *files, off_t off, charf *buf, int len,
                   off_t *off_ptr, int reset_eof);
void Files_start_mod(Files *files, off_t off,  charf *buf, size_t buf_len);
void Files_close(Files *files);
void Files_Kill(void);
int Files_Have_mmap(void);
int Files_Single(void);
void Files_finish_dir(int skip_sub_dirs);
FILE *Files_String_file(void);
void Files_Unmap(void *start, size_t);

#endif /* FILES_H */
