/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef FILEOPS_H
#define FILEOPS_H

#define UNOPENED -1
typedef int file_t;
#include "minitrue.h"

#ifndef __MSDOS__
#include <sys/stat.h>
#include <dirent.h>
typedef struct stat fdata_t;
DIR *x_opendir(const char *dir_name);
int x_stat(const char *fname, fdata_t *stat_ptr);
int x_fstat(int fdesc, fdata_t *fdata);
int x_lstat(const char *fname, fdata_t *fdata);
#else
#include <dos.h>
typedef struct find_t fdata_t;
int x_findfirst(const char *path, int attr, fdata_t *fdata);
#endif

void FileOps_Init(char *ignore_errors);
const char *FileOps_Get_writeable(const char *fname, int test_writeable,
                                  char *fname_buf, int fname_max);
void set_error_fname(const char *fname);
file_t x_open(const char *fname);
file_t x_creat(const char *fname);
file_t x_fdopen(int filedes);
int x_read(file_t fdesc, charf *buf, int len);
int x_write(file_t fdesc, const charf *buf, int len);
int x_close(file_t fdesc);
int x_rename(const char *oldname, const char *newname);
int x_remove(const char *fname);
off_t x_seek(file_t fdesc, off_t off);
off_t x_seekend(file_t fdesc);
int x_stdout(const char far *ptr, int len);
int x_dup(int fdesc);
int x_dup2(int old_fdesc, int new_fdesc);
int x_isatty(int fdesc);
int x_exists(const char *fname);
int x_clone(const char *fname, fdata_t *st, int copy_ftime);
int x_norm_perms(const char *fname);
char *x_get_dir(const char *fname);
int x_is_runnable(const char *fname);
int x_can_write(const char *fname);
int x_can_write_dir(const char *fname);
int x_get_fattr(const char *fname, fdata_t *fdata);
int x_get_ftime(int fdesc, fdata_t *fdata);
int x_get_drive(void);
int fname_cmp(const char far *fname1, const char far *fname2);
int fname_max(file_t fdesc);
int read_error(const char far *err_msg, const char *fname, int retry);

off_t fdata_size(fdata_t *st);
int fdata_seekable(fdata_t *st, int unzipped);
int fdata_isreg(fdata_t *st);
int fdata_isdir(fdata_t *st);

enum { STD_IN = 0, STD_OUT = 1 };
#endif /* FILEOPS_H */
