/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef DIRWALK_H
#define DIRWALK_H

#include "fileops.h"
#include "resizer.h"
/* This structure contatins information about a particular file */
typedef struct
{
    int name_i;    /* starting index for filename in fnames buffer */
    int name_len;  /* length of filename, includes trailing '\0' */

#ifdef __MSDOS__   /* extract these values from find_t structure */
    long size;     /* size of file */
    char attrib;   /* file attribute */
    unsigned date; /* last modified date */
    unsigned time; /* last modified time */
#else                /* only set these values to prevent statting dir twice*/
    nlink_t nlinks;  /* Number of remaining subdirectories in directory */
    ino_t inode;     /* Inode of directory */
    dev_t dev;       /* device number of file */
#endif
} FInfo;

/* This structure contains information about the current directory level
 * being looked at */
typedef struct
{
    size_t base_name_i;  /* where base name for level begins in path buffer */
    size_t finfo_start;  /* starting index of file info for level */
    size_t finfo_i;      /* current index in file info array */
    size_t fnames_start; /* starting index for level in filenames array */
    size_t subdir_start; /* where subdirs for level begin in subdir buf*/
    size_t subdir_i;     /* current position for subdirectories in subdir buf*/
    int done;            /* Set if remaining files in current directory are to
                          * be skipped. If set to SKIP_SUB_DIRS skip files
                          * in current directory's subdirectories as well */

/* use native structures for directories */
#ifndef __MSDOS__
    int subdirs_left; /* # of subdirectories in left in directory
                       * originally & of hard links to directory - 2 */
#endif
} DirLevel;

/* This struct contains information about all the directory levels
 * traversed */
typedef struct
{
    char *path;       /* path */
    int path_len;     /* length of path */
    int path_alloc;   /* # of bytes allocated for path */
    int path_skip;    /* number of initial characters to skip in path */
    char path_sep_ch; /* Path separator character */
    Resizer levels;   /* level information */
    int level;        /* current subdirectory level */
    int level_min;    /* minimum directory level */
    int level_max;    /* maximum directory level */
    int flags;
    Resizer fnames;   /* resizeable buffer where filenames are stored */
    Resizer finfo;    /* resizeable buffer containing file information */
    Resizer subdirs;  /* buffer where subdirectory names are stored */
    int prev_subdir_i;/* index of file info for previous subdirectory */
 /* These are used to prevent traversing the same dir twice if symlinks
  * followed */
    Resizer dir_inodes; /* inodes of directories traversed */
    Resizer dir_devs;   /* device nos of directories traversed */

} DirWalk;

void DirWalk_init(DirWalk *dw, const char *params, int get_hidden);
int DirWalk_start(DirWalk *dw, char *start_dir, int basename_upcase);
char *DirWalk_next(DirWalk *dw, fdata_t *fdata_ptr, int *got_fdata);
int DirWalk_only_reg(DirWalk *dw);
void DirWalk_finish(DirWalk *dw, int skip_sub_dirs);
void DirWalk_kill(DirWalk *dw);
enum { GOT_FDATA = 1, GOT_FATTR = 2 };

#endif
