/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef CONSOLE_H
#define CONSOLE_H 1
#include "minitrue.h"
#include "attribs.h"
/* This data type  represents the character/attribute pairs in screen memory*/
typedef struct
{   char ch;
    attr_t attr;
}CharAttr;

typedef CharAttr far *ScreenPtr;
void Console_Init(const char *vid_mode);
int Console_Rows(void);
int Console_Cols(void);
int Console_Tty(void);
int Console_Is_color(void);
void Console_Resize(void);
void Console_Write(ScreenPtr line_buf, int row, int start_col,
                   int nchars, int clear_eol);
void Console_Writeln(ScreenPtr line_buf, int row, int end_col);
void Console_Move_cursor(int x, int y);
int Console_Scroll(int scroll_lines, int top_i, int bottom_i);
int Console_Restore(int restore_screen);
void Console_Kill(void);
int Console_Get_key(void);

ScreenPtr LineBuf_Ptr(int line_i);
void LineBuf_putc(ScreenPtr line, int col, char ch, attr_t attr);
int LineBuf_puts(ScreenPtr line, int col, const char far *str, attr_t attr);
int LineBuf_put_nchars(ScreenPtr line, int col, const char far *str,
                       attr_t attr, int nchars);
void LineBuf_clear(ScreenPtr line, int col, attr_t attr);

enum keypad_keys
{   KEYPAD_OFF = 256, UP_KEY = KEYPAD_OFF, DOWN_KEY, LEFT_KEY, RIGHT_KEY,
    PGUP_KEY, PGDN_KEY, HOME_KEY, END_KEY, INS_KEY, DEL_KEY
};

#endif /* Console_H */

