/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef CHARCLAS_H
#define CHARCLAS_H
#include "minitrue.h"
/* This structure represents a set of characters using a 256 byte boolean
 *   array. To save space, 8 character sets will be packed into the 256 byte
 *   array, one for each bit */

typedef struct
{   ucharf *array; /* points to boolean array */
    uchar  bit;    /* which bit in array corresponds to character set */
} CharSet;

#define CharSet_iN(set, ch)    ((set).array[(uchar)(ch)] & (set).bit)
#define CharSet_removE(set,ch) ((set).array[(uns)(ch)] &= (0xff ^ (set).bit))

/* Boolean array for character classes represented by escape sequences */
extern uchar CharSet_Word_set[];

/* Bits in CharSet_Classes corresponding to predefined character classes */
enum set_bits
{   WORD_BIT  = 1, ALPHA_BIT = 2, LOWER_BIT = 4, UPPER_BIT = 8,
    DIGIT_BIT = 16, SPACE_BIT = 32, PUNCT_BIT = 64
};
#define CharSet_in_worD(ch) (CharSet_Word_set[(uchar)(ch)])

void CharSet_Init(const char *word_set);
char *CharSet_init(CharSet *set, const char *src);
char *CharSet_Abbrev(const char *src);
char *CharSet_test(const char *src);
void CharSet_dump(CharSet *set);
void CharSet_kill(CharSet *set);

#endif /* CHARCLAS_H */
