/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef BUFFERS_H
#define BUFFERS_H
#include "minitrue.h"
#include "files.h"
#include "strings.h"
typedef struct
{   charf   *start;      /* start of buffer */
    charf   *end;        /* end of last attempted read */
    charf   *alloc;      /* start of memory allocated for buffer,
                          * if memory mapped, start != alloc */
    charf   *alloc_end;  /* end of memory allocated for buffer */
    char    *mmap;       /* If buffer memmapped, start of mapping, NULL
                          * if not mapped */
    off_t    off;        /* offset of start of buffer */
    size_t  len;         /* # of characters in buffer */
    charf   *curr;       /* current position in buffer */
}Buffer;

typedef Buffer *BufPtr;

void Buffers_Init(size_t strlen_max, const char *binary_params);
BufPtr Buffers_Reset(Files *files);
void Buffers_Load(char * *start, char * *overlap, char * *end, int nrep);
void Buffers_Replace(off_t off, int len, char *replace, int rep_len);
void Buffers_Add_str(int new_str_len);
int Buffers_Apply_fn(off_t start, off_t end,
                     void (*proc_fn)(const charf *, size_t len));
off_t Buffers_Nlines(void);
void Buffers_Record_line(off_t line_num, off_t off, int last_line);
void Buffers_Count_lines(void);
off_t Buffers_Match_off(const char *loc);
off_t Buffers_Match_line_num(const char *loc);
int Buffers_Off_to_pcnt(off_t off);
off_t Buffers_Pcnt_to_off(int pcnt);
void Buffers_Close(void);
void Buffers_Kill(void);

BufPtr BufPtr_set(BufPtr buf_ptr, char far *ch_ptr);
charf *BufPtr_curr(BufPtr buf_ptr);
BufPtr BufPtr_dec(BufPtr buf_ptr);
BufPtr BufPtr_inc(BufPtr buf_ptr);
charf *BufPtr_end(BufPtr buf_ptr);
BufPtr BufPtr_next(BufPtr buf_ptr);
BufPtr BufPtr_goto(off_t off);
off_t BufPtr_off(BufPtr buf_ptr);
int BufPtr_eof(BufPtr buf_ptr);
BufPtr BufPtr_line_num(off_t line_num, off_t off, off_t *line_num_ptr);
BufPtr BufPtr_find_nl(BufPtr buf_ptr, off_t stop_off,
                      off_t nl_num,   off_t *nl_result);
BufPtr BufPtr_str_to_buf(char far *str);
#endif /* BUFFERS_H */
