/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef ATTRIB_H

#define ATTRIB_H 1
typedef char attr_t;
void Attribs_Init(int have_color, int use_tty, const char *colors);
attr_t Attrib(int text_type);

enum text_attrs
{   NORM_ATTR = -5, REV_ATTR, BOLD_ATTR, UL_ATTR, UNKNOWN_ATTR };

enum text_types {
    NORMAL,     /* Default attribute */
    WRAPPED,    /* wrapped around text */
    MATCH,      /* Matched text */
    UNKNOWN_START,  /* text whose line start is out of range */
    SUBST,      /* subsituted text */
    CTRL,       /* Control chars on right side of hex viewer */
    CTRL_MATCH, /* Highlighted control chars on right side of hex viewer */
    EOFILE,     /* End of file */
    SYMB,       /* Special symbols in text ~ at EOF, \ for wrap $ for trunc.*/
    EMPH,       /* Emphasized text */
    UNDERLINED, /* Underlined text */
    STAT_LINE,  /* Status Line attribute */
    REP_TEXT,   /* Replacement text in status line attribute */
    REP_CTRL,   /* Control characters in replacement text */
    CURR_MATCH, /* Current matched string */
    ERR_MSG,    /* Error message */
    PROMPT_TEXT,/* Prompt text */
    ENTERED_TEXT, /* Text typed in by user */
    COMMAND_CH, /* Upper case chars of commands */
    PAREN1,     /* attributes for text in regular expression parentheses */
    PAREN2,     /* Every 4 parens colors will repeat */
    PAREN3,
    NTEXT_TYPES
};
#endif
