/* This is file SYM32.C */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#define SYMADDR 0x90000000			/* compensated for ARENA offset */
#define ARENA	0x10000000
#define NULL	0
#define FALSE	0
#define TRUE	1

typedef unsigned long word32;
typedef long int32;

typedef struct SYMTREE {
  struct SYMTREE *me;
  struct SYMTREE *nleft, *nright, *ndown;
  struct SYMTREE *vleft, *vright, *vdown;
  word32 val;
  word32 type;
  word32 name_len;
  char	 name[1];
} SYMTREE;

#define MAP(p)	    ((SYMTREE *)((word32)(p) - ARENA))
#define UNMAP(p)    ((SYMTREE *)((word32)(p) + ARENA))

void symtree_sort(void)
{
	SYMTREE *sym,*walk,*root,*next;
	char *s1,*s2,done,skipped;
	int32 cval;

	root = MAP(*((SYMTREE **)SYMADDR));
	sym  = root->nleft;
	root->nleft = NULL;
	while(sym != NULL) {
	    sym  = MAP(sym);
	    next = sym->nleft;
	    sym->nleft = NULL;
	    done = skipped = FALSE;
	    walk = root;
	    while(!done) {
		s1 = sym->name;
		s2 = walk->name;
		while(*s1 && (*s1 == *s2)) s1++,s2++;
		cval = (*s1 - *s2);
		if(cval == 0) {
		    if(!walk->val || !sym->val || (walk->val == sym->val)) {
			walk->val  = sym->val;
			walk->type = sym->type;
			skipped = TRUE;
		    }
		    else {
			sym->ndown = walk->ndown;
			walk->ndown = UNMAP(sym);
		    }
		    done = TRUE;
		}
		else if(cval < 0) {
		    if(walk->nleft == NULL) {
			walk->nleft = UNMAP(sym);
			done = TRUE;
		    }
		    else walk = MAP(walk->nleft);
		}
		else {
		    if(walk->nright == NULL) {
			walk->nright = UNMAP(sym);
			done = TRUE;
		    }
		    else walk = MAP(walk->nright);
		}
	    }
	    done = skipped;
	    walk = root;
	    while(!done) {
		cval = sym->val - walk->val;
		if(cval == 0) {
		    sym->vdown = walk->vdown;
		    walk->vdown = UNMAP(sym);
		    done = TRUE;
		}
		else if(cval < 0) {
		    if(walk->vleft == NULL) {
			walk->vleft = UNMAP(sym);
			done = TRUE;
		    }
		    else walk = MAP(walk->vleft);
		}
		else {
		    if(walk->vright == NULL) {
			walk->vright = UNMAP(sym);
			done = TRUE;
		    }
		    else walk = MAP(walk->vright);
		}
	    }
	    sym = next;
	}
	/*
	 * Unused turbo assist int 21H interrupt -- should take us back to real mode
	 * Tried the equivalent of JMPTL G_CTSS (see gdt.inc) before -- did not work (why ??)
	 */
	asm volatile("movl $0xffff,%eax; int $0x21");
}

