@echo off
@rem  The at signs (@) here are necessary.  Leave 'em there.
@ADLF -f ADLFDEMO.BAT
@if errorlevel 5 goto NEFILE
@if errorlevel 4 goto ECALL
@if errorlevel 3 goto EOPT
@if errorlevel 2 goto EARG
@if errorlevel 1 goto EINTR
@goto EXIT
#
# Most of the rest of this file (except the end where the previous labels are
# to be found) is parsed by the ADLF executable and not executed by DOS
# because of the 'goto EXIT' up there.  Stop worrying!  :)
#

# This is an example of ADLF command line.  Pretty ugly huh?
# Not that bad, really.
z~1j1-c0o0u1v1e1k1m12a15d1s0r0w0t63-c0o1u0v1e0k0m8a13d1s4r1w0t63-f1023p7n1-n0

!cls!

# ADLF V1.1 (C) 1994 Daniel Chouinard
# No restrictions on distributions as long as the
# 4 files making this package are not modified in any way.

# Just execute this file to get a short demo of ADLF.
# Make sure that adlfdemo.bat is in your current directory.

# Set debug level to one (Text is echoed on-screen)
i1

# ADLFDEMO.BAT


# ADLF was designed to make programming the ADLib chip as easy as possible,
# even considering the fact that the chip in itself is a bit convoluted.

# ADLF can read its command options and arguments by way of command line
# arguments (like typing "c:\> adlf z") or by reading a file such as this
# one (like typing "c:\> adlf -f adlfdemo.bat").

# The command options and arguments are listed in lower or uppercase
# with spaces, tabs, newlines and carriage returns ignored.

# You can have a look at this file (adlfdemo.bat) for command line syntax
# examples.

x0
z-m0a14d1s1r3t63-o1m2a14d1s1r7t55-g1p4f400n1-n0-x10-f500n1-n0x10-n1f400-n0
!cls!

# You can obtain the whole list of ADLF options and argument ranges by
# typing ADLF by itself.  This is what you'd see

x0
!adlf!
x0
z-m0a14d1s1r5t63-o1m2a14d1s1r6t55-g1p4f600n1-n0
!cls!

# As you saw, most ADLF commands are separated into groups (8).  It is not
# necessary to program all options in a group or progam groups in order.
# The grouping of options is forced by the structure of the FM chip in the
# ADLib (or compatible) card.  For example, programming attack and decay for
# a single operator of a voice channel involves sending a single byte to
# the chip with a nibble representing attack and the other nibble decay.
# (nibbles are four bits, half of a byte).

# So, grouping means that when different characteristics of a channel are
# programmed, all other characteristics of the group should also be put in.
# If you don't, ADLF will supply zero values for all unmentionned options of
# the group.

# If no option of a group is programmed, the whole group won't be, leaving
# it well enough alone.

x0
z-m0a14d1s1r5t63-o1m2a14d1s1r6t55-g1p4f600n1-n0
!cls!


# -Some basics-

# The FM chip has nine (9) channels each made of two operators which
# can work in FM mode (one operator modulates the other) or in additive
# mode (both operator are heard independently).

# This file will not pretend to be a programming example at the bit level
# for the chip.  If you want to get into that, please refer to the file
# SBPROG.DOC written by Jeffrey S. Lee supplied with this package.  And
# please respect the document's copyright policy; Jeff did a darn good
# job of it and should be thanked for that.

# Here we'll only have a look at how to use ADLF to quickly program the FM
# chip with a simple user interface, on a command line or in a data file.

# Let's demonstrate by example.  Right after you...
x0
z-m0a14d1s1r5t63-o1m2a14d1s1r6t55-g1p4f600n1-n0
!cls!


# Let's program a single operator voice of a single channel to produce a
# single, lifeless and dreary tone...  First, let's reset the whole chip.

# This is accomplished by issuing the Z option, which takes no argument
# and the next line is where it happens.
z
# That single Z on the previous line did it (You're not hearing anything
# now, are you?).  It is differentiated from the text in this file by the
# fact that the line it sits on doesn't begin with a hash (#) denoting
# comments.

x0
!cls!


# Now that the chip's reset, let's get on with it.

# Here are the parameters we'll use for the tone:
# Channel 0, operator 0, additive mode, feedback 0, no amplitude modulation,
# no vibrato, EG type set to 0, modulator frequency 1, level key scaling 0,
# total level 45, attack 15, decay 0, sustain 0, release 0, waveform 0
# (sine), octave 4, frequency 400, key depressed, flush all data,
# release key (just like a keyboard synth).

# After you press a key, I'll do it in a single command line.
x0
c0o0g1b0u0v0e0m1l0t45a15d0s0r0w0p4f400n1-n0
# You should be hearing a tone now.
# The options (alphabetic characters) and their arguments (numbers) are all
# there in order.  We'll reset the chip after you've pressed a key.
x0
z
x0
!cls!

# Of course, not all options need be supplied in order to make a sound;
# all zero values can be omitted and not all characteristics are
# necessary.  For example, here's the same sound without all the fluff:
g1m1t45a15p4f400n1-n

# g1    Additive mode on
# m1    Multiplier set to one
# t45   Total level of channel set to 45
# a15   Attack set to maximum
# p4    Channel octave set to 4
# f400  Frequency set to 400
# n1    Depress key (that starts the sound)
# -     Flush current data to chip (End of line also does this)
# n     Un-depress key (let go of it.)  The n option takes an argument but
#       since it is not specified here, it defaults to zero.

# Lots of other stuff is also defaulted here, like which channel and 
# operator we're using (zeros), decay sustain and release (all zeros)...
# Basically, all non-specified channel characteristics are defaulted to zero.

x210zx0 #  <- Shut off the sound after 3 seconds.
!cls!

# Now, let's program the second operator of the same channel to produce a
# tone as well.  First, get the tone back:
c0o0g1b0u0v0e0m1l0t45a15d0s0r0w0p4f400n1-n0
x0
# And next, program operator 1 (as opposed to 0) of channel 0 to the same
# values as operator 0 but with a modulator frequency multiplier of 2
# instead of one.  That'll produce a simple harmonic.
# Right after you...
x0
c0o1m2l0t45a15d0s0r0w0p4f400n1-n0
# There!
x0
# Now if we want to change the pitch of the whole channel we've only to
# set the channel frequency and octave like so...
x0
p4f300-x20-p4f200-x20-p4f500-x20-p4f400
#          ^ Octave     ^ Frequency
# x20 inctroduces a delay of 20/70th of a second.

# Hope that's all clear for you. Next, we'll do the same in FM.
x0
z
!cls!

# To select FM mode, all we've to do is program two operators of the same
# channel and specify FM mode (g0).  Here it is:

c0o0g0b0u0v0e0m1l0t45a15d0s0r0w0-o1m2l0t45a15d0s0r0w0-p4f400n1-n0
x0

# Next, let's change both operators' multipliers...
x0
o0m2-o1m3-x20-o0m4-x20-o1m5-x20-o0m6-x20-o1m7-x20-o0m8-x20-o1m0-x10-o0m1

# Let's change waveforms for operator 0...

o0w1-x35-w2-x35-w3-x35-w0

x0

# And for operator 1...

o1w1-x35-w2-x35-w3-x35-w0

# Next, we'll program Attack, Decay, Sustain and Release to the channel.
x0
!cls!
o0a14d3s7r2-o1a14d3s7r2

#          ADD
#         A   DD
#         A     DD
#        A        SSSSSRRRR
#        A                 RRRR
#       A                      RRRR
#       A                          RRRRR

# Attack (A), Decay (D), Sustain (S) and Release (R) modulate volume levels
# to reflect natural sound production.
# In this case, something close to a bell sound.

x70-p4f200n1-n0-x70-p4f150n1-n0-x70-p4f750n1-n0
x0
!cls!
o0a1d7s7r7-o1a1d7s7r7

#                         AAAA
#                     AAAA    D
#                 AAAA         D
#             AAAA              SSSS
#         AAAA                      R
#     AAAA                           R
# AAAA                                R

# Attack (A), Decay (D), Sustain (S) and Release (R) modulate volume levels
# to reflect natural sound production.

n0-p4f200n1-x170-n0-p4f150n1-x170-n0-p4f750n1
x0
!cls!

# ADLF can also help you develop you own programs by using its
# "Output program code" option (+) to get exact byte-level programming info.
# For an example, I'll do the same single tone of before with this option
# turned on.
z

!adlf +1c0o0g1b0u0v0e0m1l0t45a15d0s0r0w0p4f400n1-n0!
# Those lines can be directly included in C code, all you have to supply
# is the progadlib() function (ADLF.C has it).

x0z
!cls!

# - Vibrato -

# Each operator has a vibrato enable option.  Let's try the tone again with
# vibrato.
zc0o0g1b0u0v0e0m1l0t45a15d0s0r0w0p5f400n1-n0
#          ^^ Now it's off
x0
zc0o0g1b0u0v1e0m1l0t45a15d0s0r0w0p5f400n1-n0
#          ^^ Now it's on

# If you listen carefully, you should hear the tone with a very small amount
# of vibrato (1db).
# There's also a global option for vibrato level.  I'll demonstrate the
# higher level after you...
x0
j1

# You should hear the tone with a substantial amount of vibrato (4.8db).
x0
!cls!
# - Amplitude modulation -

# Each operator has a AM enable option.  Let's try the tone again with
# AM (amplitude modulation.)
zc0o0g1b0u0v0e0m1l0t45a15d0s0r0w0p5f400n1-n0
#        ^^ Now it's off
x0
zc0o0g1b0u1v0e0m1l0t45a15d0s0r0w0p5f400n1-n0
#        ^^ Now it's on

# If you listen carefully, you should hear the tone with a very small
# amount of AM (7 percent).
# There's also a global option for AM level.  I'll demonstrate the
# higher level after you...
x0
~1

# You should hear the tone with a substantial amount of AM (14 percent).
x0
z
!cls!

# That about covers it.


# I haven't even tested the rythm section yet (haven't received dev_kit from
# CL yet) but the code and command options are there and seem to work
# (I don't know how)  Here's an example:

adlf z{1-c7o1a15d12r1t53f70p1w1n1

# Next, just general examples you can cut and paste in your batch files.

x0
!cls!

# This one I like to put before loading huge programs as a background.

z-mt63a15sr1-o1m5t63a15s-b4p2f162n1-n
x0
!cls!

#                             Goin' bananas...

x0
c0t50a8d2s7r7m4-o1t50a8d2s7r7m2
c1t50a8d2s7r7m4-o1t50a8d2s7r7m2
c2t50a8d2s7r7m4-o1t50a8d2s7r7m2
c3t50a8d2s7r7m4-o1t50a8d2s7r7m2
c4t50a8d2s7r7m4-o1t50a8d2s7r7m2
c0n-b1f200p4n1-c1n-b1f100p4n1-c2n-b1f150p4n1-c3n-b1f303p4n1-c4n-b1f252p4n1
x4c0n-f200p3n1-x4c1n-f100p3n1-x4c2n-f150p3n1-x4c3n-f303p3n1-x4c4n-f252p3n1
x4c0n-f134p3n1-x4c1n-f345p3n1-x4c2n-f561p3n1-x4c3n-f732p3n1-x4c4n-f821p3n1
x4c0n-f175p3n1-x4c1n-f531p3n1-x4c2n-f361p3n1-x4c3n-f112p3n1-x4c4n-f654p3n1
x4c0n-f461p3n1-x4c1n-f603p3n1-x4c2n-f412p3n1-x4c3n-f950p3n1-x4c4n-f252p3n1
x4c0n-f087p3n1-x4c1n-f387p3n1-x4c2n-f475p3n1-x4c3n-f641p3n1-x4c4n-f999p3n1
x4c0n-f200p3n1-x4c1n-f301p3n1-x4c2n-f402p3n1-x4c3n-f251p3n1-x4c4n-f604p3n1
x0
!cls!

#                             NASA BEEP


# Here's one I worked very hard to get right.  I was watching a tape of an
# Appolo mission and thought: "I want that beep!".  You know, the very
# specific beep NASA uses in between transmissions.
# It involved a lot of replaying, rewinding and pausing.


z-m4a10t55k1-p5f410g1n1-x18-d10r10n

# I'll do it again after you...
x0
z-m4a10t55k1-p5f410g1n1-x18-d10r10n

# If you're old enough, it should have rung a bell.
x0
!cls!

#                              Woo-woo:
z
c0o0e1m1t30a15d1s1r0g0w0-e1c0o1w0m15t63a15d1s1r0-p1f160n1-n0
c1o0e1m1t30a15d1s1r0g0w0-e1c1o1w0m15t63a15d1s1r0-p1f161n1-n0
c2o0e1m1t40a15d1s1r0g0w0-e1c2o1w0m15t45a15d1s1r0-p1f481n1-n0
c3o0e1m1t40a15d1s1r0g0w0-e1c3o1w0m15t45a15d1s1r0-p1f483n1-n0
c4o0e1m15t40a15d1s1r0g1w0-p1f320n1-n0
c5o0e1m15t63a15d1s1r0g0w0-e1c5o1w0m1t10a15d1s1r0-b4p1f643n1-n0

# "What, pray tell, is a woo-woo?" you ask?

# Woo-Woo: n. m. : Bruit de fond que l'on peut entendre dans un film de
# science fiction  petit budget lorsque le hro accde  la chambre des
# gnratrices d'un vaisseau spacial et que le suspense (subjectif) est
#  son plus haut.  L'effet est habituellement nul.

x0
!cls!

#                                Wang!
z
m2a14d1s0r1e1t45-o1m3a14d1s0r1e1t45
c1m2a14d1s0r1e1t45-o1m3a14d1s0r1e1t45
c2m2a14d1s0r1e1t45-o1m1a14d1s0r1e1t45
c3m2a14d1s0r1e1t45-o1m4a14d1s0r1e1t45
c4m2a14d1s0r1e1t45-o1m4a14d1s0r1e1t45
c5m2a14d1s0r1e1t45-o1m4a14d1s0r1e1t45
g1p4f200n1-c1g1p4f301n1-c2g1p4f201n1-c3p4f149n1-c4p4f187n1
c5p4f202n1


# Wang: n.m.: Voir Woo-woo.

x0
z
!cls!


#           Thump-thump... (Stark Trek (Old Series) sickbay monitor)
zu1v1m0a14d5s4r1w0t52
o1e1k1m0a14d5s1r6w0t61
p1f736g0n1-x70-n0-n1-x70-n0-n1-x70-n0-n1

# When I'll change ADLF into a TSR (Not likely this century) we'll be able
# to have sounds like this one going in the background.  That'd be so neat!
# (and nerdy)

x0
!cls!



#                     Another Star Trek sound; tricorder.

zv1m9a14s0w2t50-j1f430p7n1g1

# "Well, Spock?" - (C)MMCCXXVII Kirk, James T.
x0
z
# Vous n'avez rien vu!
!cls!

#              Another Star Trek sound; M5 Computer background.

z
e1c0o0m1t30a15d1s1r0g0w0-e1c0o1w0m15t63a15d1s1r0-p0f160n1-n0
e1c1o0m1t30a15d1s1r0g0w0-e1c1o1w0m15t63a15d1s1r0-p0f162n1-n0

# If you're not hearing anything right now, it's because this sound is
# very low in frequency and your sound system sucks.

x0
!cls!
z
c0o0m1t63a15d1s1r1e0w0-o1m15t60a15d1s1r1e0-p0f300n1-n0

# Flying saucer
x0
!cls!

#                          Double oscillator sweep
z
c0m15t55a15g1-f200n1-n0
c1m15t55a15g1-f200n1-n0
c0f200x2-c1f1000x2-c0f210x2-c1f990x2-c0f220x2-c1f980x2-c0f230x2-c1f970x2-c0f240x2-c1f960x2-c0f250x2-c1f950
c0f260x2-c1f940x2-c0f270x2-c1f930x2-c0f280x2-c1f920x2-c0f290x2-c1f910x2-c0f300x2-c1f900x2-c0f310x2-c1f890
c0f320x2-c1f880x2-c0f330x2-c1f870x2-c0f340x2-c1f860x2-c0f350x2-c1f850x2-c0f360x2-c1f840x2-c0f370x2-c1f830
c0f380x2-c1f820x2-c0f390x2-c1f810x2-c0f400x2-c1f800x2-c0f410x2-c1f790x2-c0f420x2-c1f780x2-c0f430x2-c1f770
c0f440x2-c1f760x2-c0f450x2-c1f750x2-c0f460x2-c1f740x2-c0f470x2-c1f730x2-c0f480x2-c1f720x2-c0f490x2-c1f710
c0f500x2-c1f700x2-c0f510x2-c1f690x2-c0f520x2-c1f680x2-c0f530x2-c1f670x2-c0f540x2-c1f660x2-c0f550x2-c1f650
c0f560x2-c1f640x2-c0f570x2-c1f630x2-c0f580x2-c1f620x2-c0f590x2-c1f610x2-c0f600x2-c1f600x2-c0f610x2-c1f590
c0f620x2-c1f580x2-c0f630x2-c1f570x2-c0f640x2-c1f560x2-c0f650x2-c1f550x2-c0f660x2-c1f540x2-c0f670x2-c1f530
c0f680x2-c1f520x2-c0f690x2-c1f510x2-c0f700x2-c1f500x2-c0f710x2-c1f490x2-c0f720x2-c1f480x2-c0f730x2-c1f470
c0f740x2-c1f460x2-c0f750x2-c1f450x2-c0f760x2-c1f440x2-c0f770x2-c1f430x2-c0f780x2-c1f420x2-c0f790x2-c1f410
c0f800x2-c1f400x2-c0f810x2-c1f390x2-c0f820x2-c1f380x2-c0f830x2-c1f370x2-c0f840x2-c1f360x2-c0f850x2-c1f350
c0f860x2-c1f340x2-c0f870x2-c1f330x2-c0f880x2-c1f320x2-c0f890x2-c1f310x2-c0f900x2-c1f300x2-c0f910x2-c1f290
c0f920x2-c1f280x2-c0f930x2-c1f270x2-c0f940x2-c1f260x2-c0f950x2-c1f250x2-c0f960x2-c1f240x2-c0f970x2-c1f230
c0f980x2-c1f220x2-c0f990x2-c1f210x2-c0f1000x2-c1f200
x0
z
!cls!

#                      FM distortion (the whole spectrum)

z~1j1-c0o0u1v1e1k1m12a15ds0r0w0t55-c0o1u0v1e0k0m8a13dsrw0t55-f1023p7n1
p7f0-x5p7f4-x5p7f8-x5p7f12-x5p7f16-x5p7f20-x5p7f24-x5p7f28x5
p7f32-x5p7f36-x5p7f40-x5p7f44-x5p7f48-x5p7f52-x5p7f56-x5p7f60x5
p7f64-x5p7f68-x5p7f72-x5p7f76-x5p7f80-x5p7f84-x5p7f88-x5p7f92x5
p7f96-x5p7f100-x5p7f104-x5p7f108-x5p7f112-x5p7f116-x5p7f120-x5p7f124x5
p7f128-x5p7f132-x5p7f136-x5p7f140-x5p7f144-x5p7f148-x5p7f152-x5p7f156x5
p7f160-x5p7f164-x5p7f168-x5p7f172-x5p7f176-x5p7f180-x5p7f184-x5p7f188x5
p7f192-x5p7f196-x5p7f200-x5p7f204-x5p7f208-x5p7f212-x5p7f216-x5p7f220x5
p7f224-x5p7f228-x5p7f232-x5p7f236-x5p7f240-x5p7f244-x5p7f248-x5p7f252x5
p7f256-x5p7f260-x5p7f264-x5p7f268-x5p7f272-x5p7f276-x5p7f280-x5p7f284x5
p7f288-x5p7f292-x5p7f296-x5p7f300-x5p7f304-x5p7f308-x5p7f312-x5p7f316x5
p7f320-x5p7f324-x5p7f328-x5p7f332-x5p7f336-x5p7f340-x5p7f344-x5p7f348x5
p7f352-x5p7f356-x5p7f360-x5p7f364-x5p7f368-x5p7f372-x5p7f376-x5p7f380x5
p7f384-x5p7f388-x5p7f392-x5p7f396-x5p7f400-x5p7f404-x5p7f408-x5p7f412x5
p7f416-x5p7f420-x5p7f424-x5p7f428-x5p7f432-x5p7f436-x5p7f440-x5p7f444x5
p7f448-x5p7f452-x5p7f456-x5p7f460-x5p7f464-x5p7f468-x5p7f472-x5p7f476x5
p7f480-x5p7f484-x5p7f488-x5p7f492-x5p7f496-x5p7f500-x5p7f504-x5p7f508x5
p7f512-x5p7f516-x5p7f520-x5p7f524-x5p7f528-x5p7f532-x5p7f536-x5p7f540x5
p7f544-x5p7f548-x5p7f552-x5p7f556-x5p7f560-x5p7f564-x5p7f568-x5p7f572x5
p7f576-x5p7f580-x5p7f584-x5p7f588-x5p7f592-x5p7f596-x5p7f600-x5p7f604x5
p7f608-x5p7f612-x5p7f616-x5p7f620-x5p7f624-x5p7f628-x5p7f632-x5p7f636x5
p7f640-x5p7f644-x5p7f648-x5p7f652-x5p7f656-x5p7f660-x5p7f664-x5p7f668x5
p7f672-x5p7f676-x5p7f680-x5p7f684-x5p7f688-x5p7f692-x5p7f696-x5p7f700x5
p7f704-x5p7f708-x5p7f712-x5p7f716-x5p7f720-x5p7f724-x5p7f728-x5p7f732x5
p7f736-x5p7f740-x5p7f744-x5p7f748-x5p7f752-x5p7f756-x5p7f760-x5p7f764x5
p7f768-x5p7f772-x5p7f776-x5p7f780-x5p7f784-x5p7f788-x5p7f792-x5p7f796x5
p7f800-x5p7f804-x5p7f808-x5p7f812-x5p7f816-x5p7f820-x5p7f824-x5p7f828x5
p7f832-x5p7f836-x5p7f840-x5p7f844-x5p7f848-x5p7f852-x5p7f856-x5p7f860x5
p7f864-x5p7f868-x5p7f872-x5p7f876-x5p7f880-x5p7f884-x5p7f888-x5p7f892x5
p7f896-x5p7f900-x5p7f904-x5p7f908-x5p7f912-x5p7f916-x5p7f920-x5p7f924x5
p7f928-x5p7f932-x5p7f936-x5p7f940-x5p7f944-x5p7f948-x5p7f952-x5p7f956x5
p7f960-x5p7f964-x5p7f968-x5p7f972-x5p7f976-x5p7f980-x5p7f984-x5p7f988x5
p7f992-x5p7f996-x5p7f1000-x5p7f1004-x5p7f1008-x5p7f1012-x5p7f1016-x5p7f1020x5
z
x0
!cls!

#                                Falling:

zg1w0m3t63a10d8sr8-p2f1023n1
x5n-n1f1023-x5n-n1f1003-x5n-n1f983-x5n-n1f963-x5n-n1f943-x5n-n1f923
x5n-n1f903-x5n-n1f883-x5n-n1f863-x5n-n1f843-x5n-n1f823-x5n-n1f803
x5n-n1f783-x5n-n1f763-x5n-n1f743-x5n-n1f723-x5n-n1f703-x5n-n1f683
x5n-n1f663-x5n-n1f643-x5n-n1f623-x5n-n1f603-x5n-n1f583-x5n-n1f563
x5n-n1f543-x5n-n1f523-x5n-n1f503-x5n-n1f483-x5n-n1f463-x5n-n1f443
x5n-n1f423-x5n-n1f403-x5n-n1f383-x5n-n1f363-x5n-n1f343-x5n-n1f323
x5n-n1f303-x5n-n1f283-x5n-n1f263-x5n-n1f243-x5n-n1f223-x5n-n1f203x5-z
x0
!cls!

# As an added bonus, ADLF has ten internal preprogrammed sounds that can
# executed simply by calling ADLF -0, ADLF -1, ADLF -2, ... , ADLF -9.
# Here they are:

!adlf -0!
x0
!adlf -1!
x0
!adlf -2!
x0
!adlf -3!
x0
!adlf -4!
x0
!adlf -5!
x0
!adlf -6!
x0
!adlf -7!
x0
!adlf -8!
x0
!adlf -9!
x0
!cls!

# If anything, ADLF is useful for those times when you abnormally quit
# a program that has gone beserk and left the FM chip screaming like
# a small group of horny banshees (like that last "Emergency Broadcasting
# system test").  That's when the z option is useful.
z
x0
!cls!

# Well, goodbye!

# I hope you enjoy ADLF.  For the next release I'll try to gather
# enough information to add SBPro and SB16 support, Musical notation
# (F#,A,B,...), full rythm support, and a better command language

# If you want to contact me I can be reached at:
# ( Suggestions, critiques, comments, flames, marriage proposals )

#   Internet: daniel@cam.org  (Checked almost daily)
#   CIS:      74271,1465      (Checked weekly)
#   Phone:    (514) 768-6290 (Please! EST 18:00-22:00, not collect)
#             Don't call after Sep. 15th 1994 cuz there's a good
#             chance I will have moved by then.  I plan to keep my
#             Internet account for a good while longer though.


~1j1-v1u1m2a14d4s3r4w0t55-v1u1o1m3a14d4s3r4w0t50-g1f768p2n1-x64
n0-n1-x32 n0-n1m4-x128 n0-n1m2-x64 n0-n1m4-x32 n0-n1m5-x128 n0-n1m4-x64
n0-n1m5-x32 n0-n1m6-x64 n0-n1m5-x64 n0-n1m4-x32 n0-n1m2-x128 n0-n1m2-x64
n0-n1m2-x32 n0-n1m4-x128


@@ <- Those two at-signs stop file execution.
:NEFILE
echo.
echo File not found.
goto EXIT
:ECALL
echo.
echo Calling error, see usage.
goto EXIT
:EOPT
echo.
echo Option error.
goto EXIT
:EARG
echo.
echo Argument error
goto EXIT
:EINTR
echo.
echo Pressed ^C, Darn.
goto EXIT
:exit
echo.
echo                           Ŀ
echo                            ADLFDEMO.BAT is finished 
echo                           
echo.
adlf z~1j1-u1v1e1k1m1a15drwt63-o1uv1ekm2a13dr1wt63-f1023p6n1-n
