  
PAGE  60,132
  
  
VSTlow          equ     0A8h
VSThigh         equ     0AAh
  
code_seg_a      segment
                assume  cs:code_seg_a, ds:code_seg_a
  
  
                org     100h
  
loadfont        proc    far
  
start:
                jmp     initialize
;
;Video Save table
;
vidSavTab       db      8 dup (0)
VSTacspLo       dw      0
VSTacspHi       dw      0
                db      16 dup (0)
;
;Alternate Character Set Overide Table
;
ACStab:
ACScharLen      db      ?              ;# bytes in each char defn (=rows of dots)
ACSbank         db      0              ;character generator bank
ACScount        dw      0100h          ;count of characters defined
ACSfirst        dw      0000h          ;first character defined
ACStabLo        dw      0
ACStabHi        dw      0
ACSrows         db      19h            ;# of rows per screen
ACSmodes        db      3, 0FFh        ;allowable video modes; just co80
;
; Alternate Character Set Definitions
;
ACSdefs         db      4096 dup (0)
transientArea   equ     $
errNoArgument:
                mov     bx,1
                mov     cx,lenText4
                mov     dx,offset Text4
                mov     ah,40h
                int     21h
                mov     bx,1
                mov     cx,lenText1
                mov     dx,offset Text1
                mov     ah,40h
                int     21h
                mov     ax,4c01h
                int     21h

errFindFile:
                mov     bx,1
                mov     cx,lenText4
                mov     dx,offset Text4
                mov     ah,40h
                int     21h
                mov     bx,1
                mov     cx,lenText3
                mov     dx,offset Text3
                mov     ah,40h
                int     21h
                mov     bx,1
                mov     cx,lenFileName
                mov     dx,begFileName
                mov     ah,40h
                int     21h
                mov     ax,4c01h
                int     21h

errBadRead:
                mov     bx,1
                mov     cx,lenText4
                mov     dx,offset Text4
                mov     ah,40h
                int     21h
                mov     bx,1
                mov     cx,lenText5
                mov     dx,offset Text5
                mov     ah,40h
                int     21h
                mov     ax,4c01h
                int     21h

initialize:
                cld                                             ; Clear direction

                mov     cl,ds:080h
                or      cl,cl
                je      errNoArgument
                xor     ch,ch                                   ; Zero register
; terminate filename with a null
                mov     si,cx
                mov     byte ptr ds:081h[si],0
; locate beginning of file name
                mov     si,0FFFFh

locloop_8:
                inc     si
                cmp     byte ptr ds:081h[si],20h
                loope   locloop_8

                cmp     cx,0
                jne     continue0
                jmp     errFindFile
continue0:      add     si,081h
                mov     begFileName,si
                inc     cx
                mov     lenFileName,cx
; try to open requested file
                mov     ax,3d00h
                mov     dx,begFileName
                int     21h
                jnc     continue1
                jmp     errFindFile
; try to read font data
continue1:      mov     bx,ax
                mov     hndInput,ax
                mov     ah,03fh
                mov     cx,1000h
                mov     dx,offset ACSdefs
                int     21h
                jc      errBadRead                      ;read error?
                or      ax,ax                           ;0 chars read?
                jz      errBadRead
                mov     ACScharLen,ah                   ;bytes/char=Total bytes/256
; close file
                mov     ah,03eh
                mov     bx,hndInput
                int     21h
                mov     ax,40h
                mov     es,ax
                lds     si,dword ptr es:VSTlow
                mov     di,offset vidSavTab
                mov     es:VSTlow,di
                mov     es:VSThigh,cs
                push    cs
                pop     es
                mov     cx,0Eh
                rep     movsw                                   ; Rep while cx>0 Mov [si] to es:[di]
                push    cs
                pop     ds
                mov     VSTacspLo,offset ACStab
                mov     VSTacspHi,cs
                mov     ACStabLo,offset ACSdefs
                mov     ACStabHi,cs
                mov     al,03h
                mov     ah,0
                int     10h                                     ; Video display   ah=functn 00h
; announce successful load                                      ;  set display mode in al
                mov     bx,1
                mov     cx,lenText0
                mov     dx,offset Text0
                mov     ah,40h
                int     21h
; tell which file was loaded
                mov     bx,1
                mov     cx,lenFileName
                mov     dx,begFileName
                mov     ah,40h
                int     21h
                mov     dx,offset transientArea
                int     27h                                     ; Terminate & stay resident


begFileName     dw      ?
lenFileName     dw      ?
hndInput        dw      ?
Text0           db      'Load Font 1.0, by luitje@m-net.arbornet.org; loaded '
lenText0        equ     $-Text0
Text1           db      'usage: loadfont filename'
lenText1        equ     $-Text1
Text3           db      'Couldn',27h,'t open file: '
lenText3        equ     $-Text3
Text4           db      'Load Font 1.0, by luitje@m-net.arbornet.org',0dh,0ah
lenText4        equ     $-Text4
Text5           db      'Couldn',27h,'t read font data'
lenText5        equ     $-Text5
                           
loadfont        endp

code_seg_a      ends

                end     start
