/*
 *		NAME:	DRAW DEMOS for VOX 3.0
 *		DATE:	24/3/1994
 *		FROM:	Stefano Frongillo - via Fermi,10 - 4005 Castenaso (BO) ITALIA
 */
#include <stdio.h>
#include <window.h>
#include <vox3.h>
#include <conio.h>

WINDOW *wwait;
WINDOW *w1;
void Game();

void Wwait()
{
	static opened=FALSE;

	if (!opened) {
		wwait=wopen(5,21,70,3," Sampling ");
		opened=TRUE;
		}
	else
		wactivate(wwait);
	wprintf("\n");
	while (SbStatus) {
		delay(15);
		wprintf("");
		}
	wprintf("\n");
}

Main()
{
	int k;
	char *basename="draw3";
	BOOL ext=FALSE;

	switch (argc-1) {
		case 1:
			basename=argv[1];
		default:
			printf("\
\n\[1mDrawing Demo for VOX 3.2[0m\n\
\n\
Use: DRAW [<voxbase>] \n");
	}

	if (winit(80,25,10,1000)==NULL)
		PANIC("winit() failed");

	clrscr();
	if ((w1=wopen(3,2,76,18," Drawing demo for VOX 3.2 - Stefano Frongillo, 1996 "))==NULL)
		PANIC("wopen() failed");

	if (InitVox(Wwait))
		PANIC("Initvox() failed");

	VX_PREC=60;

	wactivate(w1);
	wprintf("Loading voxbase...");
	if (LoadVoxBase(basename)==-1)
		PANIC("LoadVoxBase() failed");
	wputs("Ok.");

	Game();

	DeInitVox();
	wclose();
	wexit();
}

void Game()
{
	int i,x,xx,y,yy,ext,g, prevg;
	char c,c2;
	BOOL	continuos=FALSE;
	WINDOW *wg;

	gotoxy(1,1);
	wprintf("Use [%s, %s, %s, %s] to draw lines\n\
Use [%s] to advance plot\n\
Use [%s] (or press any key) to exit.\n",VX_WORD[0],VX_WORD[1],VX_WORD[2],VX_WORD[3],VX_WORD[4],VX_WORD[5]);

	ext=FALSE;
	xx=x=33;
	yy=y=10;
	c='';
	c2='';
	gotoxy(x,y);
	wputc(c);

	while ((g != VX_KEYSTOP)&&!ext) {
		wactivate(w1);
		gotoxy(20,5);
		wprintf("Ok, just tell me where to go...  ");

		g=SenseVox();

		if (g>=0) {
			wactivate(w1);
			gotoxy(20,5);
			wprintf("Accept \"%s\"...",VX_WORD[g]);

			if (g==4)
				g=prevg;
			else
				prevg=g;

			{
				wactivate(w1);
				switch(g) {
				case 0:	//right
					x++;
					switch (c!=''?c:c2) {
						case '':
							c2=''; break;
						case '':
							c2=''; break;
						case '':
							break;
						default:
							c2='';
					}
					c='';
					break;
				case 1:  //left
					x--;
					switch (c!=''?c:c2) {
						case '':
						case '':
							c2=''; break;
						case '':
						case '':
							c2=''; break;
						case '':
							break;
						default:
							c2='';
					}
					c='';
					break;
				case 2:  //up
					y--;
					switch (c!=''?c:c2) {
						case '':
							c2=''; break;
						case '':
							c2=''; break;
						case '':
							break;
						default:
							c2='';
					}
					c='';
					break;
				case 3:  //down
					y++;
					switch (c!=''?c:c2) {
						case '':
							c2=''; break;
						case '':
							c2=''; break;
						case '':
							break;
						default:
							c2='';
					}
					c='';
					break;
				case 4:  //avanti
					continuos=TRUE;
					break;
				case 5:  //fine
					ext=TRUE;
					c='X';
					break;
				}

				gotoxy(xx,yy);
				wputc(c2);
				gotoxy(x,y);
				wputc(c);
				xx=x; yy=y;
				gotoxy(1,2);
			}
			SOUND(400,20);
			delay(500);

			}
		}
	gotoxy(20,5);
	wprintf("Press any key to exit...");
	getch(); /* svuota il buffer di tastiera */
}

