/*
 *		NAME: ALPHA3 - demo program for VOX 3.0 basic routins
 *		DATE: 24/3/1994
 *		FROM: Stefano Frongillo (e-mail:frongill@cs.unibo.it)
 */
#include <stdio.h>
#include <window.h>
#include <vox3.h>
#include <conio.h>

WINDOW *wwait;

void Wwait()
{
	static opened=FALSE;

	if (!opened) {
		wwait=wopen(5,21,70,3," Sampling ");
		opened=TRUE;
		}
	else
		wactivate(wwait);
	wprintf("\n");
	while (SbStatus) {
		delay(15);
		wprintf("");
		}
	wprintf("\n");
}

Main()
{
	int k;
	char *basename;
	WINDOW *w1;
	BOOL ext=FALSE,woff=FALSE;

	printf("\n[1mAlpha3 - demo programs for VOX 3.0[0m\n\nUse: ALPHA3 [<voxbase [WOFF]]\n\n");

	(argc>1)?(basename=argv[1]):(basename="alpha3");
	woff=(argc>2);

	if (winit(80,25,10,1000)==NULL)
		PANIC("winit() failed");

	clrscr();
	if ((w1=wopen(3,2,76,18," Alphabet, a demo for "VX_VER" - Stefano Frongillo, 1994 "))==NULL)
		PANIC("wopen() failed");

	if (InitVox(woff?NULL:Wwait))
		PANIC("InitVox() failed");


	wactivate(w1);
	wprintf("Loading voxbase \"%s\"...",basename);
	if (LoadVoxBase(basename)==-1)
		PANIC("LoadVoxBase() failed");

	wprintf(" (meth.%d prec.=%d)\n",VX_METHOD,VX_PREC);
	wprintf("Ok.\n\nTell me what... (press a key to exit)\n\n>");

	while (!kbhit() && !ext) {
		k=SenseVox();
//		while(!kbhit() && ((k=GoVox())==-1));
		BEEP;
		wactivate(w1);
		wtextcolor(WHITE,CYAN);
		switch(k){
		case 26:
			wprintf("\n>");
		CASE 27:
			gotoxy(wherex()-1,wherey());
			wprintf(" ");
			gotoxy(wherex()-1,wherey());
		CASE 28:
			wprintf("_");
		CASE VX_KEYSTOP:
			ext=TRUE;
		CASE VX_NOVOICE:
		DEFAULT:
			wprintf("%c",'a'+k);
			}
		}

	wprintfto(w1,"\n\nPress SPACE to exit...");
	while (getch()!=' ');

	DeInitVox();

	wclose();
	wexit();
}
