;SVC - Sound Volume Changer 2.20mk
;Made by Shielden - November 21st, 1996

;-------------------------------------------------------
;From now on, July 25th - 1997, the program is now named
;Sound Volume Control. I never liked the old name! ;).
;-------------------------------------------------------

;Some explanations for the operations that SVC will do
;to get and use the given number.

;All characters typed after the program's name are placed at a
;memory segment called PSP (Program Segment Prefix). That section's
;purpose is to give information about several things of the machine.

;The PSP starts at offset CS:0000h. On this program we will use three things
;the PSP holds:
;At address 2Ch it contains the address of the environment, which
;we will use to look for the BLASTER variable.
;At 81h, there are all the characters typed on the command line after the
;program's name. It's first character is normally a space (it is counted too).
;The maximum character count is 127. The string ends with a 0Dh.
;And at 80h, there's a count of the characters typed after the program's name. It counts the space
;That byte counts the space between the program's name and the characters.

;The idea to get the numbers in PSP (Program Segment Prefix) is to do
;this formula:
;Assuming that we executed something like SVC 168

;We get one number and substract 30h from it (remember: the hex values
;for the numbers are from 30h (0) to 39h (9)).
;The resulting value will be the one we placed at the command line
;(i.e. 6 --> 36h - 30h = 6)

;The calculation then will be:

;1 ---- (A) ---- 1 * 100 = 100 +
;6 ---- (B) ---- 6 *  10 =  60 +
;8 ---- (C) ---- 8 ----- =   8
;-----------------------------
;                    (D) = 168 = A8 --> Use it.

;If we typed a Two digit value, then the program will skip (A) and start
;from (B), and if we type a One digit number, it starts from (C).

;UPDATE!: It now verifies each character to see if it is really a number, and
;	  not a letter we can't use. It verifies too if we put many
;	  characters (more than 3 are not allowed).
;UPDATE 2!: Now gives ErrorLevels, so it can be used from within Batch files.
;	    Optimized code too.
;UPDATE 3!: Optimized a LOT of code.
;UPDATE 4!: Optimized the speed and size of the program (STOSW).
;UPDATE 5!: Optimized the speed and size of the program (LODSB).
;MAJOR UPDATE 6!: When changing the volume the program shows what Volume
;		  Value did it put. Optimized the code through the use of
;		  PTRs (I've learned about them today).
;UPDATE 7!: Increased the speed and reduced the COM's size in five bytes
;	    through optimization at the program's starting code.
;UPDATE 8!: More optimization. COM's size reduced in 8 bytes.
;MAJOR UPDATE 9!: The PREPARE_TO_WRITE_MSG function can now address ANY video
;		  mode. Formerly, it could only address 80 column modes.
;MAJOR UPDATE 10!: The PREPARE_TO_WRITE_MSG and SHOWMSG functions can now
;		   work with monochrome displays too.
;MAJOR UPDATE 11!: Added the routine GET_RIGHT_PORT, which detects the
;		   BLASTER environment variable and uses the specified port
;		   address to change the volume. Uff! that part was Veeerrry
;		   Hard!.
;ULTRA MAJOR UPDATE 12!: I have achieved a complete restructuration of the
;			 source code. The program now occupies about 300
;			 bytes more now but it has the capability to be
;			 updated without getting a headache too.
;NUCLEAR UPDATE 13!: On December 28th I made the second engine, which
;		     contained the Interface. Today, after some vacations at
;		     the beach, I have combined that engine with old SVC's
;		     one. This program is almost finished!.
;NUCLEAR UPDATE 14!: On January 6th, 7th and 8th, I've been working on a
;		     new Interface code. Now it works with EVERY text mode
;		     screen (formerly, it saved the old video mode, switched
;		     to mode 03h, and then restored the old one). Also, the
;		     Interface now has it's shadow (like Norton Utilities) and
;		     restores the overwrited characters.
;		     Uff!. It costed me an eye, but I've learned a lot about
;		     segments with this one.
;UPDATE 15!: Added a routine (made by me, of course) to center the interface
;	     on the screen. It works with ALL video modes. Added other minor
;	     changes.
;MAJOR NUCLEAR UPDATE 16!: Almost totally renewed!. Added ability to control
;			   CD Audio volume, a help screen! and, most of all,
;			   I completely remade the parameter engines!. Oof!,
;			   you have to try it now, I feel like a hero!.
;UPDATE 17!: Updated 2/3 of the shadowing routine. Now it's the BEST routine
;	     you can find to shade characters.
;UPDATE 18!: Added a pair of control routines for the Base Address.

;Created on November 21st, 1996. ---------------- Finished at  9:48 am.
;UPDATE 2 --------------------------------------- Finished at 10:19 am.
;UPDATE 3 --------------------------------------- Finished at  1:22 pm.
;UPDATE 4 --------------------------------------- Finished at  5:05 pm.
;UPDATE 5 --------------------------------------- Finished at  6:31 pm.
;MAJOR UPDATE 6 ---------- November 23rd, 1996. - Finished at  5:23 pm.
;UPDATE 7 --------------------------------------- Finished at 10:10 pm.
;UPDATE 8 ---------------- November 25th, 1996 -- Finished at  7:32 pm.
;MAJOR UPDATE 9 ---------- November 27th, 1996 -- Finished at  2:17 pm.
;MAJOR UPDATE 10 --------- December 2nd, 1996 --- Finished at 12:40 am.
;						  (I'm gonna sleep)
;MAJOR UPDATE 11 --------- December 5th, 1996 --- Finished at 10:37 pm.
;ULTRA MAJOR UPDATE 12 --- December 8th, 1996 --- Finished at  7:56 pm.
;NUCLEAR UPDATE 13 ------- January 1st, 1997 ---- Finished at 10:17 pm.
;NUCLEAR UPDATE 14 ------- January 8th, 1997 ---- Finished at  9:53 am.
;UPDATE 15 --------------- January 28th, 1997 --- Finished at  3:29 pm.
;MAJOR NUCLEAR UPDATE 16 - May 9th, 1997 -------- Finished at 11:56 pm.
;						  (I'm gonna sleep again!)
;UPDATE 17 --------------- May 17th, 1997 ------- Finished at 12:49 pm.
;UPDATE 18 --------------- July 21st, 1997 ------ Finished at 12:37 pm.

;ADVICE: I've made this program to be assembled with A86.
;If you have the Microsoft Macro Assembler and/or the Borland Turbo Assembler
;then you will have to define the memory model and make other changes, since
;I've used some instructions that only A86 can use. In fact, wou will need to
;make LOTS! of changes.

Svc_Program	SEGMENT

Svc_Start:
;-------------------------------------------------------------------------
;This is the main dispatcher of all operations. Get a parameter, see if it
;is bigger than 248, see if it is eight multiple, get BLASTER environment
;variable, and, at last, change the volume. If any error appears, jump to
;the Message Dispatcher.
;See that this procedure jumps itself to Alldone, instead of jumping to
;the Message Dispatcher. That is because Alldone is not a normal message,
;as it involves the display of unknown numbers.
;-------------------------------------------------------------------------

	jmp	Main_Program

Star_Trek_First_Contact	DB	'Resistance is Futile'

Main_Program	PROC
	call	Parameter_Alloc			;Setup Parameter_Table and
						;Parameter_Count variable.
	cmp	Byte Ptr cs:Parameter_Count,0	;If no parameters were typed,
						;run the Interface.
	jnz	Parameter_Get			;Jump to a procedure to get
						;the given parameters.
	call	Get_Blaster_Port
	jmp	Screen_Control
Main_Program	ENDP

;-------------------------------------------------------------------------
;This procedure verifies if there was any parameter and, if so, jumps to
;the right procedure to calculate the number, which will be written in DX.
;
;On entry :	Parameter at the command line.
;Returns :	Parameter converted to a byte (in hex) in DX.
;
;Reads :	Psp, DS:80h.
;-------------------------------------------------------------------------
Parameter_Get	PROC
	push	ax
	push	bx
	push	si
	call	Get_Blaster_Port	;Call a routine to get the SB16 port
					;address. If I use the most common
					;value, 220h, the people who don't
					;have that value would get an error.

	lea	di,cs:Help_Character	;Load a "string" which contains a '?'.
	mov	cx,1			;The string contains only one
					;character.
	call	Find_Parameter		;Look for it.
	jnc	Show_Help_Jump		;If we found it, show a help screen
					;and exit.

	lea	di,cs:PostMan_String
	mov	cx,8
	call	Find_Parameter
	jnc	PostMan_Jump

	call	Params_To_Lowercase	;If not, proceed with the given
					;parameters. As we will look for some
					;strings, we must keep in mind the
					;case. So, instead of trying to find
					;all combinations of cases, convert
					;them to Lowercase and look for
					;lowercase strings.
	lea	di,cs:Null_String	;See if the user wants no screen
					;output. For that, we will look for
					;the 'nul' string.
	mov	cx,3
	call	Find_Parameter
	jc	Search_Master		;If not found, forget the 'nul' story
					;and look for the first parameter.
	mov	Byte Ptr cs:Null_Asked,01h	;Set Null_Asked to 1, so no
						;message will be showed on
						;screen.
	jmp	Search_Master		;Look for the first parameter.

Show_Help_Jump:
	jmp	Show_Help		;Make a long jump to Show_Help.

PostMan_Jump:
	jmp	PostMan_Proc

Search_Master:
	mov	Byte Ptr cs:Mod_Port,Master_Value	;Otherwise, change
							;the Master volume to
							;the specified by the
							;number.
	lea	di,cs:Master_String	;Load the first string to search.
	mov	cx,2			;The string has 2 (Two) characters.
	call	Find_Parameter		;Look for it.
	jc	Search_Cd		;If we didn't find it, look for the
					;next string.
	call	Get_Digits		;Try to get the number.
	jc	Search_Cd		;If we didn't find the number but the
					;string, then it was a user's error!.
	call	Change_Both		;Change the Master volume!.

	mov	cs:Master_Number_Length,cl	;As the program accepts
						;numbers with one, two or
						;three digits, the final
						;message routine needs to
						;know that information.
	dec	cx				;Substract 1 to CX...
	sub	si,cx				;Then substract the resulting
						;value to SI. We get that way
						;the position of the number.
	mov	cs:Master_Number_Position,si	;Save it.
	add	Byte Ptr cs:Changed_Ports,0001xb;Indicate on the variable
						;that we modified the Master
						;volume.

Search_Cd:
	mov	Byte Ptr cs:Mod_Port,Cd_Value
	lea	di,cs:Cd_String		;Now do exactly the same but with the
					;"cd" parameter.
	mov	cx,2
	call	Find_Parameter
	jc	Search_Treble
	call	Get_Digits
	jc	Search_Treble
	call	Change_Both

	mov	cs:Cd_Number_Length,cl
	dec	cx
	sub	si,cx
	mov	cs:Cd_Number_Position,si
	add	Byte Ptr cs:Changed_Ports,0010xb

Search_Treble:
	mov	Byte Ptr cs:Mod_Port,Treble_Value
	lea	di,cs:Treble_String
	mov	cx,2
	call	Find_Parameter
	jc	Search_Bass
	call	Get_Digits
	jc	Search_Bass
	call	Change_Both

	mov	cs:Treble_Number_Length,cl
	dec	cx
	sub	si,cx
	mov	cs:Treble_Number_Position,si
	add	Byte Ptr cs:Changed_Ports,0100xb

Search_Bass:
	mov	Byte Ptr cs:Mod_Port,Bass_Value
	lea	di,cs:Bass_String
	mov	cx,2
	call	Find_Parameter
	jc	End_Get_Parameter
	call	Get_Digits
	jc	End_Get_Parameter
	call	Change_Both

	mov	cs:Bass_Number_Length,cl
	dec	cx
	sub	si,cx
	mov	cs:Bass_Number_Position,si
	add	Byte Ptr cs:Changed_Ports,1000xb

End_Get_Parameter:
	pop	si
	pop	bx
	pop	ax
	jmp	Alldone
Parameter_Get	ENDP

Port_Address	DW	0200h	;This is a basic base Port Address. It needs
				;to be added to the value that
				;GET_BLASTER_PORT will find at the BLASTER
				;environment variable.

Master_String		DB	'ma'	;These are the valid parameters.
Cd_String		DB	'cd'
Treble_String		DB	'tr'
Bass_String		DB	'bs'
Help_Character		DB	'?'	;Help!.
Null_String		DB	'nul'

Master_Number_Length	DB	0
Master_Number_Position	DW	?
Cd_Number_Length	DB	0
Cd_Number_Position	DW	?
Treble_Number_Length	DB	0
Treble_Number_Position	DW	?
Bass_Number_Length	DB	0
Bass_Number_Position	DW	?

Null_Asked		DB	0	;Indicator of a 'nul' string.
Changed_Ports		DB	0	;Indicator of what port was modified.
					;Table is as follows:
					;Bit 1 : Master
					;Bit 2 : CD Audio
					;Bit 3 : Treble
					;Bit 4 : Bass
					;Bits 5 to 8 : Left for future uses.

;Below are some INCLUDEs. Each of these lines indicate that the following
;file must be inserted as if it were written on this file. Also, instead of
;typing A86 SVC.ASM SCREEN.ASM MEMORY.ASM SB16.ASM MESSAGES.ASM PSEARCH.ASM
;NUMBER.ASM INTERFC.ASM (ajjj!), you can type just A86 SVC.ASM and Voila!.

INCLUDE SCREEN.ASM		;Almost all screen procedures.
INCLUDE MEMORY.ASM		;BLASTER environment variable treatment.
INCLUDE SB16.ASM		;Sound Blaster 16 handling routines.
INCLUDE MESSAGES.ASM		;Ending messages and Help screen.
INCLUDE PSEARCH.ASM		;Parameter engines.
INCLUDE NUMBER.ASM		;Volume number treatment routines.
INCLUDE INTERFC.ASM		;Interface and some screen routines.

Svc_Program	ENDS
