Big_Number_Color	EQU	1Eh	;Color of the Real Volume value.
Small_Number_Color	EQU	1Ch	;Color of the Divided Volume value.

Vmeter_Char		EQU	''	;VMeter Unit Character.

First_Color	EQU	1Ah	;Color of the First part of the VM.
Second_Color	EQU	1Eh	;Color of the Second part of the VM.
Third_Color	EQU	1Ch	;Color of the Third part of the VM.

Rest_Color	EQU	1Fh	;Background Color of the remaining spaces
				;when the VM is reduced.

;Try changing the following numbers, always maintaing their order, then
;assemble and see the VMeter. Remember not to exceed the 31 characters limit.
First_Section		EQU	10	;Length of the Low part of the VM.
Second_Section		EQU	25	;Length of the Medium part of the VM.
Third_Section		EQU	31	;Length of the High part of the VM.

Numberloc_To_Left_Bracket	EQU	22h	;Distance in bytes from
						;Numberloc to the Left
						;indicator position.
Left_Bracket		EQU	'['	;Current VMeter selector - Left side.
Right_Bracket		EQU	']'	;Current VMeter selector - Right side.
Bracket_Color		EQU	1Fh	;Selector's colour.
Brackets_Distance	EQU	76h	;Distance between both selectors.

Help_Line_Length	EQU	80	;Length of each of the Help screen
					;rows.

;---------------------------------------------------------------------------
;This procedure sets the video address to display a message just under the
;last prompt line. Defines the Segment Video Address for Mono or Color
;monitor and it's Offset.
;Returns the color identifier in BX.
;---------------------------------------------------------------------------
Prepare_To_Write_Msg	PROC
	push	ax		;Save registers.

	mov	ah,3		;Function to Read the current cursor position
	mov	bh,0		;On video page 0
	int	10h		;Read cursor position. Returns row in DH and
				;column in DL
	
Get_Current_Video_Mode:
	mov	ah,0Fh		;Function to Get the Current Video Mode.
				;Returns number of columns on AH.
	int	10h		;Yeah, Go.
	mov	bx,2		;Prepare to multiply AL by two
	mov	al,00		;Clear AL
	xchg	ah,al		;EXCHanGe the contents between AH and AL
				;(now the number of columns is in AL)
	mul	bl
	
Set_Address:
	mov	bx,ax		;Multiplicate by the number we got from
				;Get_Current_Video_Mode. As an example, if
				;the current video mode contained 80 columns,
				;we multiply 80 * 2 and get 160. We MUST
				;multiply it by 2 because each character has
				;two bytes, one for the color and one for
				;the character itself.
				;So, with the example told above, each row
				;is positioned at offset 000, 160, 320, 480,
				;etc. at the Video Address.
				;With video modes with a different number
				;off columns, lets say,	132 columns, each
				;row is positioned at offset 000, 264, 396,
				;etc.
	xor	ax,ax		;Clear AX so the MUL command works only
				;with AL (see the line below)
	mov	al,dh		;Send the current row number (we got that
				;number from the start of Prepare... before)
				;to AL for a MUL
	mul	bx		;Go!
	mov	di,ax		;The result is the memory address needed to
				;display the message at the current cursor
				;position. That is, just under the last
				;prompt line.
	call	Get_Video_Type
	mov	es,cs:Display_Base
	pop	ax
	ret
Prepare_To_Write_Msg	ENDP

Get_Video_Type	PROC
	push	ax
	int	11h		;Function to get info about the current
				;equipment. Returns a value in ah, from
				;where we should analyse the bits 5-4, which
				;have the info for the display type.
	and	ax,30h		;AND it with 30h (0011 0000) to isolate the
				;bits 5-4.
	cmp	ax,30h		;If the machine has a color display, those
				;bits are 0010 0000 (20h). If the machine
				;has a monochrome display, those bits are
				;0011 0000 (30h). Do you undestand now why
				;I am doing a comparison between AX and 30h?
	mov	cs:Display_Base,0B800h	;Move to the Extra Segment the
						;Text Video segment address
						;(Color Video).
	jb	Done_Get_Video	;If AX was below 30h, it means that it was
				;20h (a color display).
	mov	cs:Display_Base,0B000h	;Move to the Extra Segment the
						;Text Video segment address
						;(Monochrome Video).

Done_Get_Video:
	pop	ax
	ret
Get_Video_Type	ENDP

;---------------------------------------------------------------------------
;This procedure displays the given message (loaded with LEA si,Message) at
;the current position (it doesn't change it) in the desired color.
;---------------------------------------------------------------------------
Showmsg		PROC
	push	ax
	cld			;Clear the Direction Flag so DI will be
				;Incremented by LODSB and STOSW functions.
Loop_Part:
	lodsb			;Get a character from DS:SI and put it into
				;AL.
	
	or	al,al		;Verify if it's the end of the message.
	jz	Finished	;If so, jump to Finished.

	stosw			;Move to video the value of the current char.
				;at ES:DI (Destination Index) plus it's
				;colour.
				;This would be the same as MOVE TO B800h THIS
				;CHARACTER IN THIS COLOUR, OK???
	jmp	Loop_Part	;Print the next character.

Finished:
	pop	ax
	ret			;Go back.
Showmsg		ENDP

;------------------------------------------------------------------------
;This procedure gets a number in hexadecimal and writes it to the screen
;in decimal notation.
;
;On entry :	Color of the number to display in AH.
;		Hex number to display in AL.
;
;Returns :	Decimal value on screen.
;------------------------------------------------------------------------
Decimal_Video	PROC
	push	dx
	push	cx
	xor	cx,cx			;Clear CX to use it as a counter.
	mov	si,10			;Will divide by 10 using SI.
	mov	bh,ah			;Save the color.
	xor	ah,ah			;Clear that value so the DIV function
					;works with AL only.
Non_Zero:
	xor	dx,dx			;Clear DX to use it as a Stack.
	div	si			;Calculate AL/10.
	push	dx			;Push one digit onto the stack.
	inc	cx			;One more digit added.
	or	ax,ax			;N = 0 yet?.
	jnz	Non_Zero		;If not, continue.
	mov	ah,bh			;Restore the Colour Value.
	cld

Looping:
 	pop	dx		;Get one number.
	add	dx,30h		;Add 30h so the STOSW displays it as a number.
	mov	al,dl		;Move the result to AL.
	stosw
	loop	Looping		;Loop 'til all numbers are printed.
	pop	cx
	pop	dx
	ret
Decimal_Video	ENDP

;------------------------------------------------------------------------
;This procedure gets a number in AX and prints it in two ways: in a
;normal, three digit form, and in a two digit form (divided by 8). Then
;calls the Show_V_Meter procedure to show the VMeter.
;
;On entry :	Volume in AX.
;Returns :	Numbers and VMeter.
;
;Calls :	Show_V_Meter.
;------------------------------------------------------------------------
Show_Numbers	PROC
	cmp	ax,0008h	;If the volume is 8 or 0, then we must show
				;two zeroes before it.
	jbe	Double_Zero
	cmp	ax,0060h	;See if it is below 100.
	ja	Skip_Zero

	push	ax
	mov	ah,Big_Number_Color
	mov	al,30h		;Insert a "0" in Bright Green color.
	stosw
	pop	ax
	jmp	Skip_Zero

Double_Zero:
	push	ax
	mov	ah,Big_Number_Color
	mov	al,30h		;Insert a "0" in Bright Green color.
	stosw
	stosw
	pop	ax

Skip_Zero:
	mov	ah,Big_Number_Color	;Color of the number to display
	call	Decimal_Video

	add	di,6			;Skip the " - " between the two
					;numbers.
	mov	ax,dx			;Make a copy in AX from the actual
					;volume value.
	mov	bx,8			;Divide by 8
	div	bl
	cmp	ax,0009h		;See if it is below 10
	ja	Skip_Second_Zero	;If so, we must insert a zero before
					;the number.

	push	ax
	mov	ah,Small_Number_Color
	mov	al,30h			;Insert a "0" in Bright Green color.
	stosw				;Print.
	pop	ax

Skip_Second_Zero:
	mov	ah,Small_Number_Color
	call	Decimal_Video		;Write it on the screen.
	call	Show_V_Meter
	ret
Show_Numbers	ENDP

;-------------------------------------------------------------------------
;This procedure shows the Aaaawesome VMeter! (comments appart, please).
;
;On entry :	Volume value in DX.
;Returns :	VMeter.
;
;Calls :	Clear_Rest
;-------------------------------------------------------------------------
Show_V_Meter	PROC
	push	ax
	push	bx
	push	cx
	add	di,6		;Skip the " - " between the last number and
				;the VMeter.
	
	mov	ax,dx		;Make a copy in AX from the actual volume
				;value.
	mov	bx,8		;Divide by 8.
	div	bl
	mov	bx,ax		;Since AX is used by STOSW, we will use BX.

	cmp	bx,First_Section
	ja	All_First	;If BX (actual volume divided by 8) is above
				;10 (ten), then ALL of the Green bars (10
				;bars) must be printed.
	jbe	First_Exit	;If below or equal, then we must print the
				;adequate number of bars and exit.


All_First:
	mov	ah,First_Color		;For the STOSW function, we put in AH
					;the desired color...
	mov	al,Vmeter_Char		;And we put the desired character in
					;AL.
	mov	cx,First_Section	;Write it X times.
	rep	stosw
	jmp	Ver_Yellow		;Jump to the Yellow bars.

First_Exit:
	mov	ah,First_Color
	mov	al,Vmeter_Char
	mov	cx,bx		;The right value is in BX. Move to CX for the
				;STOSW function.
	rep	stosw
	call	Clear_Rest	;Clear the rest of the line (in case we
				;dropped down the volume).
	mov	di,cs:Numberloc	;Restore the position where the numbers are to
				;be writed.
	jmp	End_Show_V_Meter

Ver_Yellow:
	cmp	bx,Second_Section	;See how many Yellow bars should we
					;show.
	ja	All_Second		;If above, then Red bars are to be
					;printed, so there will appear all of
					;the Yellow ones.
	jbe	Second_Exit		;If below or equal, print the adequate
					;number of Yellow bars and exit.

All_Second:
	mov	ah,Second_Color
	mov	al,Vmeter_Char
	mov	cx,Second_Section-first_Section
	rep	stosw
	jmp	Remaining_Red

Second_Exit:
	mov	ah,Second_Color
	mov	al,Vmeter_Char
	mov	cx,bx
	sub	cx,First_Section	;Sub X to CX because the first X bars
					;are Green and they are already
					;printed on screen.
	rep	stosw
	call	Clear_Rest
	mov	di,cs:Numberloc

	jmp	End_Show_V_Meter

Remaining_Red:
	mov	ah,Third_Color
	mov	al,Vmeter_Char
	mov	cx,bx
	sub	cx,Second_Section
	rep	stosw
	call	Clear_Rest
	mov	di,cs:Numberloc

End_Show_V_Meter:
	pop	cx
	pop	bx
	pop	ax
	ret
Show_V_Meter	ENDP

;------------------------------------------------------------------------
;This procedure is entirely for use by Show_V_Meter. It clears the
;remainings of the old VMeter.
;------------------------------------------------------------------------
Clear_Rest	PROC
	mov	cx,Third_Section	;Move to CX the maximum divided value.
	sub	cx,bx		;Substract from CX the actual volume, which
				;is at BX.
				;The result are the remaining unused spaces
				;the VMeter leaves. These must be cleared.
	mov	ah,Rest_Color	;Insert spaces in the desired color.
	mov	al,20h		;Space character.
	rep	stosw
	ret
Clear_Rest	ENDP

Erase_Cursor	PROC
	push	ax
	push	bx
	push	cx
	push	dx

	xor	bx,bx			;Video page 0.
	mov	ah,3			;Get current cursor type. The cursor
					;type is returned in CX (Start line
					;in CH and End line in CL).
	int	10h
	mov	cs:Old_Cursor,cx	;Save it for posterior restore.

	mov	dx,0F00h		;Set the Start and End scan lines of
					;the cursor. It will turn into an
					;invisible cursor.
	call	Set_Cursor

	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
Erase_Cursor	ENDP

;-----------------------------------------------------------------------;
; This procedure sets the end and start lines of the cursor.		;
;									;
; On entry:	DH	First scan-line of cursor.			;
;		DL	Last scan-line of cursor.			;
;									;
; Writes:	Old_Cursor						;
;-----------------------------------------------------------------------;
Set_Cursor	PROC
	push	ax
	push	cx

	mov	cx,dx		;Place in CX the cursor specifications (the
				;INT 10h function needs them in CX).
	mov	ah,1		;Function to set the cursor type.
	int	10h

	pop	cx
	pop	ax
	ret
Set_Cursor	ENDP

Get_Attribute	PROC
	push	ax
	push	ds
	push	si

	xor	ax,ax
	mov	ds,0040		;Point to 0040:0065h
	mov	al,ds:[65h]	;Get the byte there.

	and	al,020h		;Isolate bit #5 (0010 0000). That indicates
				;the current attribute state. If it's 1, then
				;the blinking attribute is set, and if 0, the
				;bright background attribute is set. We must
				;determine which shading routine will we use.
	or	al,al
	jnz	Get_Attribute_Exit
	mov	Byte Ptr cs:Attribute,02h	;Save 02h at ... if bright
						;background is enabled.
	
Get_Attribute_Exit:
	pop	si
	pop	ds
	pop	ax
	ret
Get_Attribute	ENDP

Shader		PROC
	push	ax
	push	bx
	push	dx
	cmp	Byte Ptr cs:Attribute,01h
	ja	Bright_Shader		;If 1, that means that current video
					;attribute is blinking.	Else, it could
					;be 2, which means that bit #5 is on
					;and the bright background attribute
					;is set.
Blinking_Shader:
	xor	ax,ax
	inc	di
	mov	al,es:[di]
	mov	dx,ax
	call	Process_Fore
	
	and	dl,0F0h
	call	Rotate
	push	ax
	mov	al,dl
	lea	bx,Blink_Shadow_Table
	xlat
	mov	dl,al
	pop	ax
	call	Rotate

	add	ax,dx

	stosb				;Write to the screen.
	loop	Blinking_Shader		;Loop Mamma.
	jmp	Shader_Exit

Bright_Shader:
	xor	ax,ax		;Clear AX so the MOV function works only
				;with AL.
	inc	di		;Increment DI in one unit. Instead of
				;pointing to the next character, we are
				;pointing at it's attribute.
	mov	al,es:[di]	;Move to AL the attribute.
	mov	dx,ax		;Make a copy. AX will be used by Process_Fore
				;and DX will be used when processing the
				;Background value.
	call	Process_Fore	;Proccess Foreground value.

	and	dl,0F0h			;Isolate the leftmost nibble.
	call	Rotate			;Move it to the right.
	push	ax			;For XLAT, use AX for a while.
	mov	al,dl
	lea	bx,Back_Shadow_Table	;Transform the value.
	xlat
	mov	dl,al			;Put the value in AL where it belongs.
	pop	ax
	call	Rotate			;Move it to the left nibble.

	add	ax,dx		;Combine Foreground and Background bytes,
				;resulting in a byte containing the new
				;attribute for the current character.
	stosb
	loop	Bright_Shader

Shader_Exit:
	pop	dx
	pop	bx
	pop	ax
	ret
Shader		ENDP

Process_Fore	PROC
	and	al,0Fh		;Get the lower nibble (1 byte = 2 nibbles).
				;It contains the color byte.
	lea	bx,Fore_Shadow_Table
	xlat
	ret
Process_Fore	ENDP

Rotate		PROC
	ror	dl,1			;Since XLAT will work with
	ror	dl,1			;lower-nibble values, we need to
	ror	dl,1			;rotate four times, XLAT, and again
	ror	dl,1			;to restore.
	ret
Rotate		ENDP

Show_Brackets	PROC
	push	ax
	sub	di,Numberloc_To_Left_Bracket	;Go back X bytes (1/2*X
						;characters) to DRAW the Left
						;indicator.
	mov	ah,Bracket_Color	;Load the desired color.
	mov	al,Left_Bracket		;Load the Left indicator.
	mov	es:[di],ax		;Write to screen.

	add	di,Brackets_Distance	;Then go X characters to the right.
	mov	al,Right_Bracket	;Now load the Right bracket indicator.
	mov	es:[di],ax

	mov	di,cs:Numberloc	;Save new position so the VMeter procs work
				;on the right one.
	pop	ax
	ret
Show_Brackets	ENDP

Clear_Brackets	PROC
	push	di
	sub	di,Numberloc_To_Left_Bracket	;Go back X bytes (1/2*X
						;characters) to ERASE the
						;Left indicator.
	mov	es:[di],1F20h		;Write a space to clear it.

	add	di,Brackets_Distance	;Then go X characters to the right.
	mov	es:[di],1F20h		;Clear the right bracket.

	pop	di
	ret
Clear_Brackets	ENDP

Screen_Setup	PROC
	push	ax
	push	bx
	mov	ah,0Fh		;Function to Get the Current Video Mode.
				;Returns number of columns in AH.
	int	10h		;Yeah, Go.
	mov	bx,2		;Prepare to multiply AL by two.
	xor	al,al
	xchg	ah,al		;EXCHanGe the contents between AH and AL
				;(now the number of columns is in AL).
	mul	bl		;Multiply by two to get the quantity of
				;bytes, not columns (1 column = 1 word).

	mov	cs:Line_Width,ax	;Save the width of the lines.
	div	bl			;Restore from the previous
					;multiplication.

	sub	ax,Help_Line_Length	;The result is the quantity of bytes
					;to skip to write the next line.
	mul	bl			;Multiply again for the same reason.
	mov	cs:Skip_Bytes,ax	;Save it for future uses.

	call	Get_Video_Type		;Set address for Mono or Color
					;display. It will be saved in a
					;variable called Display_Base.
	mov	es,cs:Display_Base	;Place the address in the right place.
	pop	bx
	pop	ax
	ret
Screen_Setup	ENDP

Get_Number_Of_Rows	PROC
	push	ax
	push	ds
	push	si

	mov	ax,0040h
	mov	ds,ax			;Get the current number of rows,
					;which is indicated at 0040:0084h.
	xor	ax,ax
	mov	al,ds:[84h]		;Move to al, not ah, because it is a
					;byte, not a word.
	mov	cs:Screen_Height,ax	;Save.

	pop	si
	pop	ds
	pop	ax
	ret
Get_Number_Of_Rows	ENDP

Line_Table	LABEL	BYTE
	DB	01
	DW	Line_One
	DB	02
	DW	Line_Two
	DB	03
	DW	Line_Three
	DB	04
	DW	Line_Four
	DB	05
	DW	Line_Five
	DB	06
	DW	Line_Six
	DB	07
	DW	Line_Seven
	DB	08
	DW	Line_Eight
	DB	09
	DW	Line_Nine
	DB	10
	DW	Line_Ten
	DB	11
	DW	Line_Eleven
	DB	12
	DW	Line_Twelve
	DB	13
	DW	Line_Thirteen
	DB	14
	DW	Line_Fourteen
	DB	15
	DW	Line_Fifteen
	DB	0

;Here's the Interface. See that it is divided in several lines. That is
;because it's the only way I know to make it appear in all video modes.
;-- If you know another way, tell me! --
;
;Looks weird to implement, but if you don't understand, think a little.
;It's easy.
;
;And remember: although I've made this screen with and ANSI editor, the
;program doesn't need an ANSI driver.
Line_One:
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31

Line_Two:
        DB      '',31,' ',31,'S',28,'o',28,'u',28,'n',28,'d',28,' ',28
        DB      'V',28,'o',28,'l',28,'u',28,'m',28,'e',28,' ',28,'C',28
        DB      'o',28,'n',28,'t',28,'r',28,'o',28,'l',28,' ',28,' ',28
        DB      ' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28
        DB      ' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28
        DB      ' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28
        DB      'V',26,'e',26,'r',26,'s',26,'i',26,'o',26,'n',26,' ',26
        DB      '2',30,'.',30,'2',30,'0',30,'m',30,'k',30,' ',30,'',31

Line_Three:
        DB      '',31,' ',31,'-',27,'-',27,'-',27,'-',27,'-',27,'-',27
        DB      '-',27,'-',27,'-',27,'-',27,'-',27,'-',27,'-',27,'-',27
        DB      '-',27,'-',27,'-',27,'-',27,'-',27,'-',27,' ',27,' ',27
        DB      ' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27
        DB      ' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27
        DB      ' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27
        DB      '-',27,'-',27,'-',27,'-',27,'-',27,'-',27,'-',27,'-',27
        DB      '-',27,'-',27,'-',27,'-',27,'-',27,'-',27,' ',27,'',31

Line_Four:
        DB      '',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,'',31

Line_Five:
        DB      '',31,' ',31,' ',31,'M',26,'a',26,'s',26,'t',26,'e',26
        DB      'r',26,' ',26,'V',26,'o',26,'l',26,'u',26,'m',26,'e',26
        DB      ' ',26,':',28,' ',28,' ',28,' ',28,' ',28,' ',28,'-',26
        DB      ' ',26,' ',26,' ',26,' ',26,'-',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,'',31

Line_Six:
        DB      '',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,'C',26
        DB      'D',26,' ',26,'V',26,'o',26,'l',26,'u',26,'m',26,'e',26
        DB      ' ',26,':',28,' ',28,' ',28,' ',28,' ',28,' ',28,'-',26
        DB      ' ',26,' ',26,' ',26,' ',26,'-',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,'',31

Line_Seven:
        DB      '',31,' ',31,' ',31,' ',31,'S',26,'o',26,'u',26,'n',26
        DB      'd',26,' ',26,'T',26,'r',26,'e',26,'b',26,'l',26,'e',26
        DB      ' ',26,':',28,' ',28,' ',28,' ',28,' ',28,' ',28,'-',26
        DB      ' ',26,' ',26,' ',26,' ',26,'-',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,'',31

Line_Eight:
        DB      '',31,' ',31,' ',31,' ',31,' ',31,' ',31,'S',26,'o',26
        DB      'u',26,'n',26,'d',26,' ',26,'B',26,'a',26,'s',26,'s',26
        DB      ' ',26,':',28,' ',28,' ',28,' ',28,' ',28,' ',28,'-',26
        DB      ' ',26,' ',26,' ',26,' ',26,'-',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,' ',26,'',31

Line_Nine:
        DB      '',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,'',31

Line_Ten:
        DB      '',31,' ',31,'R',26,'i',26,'g',26,'h',26,'t',26,' ',26
        DB      ' ',26,' ',26,' ',26,':',28,' ',28,'I',30,'n',30,'c',30
        DB      'r',30,'e',30,'a',30,'s',30,'e',30,' ',30,'V',30,'o',30
        DB      'l',30,'u',30,'m',30,'e',30,' ',30,' ',30,' ',30,' ',30
        DB      ' ',30,' ',30,' ',30,' ',30,' ',30,' ',30,' ',30,' ',30
        DB      ' ',30,' ',30,' ',30,' ',30,']',26,' ',26,':',28,' ',28
        DB      'M',30,'a',30,'x',30,'i',30,'m',30,'u',30,'m',30,' ',30
        DB      'V',30,'o',30,'l',30,'u',30,'m',30,'e',30,' ',30,'',31

Line_Eleven:
        DB      '',31,' ',31,'L',26,'e',26,'f',26,'t',26,' ',26,' ',26
        DB      ' ',26,' ',26,' ',26,':',28,' ',28,'D',30,'e',30,'c',30
        DB      'r',30,'e',30,'a',30,'s',30,'e',30,' ',30,'V',30,'o',30
        DB      'l',30,'u',30,'m',30,'e',30,' ',30,' ',30,' ',30,' ',30
        DB      ' ',30,' ',30,' ',30,' ',30,' ',30,' ',30,' ',30,' ',30
        DB      ' ',30,' ',30,' ',30,' ',30,'[',26,' ',26,':',28,' ',28
        DB      'M',30,'i',30,'n',30,'i',30,'m',30,'u',30,'m',30,' ',30
        DB      'V',30,'o',30,'l',30,'u',30,'m',30,'e',30,' ',30,'',31

Line_Twelve:
        DB      '',31,' ',31,'U',26,'p',26,',',30,' ',30,'D',26,'o',26
        DB      'w',26,'n',26,' ',26,':',28,' ',28,'S',30,'e',30,'l',30
        DB      'e',30,'c',30,'t',30,' ',30,'S',30,'o',30,'u',30,'r',30
        DB      'c',30,'e',30,' ',30,' ',30,' ',30,' ',30,' ',30,' ',30
        DB      ' ',30,' ',30,' ',30,'E',26,'s',26,'c',26,',',30,' ',30
        DB      'E',26,'n',26,'t',26,'e',26,'r',26,' ',26,':',28,' ',28
        DB      'E',30,'x',30,'i',30,'t',30,' ',30,'P',30,'r',30,'o',30
        DB      'g',30,'r',30,'a',30,'m',30,' ',30,' ',30,' ',30,'',31

Line_Thirteen:
        DB      '',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,'',31

Line_Fourteen:
        DB      '',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31,' ',31
        DB      ' ',31,' ',31,' ',31,' ',31,'S',29,'e',29,'p',29,'t',29
        DB      'e',29,'m',29,'b',29,'e',29,'r',29,' ',29,'1',29,'8',29
        DB      't',29,'h',29,',',29,' ',29,'1',29,'9',29,'9',29,'7',29
        DB      ' ',29,'-',29,' ',29,'A',29,'n',29,'d',29,'r',29,'',29
        DB      's',29,' ',29,'C',29,'.',29,' ',29,'M',29,'a',29,'z',29
        DB      'z',29,'o',29,'c',29,'c',29,'h',29,'i',29,' ',29,'',31

Line_Fifteen:
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31

Display_Base	DW	?	;This is where the video address will be
				;saved. When a procedure must write to the
				;screen, it should load this variable.
Old_Cursor	DW	0	;Here is saved the old cursor.
Attribute	DB	1	;Here is saved the current video attribute.
				;01 means Blinking active, and 02 means
				;Bright Background active.
Fore_Shadow_Table	DB	00h,01h,02h,03h,04h,05h,06h,08h,00h,01h,02h,03h,04h,05h,06h,07h
Back_Shadow_Table	DB	00h,00h,00h,00h,00h,00h,00h,08h,00h,01h,02h,03h,04h,05h,06h,07h
Blink_Shadow_Table	DB	00h,00h,00h,00h,00h,00h,00h,00h,00h,08h,08h,08h,08h,08h,08h,08h
