Master_Value	EQU	30h	;This is the value we should send to the base
				;address to change the Master volume.
Cd_Value	EQU	36h	;This is the value we should send to the base
				;address to change the CD volume.
Treble_Value	EQU	44h	;This is the same for the Treble.
Bass_Value	EQU	46h	;And this is the same for the Bass.

;-------------------------------------------------------------------------
;This procedure changes the volume of both Right and Left channels.
;
;On entry :	Volume value in DX.
;-------------------------------------------------------------------------
Change_Both	PROC
	push	ax
	mov	al,cs:Mod_Port	;Put the required value in AL.The procedure
				;Change_Ports will use it for the Index port.
	call	Change_Ports
	inc	al		;Same with the Left channel.
	call	Change_Ports
	pop	ax
	ret
Change_Both	ENDP

;-------------------------------------------------------------------------
;This procedure changes the volume at the indicated Port addresses.
;
;On entry :	Volume value in DX.
;		Port to change in AL.
;		Port Address in Port_Address.
;-------------------------------------------------------------------------
Change_Ports	PROC
	push	ax
	push	cx
	push	dx

	mov	cx,dx		;Move to CX the Volume Value.
	mov	dx,cs:Port_Address	;Get the Port Address we found at
					;Get_Right_Port. We don't need to set
					;DS because we didn't change it
					;before (see explanations in
					;MEMORY.ASM).
	add	dx,04h		;Adding 4 will convert it to 2x4h, which is
				;the Index Port.
	out	dx,al		;This would be something like OUT 224h,30h
	inc	dx		;Now it is the Value Port (2x5h).
	mov	ax,cx		;Put in AX the volume we got before (the one
				;we moved to CX).
	out	dx,ax		;Repeat the translation.

	cmp	cs:Mod_Port,Master_Value	;Do the usual CMP to see
						;which variable should we
						;treat.
	je	Save_Master_Volume		;If 30h, we should save the
						;new volume in Master_Volume.
	cmp	cs:Mod_Port,Cd_Value		;Do the same, but with CD.
	je	Save_Cd_Volume

	cmp	cs:Mod_Port,Treble_Value	;Again, but with Treble.
	je	Save_Treble_Volume

	;If none of the above, then we changed the Bass volume.

Save_Bass_Volume:
	mov	cs:Bass_Volume,al	;Save Bass volume.
	jmp	End_Change_Ports	;Then exit.

Save_Treble_Volume:
	mov	cs:Treble_Volume,al	;Save Treble volume.
	jmp	End_Change_Ports	;Then exit.

Save_Cd_Volume:
	mov	cs:Cd_Volume,al		;Save CD volume.
	jmp	End_Change_Ports	;Then exit.

Save_Master_Volume:
	mov	cs:Master_Volume,al	;Save Master volume.

End_Change_Ports:
	pop	dx
	pop	cx
	pop	ax
	ret
Change_Ports	ENDP

;-------------------------------------------------------------------------
;This procedure gets the current volume.
;
;On entry :	Port Address in Port_Address.
;Returns :	Current volume in AL.
;-------------------------------------------------------------------------
Port_Get        PROC
	push	dx
	mov     dx,cs:Port_Address	;Use the Port Address we found at
					;GET_RIGHT_PORT.
	add	dx,04h
	mov	al,cs:Mod_Port	;Get the volume from the Right channel.
	out     dx,al
	xor     ax,ax
	inc	dx
	in      al,dx		;Get volume and put it into AL.
	pop	dx
	ret
Port_Get        ENDP

Volume_Up	PROC
	cmp	cs:Mod_Port,Treble_Value
	;When treating the Treble and Bass, their maximum value is 240 (F0h),
	;so to avoid conflicts we will make two kinds of comparisons
	;depending on the source being modified.
	jb	Volume_Up_Normal

Volume_Up_Special:
	cmp	dx,0F0h		;If volume is not at it's maximum value,
				;slide up the volume.
	jb	Add_Eight
	ret			;If it was at it's maximum, do nothing.

Volume_Up_Normal:
	cmp	dx,0F8h		;If volume is not at it's maximum value,
				;slide up the volume.
	jb	Add_Eight
	ret			;If it was at it's maximum, do nothing.

Add_Eight:
	add	dx,8h		;Increment volume by 8.
	call	Change_Both	;Change volume on both Right and Left
				;channels.

	mov	ax,dx		;Get a copy of the actual volume (at DX).
	call	Show_Numbers	;Show Numbers and the VMeter.
	ret
Volume_Up	ENDP

Volume_Down	PROC
	or	dx,dx		;If volume is not at it's minimum, slide down
				;the Volume.
	ja	Sub_Eight
	ret

Sub_Eight:
	sub	dx,8h
	call	Change_Both

	mov	ax,dx
	call	Show_Numbers
	ret
Volume_Down	ENDP

All_Up		PROC
	cmp	cs:Mod_Port,Treble_Value
	jb	All_Up_Normal

All_Up_Special:
	mov	dx,0F0h		;Put volume to the maximum.
	call	Change_Both
	jmp	End_All_Up	

All_Up_Normal:
	mov	dx,0F8h		;Put volume to the maximum.
	call	Change_Both

End_All_Up:
	mov	ax,dx
	call	Show_Numbers
	ret
All_Up		ENDP

All_Down	PROC
	xor	dx,dx		;Put volume to the minimum.
	call	Change_Both

	mov	ax,dx
	call	Show_Numbers
	ret
All_Down	ENDP

Mod_Port	DB	30h	;This variable will contain either
				;Master_Value, Cd_Value, Treble_Value or
				;Bass_Value port values. It will be used by
				;several routines to know which source it
				;should treat.
Master_Volume	DB	0	;This variable will contain the current
				;Master volume.
Cd_Volume	DB	0	;This variable will contain the current CD
				;volume.
Treble_Volume	DB	0	;This variable will contain the current
				;Treble volume.
Bass_Volume	DB	0	;This variable will contain the current
				;Bass volume.
