Max_Parameters	EQU	0Fh	;Maximum number of accepted parameters.

;-- Korolev Engine - Model Alpha 1.10a --------------------------------------

;This is my forever delayed parameter engine!.
;Made on Saturday, April 19th, 1997.

;- Wednesday, April 30th, 1997: update #1. Now the Parameter_Table contains
;				two data fields instead of one. The first one
;				is a Byte and contains the number of
;				characters the parameter has. The second
;				field is a Word and contains the memory
;				address of the parameter itself.

Parameter_Alloc		PROC
	push	ax		;Save registers to be used.
	push	bp
	push	cx
	push	di
	push	ds
	push	es
	push	si
	xor	ax,ax

	mov	si,80h		;Translate PSP address.

	mov	al,ds:[si]	;Get the amount of characters typed after the
				;program at the command line.
	mov	cs:Byte_Count,al	;Save this value in a variable.
	inc	si			;Start from 0081h to "fly through"
					;the first parameter including the
					;first space.
	xor	ax,ax
	mov	al,cs:Parameter_Count	;Save parameter counter in AL.

Space_Search:
	or	ax,ax			;Verify we are looking for the first
					;parameter.
	jz	Space_Loop		;If so, skip. 
	mov	dx,si			;Save SI Copy #1 to make a count of
					;the amount of characters the next
					;parameter has.

Space_Loop:
	cmp	Byte Ptr [si],0Dh	;See if we reached the end of the
					;command line.
	jz	End_Of_Cmd		;If so, get out of here.
	cmp	Byte Ptr [si],20h	;See if we found a space.
	je	Space_Found		;If so, save the parameter's address
					;in memory.
	inc	si			;Otherwise, look for the next byte.
	jmp	Space_Loop		;Loop man!.

Space_Found:
	mov	cx,si			;Save SI Copy #2.
	inc	Byte Ptr cs:Parameter_Count	;Indicate the parameter's
						;number.
	cmp	cs:Parameter_Count,Max_Parameters
	ja	Exceeded
					;We will now search for a nonsense
					;space chain. A graphic representation
					;would be like this: param     param2
					;                         -----
					;               wasted space
	inc	si			;Look for the next byte.

Skip_Space:
	cmp	Byte Ptr [si],20h	;Mamma, if I find a space I will skip
					;it!.
	jne	Save_Address		;If there wasn't a space, save the
					;current parameter's address in the
					;Parameter_Table.
	inc	si
	jmp	Skip_Space		;Loop Mamma.

Exceeded:
	mov	cs:Parameter_Count,Max_Parameters	
				;Set PARAM... to it's maximum. It was
				;exceeded, so to avoid problems, like trying
				;to process a non-existing parameter, we must
				;do this.
	jmp	End_Of_Cmd
Parameter_Alloc		ENDP

Save_Address	PROC
	lea	bx,Parameter_Table	;Load the table at BX.

Param_Loop:
	xor	ax,ax
	mov	al,cs:Parameter_Count	;As we need to save the address at
					;the correct position, let's say,
					;save parameter #3, we must save it
					;in the table at position #3.
	cmp	Byte Ptr [bx],al	;So, do what we need to do.
	je	Param_Save
	add	bx,4			;If we aren't at the right position
					;yet, skip to the next one. Four
					;bytes stand for a Byte (parameter
					;number), another Byte (amount of
					;characters the parameter has) and a
					;Word (reserved address space).
	jmp	Param_Loop

Param_Save:
	dec	ax			;Decrement AX because it was
					;previously incremented. We need to
					;find a zero telling that we must
					;skip saving the first count of the
					;number of characters a parameter
					;has.
	or	al,al			;See if it's zero.
	jz	Skip_Save_Count		;If so, skip saving.

Save_Count:
	sub	cx,dx		;By substracting Copy #1 from Copy #2, we
				;obtain the number of characters the PREVIOUS
				;parameter has.
	sub	bx,3		;And as it is the PREVIOUS parameter, we must
				;go back 3 bytes.
	mov	[bx],cl		;Save that number.
	add	bx,3		;Then restore BX. Why don't execute ADD bx,5
				;instead?. Simple: remember that if we find
				;a zero at the start of the routine, this
				;procedure will be skipped!, so the line
				;ADD bx,5 will not be executed and the
				;Skip_Save_Count procedure will save the
				;parameter's address at the wrong point.

Skip_Save_Count:
	inc	ax		;Restore ah, as we have just decremented it.
	add	bx,2		;Point to the word where we will place the
				;parameter X address.
	mov	[bx],si		;Save SI.
	jmp	Space_Search	;Get back to work.
Save_Address	ENDP

End_Of_Cmd	PROC
	mov	cx,si		;Save SI Copy #2.
	sub	cx,dx		;Make the known substraction.	
	sub	bx,1		;Go back just one position, not three as
				;before because this is the last parameter
				;and we didn't advance to the next one.
	mov	[bx],cl		;Save Mamma.

	pop	si		;And restore all...
	pop	es
	pop	ds
	pop	di
	pop	cx
	pop	bp
	pop	ax
	ret
End_Of_Cmd	ENDP


;-- Korolev Engine - Model Beta 1.00a ---------------------------------------

;Made on Friday, May 2nd, 1997.

;-------------------------------------------------------------------------
;Needs DI to be pointed to the desired string and CX set to the number of
;characters it contains. 
;
;Carry Flag set if string not found. Cleared if found.
;Returns ES:DI pointing to the byte just after the matching string.
;-------------------------------------------------------------------------
Find_Parameter	PROC
	push	bx
	push	ds

	mov	cs:DI_Position,di	;Although it seems that DI doesn't
					;need to be modified, it will!!!. So
					;we must save it because later we
					;will have to get this value several
					;times.
	push	cs		;Set DS equal to CS.
	pop	ds

	mov	si,81h		;Point to Psp, but skip the count byte
				;because it's useless and if it's 0Dh, guess
				;what will happen...
	mov	bx,cx		;We must save the counter as the REPE
				;function modifies it.
	cld			;Forward scan for CMPSB.

Fp_Compare_Strings:
	cmp	Byte Ptr [si],0Dh	;See if we found the end of the
					;command tail.
	je	End_Find_Parameter	;And if so, exit with an error (we
					;didn't find the string).

	repe	cmpsb		;Repeat while zero (or equal) the comparison
				;of a string (CMPSB compares the char at
				;DS:SI with the one at ES:DI).
				;We could compare words, but if we have to
				;find a "one character string" there would be
				;problems.
	jne	Fp_Bad_String	;If the above instruction didn't set the
				;Zero Flag (or Equal Flag), then the character
				;didn't belong to the string. We must start
				;again with the	next byte in memory.
	pop	ds
	pop	bx
	clc			;As we did find the string, we must indicate
				;that all went fine, so...
	ret			;Mamma, get back to work.

Fp_Bad_String:
	mov	cx,bx		;Set CX again. Remember that we saved it in
				;BX before.
	inc	cs:DI_Position		;Explanation: if REPE found one or
					;more matching characters, but not
					;the entire string, then SI is
					;incremented with the first
					;unmatching character. That
					;unmatching byte at SI would then be
					;skipped and it can be an important
					;byte, like the 0Dh at the end. It
					;could be the first character of the
					;string we are looking for too. So...
	cmp	di,cs:DI_Position	;Compare to see if the above thing
					;happened.
	ja	Restore_SI	;If DI is above DI_Position, then we know
				;that REPE found one or more matching
				;characters.

Leave_SI:
	dec	cs:DI_Position		;Restore from the INC above.
	mov	di,cs:DI_Position	;Set DI to point to the desired
					;string again.
	jmp	Fp_Compare_Strings	;And compare the string again.

Restore_SI:
	dec	cs:DI_Position
	dec	si			;Go back one byte at SI for the above
					;reason.
	mov	di,cs:DI_Position
	jmp	Fp_Compare_Strings	;And compare the string again.

End_Find_Parameter:
	pop	ds
	pop	bx
	stc			;This time we found an error!. We couldn't
				;find the specified string, so let's tell
				;our caller that problem.
	ret			;Mamma, I got a problem Mamma...	
Find_Parameter	ENDP

Params_To_Lowercase	PROC
	push	ax
	push	si

	mov	si,81h
	xor	ax,ax

Lower_Loop:
	inc	si		;Point to the next character.
	mov	al,ds:[si]	;Load it into AL.

	cmp	al,0Dh		;See if we reached the end of the command
				;tail.
	je	End_Lower	;If so, we finished our work.

	cmp	al,41h		;41h = ASCII "A".
	jb	Skip_Lower	;If below, skip.
	cmp	al,5Ah		;5Ah = ASCII "Z".
	ja	Skip_Lower	;If above, skip.

	add	al,20h		;Otherwise, add 20h to transform the
				;character in lowercase.
	mov	ds:[si],al	;Save it in the command tail.

Skip_Lower:
	jmp	Lower_Loop	;Loop until we find a 0Dh.

End_Lower:
	pop	si
	pop	ax
	ret
Params_To_Lowercase	ENDP

Byte_Count		DB	?	;Useless by now, here is the amount
					;of characters typed after the
					;program at the command line.
Parameter_Count		DB	0	;General counter for the amount of
					;parameters. This variable should be
					;used to determine how many parameters
					;did the user type.

;This table will contain each parameter's address at their position and how
;much characters they take. First parameter's address will be placed at
;position #1 and so on. By now it accepts up to 15 parameters.
Parameter_Table	LABEL	BYTE
	DB	01
	DB	0
	DW	0
	DB	02
	DB	0
	DW	0
	DB	03
	DB	0
	DW	0
	DB	04
	DB	0
	DW	0
	DB	05
	DB	0
	DW	0
	DB	06
	DB	0
	DW	0
	DB	07
	DB	0
	DW	0
	DB	08
	DB	0
	DW	0
	DB	09
	DB	0
	DW	0
	DB	0A
	DB	0
	DW	0
	DB	0B
	DB	0
	DW	0
	DB	0C
	DB	0
	DW	0
	DB	0D
	DB	0
	DW	0
	DB	0E
	DB	0
	DW	0
	DB	0F
	DB	0
	DW	0

DI_Position	DW	?	;Guess what will we save here...
