;-- Korolev Engine - Model Gamma / Variation from SVC's first routine -------

;Made on Monday, May 5th, 1997.

;-------------------------------------------------------------------------
;Procedure to get a number starting from current DS:[SI] address. Returns a
;valid volume value in DX.
;-------------------------------------------------------------------------

Get_Digits	PROC
	push	ax

	xor	ax,ax
	xor	cx,cx
	xor	dx,dx

	cmp	Byte Ptr ds:[si],3Ah	;If after the parameter there was a
					;":", a valid character, we will skip
					;it by pointing to the next character.
	jne	No_Two_Points		;If there wasn't a ":", read the
					;first digit.

Two_Points_First:
	inc	si			;Point to the next character.
	
No_Two_Points:
	mov	al,ds:[si]		;Get the first digit.
	call	Verify_Digit		;See if it's a real number.
	jc	No_Number		;If not, finish the session. As this
					;is the first digit, no number was
					;typed so our caller will receive an
					;error.
	mov	cs:First_Digit,al	;Save in memory.

	inc	si			;Point to the second digit.
	mov	al,ds:[si]
	call	Verify_Digit
	jc	End_Of_Reading
	mov	cs:Second_Digit,al	;Save the second digit in memory.

	inc	si			;Point to the third digit.
	mov	al,ds:[si]
	call	Verify_Digit
	jc	End_Of_Reading
	mov	cs:Third_Digit,al	;Save the third one.

End_Of_Reading:
	cmp	cx,03h			;If three, then we have readed a
					;three digit number.
	je	Three_Digits_Number	;Jump to the procedure that reads all
					;three variables.
	cmp	cx,02h			;If two, you know...
	je	Two_Digits_Number
	cmp	cx,01h
	je	One_Digit_Number

No_Number:
	pop	ax
	mov	ax,0B07h
	jmp	Msg_Dispatcher
Get_Digits	ENDP

Three_Digits_Number	PROC
	mov	al,cs:First_Digit	;Get the first digit we saved on
					;memory.
	sub	al,30h		;Substract 30h so the resulting number will
				;be the decimal value, not the Hex Character
				;value (example: 4 is 34h, so 34h - 30h = 4).
	mov	bl,al
	mov	ax,0064h	;Multiply it by 100.
	mul	BL
	add	dx,ax		;Add to DX to make the final volume number in
				;it's hex version. See the formula at the
				;start of SVC.ASM.

	mov	al,cs:Second_Digit
	sub	al,30h
	mov	bl,al
	mov	ax,000Ah	;Multiply it by 10.
	mul	bl
	add	dx,ax

	mov	al,cs:Third_Digit
	sub	al,30h
	add	dx,ax

	jmp	Last_Verifications
Three_Digits_Number	ENDP

Two_Digits_Number	PROC
	mov	al,cs:First_Digit
	sub	al,30h
	mov	bl,al
	mov	ax,000Ah	;Multiply it by 10.
	mul	bl
	add	dx,ax

	mov	al,cs:Second_Digit
	sub	al,30h
	add	dx,ax

	jmp	Last_Verifications
Two_Digits_Number	ENDP

One_Digit_Number	PROC
	mov	al,cs:First_Digit
	sub	al,30h
	add	dx,ax

	jmp	Last_Verifications
One_Digit_Number	ENDP

;-------------------------------------------------------------------------
;This procedure verifies that the given parameter is really a number and
;not other character.
;
;On entry :	Value to verify in AL.
;-------------------------------------------------------------------------
Verify_Digit	PROC
	cmp	al,30h		;Compare with the characters below.
	jb	No_Digit	;From 01h to 29h, complain...
	cmp	al,39h		;Again, but now with characters above.
	ja	No_Digit	;From 40h to FFh, complain again...
	inc	cx		;If all went fine, then we got a good number,
				;so increment CX to indicate that.
	clc			;No errors, skip CF.
	ret

No_Digit:
	cmp	al,20h		;If we are here, we must determine WHY we are
				;here. There are two reasons:
				;1. The number contained a non-numeric
				;   character.
				;2. We reached the end of the number. In this
				;   case, we will find a space at the end.
	je	Verify_Ok	;If a space was found, no problemo!, we
				;reached the end of the number.
	cmp	al,0Dh		;Remember that at the end of the command tail
				;there's a 0Dh!. We must keep it in mind.
	je	Verify_Ok

	mov	ax,0C01h	;But if it wasn't a space, then the number
				;contained a non-numeric character. Exit with
				;error #1.
	jmp	Msg_Dispatcher

Verify_Ok:
	cmp	cx,2			;Some special operations. We must
					;see if the number contained 2 digits
					;or less, because in that case...
	ja	Exit_Verify_Digit
	dec	si			;We should decrement SI to let the
					;other routines work fine (if you
					;don't understand, please use a
					;debugger).
Exit_Verify_Digit:
	stc			;Indicate that this is the end of the number.
	ret
Verify_Digit	ENDP

Last_Verifications	PROC
	call	Bigger?			;See that the number is not too high.
	call	Eight_Multiple?		;See too that it is an Eight
					;multiple, since the SB cannot accept
					;other values.
	pop	ax
	ret				;If the other procedures didn't jump
					;to the Msg_Dispatcher, that's the
					;sign we needed to know that
					;everything is fine. Return without
					;errors.
Last_Verifications	ENDP

;-------------------------------------------------------------------------
;This procedure verifies that the given number is not higher than 248,
;which is the maximum volume value.
;
;On entry :	Volume value in DX.
;-------------------------------------------------------------------------
Bigger?	PROC
	cmp	cs:Mod_Port,Treble_Value
	jb	Bigger_Normal

Bigger_Special:
	cmp	dx,0F0h			;This is the maximum volume for the
					;Treble and Bass.
	ja	Bigger_Error_Jump
	clc
	ret

Bigger_Normal:
	cmp	dx,0F8h		;See how is DX related to 248 (the maximum
				;Volume Value).
	ja	Bigger_Error_Jump	;If the number is greater than 248,
					;then it won't be possible to use it
					;as a Volume Value, so we will
					;complain and exit.
	clc
	ret

Bigger_Error_Jump:
	mov	ax,0C03h	;Error!, show message #03 and exit.
	jmp	Msg_Dispatcher
Bigger?	ENDP

;-------------------------------------------------------------------------
;This procedure verifies that the given number is eight multiple,
;otherwise the program will exit because the SB16 only accepts numbers in
;eight to eight increments.
;
;On entry :	Volume value in DX.
;-------------------------------------------------------------------------
Eight_Multiple?		PROC
	push	ax
	push	bx
	mov	ax,dx		;Make a copy of DX to divide by 8.
	mov	bl,08		;It will be divided by eight, and we will
				;use BL for that.
	div	bl		;Divide AX by BL (the result is placed in
				;al, and the remainder in AH).
	or	ah,ah		;See if AH (the remainder) is 0.
	jnz	Numerror_Jump	;If it is not 0, give an Error and exit.
	pop	bx
	pop	ax
	clc
	ret

Numerror_Jump:
	mov	ax,0C02h	;Error!, show message #02 and exit.
	jmp	Msg_Dispatcher
Eight_Multiple?		ENDP

First_Digit	DB	0	;As the name implies, here goes the first
				;digit we read from the command line.
Second_Digit	DB	0	;Here goes the second...
Third_Digit	DB	0	;And here goes the third one.
