Alldone_Message_Color	EQU	07h	;Alldone procedure's normal color.
Device_Color		EQU	0Eh	;Alldone procedure's color when
					;writing a device name (like Master,
					;CD).
Number_Color		EQU	0Eh	;Alldone procedure's color when
					;displaying a number, like the volume.
Displayed_Lines		EQU	0Ah	;To make clean space when displaying
					;the final results, we will scroll
					;down 10 (ten) lines.
Displayed_Help_Lines	EQU	22	;This is the same for the help screen.
Ending_Skip_Chars	EQU	41	;Amount of characters to skip to
					;start on the next row when writing
					;the final report.
Num_Of_Sources		EQU	4	;Amount of supported sources. By now
					;they are four: Master, CD Audio,
					;Treble and Bass.
PostMan_Lines		EQU	5

;---------------------------------------------------------------------------
;Here's the Message Dispatcher. Depending on the value given in al, this
;procedure will show the right message according to a table called
;Message_Table, which contains the name of each message. The message will
;be showed in the color given in AH.
;The errorlevel must be given in al, too (two functions in one!).
;---------------------------------------------------------------------------
Msg_Dispatcher	PROC
	cmp	cs:Null_Asked,0		;See if we should display any message.
	je	Null_Skipped		;If yes, show a message and exit.
	mov	ah,4Ch			;If not, exit to DOS with errorlevel
					;in AL.
	int	21h

Null_Skipped:
	call	Prepare_To_Write_Msg	;Prepare the Video Address to write
					;a message.
	lea	bx,Message_Table	;Load in BX a table which indicates
					;what message to show with the given
					;Errorlevel.

Get_Message_Loop:
	cmp	al,[bx]			;Compare the Errorlevel with the
					;byte at [BX].
	je	Send_Message		;If equal, then we found the right
					;message. Show it and exit.
	add	bx,3			;If not, skip to the next byte by
					;adding 3 to BX. 1 for the byte, and
					;2 for the word indicating the
					;address of a message.
	jmp	Get_Message_Loop	;Loop until we find the right
					;message.

Send_Message:
	inc	bx		;Point to the address of the message.
	mov	si,[bx]		;Move to SI the Message to display.
	call	Showmsg		;Show that Message.
	mov	ah,4Ch		;DOS function 4Ch to exit with the
				;ErrorLevel in AL.
	int	21h		;Exit to DOS.
Msg_Dispatcher	ENDP

Alldone		PROC
	cmp	cs:Null_Asked,0
	je	Alldone_Null_Skipped
	cmp	cs:Changed_Ports,0	;Whether the user gave a valid
					;parameter or not, if a parameter was
					;at the command line the program will
					;ALWAYS jump here. If no ports were
					;changed, then a bad parameter was
					;typed, and if it was typed in
					;conjunction with the 'nul' parameter,
					;this program should display the
					;message skipping the 'nul' asking
					;(Rules are Rules).
	je	Bad_Parameter		;So, see the Bad_Parameter proc to
					;keep reading about this stuff.
	mov	ah,4Ch
	int	21h

Alldone_Null_Skipped:
	cmp	cs:Changed_Ports,0	;If zero, it means that a parameter
					;was found but it was incorrectly
					;typed.
	jne	Show_Logo

Bad_Parameter:
	mov	cs:Null_Asked,0		;Whether or not the NULL_ASKED
					;variable was 1 or 0, it will be set
					;to zero because this message will
					;ALLWAYS be shown on screen.
	mov	ax,0C06h
	jmp	Msg_Dispatcher

Show_Logo:
	mov	ax,0900h		;First, scroll down some lines to
					;leave space for the final lines.
	lea	dx,cs:Clean_Space	;For that, write a series of
					;[0Dh, 0Ah], which are the CR/LF
					;characters.
	int	21h			;Using DOS function 09h.

	mov	ax,0300h		;Then, get current cursor position.
	xor	bx,bx
	int	10h			;Returns current row in DH.

	push	dx			;Save it, because we will have to
					;position the cursor again on the
					;current position.
	sub	dh,Displayed_Lines	;Substract from the resulting number
					;the amount of lines we scrolled down
					;before.
	mov	ax,0200h
	int	10h			;And position the cursor on the new
					;location.

	call	Prepare_To_Write_Msg	;Write on screen below current cursor
					;position.
	xor	ax,ax

Write_Ending_Lines:
	call	Screen_Setup	;Setup relevant data for the next routines.
	inc	al		;Increment the index value to print the next
				;line.
	lea	bx,Logo_Table	;Load the table which contains the addresses
				;of each help line to be printed.

Ending_Lines_Loop:
	cmp	Byte Ptr [bx],0 	;End of table?.
	je	End_Show_Logo		;If so, exit Mamma.
	cmp	al,[bx] 		;Is it this table entry?.
	je	Show_Ending_Line	;Write a line to the screen.
	add	bx,3			;No, try next entry.
	jmp	Ending_Lines_Loop

Show_Ending_Line:
	inc	bx		;Point to address of the procedure.

	mov	bp,[bx]		;Try to load not the address but the
				;contents so we can display them. To do that,
				;load the address in BP and then...
	lea	si,[bp]		;Load into SI what is at the address in BP.
				;Works!.

	cld				;Go forward.
	mov	cx,Help_Line_Length	;Write as many characters as needed.
	rep	movsw			;Write the Interface.

	add	di,cs:Skip_Bytes	;Go to the start of the next row.
	jmp	Write_Ending_Lines

End_Show_Logo:
	mov	bx,Num_Of_Sources	;In order to place the prompt line
					;right after the last line printed by
					;this program, we will set BX to 4,
					;then each of the four routines that
					;show their respective line will
					;decrease it in one unit. At the end,
					;BX will have the number of rows to
					;go up (starting from the row number
					;saved in DX).

Alldone_Master_Line:
	xor	ax,ax
	xor	cx,cx
	mov	al,cs:Changed_Ports	;Load the indicator of modified ports.
	and	al,0001xb		;See if we modified the Master volume.

	or	al,al			;If zero, we didn't modify it. So...
	jz	Alldone_Cd_Line		;Jump to the next port routine.

	lea	si,cs:Mastermsg		;Show 'Master' message.
	mov	ah,Device_Color
	call	Showmsg
	call	Show_Adjustedmsg

	mov	cl,cs:Master_Number_Length	;Load the amount of digits
						;the volume number has.
	mov	si,cs:Master_Number_Position	;And load the address where
						;it's placed.
	call	Show_Number			;Show the number.
	dec	bx			;One line displayed, one row less to
					;substract at the end of the routine.

Alldone_Cd_Line:
	xor	ax,ax
	xor	cx,cx
	mov	al,cs:Changed_Ports
	and	al,0010xb		;See if we modified the CD Audio
					;volume.
	or	al,al
	jz	Alldone_Treble_Line

	lea	si,cs:CDmsg
	mov	ah,Device_Color
	call	Showmsg
	call	Show_Adjustedmsg

	mov	cl,cs:Cd_Number_Length
	mov	si,cs:Cd_Number_Position
	call	Show_Number
	dec	bx

Alldone_Treble_Line:
	xor	ax,ax
	xor	cx,cx
	mov	al,cs:Changed_Ports
	and	al,0100xb		;See if we modified the Treble volume.

	or	al,al
	jz	Alldone_Bass_Line

	lea	si,cs:Treblemsg
	mov	ah,Device_Color
	call	Showmsg
	call	Show_Adjustedmsg

	mov	cl,cs:Treble_Number_Length
	mov	si,cs:Treble_Number_Position
	call	Show_Number
	dec	bx

Alldone_Bass_Line:
	xor	ax,ax
	xor	cx,cx
	mov	al,cs:Changed_Ports
	and	al,1000xb		;See if we modified the Treble volume.

	or	al,al
	jz	Alldone_Exit

	lea	si,cs:Bassmsg
	mov	ah,Device_Color
	call	Showmsg
	call	Show_Adjustedmsg

	mov	cl,cs:Bass_Number_Length
	mov	si,cs:Bass_Number_Position
	call	Show_Number
	dec	bx

Alldone_Exit:
	pop	dx			;Restore the cursor position. That
					;way the prompt line will appear just
					;below the ending lines.
	xchg	bh,bl			;Toggle so the SUB operation works
					;with DH and BH.
	sub	dx,bx			;By doing this, we place the prompt
					;line just below the last of the
					;lines.
	xor	bx,bx
	mov	ax,0200h		;Using function 02 to set it.
	int	10h

	mov	ax,4C00h	;DOS function 4Ch to exit with Errorlevel 0.
	int	21h		;Exit to DOS.
Alldone		ENDP

Show_Number	PROC
	push	cx		;Save the number of digits.
	mov	ah,Number_Color	;Print the numbers in the desired color.
	clc			;Make the LODSB and STOSW functions go
				;forward.

Num_Loop:
	lodsb			;Get a byte from DS:SI and put it in AL.
	stosw			;Move to video the current character in AL
				;to ES:DI (Video Address) plus it's
				;colour (in AH).
	loop	Num_Loop	;Loop 'til CX=0.
	pop	cx		;Restore. We need it because we must know how
				;many bytes we must skip to start writing on
				;the next row.
	cmp	cx,2		;So, we must add X bytes to DI.
	je	Add_One
	jb	Add_Two

Add_Zero:
	add	di,Ending_Skip_Chars*2	;If the number has three digits, skip
					;Ending_Skip_Chars characters
					;(multiplied by two because there are
					;two bytes for each character).
	jmp	End_Show_Number

Add_One:
	add	di,(Ending_Skip_Chars+1)*2	;If the number has two digits,
						;skip Ending_Skip_Chars+1
						;characters.
	jmp	End_Show_Number

Add_Two:
	add	di,(Ending_Skip_Chars+2)*2	;And if the number has two
						;digits, skip
						;Ending_Skip_Chars+2 chars.

End_Show_Number:
	add	di,cs:Skip_Bytes	;When finished, all lines will have
					;the same length, so we can now skip
					;the remaining bytes to start on the
					;next row. PLEASE!, see the notes on
					;the first messages below.
	ret
Show_Number	ENDP

Show_Adjustedmsg	PROC
	lea	si,cs:Adjustedmsg
	mov	ah,Alldone_Message_Color
	call	Showmsg
	ret
Show_Adjustedmsg	endp

PostMan_Proc	PROC
	mov	ax,0900h
	lea	dx,cs:PostMan_Poem
	int	21h
	mov	ax,4CF0h
	int	21h
PostMan_Proc	ENDP

Show_Help	PROC
	call	Screen_Setup
	mov	ax,0900h		;First, scroll down some lines to
					;leave space for the help screen.
	lea	dx,cs:Help_Clean_Space	;For that, write a series of
					;[0Dh, 0Ah], which are the CR/LF
					;characters.
	int	21h			;Using DOS function 09h.

	mov	ax,0300h		;Then, get current cursor position.
	xor	bx,bx
	int	10h			;Returns current row in DH.

	push	dx			;Save it, because we will have to
					;position the cursor again on the
					;current position.
	sub	dh,Displayed_Help_Lines	;Substract from the resulting number
					;the amount of lines we scrolled down
					;before.
	mov	ax,0200h
	int	10h			;And position the cursor on the new
					;location.

	call	Prepare_To_Write_Msg	;Write on screen below current cursor
					;position.
	xor	ax,ax

Write_Help_Lines:
	inc	al		;Increment the index value to print the next
				;line.
	lea	bx,Help_Table	;Load the table which contains the addresses
				;of each help line to be printed.

Help_Line_Loop:
	cmp	Byte Ptr [bx],0 	;End of table?.
	je	End_Of_Help		;If so, exit Mamma.
	cmp	al,[bx] 		;Is it this table entry?.
	je	Show_Help_Line		;Write a line to the screen.
	add	bx,3			;No, try next entry.
	jmp	Help_Line_Loop

Show_Help_Line:
	inc	bx		;Point to address of the procedure.

	mov	bp,[bx]		;Try to load not the address but the
				;contents so we can display them. To do that,
				;load the address in BP and then...
	lea	si,[bp]		;Load into SI what is at the address in BP.
				;Works!.

	cld			;Go forward.
	mov	cx,Help_Line_Length	;Write as many characters as needed.
	rep	movsw		;Write the Interface.

	add	di,cs:Skip_Bytes	;Go to the start of the next row.
	jmp	Write_Help_Lines

End_Of_Help:
	pop	dx			;Restore the cursor position. That
					;way the prompt line will appear just
					;below the help screen.
	xor	bx,bx
	mov	ax,0200h		;Using function 02 to set it.
	int	10h

	mov	ax,4C00h
	int	21h
Show_Help	ENDP

;Here go all the messages and a table used by the program.
;See that every message finishes with a "0". That is because we use that
;zero as an indicator for the end of the message.

Adjustedmsg	DB	': Volume adjusted to ',0

Mastermsg	DB	' Master       ',0	;See that there are several
						;blank spaces, and they all
CDmsg		DB	' CD Audio     ',0	;have 15 characters. That's
						;because when we later combine
Treblemsg	DB	' Sound Treble ',0	;all the strings, we get a
						;unique string with 80
Bassmsg		DB	' Sound Bass   ',0	;characters. By adding the
						;variable Skip_Bytes
						;calculated for the Help
						;screen, which also has 80
						;characters/line, we make our
						;way out without recalculating
						;Skip_Bytes.
Biggermsg	DB	'Can',27h,'t use this value because it is greater than the maximum volume.',0

Noteightmsg	DB	'Can',27h,'t use this value because it isn',27h,'t multiple of 8 (Eight).',0

Notvalidmsg	DB	'The volume number you specified had a non-numeric character!.',0

Badenvmsg	DB	'The BLASTER environment string is bad!. Please review it.',0

Noenvmsg	DB	'The BLASTER environment string is not in memory!.',0

Badparametermsg	DB	'You typed a bad parameter!. Type SVC ? to see a list of valid parameters.',0

Nonumbermsg	DB	'The parameter was fine, but you forgot the volume number!.',0

Wrongaddressmsg	DB	'The A2x0 directive in the BLASTER environment string is wrong!.',0

Clean_Space	DB	Displayed_Lines DUP (0Dh, 0Ah), '$'
			;This is a clean sequence that is used because it has
			;the advantage of scrolling the screen as much as
			;needed. No less, no more.
Help_Clean_Space	DB	Displayed_Help_Lines DUP (0Dh, 0Ah), '$'
			;This is the same for the Help screen.
PostMan_Clean_Space	DB	5 DUP (0Dh, 0Ah), '$'

PostMan_Poem	DB	'Everything has happened now, She',27h,'s not here anymore.',0Dh,0Ah
		DB	'My grief has no voice, on my heart She has left a sore.',0Dh,0Ah
		DB	'To wish Griselda, is like wishing a perfect dream,',0Dh,0Ah
		DB	'indeed it never comes, indeed it never will...',0Dh,0Ah,'$'

Message_Table	LABEL	BYTE
	DB	01
	DW	Notvalidmsg
	DB	02
	DW	Noteightmsg
	DB	03
	DW	Biggermsg
	DB	04
	DW	Noenvmsg
	DB	05
	DW	Badenvmsg
	DB	06
	DW	Badparametermsg
	DB	07
	DW	Nonumbermsg
	DB	08
	DW	Wrongaddressmsg

Logo_Table	LABEL	BYTE
	DB	01
	DW	Help_One
	DB	02
	DW	Help_Two
	DB	03
	DW	Help_Three
	DB	04
	DW	Help_Four
	DB	05
	DW	Help_Five
	DB	06
	DW	Help_Six
	DB	0

Help_Table	LABEL	BYTE	;See that Help_Six is repeated several times.
	DB	01		;That's because it has a blank line, so to
	DW	Help_One	;save memory (and disk space) the table uses
	DB	02		;Help_Six for all blank lines.
	DW	Help_Two
	DB	03
	DW	Help_Three
	DB	04
	DW	Help_Four
	DB	05
	DW	Help_Five
	DB	06
	DW	Help_Six
	DB	07
	DW	Help_Seven
	DB	08
	DW	Help_Six
	DB	09
	DW	Help_Nine
	DB	10
	DW	Help_Ten
	DB	11
	DW	Help_Six
	DB	12
	DW	Help_Twelve
	DB	13
	DW	Help_Thirteen
	DB	14
	DW	Help_Fourteen
	DB	15
	DW	Help_Fifteen
	DB	16
	DW	Help_Six
	DB	17
	DW	Help_Seventeen
	DB	18
	DW	Help_Eighteen
	DB	19
	DW	Help_Nineteen
	DB	20
	DW	Help_Six
	DB	21
	DW	Help_Twentyone
	DB	22
	DW	Help_Twentytwo
	DB	23
	DW	Help_Six
	DB	24
	DW	Help_Six
	DB	0

Help_One:
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,' ',01,' ',01

Help_Two:
        DB      '',31,' ',31,'S',28,'o',28,'u',28,'n',28,'d',28,' ',28
        DB      'V',28,'o',28,'l',28,'u',28,'m',28,'e',28,' ',28,'C',28
        DB      'o',28,'n',28,'t',28,'r',28,'o',28,'l',28,' ',28,' ',28
        DB      ' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28
        DB      ' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28
        DB      ' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28
        DB      ' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,' ',28
        DB      ' ',28,' ',28,' ',28,' ',28,' ',28,' ',28,'V',26,'e',26
        DB      'r',26,'s',26,'i',26,'o',26,'n',26,' ',26,'2',30,'.',30
        DB      '2',30,'0',30,'m',30,'k',30,' ',30,'',31,'',01,'',01

Help_Three:
        DB      '',31,' ',31,'A',27,'n',27,'d',27,'r',27,'',27,'s',27
        DB      ' ',27,'C',27,'.',27,' ',27,'M',27,'a',27,'z',27,'z',27
        DB	'o',27,'c',27,'c',27,'h',27,'i',27,' ',27,'a',27,'k',27
        DB	'a',27,' ',27,'S',27,'h',27,'i',27,'e',27,'l',27,'d',27
        DB	'e',27,'n',27,' ',27,'-',27,' ',27,'S',27,'e',27,'p',27
        DB	't',27,'e',27,'m',27,'b',27,'e',27,'r',27,' ',27,'1',27
        DB	'8',27,'t',27,'h',27,',',27,' ',27,'1',27,'9',27,'9',27
        DB	'7',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27
        DB      ' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27,' ',27
        DB      ' ',27,' ',27,' ',27,' ',27,' ',27,'',31,'',01,'',01

Help_Four:
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',31,'',31
        DB      '',31,'',31,'',31,'',31,'',31,'',31,'',01,'',01

Help_Five:
        DB      ' ',01,' ',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
        DB      '',01,'',01,'',01,'',01,'',01,'',01,'',01,'',01
		
Help_Six:
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Seven:
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,'-',11,'-',14,'-',11,' ',11,'S',14,'o',14
        DB      'u',14,'n',14,'d',14,' ',14,'B',14,'l',14,'a',14,'s',14
        DB      't',14,'e',14,'r',14,' ',14,'1',14,'6',14,'/',14,'A',14
        DB      'W',14,'E',14,'3',14,'2',14,' ',14,'V',14,'o',14,'l',14
        DB      'u',14,'m',14,'e',14,' ',14,'C',14,'o',14,'n',14,'t',14
        DB      'r',14,'o',14,'l',14,' ',14,'-',11,'-',14,'-',11,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Nine:
        DB      'U',11,'s',11,'a',11,'g',11,'e',11,':',11,' ',11,'S',07
        DB      'V',07,'C',07,' ',07,'[',07,'E',07,'n',07,'t',07,'e',07
        DB      'r',07,']',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Ten:
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,'O',14
        DB      'R',14,' ',14,' ',14,'S',07,'V',07,'C',07,' ',07,'m',10
        DB      'a',10,'[',07,':',07,']',07,'V',14,'o',14,'l',14,'u',14
        DB      'm',14,'e',14,' ',14,'c',10,'d',10,'[',07,':',07,']',07
        DB      'V',14,'o',14,'l',14,'u',14,'m',14,'e',14,' ',14,'t',10
        DB      'r',10,'[',07,':',07,']',07,'V',14,'o',14,'l',14,'u',14
        DB      'm',14,'e',14,' ',14,'b',10,'s',10,'[',07,':',07,']',07
        DB      'V',14,'o',14,'l',14,'u',14,'m',14,'e',14,' ',14,'[',07
        DB      'n',12,'u',12,'l',12,']',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Twelve:
        DB      'E',11,'x',11,'a',11,'m',11,'p',11,'l',11,'e',11,'s',11
        DB      ':',11,' ',11,'S',07,'V',07,'C',07,' ',07,'m',07,'a',07
        DB      ':',07,'2',07,'4',07,'8',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Thirteen:
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,'S',07,'V',07,'C',07,' ',07,'m',07,'a',07
        DB      ':',07,'1',07,'7',07,'6',07,' ',07,'c',07,'d',07,':',07
        DB      '2',07,'0',07,'8',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Fourteen:
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07
        DB      '-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07,'-',07

Help_Fifteen:
        DB      'C',11,'o',11,'m',11,'m',11,'a',11,'n',11,'d',11,' ',11
        DB      'S',11,'u',11,'m',11,'m',11,'a',11,'r',11,'y',11,':',11
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Seventeen:
        DB      ' ',11,'m',11,'a',11,' ',11,' ',11,':',11,' ',11,'M',07
        DB      'a',07,'s',07,'t',07,'e',07,'r',07,' ',07,'V',07,'o',07
        DB      'l',07,'u',07,'m',07,'e',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,'(',07,'M',07,'a',07,'x',07,'.',07,' ',07
        DB      '2',07,'4',07,'8',07,')',07,' ',07,' ',07,' ',07,' ',07
        DB      't',11,'r',11,' ',11,':',11,' ',11,'S',07,'o',07,'u',07
        DB      'n',07,'d',07,' ',07,'T',07,'r',07,'e',07,'b',07,'l',07
        DB      'e',07,' ',07,'(',07,'M',07,'a',07,'x',07,'.',07,' ',07
        DB      '2',07,'4',07,'0',07,')',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Eighteen:
        DB      ' ',07,'c',11,'d',11,' ',11,' ',11,':',11,' ',11,'C',07
        DB      'D',07,' ',07,'A',07,'u',07,'d',07,'i',07,'o',07,' ',07
        DB      'V',07,'o',07,'l',07,'u',07,'m',07,'e',07,' ',07,' ',07
        DB      ' ',07,' ',07,'(',07,'M',07,'a',07,'x',07,'.',07,' ',07
        DB      '2',07,'4',07,'8',07,')',07,' ',07,' ',07,' ',07,' ',07
        DB      'b',11,'s',11,' ',11,':',11,' ',11,'S',07,'o',07,'u',07
        DB      'n',07,'d',07,' ',07,'B',07,'a',07,'s',07,'s',07,' ',07
        DB      ' ',07,' ',07,'(',07,'M',07,'a',07,'x',07,'.',07,' ',07
        DB      '2',07,'4',07,'0',07,')',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Nineteen:
        DB      ' ',07,'n',11,'u',11,'l',11,' ',11,':',11,' ',11,'S',07
        DB      'k',07,'i',07,'p',07,' ',07,'s',07,'c',07,'r',07,'e',07
        DB      'e',07,'n',07,' ',07,'o',07,'u',07,'t',07,'p',07,'u',07
        DB      't',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07
        DB      ' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07,' ',07

Help_Twentyone:
        DB      ' ',07,'-',11,' ',11,'T',07,'h',07,'e',07,' ',07,'v',07
        DB      'o',07,'l',07,'u',07,'m',07,'e',07,' ',07,'n',07,'u',07
        DB      'm',07,'b',07,'e',07,'r',07,'s',07,' ',07,'s',07,'h',07
        DB      'o',07,'u',07,'l',07,'d',07,' ',07,'b',07,'e',07,' ',07
        DB      '8',07,' ',07,'(',07,'E',07,'i',07,'g',07,'h',07,'t',07
        DB      ')',07,' ',07,'m',07,'u',07,'l',07,'t',07,'i',07,'p',07
        DB      'l',07,'e',07,' ',07,'a',07,'n',07,'d',07,' ',07,'t',07
        DB      'h',07,'e',07,'y',07,' ',07,'c',07,'a',07,'n',07,39,07
        DB      't',07,' ',07,'b',07,'e',07,' ',07,'l',07,'a',07,'r',07
        DB      'g',07,'e',07,'r',07,' ',07,'t',07,'h',07,'a',07,'n',07

Help_Twentytwo:
        DB      ' ',07,' ',07,' ',07,'t',07,'h',07,'e',07,'i',07,'r',07
        DB      ' ',07,'m',07,'a',07,'x',07,'i',07,'m',07,'u',07,'m',07
        DB      ' ',07,'(',07,'M',07,'a',07,'x',07,'.',07,' ',07,'#',07
        DB      '#',07,'#',07,')',07,' ',07,'v',07,'o',07,'l',07,'u',07
        DB      'm',07,'e',07,' ',07,'v',07,'a',07,'l',07,'u',07,'e',07
        DB      '.',07,' ',07,'V',07,'a',07,'l',07,'u',07,'e',07,'s',07
        DB      ' ',07,'c',07,'a',07,'n',07,' ',07,'c',07,'o',07,'n',07
        DB      't',07,'a',07,'i',07,'n',07,' ',07,'u',07,'p',07,' ',07
        DB      't',07,'o',07,' ',07,'t',07,'h',07,'r',07,'e',07,'e',07
        DB      ' ',07,'d',07,'i',07,'g',07,'i',07,'t',07,'s',07,'.',07
