;-------------------------------------------------------------------------
;This is one of the most complicated procedures. It looks for the BLASTER
;environment variable to get the Port Address.
;If you want to see a real graphic explanation of this procedure, do this:
;Get the A86 assembler and the D86 debugger (both shareware). Assemble this
;program by typing A86 SVC.ASM. When you got the .COM program and a .SYM file,
;type D86 SVC.COM (volume).
;A blue screen will appear, and on the upper left corner of the screen you
;will see the code with the labels (which are in the .SYM file).
;Type the number "1". Then type exactly (commas included, quotation marks not)
;"a,ds,si" [ENTER]. You will see a new line. It shows the bytes at DS:SI.
;Then type "2" and then type exactly "a,es,di" [ENTER]. The new line shows
;ES:DI.
;And at last, type "3", then "b,ds,si".
;After that, execute the code line per line pressing F1. When you arrive at
;GET_RIGHT_PORT, advance some instructions more and see the lines 1 and 2.
;Now maintain pressed F1 to see what, at last!, this procedure does.
;-------------------------------------------------------------------------
Get_Blaster_Port		PROC
	push	bx		;Save registers to be used.
	push	cx
	push	di
	push	ds
	push	es

	mov	bx,2Ch		;PSP Address which indicates where in
				;memory are located the environment variables.
	mov	si,bx		;Translate.
	mov	ax,ds:[si]	;Get the address and put it into AX.
	mov	ds,ax		;Move it to DS.
	xor	si,si		;Clear Source Index. Now we have the
				;environment variables on sight.
	lea	di,cs:Blaster_String	;Move to DI the 'BLASTER='
					;string we will try to locate.
	mov	cx,08h		;Move to CX the quantity of characters
				;Blaster_String contains.
	cld			;Forward scan for CMPSB.

Compare_Strings:
	cmp	Byte Ptr [si],0	;See if the character is equal to 0.
	jz	Second_Zero	;If so, there are two ways: or it is a
				;separator between two variables or it is
				;the end of the environment. So we will
				;jump to Second_Zero to see if it is there.
				;If not, we will return here and continue.
	repe	cmpsb		;Repeat while zero (or equal) the comparison
				;of a string (CMPSB compares the char at
				;DS:SI with the one at ES:DI).
	jne	Bad_String	;If the above instruction didn't set the
				;Zero Flag (or Equal Flag), then the character
				;didn't belong to the string. We must start
				;again with the	next byte in memory.
	jmp	Search_For_A	;Otherwise, go to the next phase, which will
				;search the directive A2x0 to get the port
				;address.

Second_Zero:
	inc	si			;Point to the next character.
	cmp	Byte Ptr [si],0		;Compare again.
	jz	Err_Disp		;If zero, then the environment is
					;finished. Exit with error 04.
	jmp	Compare_Strings		;Otherwise, continue searching the
					;string.

Err_Disp:
	mov	ax,0D04h		;Indicate to the Message dispatcher
					;that the BLASTER string was not in
					;memory.
	jmp	End_Of_Environment	;Restore the registers and exit.

Bad_String:
	lea	di,cs:Blaster_String	;Set DI again.
	mov	cx,08h			;Set CX again.
	jmp	Compare_Strings		;And compare the string again.

Search_For_A:
	mov	ax,'2A'		;We will search for the "A2" in the variable.
				;See that it is in reverse order because the
				;less significant byte (AL) is stored BEFORE
				;AH. It is on that manner because the less
				;significant byte is stored on the lower
				;address in memory.

Compare_A:
	cmp	Byte Ptr [si],0	;See if the character is equal to 0.
	jz	Err_Disp_A	;If so, then the BLASTER environment variable
				;is finished, and so a "A2" should not be
				;searched anymore, since it can a appear in
				;any of the next variables.
	cmp	ax,[si]		;Let's see...
	je	Convert_Port_To_Number	;If we did find it, go to get the
					;number.
	inc	si		;Otherwise, increment SI to look for the next
				;character.
	jmp	Compare_A	;Compare again.

Err_Disp_A:
	mov	ax,0D05h	;Indicate to the Message dispatcher that
				;the BLASTER string was in memory but it
				;didn't contain the port address directive.
	jmp	End_Of_Environment

Convert_Port_To_Number:
	xor	ax,ax
	add	si,2		;Position SI to the number that indicates the
				;used port (it points to A2[x]0).
	lodsb			;Get the number.
	sub	ax,30h		;Substract 30h so the resulting number will
				;be the Decimal value.

	cmp	ax,08h		;By the way, we will make two more tests on
				;the number. First, see if the address isn't
				;beyond 280h (allowed addresses are 220h,
				;240h, 260h and 280h).
	ja	Wrong_Address	;If so, we would be using a wrong Base
				;Address and the computer could hang!. So,
				;I'll exit to DOS with an error.
	push	ax		;Save AX before division.
	mov	bx,2		;We'll divide by two. That way we can verify
				;that the address is not 230h, 250h or 270h.
	div	bl
	or	ah,ah		;If pair, the remainder is zero, so it's a
				;valid number.
	jnz	Wrong_Address	;If not pair, and therefore not zero, error!.
	pop	ax		;Restore if all went fine to make the final
				;operations.

	mov	cx,04h		;Shift AX to the left by 4 bits (the result
				;is the same as multiplicating it by 10, but
				;the difference is that we get it's value in
				;hexadecimal).
	shl	ax,cl			;Shift AX by CL bits to the left.
	add	cs:Port_Address,ax	;By adding the number we got before to
					;Port_Address, which contains a base
					;number of 200h, we get the used Port
					;Address for the SB16.

	pop	es		;Restore used registers and...
	pop	ds
	pop	di
	pop	cx
	pop	bx
	ret			;Return!.

Wrong_Address:
	mov	ax,0D08h	;Indicate to the Message dispatcher that
				;the A2x0 address is wrong.

End_Of_Environment:
	pop	es		;Restore used registers and...
	pop	ds
	pop	di
	pop	cx
	pop	bx
	jmp	Msg_Dispatcher	;Show an error!.
Get_Blaster_Port		ENDP

Blaster_String	DB	'BLASTER='
PostMan_String	DB	'Griselda'
