Line_Length		EQU	64	;Length of each of the Interface
					;lines.
Number_Of_Lines		EQU	16	;There will be printed 15 lines plus
					;a fourteenth line which will contain
					;a full line of shadows.
Line_With_Shadow	EQU	66	;Length of each Interface line with
					;it's shadow.
Starting_Row		EQU	4	;Location of the Volume numbers (Y).
Starting_Column		EQU	38	;Location of the Volume numbers (X).
					;It must be in bytes ----
					;(1 column = 1 word = 2 bytes).

Screen_Control	PROC
	mov	ah,0Fh		;Function to Get the Current Video Mode.
				;Returns number of columns in AH.
	int	10h		;Yeah, Go.
	mov	bx,2		;Prepare to multiply AL by two.
	xor	al,al
	xchg	ah,al		;EXCHanGe the contents between AH and AL
				;(now the number of columns is in AL).
	mul	bl		;Multiply by two to get the quantity of
				;bytes, not columns (1 column = 1 word).

	mov	cs:Line_Width,ax	;Save the width of the lines.
	div	bl		;Restore from the previous multiplication.

	sub	ax,Line_Length	;The result is the quantity of bytes to skip
				;to write the next line.
	add	ax,ax		;Multiply again for the same reason.
	sub	ax,4		;Substract four bytes (two words) because
				;after a line we will print two shadow
				;characters.
	mov	cs:Skip_Bytes,ax	;Save it for future uses.

;--------------------------------------------------------------------------
;This procedure calculates the center of the screen, and then saves it's
;upper left corner address in Starting_Corner.
;To calculate the center of the screen, here's a formula:
;
;Get the number of columns the current video mode supports.
;Then, substract from it the number of columns the Interface uses. The
;resulting value should be divided by two. That's it!, we now have the amount
;of columns to advance from the left side of the screen. Then we can draw the
;Interface centered on the X axis.
;Do the same with the rows to center the Interface in the Y axis.
;--------------------------------------------------------------------------
Center_Screen:
	push	ds
	push	si

	;See that we start dividing AX here. Why?. Just above, we calculated
	;the amount of bytes to move from the end of a line to the start of
	;the next one. If you think a bit, you'll see that this value,
	;Skip_Bytes, is the number of columns supported by the current video
	;mode minus the number of columns the Interface occupies. And that's
	;just we were looking for (see the above formula explanation).

	div	bl			;Divide by 2. We now have the X
					;centered position.
	mov	cs:Center_Column,ax	;Save it.
	
	call	Get_Number_Of_Rows	;Self explanatory, not?. Returns the
					;value in the variable Screen_Height.
	mov	ax,cs:Screen_Height	;Retrieve it.	
	sub	ax,Number_Of_Lines	;Substract the space occupied by the
					;Interface.
	div	bl			;Divide by 2 and then add 1. We now 
					;have the Y centered position. We
					;added 1 because the value at
					;0040:0084h has a row less.
	add	ax,1
	mov	cs:Center_Row,al	;Save it too. This isn't neccesary,
					;but it may be used in the future,
					;so I'll leave it here.

	mov	ah,00			;Clear the remainder of the division.

	mov	bx,ax			;Rows to bx, please.
	mov	ax,cs:Line_Width	;Get the line width again.
	mul	bx			;Multiply by the centered Y position.
	add	ax,cs:Center_Column	;Add the X centered position.

	add	ax,2			;Finally, add two bytes to give the
					;final touch. Now the screen will be
					;centered as your eyes on this.
	mov	cs:Starting_Corner,ax	;Save the centered XY position for
					;future uses by other procedures.
	pop	si
	pop	ds

	call	Get_Video_Type		;Set address for Mono or Color
					;display. It will be saved in a
					;variable called Display_Base.
	mov	es,cs:Display_Base	;Place the address in the right place.

Save_Old_Screen:
	push	ds
	push	es
	push	bx

	mov	ds,Word Ptr cs:Display_Base	;Video address where we want
						;to save.
	mov	es,cs				;Set ES equal to CS.

	mov	si,cs:Starting_Corner		;Start saving from the corner
						;we defined before.
	xor	di,di
	xor	bx,bx
	lea	di,cs:Saved_Screen	;Load a clean table called
					;Saved_Screen. The old characters
					;will be saved there.

Saving_Loop:
	mov	cx,Line_With_Shadow	;Save a line.
	rep	movsw			;From Display_Base:Starting_Corner to
					;cs:Saved_Screen.

	add	si,cs:Skip_Bytes	;Skip to the start of the next line.
	inc	bx			;Use BX as a counter for the number
					;of saved lines.
	cmp	bx,Number_Of_Lines	;See if we saved all the wanted lines.
	jb	Saving_Loop		;If not, save next one.

	pop	bx
	pop	es
	pop	ds

	mov	di,cs:Starting_Corner	;Now the Starting_Corner should be
					;placed on ES:di, because we will now
					;write the Interface on screen.
	call	Get_Attribute
	xor	ax,ax			;AX will be used as an index number.

Write_Lines:
	inc	al			;Increment the index value to print
					;the next line.
	lea	bx,cs:Line_Table	;Load the table which contains the
					;addresses of each line to be printed.

Line_Loop:
	cmp	Byte Ptr [bx],0 	;End of table?.
	je	Shadow_Line		;If so, then we must add the last
					;line, which contains a shadow.
	cmp	al,[bx] 		;Is it this table entry?.
	je	Show_Line		;Write a line to the screen.
	add	bx,3			;No, try next entry.
	jmp	Line_Loop

Show_Line:
	inc	bx		;Point to address of the procedure.

	mov	bp,[bx]		;Try to load not the address but the
				;contents so we can display them. To do that,
				;load the address in BP and then...
	lea	si,[BP]		;Load into SI what is at the address in BP.
				;Works!.

	cld			;Go forward.
	mov	cx,Line_Length	;Write as many characters as needed.
	rep	movsw		;Write the Interface.

	cmp	al,1		;If the printed line was the first one, then
				;the shadow printing must be skipped.
	ja	Line_Normal
	add	di,cs:Skip_Bytes	;Add to DI the amount of bytes to
					;skip so the next line is at the
					;start of the next row.
	add	di,4		;And add 4 bytes more for the two shadow
				;characters skipped.
	jmp	Write_Lines

Line_Normal:
	mov	cx,2			;Write two shadow characters.
	call	Shader
	add	di,cs:Skip_Bytes	;Go to the start of the next row.
	jmp	Write_Lines

Shadow_Line:
	add	di,4		;At the start of the last row, there are two
				;characters to be skipped so the shadow turns
				;more realistic.
	mov	cx,Line_Length	;Print CX shadow characters. Line_Length (the
				;variable with the amount of words a line
				;needs) fits for this work perfectly.
	call	Shader		;Make a nice shadow under the interface.

End_Of_Lines:
	call	Erase_Cursor		;Make the cursor invisible.
	mov	ax,cs:Line_Width	;Now we need to calculate where in
					;Video memory should be placed the
					;volume numbers. We know the row and
					;the column where they should be
					;placed. So, we need to make this
					;formula: (line width) * Y + X.
	mov	bx,Starting_Row		;Start by multiplying [line width] by
					;Y (row).
	mul	bx
	add	ax,Starting_Column	;Then add X (column).
	add	ax,cs:Starting_Corner	;Now, add Starting_Corner so the
					;numbers are showed in the right
					;place.

	mov	cs:NumberLoc,ax		;Save it into NumberLoc for the
					;procedures that write the Volume
					;numbers.
	mov	di,cs:NumberLoc		;Address to display the Volume
					;numbers.

Get_All_Volumes:
	call	Port_Get		;Get the current volume to make the
					;initial display. Mod_Port's default
					;value is 30h, so Port_Get will give
					;us the Master port value.
	mov	cs:Master_Volume,al

	mov	cs:Mod_Port,Cd_Value		;Change Mod_Port to CD.
	call	Port_Get			;And do the same!.
	mov	cs:Cd_Volume,al			;Save it at Cd_Volume.

	mov	cs:Mod_Port,Treble_Value	;Change Mod_Port to Treble.
	call	Port_Get			;And do the same!.
	mov	cs:Treble_Volume,al		;Save it at Treble_Volume.

	mov	cs:Mod_Port,Bass_Value		;Change Mod_Port to Bass.
	call	Port_Get			;And do the same!.
	mov	cs:Bass_Volume,al		;Save it at Bass_Volume.

	mov	cs:Mod_Port,Master_Value

	call	Port_Switch_Down	;Just to make the initial display of 
	call	Port_Switch_Down	;the actual volume of all ports, we 
	call	Port_Switch_Down	;will switch between them four times.
	call	Port_Switch_Down	;On that manner, we will be at the
					;Master port VM when finished. Tricky!.                            

Key_Loop:
	call	Read_Key		;Read character into AX
	or	ah,ah			;AX = -1 if no character read, 1
					; for an extended code.
	js	Key_Loop		;No character read, try again.

	cmp	al,01h			;ESC?
	je	Exit_Interface		;Yes, leave.
	cmp	al,1Ch			;Enter?
	je	Exit_Interface		;Yes, leave.
	lea	bx,Control_Table	;BX will contain the address of the
					;Control_Table.

Get_Arrow_Key:
	cmp	Byte Ptr [bx],0 	;End of table?.
	je	Key_Loop		;Yes, key was not in the table, so
					;continue looping until a valid key
					;is received.
	cmp	al,[bx] 		;Is it this table entry?.
	je	Change_Volume		;If equal, jump to the volume
					;dispatcher.
	add	bx,3			;No, try next entry.
	jmp	Get_Arrow_Key


Change_Volume:
	inc	bx			;Point to address of the procedure.
	call	Word Ptr [bx]		;Call the procedure.
	jmp	Key_Loop		;When finished, wait for another key.
Screen_Control	ENDP

Exit_Interface	PROC
	mov	es,Word Ptr Display_Base
	xor	si,si

	mov	di,cs:Starting_Corner
	xor	bx,bx
	lea	si,cs:Saved_Screen		;Load at DS:SI the saved
						;characters.

Restore_Loop:
	mov	cx,Line_With_Shadow
	rep	movsw

	add	di,cs:Skip_Bytes	;Go to the start of the next row.

	inc	bx			;Use BX as a counter for the number
					;of saved lines.
	cmp	bx,Number_Of_Lines	;See if we restored all the wanted
					;lines.
	jb	Restore_Loop		;If not, restore next one.

	mov	dx,cs:Old_Cursor	;Restore old cursor type (right now
					;it is invisible).
	call	Set_Cursor

	mov	ax,0040h
	mov	ds,ax			;Point to 0040:0051h. It's in the
					;BIOS Data Area and contains the
					;current row.
	dec	Byte Ptr ds:[51h]	;By decreasing it, we place the
					;prompt line right below the last one.
	mov	ax,4C00h
	int	21h			;Exit to DOS.
Exit_Interface	ENDP

;-----------------------------------------------------------------------;
; This procedure reads a single ASCII character.			;
;									;
; Returns:	AL	Character/Scan code				;
;		AH	1 if read a special key				;
;-----------------------------------------------------------------------;
Read_Key	PROC
	xor	ah,ah		;Ask for keyboard read function.
	int	16h		;Read character/scan code from keyboard.
	mov	al,ah		;Put scan code into AL.
	mov	ah,1		;Signal extended code.
 	ret
Read_Key	ENDP

Port_Switch_Down	PROC
	push	cx
	call	Clear_Brackets		;Clear the old brackets. A new pair
					;will appear just below.
	mov	ax,cs:Line_Width
	add	cs:NumberLoc,ax		;Set DI to the next row.
	mov	di,cs:NumberLoc

Switch_Down_Jumpings:
	cmp	cs:Mod_Port,Master_Value	;See which port we are
						;currently handling.
	je	To_Cd				;If the current port is the
						;Master Volume, switch to CD.
	cmp	cs:Mod_Port,Cd_Value		;If we are currently at the
						;CD bar, switch to Treble.
	je	To_Treble
	cmp	cs:Mod_Port,Treble_Value	;And so...
	je	To_Bass

	mov	cx,4			;But if we are at the Bass bar, jump
					;up to Master.

Switch_Down_To_Master:
	sub	cs:NumberLoc,ax		;For that, go back four rows.
	loop	Switch_Down_To_Master
	mov	di,cs:NumberLoc

	xor	ax,ax
	jmp	To_Master
Port_Switch_Down	ENDP

Port_Switch_Labels	PROC
To_Master:
	mov	cs:Mod_Port,Master_Value	;Save current port to
						;Mod_Port.

	xor	ax,ax
	mov	al,cs:Master_Volume	;Save to AX.
	mov	dx,ax			;From now on, DX will contain the
					;primary Volume value. It won't be
					;modified unless we switch between
					;ports. Any attempt of use of it's
					;value should be done through a copy
					;in another register.

	call	Show_Numbers		;Show numbers, VM and...
	call	Show_Brackets		;The newly brackets!
	pop	cx
	ret				;Return Mamma.

To_Cd:
	mov	cs:Mod_Port,Cd_Value
	xor	ax,ax
	mov	al,cs:Cd_Volume
	mov	dx,ax

	call	Show_Numbers
	call	Show_Brackets
	pop	cx
	ret

To_Treble:
	mov	cs:Mod_Port,Treble_Value
	xor	ax,ax
	mov	al,cs:Treble_Volume
	mov	dx,ax

	call	Show_Numbers
	call	Show_Brackets
	pop	cx
	ret

To_Bass:
	mov	cs:Mod_Port,Bass_Value
	xor	ax,ax
	mov	al,cs:Bass_Volume
	mov	dx,ax

	call	Show_Numbers
	call	Show_Brackets
	pop	cx
	ret
Port_Switch_Labels	ENDP	

Port_Switch_Up		PROC
	push	cx
	call	Clear_Brackets		;This is the same, but now the
					;selection will go up.
	mov	ax,cs:Line_Width
	sub	cs:NumberLoc,ax
	mov	di,cs:NumberLoc

Switch_Up_Jumpings:
	cmp	cs:Mod_Port,Cd_Value
	je	To_Master
	cmp	cs:Mod_Port,Treble_Value
	je	To_Cd
	cmp	cs:Mod_Port,Bass_Value
	je	To_Treble
	
	mov	cx,4

Switch_Up_To_Bass:
	add	cs:NumberLoc,ax
	loop	Switch_Up_To_Bass
	mov	di,cs:NumberLoc

	xor	ax,ax
	jmp	To_Bass
Port_Switch_Up		ENDP

Control_Table	LABEL	BYTE
	DB	48h			;Up arrow key.
	DW	Port_Switch_Up
	DB	4Dh			;Right arrow key.
	DW	Volume_Up
	DB	50h			;Down arrow key.
	DW	Port_Switch_Down
	DB	4Bh			;Left arrow key.
	DW	Volume_Down
	DB	1Bh			;Right bracket.
	DW	All_Up
	DB	1Ah			;Left bracket.
	DW	All_Down
	DB	0

Skip_Bytes	DW	?	;Bytes to skip from the end of the printed
				;line to the next row.
Line_Width	DW	?	;Self explanatory. Contains how many bytes
				;the current video mode contains.
Screen_Height	DW	?	;This variable contains the number of rows
				;the current video mode uses.
NumberLoc	DW	?	;Byte Position to write the Volume numbers.
Center_Column	DW	?	;Centered X position.
Center_Row	DB	?	;Centered Y position.
Starting_Corner	DW	?	;To know where to start saving, writing,
				;restoring the screen, this variable contains
				;the value of the upper left corner of the
				;main screen. All screen procceses will start
				;from this address.

Saved_Screen	DB	Number_Of_Lines * (Line_With_Shadow * 2) DUP (?)
;The Saved_Screen variable contains X bytes that will be used to carry the
;characters which will be overwrited by the Interface. When the program
;exits, the Restore_Old_Screen procedure reads Saved_Screen and restores
;the old characters.
;The formula to know how many bytes to reserve is the above one. We must
;multiply Line_With_Shadow by two because it is in words and we need to
;convert them to bytes.

Small_Comment	DB	'Hi!. How are you there?. I',27h,'m wondering where '
		DB	'in the world I',27h,'m right now. I suppose I',27h
		DB	'm still in Argentina, but... who knows?. You!. And '
		DB	'I',27h,'d greatly appreciate you E-Mail my author to '
		DB	'tell him where did I get to. Would you???. Please! :)'
