/*****************************************************************************
*                           BC 3.2 LIBRARY                                   *
*                         MOUSE ROUTINES V1.0                                *
*                               MOUSE.C                                      *
*                                                                            *
*  This product is copyrighted (C) 1996 by Henk Thomassen. Permission is     *
*  granted for non-commercial use and distribution.                          *
******************************************************************************
* REMARK:  Only basic set of MOUSE-functions included.                       *
*          Use the mouse event handler to detect mouse-actions.              *
*                                                                            *
*          v1.0 Jan 1996                                                     *
*                                                                            *
******************************************************************************
* If you have any questions or remarks please contact me                     *
* Henk Thomassen, thomass@IAEhv.nl                                           *
*****************************************************************************/

#include <dos.h>
#include <stdio.h>
#include "mouse.h"

// -------------------------GLOBAL VARIABLE---------------------------------
int mouse_present;
unsigned LastMask = 0;


// -------------------------LOCAL VARIABLE---------------------------------
static unsigned arrowdata[] = {
    0xFFFF,0x9FFF,0x8FFF,0x87FF,0x83FF,0x81FF,0x80FF,0x807F,0x803F,
    0x801F,0x800F,0x801F,0x807F,0x887F,0xDC3F,0xFC3F,
    0x0,0x0,0x2000,0x3000,0x3800,0x3C00,0x3E00,0x3F00,0x3F80,0x3FC0,
    0x3FE0,0x3E00,0x3300,0x2300,0x0180,0x0180
   };
static unsigned targetdata[] = {
    0xFFFF,0xFFFF,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0x06C1,0x0101,
    0x06C1,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFFFF,
    0x0000,0x0000,0x0000,0x0100,0x0100,0x0100,0x0100,0x0000,0x783C,
    0x0000,0x0100,0x0100,0x0100,0x0100,0x0000,0x0000
   };

static struct REGPACK reg ;
static const MAXEVENTBUF = 50;
static struct eventbufTYPE{int x,y,k,d;} eventbuf[MAXEVENTBUF+1];
static int eventbufin=0;
static int eventbufout=0;


/***************************************************************************
*                               callmouse                                  *
***************************************************************************/
static void callmouse(void)
{
    intr(MOUSEINT,&reg);
};

/***************************************************************************
*                                  initMouse                               *
***************************************************************************/
void initmouse(void)
{
    reg.r_ax = 0;
    callmouse();
    mouse_present = (reg.r_ax != 0) ? TRUE : FALSE ;
};

/***************************************************************************
*                               showmouse                                  *
****************************************************************************/
void showmouse(void)
{
    reg.r_ax = 1;
    callmouse();
};

/***************************************************************************
*                                hidemouse                                 *
****************************************************************************/
void hidemouse(void)
{
    reg.r_ax = 2;
    callmouse();
};

/***************************************************************************
*                                  mousex                                  *
****************************************************************************/
unsigned mousex(void)
{
    reg.r_ax = 3;
    callmouse();
    return reg.r_cx;
};

/***************************************************************************
*                                   mousey                                 *
****************************************************************************/
unsigned mousey(void)
{
    reg.r_ax = 3;
    callmouse();
    return reg.r_dx;
};

/***************************************************************************
*                      (LOCAL)     swap                                    *
****************************************************************************/
static void swap(unsigned &a, unsigned &b)
{
    unsigned c;
     c =  a;
     a =  b;
     b =  c;
};

/***************************************************************************
*                                mousebox                                  *
****************************************************************************/
void mousebox(unsigned left, unsigned top, unsigned right, unsigned bottom)
{
    if (left > right)
       swap(left,right);
    if (top > bottom)
       swap(top,bottom);
    reg.r_ax = 7;
    reg.r_cx = left;
    reg.r_dx = right;
    callmouse();
    reg.r_ax = 8;
    reg.r_cx = top;
    reg.r_dx = bottom;
    callmouse();
};

/***************************************************************************
*                   (LOCAL)       mousecursor                              *
****************************************************************************/
static void mousecursor(char xhot,char yhot,unsigned *data)
{
    reg.r_ax = 9;
    reg.r_bx = xhot;
    reg.r_cx = yhot;
    reg.r_dx = FP_OFF(data);
    reg.r_es = FP_SEG(data);
    callmouse();
};

/***************************************************************************
*                             arrowmouse                                   *
****************************************************************************/
void arrowmouse (void)
{
    mousecursor(1, 1, arrowdata);
};

/***************************************************************************
*                             targetmouse                                  *
****************************************************************************/
void targetmouse(void)
{
    mousecursor(7, 8, targetdata);
};


/****************************************************************************
*                              defaulthandler                               *
****************************************************************************/
void far interrupt defaulthandler (void)
{
   asm{
      mov AX,BX            	// save BX
      Mov BX,eventbufin    	// point to last event
      mov SI,BX       		// save eventbufin
      Inc BX                    // next event
      Cmp BX,MAXEVENTBUF        // end of buffer?
      Jle NotEnd                // ...no,  go on
      Xor BX,BX                 // ...yes, goto begin of buffer
   }NotEnd:asm{                 // !!!! looks strange, but how to include a label in BASM ??
      Cmp BX,eventbufout        // buffer full?
      Je uit                    // ...yes, EXIT
      Mov Word Ptr eventbufin,BX// save input pointer to buffer
      mov BX,SI                 // here we want to save the event
      shl BX,3                  // times 8, for position in buffer
      mov DI,OFFSET eventbuf    // get offset buffer
      mov WORD PTR [DI+BX  ],CX // save event X
      mov WORD PTR [DI+BX+2],DX // save event Y
      mov WORD PTR [DI+BX+4],AX // save event K
   }uit:asm{
      pop bp                    // and restore all registers
      pop di
      pop si
      pop ds
      pop es
      pop dx
      pop cx
      pop bx
      pop ax
      retf                      // mouse driver expects a far return
      }
}
/***************************************************************************
*                           setmouseevent                                  *
****************************************************************************/
void setmouseevent(unsigned mask )
{
    reg.r_ax = 12;
    reg.r_cx = mask;
    reg.r_es = FP_SEG(defaulthandler);
    reg.r_dx = FP_OFF(defaulthandler);
    callmouse();
    LastMask = mask;
};


/****************************************************************************
*                             getevent                                      *
****************************************************************************/
int getevent(int &x, int &y, int &k)
{
  if(eventbufin!=eventbufout)
  {
    x=eventbuf[eventbufout].x;
    y=eventbuf[eventbufout].y;
    k=eventbuf[eventbufout].k;
    if((++eventbufout)>MAXEVENTBUF) eventbufout=0;
    return(TRUE);
  }
  else
    return(FALSE);
}

/****************************************************************************
*                             waistevent                                    *
****************************************************************************/
int waistevent()
{
  if(eventbufin!=eventbufout)
  {
    if((++eventbufout)>MAXEVENTBUF) eventbufout=0;
    return(TRUE);
  }
  else
    return(FALSE);
}

/****************************************************************************
*                             event                                         *
****************************************************************************/
int event()
{
  return(eventbufin!=eventbufout);
}

/****************************************************************************
*                             mousein                                       *
****************************************************************************/
int mousein(int mx, int my, int x1, int y1, int x2, int y2)
{
   if( (mx>=x1)&&(mx<=x2)&&(my>=y1)&&(my<=y2))
     return(TRUE);
   else
     return(FALSE);
}

/******************************* END ***************************************/
