;/*****************************************************************************
;*                               TASM                                         *
;*                        LINE DRAW FUNCTION                                  *
;*                             LINE.ASM                                       *
;*                                                                            *
;******************************************************************************
;* REMARK:   adaptation of line draw algoritm,                                *
;*           Advanced programmer's guide for EGA/VGA, 1988                    *
;*                                                                            *
;*           v1.0 Jan 1996                                                    *
;*                                                                            *
;******************************************************************************
;* If you have any questions or remarks please contact me                     *
;* Henk Thomassen, thomass@IAEhv.nl                                           *
;*****************************************************************************/
; linebuf (x0, y0, x1, y1 )

extrn    _screen

	.MODEL large

	.DATA?
d1      dw ?
d2      dw ?

	.CODE
	.386

	PUBLIC  _linebuf

_linebuf PROC    FAR
	ARG X0:WORD, Y0:WORD, X1:WORD, Y1:WORD
	PUSH 	BP
	MOV	BP,SP
	PUSH    DI
	PUSH    SI
	PUSH    DS
	PUSH    ES

	MOV     AX,X0                   ; make sure that x1 >= x0
	MOV     CX,X1
	CMP     CX,AX
	JGE     Get_Offset              ; x1>= x0
	MOV     BX,Y0
	MOV     DX,Y1
	MOV     X0,CX
	MOV     Y0,DX
	MOV     X1,AX
	MOV     Y1,BX

;COMPUTE ADDRESS AND MASK FOR FIRST PIXEL
Get_Offset:
	;Compute offset and save on stack
	MOV     AX,Y0
	SHL     AX,6                    ;display is 64 bytes

	MOV     BX,X0                   ; + x/8
	SHR     BX,3
	ADD     AX,BX
	MOV     BX,OFFSET _screen
	ADD	AX,BX
	PUSH    AX                      ; save offset on stack, later pop to DI

	;Compute mask and save on the stack

	MOV     CX,X0                   ; compute which bit (x mod 8) to modify
	AND     CL,7
	MOV     BX,80h
	SHR     BX,CL
	PUSH    BX                      ; save mask on stack, later pop to SI

	;Load segment register

	MOV     DX,SEG _screen          ;
	MOV     DS,DX
	MOV     ES,DX

;COMPUTE  DX AND DY
;DETERMINE IF HORIZONTAL, VERTICAL OR DIAGONNAL LINE

	MOV     DX,64
	MOV     SI,X1                   ; compute dx           reg-si
	SUB     SI,X0
	MOV     DI,Y1                   ; compute dy           reg-di
	SUB     DI,Y0
	JGE     DyIsPos
	NEG     DX
	NEG     DI
DyIsPos:
	CMP     SI,0                    ; jump according to type of line
	JZ      Vert
	CMP     DI,0
	JZ      Horiz
	JMP     Diag

;GENERATE A VERTICAL LINE

Vert:   MOV     CX,DI                   ; set up counter
	INC     CX

	POP     SI                      ; fetch mask
	MOV     AX,SI

	POP     DI                      ; fetch offset
LoopVert:
	OR      [DI],AL                 ; write new data (only one bit will be
	ADD     DI,DX                   ; update offset
	LOOP    LoopVert
	JMP     LineDone

;GENERATE A HORIZONTAL LINE

Horiz:  MOV     CX,SI                   ; set counter of pixels
	INC     CX
	POP     SI                      ; fetch mask
	POP     DI                      ; fetch offset

	;draw pixels from the leading partial byte

	MOV     AX,X0
	AND     AX,07h                  ; check for partial byte
	JZ      FullBytes

	MOV     BX,0FFh                 ; compute the mask
	PUSH    CX
	MOV     CX,AX
	SHR     BX,CL
	POP     CX
	ADD     CX,AX                   ; update counter
	SUB     CX,08h
	JGE     MaskSet                 ; modify mask if only one byte

	NEG     CX
	SHR     BX,CL
	SHL     BX,CL
	XOR     CX,CX                   ; restore counter
MaskSet:
	OR     [DI],BL                  ; write new data
	INC     DI                      ; update offset

	;draw pixels from the middle complete bytes
FullBytes:                              ;
	MOV     BX,CX                   ; check if any bytes to set
	CMP     CX,8
	JL      TrailBytes
	SHR     CX,3                    ; compute count
	MOV     AL,0FFh

	REP     STOSB                   ; fill complete bytes

	;draw pixels from the trailing partial byte
TrailBytes:
	AND     BX,7h
	JZ      HorizDone
	MOV     AL,0FFh                 ; compute mask
	MOV     CX,BX
	SHR     AL,CL
	XOR     AL,0FFh                 ; set the mask
	OR     [DI],AL                  ; set new data
HorizDone:
	JMP     LineDone

;GENERATE A DIAGONAL LINE

	;figure out which quarter does the line lie in

Diag:   CMP     SI,DI                   ; Is dy > dx
	JLE     oct12                   ; ...Yes, do processing in octants
					;    1 and 2
	; Compute constants for octant zero and three
	; This is where x is the major direction and y is minor

oct03:  MOV     CX,SI                   ; set counter to dx+1
	INC     CX
	SAL     DI,1                    ; d1 = dy*2             reg-di
	MOV     BX,DI                   ; d  = dy*2-dx          reg-bx
	SUB     BX,SI
	NEG     SI                      ; d2 = dy*2-dx-dx       reg-si
	ADD     SI,BX

	MOV     [d1],di                 ; save d1
	MOV     [d2],si                 ; save d2
	POP     AX                      ; fetch mask
	POP     DI                      ; fetch address

	;GENERATE LINE IN THE OCTANT ZERO AND THREE

next0:
	OR     [DI],AL                  ; modify (enabled bits)

	ROR     AL,1                    ; update mask
	ADC     DI,0                    ; update byte address

	TEST    BX,8000H                ; if d >= 0 then ...
	JNZ     dneg0
	ADD     BX,[d2]                 ; ... d = d + d2
	ADD     DI,DX                   ; update offset to next scan line
	LOOP    next0
	JMP     LineDone

dneg0:  ADD     BX,[d1]                 ; if d < 0 then d = d + d1
	LOOP    next0
	JMP     LineDone


	;Compute constants for octant one and two

oct12:  MOV     CX,DI                   ; set counter to dy+1
	INC     CX
	SAL     SI,1                    ; d1 = dx * 2
	MOV     BX,SI                   ; d  = dx * 2 - dy
	SUB     BX,DI
	NEG     DI                      ; d2 = -dy + dx * 2 - dy
	ADD     DI,BX

	MOV     [d2],DI                 ; save d2
	MOV     [d1],SI                 ; save d1
	POP     AX                      ; fetch mask
	POP     DI                      ; fetch address

	;GENERATE A LINE IN THE OCTANT ONE AND TWO

next1:	OR      [DI],AL                 ; modify (enabled bits)

	ADD     DI,DX                   ; update offset (y = y+1)

	TEST    BX,8000H                ; if d >= 0 then ...
	JNZ     dneg1

	ADD     BX,[d2]                 ; ... d = d + d2
	ROR     AL,1                    ; ... update mask (x = x+1)
	ADC     DI,0                    ; ... update offset
	LOOP    next1
	JMP     LineDone

dneg1:  ADD     BX,[d1]                 ; if d < 0 then d = d + d1
	LOOP    next1

LineDone:
	POP     ES
	POP     DS
	POP     SI
	POP     DI
	MOV     SP,BP
	POP	BP
	RET
_linebuf   	ENDP

		END