/*****************************************************************************
*                           BC 3.2 LIBRARY                                   *
*                    GRAPHICAL ROUTINES FOR FFT.CCP                          *
*                            GRAPHICS.CPP                                    *
*                                                                            *
*  This product is copyrighted (C) 1996 by Henk Thomassen. Permission is     *
*  granted for non-commercial use and distribution.                          *
******************************************************************************
* REMARK:                                                                    *
*                                                                            *
*                                                                            *
*                                                                            *
*                                                                            *
*                                                                            *
*          v1.0 Jan 1996                                                     *
*                                                                            *
******************************************************************************
* If you have any questions or remarks please contact me                     *
* Henk Thomassen, thomass@IAEhv.nl                                           *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <malloc.h>
#include <conio.h>
#include <ctype.h>
#include <math.h>
#include <dos.h>
#include <graphics.h>

#include "graphics.h"
#include "mouse.h"
#include "sb16.h"

#include "font.inc"

#define FALSE           (0)
#define TRUE            (!FALSE)


static struct knop_s{int x,y,b,h,c1,c2,on;} knops[MAXKNOPS];
static struct pmknop_s{int x,y,w,h,code,gfx;} pmknops[MAXKNOPS];

static struct s_slidedata { int l,x,y,pos,placed;} slidedata[MAXSLIDES];
static void far *slidek;
static void far *slidea[MAXSLIDES];

static struct mixhot_s{int x1,y1,x2,y2,on,typ;} mix[12];

unsigned char far screen[DISPLAY_H+10][DISPLAY_W>>3];
static unsigned char far *VGAmem = (char far *)MK_FP(0xa000,0);

/****************************************************************************
* KNOP:                                                                      *
*****************************************************************************/
int init_knop(int n, int x, int y, int b, int h, int c1, int c2, int on)
{
 if (n<MAXKNOPS)
 {
   knops[n].x=x;
   knops[n].y=y;
   knops[n].b=b;
   knops[n].h=h;
   knops[n].c1=c1;
   knops[n].c2=c2;
   knops[n].on=on;
   return(TRUE);
 }
 else
   return(FALSE);
}

/****************************************************************************
* KNOP:                                                                      *
*****************************************************************************/
int knopin(int n)
{
  return(knops[n].on);
}

/****************************************************************************
* KNOP:                                                                      *
*****************************************************************************/
void setknop(int n,int on)
{
  int I;
  knop_s k;

  k=knops[n];
  setcolor(0);
  hidemouse();
  rectangle(k.x,k.y+1,k.x+k.b ,k.y+k.h);
  line(k.x,k.y,k.x+k.b,k.y);
  for (I=1; I<=(k.h-1); I++)
  {
    setcolor( k.c2-(k.c2-k.c1)*I / k.h);
    line(k.x+1,k.y+I,k.x+k.b-1,k.y+I);
  }
  if (on)
  {
    knop_s k=knops[n];
    setcolor(6);
    rectangle(k.x+1,k.y+1,k.x+k.b-1,k.y+k.h-1);
    knops[n].on=TRUE;
  }
  knops[n].on=on;
  showmouse();
}

/****************************************************************************
* KNOP:                                                                      *
*****************************************************************************/
int xy_onknop(int x,int y,int n)
{
   if( (x>=knops[n].x)&&(x<=(knops[n].x+knops[n].b))&&(y>=knops[n].y)&&(y<=(knops[n].y+knops[n].h)))
     return(TRUE);
   else
     return(FALSE);
}

/****************************************************************************
* KNOP:                                                                      *
*****************************************************************************/
void moveknop(int n, void(*f)())
{
  setknop(n,TRUE);
  while(!event()) f();
  waistevent();
  setknop(n,FALSE);
}

/****************************************************************************
* KNOP:                                                                      *
*****************************************************************************/
int pmknopin(int n)
{
  return(pmknops[n].code);
}

/****************************************************************************
* PMKNOP:                                                                    *
*****************************************************************************/
int init_pmknop(int n, int x, int y, int w, int h, int gfx)
{
 if (n<MAXKNOPS)
 {
   pmknops[n].x=x;
   pmknops[n].y=y;
   pmknops[n].w=w;
   pmknops[n].h=h;
   pmknops[n].code=-1;
   pmknops[n].gfx=gfx;
   return(TRUE);
 }
 else
   return(FALSE);
}

/****************************************************************************
* PMKNOP:                                                                    *
*****************************************************************************/
void set_pmknop(int n)
{
  int x=pmknops[n].x;
  int y=pmknops[n].y;
  int w=pmknops[n].w;
  int h=pmknops[n].h;
  int c=pmknops[n].code;
  int g=pmknops[n].gfx;
  int poly[6];

  hidemouse();

  switch(g){
  case 0: fbar(x-2,y-1,x+w+2,y+h+1,0);
	  fbar(x,y,x+w,y+h,8);
	  setcolor(10);
	   line(x,y,x+w,y);
	   line(x+w,y,x+w,y+h);
	  setcolor(6);
	   line(x,y+1,x,y+h);
	   line(x,y+h,x+w,y+h);

	  setcolor(10);
	   line(x+3,y+1,x+3,y+h-1);
	   line(x+6,y+1,x+6,y+h-1);
	   line(x+9,y+1,x+9,y+h-1);

	   line(x+w-3,y+1,x+w-3,y+h-1);
	   line(x+w-6,y+1,x+w-6,y+h-1);
	   line(x+w-9,y+1,x+w-9,y+h-1);

	  setcolor(6);
	   line(x+4,y+1,x+4,y+h-1);
	   line(x+7,y+1,x+7,y+h-1);
	   line(x+10,y+1,x+10,y+h-1);

	   line(x+w-4,y+1,x+w-4,y+h-1);
	   line(x+w-7,y+1,x+w-7,y+h-1);
	   line(x+w-10,y+1,x+w-10,y+h-1);
	  switch(c){
	    case 0:setcolor(6);
		    line(x+1,y,x+1,y+h);
		    line(x,y,x+w,y-1);
		    line(x,y+h,x+w,y+h+1);
		   break;
	    case 1:setcolor(6);
		    line(x+w,y,x+w,y+h);
		    line(x+w,y,x,y-1);
		    line(x+w,y+h,x,y+h+1);
		   break;
	  }
	  break;
  case 1: setfillstyle(SOLID_FILL, 8);
	  moveto(x+w/2,y-2);
	  setcolor(0);
	    lineto(x-1,y+h/2-1);
	    lineto(x+w+1,y+h/2-1);
	    lineto(x+w/2,y-2);
	  setcolor(6);
	    poly[0] = x+w/2;         // 1st vertex
	    poly[1] = y-1;
	    poly[2] = x+1;           // 2nd
	    poly[3] = y+h/2-2;
	    poly[4] = x+w-1;         // 3rd
	    poly[5] = y+h/2-2;
	    fillpoly(3, poly);
	  moveto(x+w/2,y+1);
	  setcolor(11);
	    line(x+w/2+1,y,x+w-1,y+h/2-2);

	  moveto(x+w/2,y+w+2);
	  setcolor(0);
	    lineto(x-1,y+h/2+1);
	    lineto(x+w+1,y+h/2+1);
	    lineto(x+w/2,y+w+2);
	  setcolor(6);
	    poly[0] = x+w/2;        // 1st vertex
	    poly[1] = y+w+1;
	    poly[2] = x+1;          // 2nd
	    poly[3] = y+h/2+2;
	    poly[4] = x+w-1;        // 3rd
	    poly[5] = y+h/2+2;
	    fillpoly(3, poly);
	  setcolor(11);
	    line(x+1,y+h/2+2,x+w-1,y+h/2+2);
	  switch(c){
	    case 0:setcolor(6);
		   line(x+w/2+1,y,x+w-1,y+h/2-2);
		   break;
	    case 1:setcolor(6);
		   line(x+1,y+h/2+2,x+w-1,y+h/2+2);
		   break;
	  }
	  break;
  }


  showmouse();
}

/****************************************************************************
* PMKNOP:                                                                    *
*****************************************************************************/
int xy_onpmknop(int x,int y,int n)
{
   int r=FALSE;
   if( (x>=pmknops[n].x)&&(x<=(pmknops[n].x+pmknops[n].w))&&(y>=pmknops[n].y)&&(y<=(pmknops[n].y+pmknops[n].h)))
     switch(pmknops[n].gfx)
     {
       case 0: pmknops[n].code=(int)((x-pmknops[n].x)*2)/(pmknops[n].w);
	       r=TRUE;
	       break;
       case 1: pmknops[n].code=(int)((y-pmknops[n].y)*2)/(pmknops[n].h);
	       r=TRUE;
	       break;
     }
   return(r);
}

/****************************************************************************
* PMKNOP:                                                                    *
*****************************************************************************/
void movepmknop(int n, void(*f)())
{
  set_pmknop(n);
  while(!event()) if(f!=NULL)f();
  waistevent();
  pmknops[n].code=-1;
  set_pmknop(n);
}

/****************************************************************************
* CABINET:                                                                   *
*****************************************************************************/
void cabinet(int x, int y, int h, int w)
{
  int i;
  fbar(0,0,getmaxx(),getmaxy(),7);
  for(i=0;i<3;i++)
  {
    setcolor(8+i);
    line(x-3+i,y-3+i,x-3+i,y+h+3-i);
    setcolor(8-i);
    line(x+w+3-i,y-3+i,x+w+3-i,y+h+3-i);

    setcolor(10-i);
    line(x-1-i,y+h+1+i,x+w+1+i,y+h+1+i);
    setcolor(6+i);
    line(x-i,y-1-i,x+1+w+i,y-1-i);
  }
  fbar(x,y,x+w,y+h,2);
}

/****************************************************************************
* SLIDE:                                                                    *
*****************************************************************************/
void sleuf(int x1, int y1, int l)
{
  int y2=y1+l,x2=x1+1,i;
  setcolor(12);
  line(x1-1,y1,x1-1,y2+1);
  line(x1,y2+1,x2,y2+1);
  setcolor(6);
  line(x2+1,y1,x2+1,y2+1);
  line(x1,y1-1,x2,y1-1);
  setcolor(0);
  for(i=x1;i<=x2;i++) line(i,y1,i,y2);
  for(i=1;i<(l / 10);i++)
  {
    setcolor(6);
    line(x1-12,y1+(i*10),x1-4,y1+(i*10));
    line(x1+13,y1+(i*10),x1+5,y1+(i*10));
    setcolor(9);
    line(x1-12,y1+(i*10)+1,x1-4,y1+(i*10)+1);
    line(x1+13,y1+(i*10)+1,x1+5,y1+(i*10)+1);
  }
}

/****************************************************************************
* SLIDE:                                                                    *
*****************************************************************************/
int slidepos(int n)
{
  if(n<MAXSLIDES)
    return(slidedata[n].pos);
  else
    return(-1);
}

/****************************************************************************
* SLIDE:                                                                    *
*****************************************************************************/
int openslides()
{
  int x=100,y=100,i;
  unsigned slidesize;
  slidesize = imagesize(0,0,17,12);
  if ((slidek = farmalloc(slidesize)) == NULL)
    return(FALSE);

  for(i=0; i<MAXSLIDES ; i++)
  if ((slidea[i] = farmalloc(slidesize)) == NULL)
    return(FALSE);

  for(i=0; i<MAXSLIDES; i++) slidedata[i].placed = FALSE;

  getimage(x-8,y-4,x+9,y+8,slidea[0]);

  setcolor(7);
  for(i=0; i<=5; i++) line(x-4,y+i,x+5,y+i);
  for(i=0; i<3; i++)
  {
    setcolor(6);
    line(x-7+i,y-3+i,x-7+i,y+7-i);
    line(x-7+i,y+7-i,x+8-i,y+7-i);
    setcolor(10);
    line(x+8-i,y+7-i,x+8-i,y-3+i);
    line(x+8-i,y-3+i,x-7+i,y-3+i);
  }
  setcolor(0);
  line(x-8,y-4,x-8,y+8);
  line(x-8,y+8,x+9,y+8);
  line(x+9,y+8,x+9,y-4);
  line(x+9,y-4,x-8,y-4);

  getimage(x-8,y-4,x+9,y+8,slidek);
  putimage(x-8,y-4,slidea[0],COPY_PUT);
  return(TRUE);
}

/****************************************************************************
* SLIDE:                                                                    *
*****************************************************************************/
int init_slide(int n, int x, int y, int l, unsigned pos)
{
  if(n<MAXSLIDES)
  {
    if (pos>l) pos=l;

    sleuf(x,y,l+8);
    slidedata[n].placed=TRUE;
    slidedata[n].x=x-8;
    slidedata[n].y=y;
    slidedata[n].pos=pos;
    slidedata[n].l=l;

    getimage(slidedata[n].x,slidedata[n].y+pos,
	     slidedata[n].x+17,slidedata[n].y+pos+12,slidea[n]);
    putimage(slidedata[n].x,slidedata[n].y+pos,slidek,COPY_PUT);
    return TRUE;
  }
  else
    return FALSE;
}

/****************************************************************************
* SLIDE:                                                                    *
*****************************************************************************/
void closeslides()
{
  int i;
  for(i=0; i<MAXSLIDES ; i++) farfree(slidea);
  farfree(slidek);
}

/****************************************************************************
* SLIDE:                                                                    *
*****************************************************************************/
void moveslide(int n, int xx, int yy, void(*f)())
{
  int y,y1,p;
  unsigned savemask;

  if(mousein(xx,yy,
     slidedata[n].x,slidedata[n].y+slidedata[n].pos,
     slidedata[n].x+17,slidedata[n].y+slidedata[n].pos+12))
   {
     y1=yy;
     hidemouse();
     savemask=LastMask;
     setmouseevent(4);
     do
      {
	y=mousey();
	if(y!=y1)
	 {
	   p=y-y1+slidedata[n].pos;
	   if (((p>=0)&&(p<slidedata[n].l)&&slidedata[n].placed))
	    {
	      putimage(slidedata[n].x,slidedata[n].y+slidedata[n].pos,slidea[n],COPY_PUT);
	      slidedata[n].pos=p;
	      getimage(slidedata[n].x,slidedata[n].y+p,
		       slidedata[n].x+17,slidedata[n].y+p+12,slidea[n]);
	      putimage(slidedata[n].x,slidedata[n].y+p,slidek,COPY_PUT);
	      setVolume(n,p);
	    }
	   y1=y;
	 }
	 f();
      }
      while(!event());
      waistevent();
      showmouse();
      setmouseevent(savemask);
   }
}

/****************************************************************************
* MIXER:                                                                    *
*****************************************************************************/
static void init_mixsw(int n, int x1, int y1, int x2, int y2, int on, int typ)
{
  char *amptext[] ={"1x","2x","4x","8x"};

  mix[n].x1=x1;
  mix[n].y1=y1;
  mix[n].x2=x2;
  mix[n].y2=y2;
  mix[n].on=on;
  mix[n].typ=typ;

  switch(typ)
  {
  case 0: emboss(x1,y1,x2,y2);
	  if (on)
	   {
	     setfillstyle(SOLID_FILL,4);
	     bar(x1+3,y1+2,x2-3,y2-2);
	   }
	   break;
  case 1: setcolor(0);
	  settextstyle(SMALL_FONT,VERT_DIR,0);
	  setusercharsize(1,1,1,1);
	  outtextxy(x1+6,y1,amptext[on]);
	  break;
  case 2: setcolor(0);
	  settextstyle(SMALL_FONT,VERT_DIR,0);
	  setusercharsize(1,1,1,1);
	  outtextxy(x1+7,y1-12,amptext[on]);
  }
}


/****************************************************************************
* MIXER:                                                                    *
*****************************************************************************/
static void set_mixsw(int n, int on)
{
  char *amptext[] ={"1x","2x","4x","8x"};

  setcolor(7);
  settextstyle(SMALL_FONT,VERT_DIR,0);
  setusercharsize(1,1,1,1);
  hidemouse();
  switch(mix[n].typ)
  {
    case 0: if(on)
	      setfillstyle(SOLID_FILL,4);
	    else
	      setfillstyle(SOLID_FILL,7);
	    bar(mix[n].x1+3,mix[n].y1+2,mix[n].x2-3,mix[n].y2-2);
	    break;
    case 1: outtextxy(mix[n].x1+6,mix[n].y1,amptext[mix[n].on]);
	    setcolor(0);
	    outtextxy(mix[n].x1+6,mix[n].y1,amptext[on]);
	    break;
    case 2: outtextxy(mix[n].x1+7,mix[n].y1-12,amptext[mix[n].on]);
	    setcolor(0);
	    outtextxy(mix[n].x1+7,mix[n].y1-12,amptext[on]);
	    break;
  }

  settextstyle(DEFAULT_FONT,HORIZ_DIR,1);
  showmouse();
  mix[n].on=on;
  setSBswitch(n,on);
}

/****************************************************************************
* MIXER:                                                                    *
*****************************************************************************/
static int get_mixsw(int n)
{
  return(mix[n].on);
}


/****************************************************************************
* MIXER:                                                                    *
*****************************************************************************/
void init_sb16mix(int x, int y, int present)
{
  settextjustify(LEFT_TEXT, TOP_TEXT);
  setfillstyle(SOLID_FILL,7);
  bar(x,y,x+220,y+95);

  init_slide(0,x+20,y+35,32,getVolume(0));
  init_slide(1,x+90,y+35,32,getVolume(1));
  init_slide(2,x+125,y+35,32,getVolume(2));
  init_slide(3,x+160,y+35,32,getVolume(3));

  // line switches
  init_mixsw(0,x+78,y+8,x+88,y+16,getSBswitch(0),0);
  init_mixsw(1,x+92,y+8,x+102,y+16,getSBswitch(1),0);
  init_mixsw(2,x+78,y+28+57,x+88,y+36+57,getSBswitch(2),0);
  init_mixsw(3,x+92,y+28+57,x+102,y+36+57,getSBswitch(3),0);
  // cd switches
  init_mixsw(4,x+78+35,y+8,x+88+35,y+16,getSBswitch(4),0);
  init_mixsw(5,x+92+35,y+8,x+102+35,y+16,getSBswitch(5),0);
  init_mixsw(6,x+78+35,y+28+57,x+88+35,y+36+57,getSBswitch(6),0);
  init_mixsw(7,x+92+35,y+28+57,x+102+35,y+36+57,getSBswitch(7),0);
  // mic switches
  init_mixsw(8,x+78+77,y+8,x+88+77,y+16,getSBswitch(8),0);
  init_mixsw(9,x+78+77,y+28+57,x+88+77,y+36+57,getSBswitch(9),0);
  // init amp switches
  init_mixsw(10,x+43,y+39,x+68,y+46,getSBswitch(10),1);
  init_mixsw(11,x+182,y+57,x+208,y+64,getSBswitch(11),2);
  // a/d amp
  setcolor(6);
  line(x+42,y+38,x+68,y+38);
  line(x+69,y+38,x+56,y+63);
  setcolor(9);
  line(x+56,y+63,x+42,y+38);
  // output amp
  setcolor(6);
  line(x+209,y+63,x+196,y+38);
  setcolor(9);
  line(x+182,y+63,x+208,y+63);
  line(x+196,y+38,x+182,y+63);
  // wide blue lines
  setlinestyle(SOLID_LINE,0,3);
  setcolor(1);
  line(x+196,y+64,x+196,y+89);
  line(x+196,y+89,x+173,y+89);
  line(x+103,y+89,x+112,y+89);
  line(x+138,y+89,x+154,y+89);

  line(x+56,y+37,x+56,y+12);
  line(x+56,y+12,x+77,y+12);
  line(x+103,y+12,x+112,y+12);
  line(x+138,y+12,x+154,y+12);

  line(x+56,y+65,x+56,y+89);
  line(x+56,y+89,x+20,y+89);
  line(x+20,y+89,x+20,y+80);
  line(x+20,y+33,x+20,y+25);
  line(x+196,y+37,x+196,y+25);
  // loudspeaker
  setlinestyle(SOLID_LINE,0,1);
  rectangle(x+15,y+25,x+25,y+18);
  line(x+25,y+18,x+30,y+10);
  line(x+30,y+10,x+10,y+10);
  line(x+10,y+10,x+15,y+18);
  // a/d
  rectangle(x+182,y+25,x+210,y+10);
  // set text justify
  settextjustify(LEFT_TEXT, TOP_TEXT);
  settextstyle(SMALL_FONT,HORIZ_DIR,0);
  setusercharsize(1,1,1,1);
  // A/D text
  setcolor(1);
  outtextxy(x+188,y+12,"A/D");
  // input text
  setcolor(0);
  outtextxy(x+81,y+20,"line");
  outtextxy(x+118,y+20,"cd    mic");

  set_mixsw(2,TRUE);
  set_mixsw(3,FALSE);
  set_mixsw(6,FALSE);
  set_mixsw(7,FALSE);
  set_mixsw(9,FALSE);

  setcolor(7);
  if(!present){
    for(int i=x; i<(x+220); i+=2) line(i,y,i,y+95);
    for(i=y; i<(y+95); i+=2) line(x,i,x+220,i);
  }
}

/****************************************************************************
* MIXER:                                                                    *
*****************************************************************************/
void sb16_mixer(int x, int y)
{
  int sw;
  for(sw=0; sw<12; sw++)
    if(mousein(x,y,mix[sw].x1,mix[sw].y1,mix[sw].x2,mix[sw].y2))
    {
      switch(mix[sw].typ)
      {
	case 0: set_mixsw(sw,!get_mixsw(sw));
		if( ((sw==2)||(sw==3)||(sw==6)||(sw==7)||(sw==9))&&get_mixsw(sw) )
		{
		  if((sw!=2)&&(sw!=3)) set_mixsw(2,FALSE);
		  if((sw!=3)&&(sw!=2)) set_mixsw(3,FALSE);
		  if((sw!=6)&&(sw!=7)) set_mixsw(6,FALSE);
		  if((sw!=7)&&(sw!=6)) set_mixsw(7,FALSE);
		  if(sw!=9) set_mixsw(9,FALSE);
		}
		break;
	case 1:
	case 2: if( ((mix[sw].x1+mix[sw].x2)>>1)<x)
		  { if (mix[sw].on<3) set_mixsw(sw,mix[sw].on+1);}
		  else
		  { if (mix[sw].on>0) set_mixsw(sw,mix[sw].on-1);}
		break;
      }
    }
}

/****************************************************************************
* MIXER:                                                                    *
*****************************************************************************/
int gettotalamp()
{
  int v;
  if(get_mixsw(2)) v=(31-getVolume(1))*2+(SBgetmixreg(0x040)>>6)*6-62;
  else if(get_mixsw(3)) v=(31-getVolume(1))*2+(SBgetmixreg(0x040)>>6)*6-62;
  else if(get_mixsw(6)) v=(31-getVolume(2))*2+(SBgetmixreg(0x040)>>6)*6-62;
  else if(get_mixsw(7)) v=(31-getVolume(2))*2+(SBgetmixreg(0x040)>>6)*6-62;
  else if(get_mixsw(9)) v=(31-getVolume(3))*2+(SBgetmixreg(0x040)>>6)*6-62+20;
  else v=0;

  return(v);
}


/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void vLine(int x,int y1,int y2)
{
 int v;
 unsigned ay;
 if (y1>y2){ v=y1; y1=y2; y2=v;}
 ay=(y1<<6)+(y1<<4)+(x>>3);
 for(v=y1;v<=y2;v++){ *(VGAmem+ay)|=1<<(7-(x&7)); ay+=80; }
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void hLine(int x1,int x2,int y)
{
 int x1n,x2n,v;
 unsigned ay;

 if (x1>x2){ v=x1; x1=x2; x2=v;}

 x2n=x2>>3;
 x1n=x1>>3;
 ay=80*y;

 for(v=(x1>>3); v<((x2+7)>>3);v++)
 {
   if (x1n==x2n)
      *(VGAmem+x1n+ay) |= 0xff>>(x1%8)&0xff<<(8-x2%8);
   else
     if ((v<<3)<x1)
       *(VGAmem+x1n+ay) |= 0xff>>(x1%8);
     else
       if (v<x2n)
	 *(VGAmem+v+ay)|=0xff;
       else
	 *(VGAmem+x2n+ay) |= 0xff<<(8-x2%8);
  }
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void box(int x1,int y1,int x2,int y2)
{
  vLine(x1,y1,y2);
  vLine(x2,y1,y2);
  hLine(x1,x2,y1);
  hLine(x1,x2,y2);
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void PutDot(int x,int y)
{
  VGAmem[(x>>3)+(y<<6)+(y<<4)]|=1<<(~x&7);
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void putdotbuf(int x,int y)
{
  screen[y][x>>3]|=1<<(~x&7);
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void clearDisplay0()
{
  int m;
  for (m=(DISPLAY_Y*80+(DISPLAY_X >> 3)); m<=(DISPLAY_Y+DISPLAY_H+1)*80; m+=80)
    _fmemset(&VGAmem[m],0,DISPLAY_W >> 3);
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void cleardisplaybuf()
{
    _fmemset(screen,0,sizeof(screen));
}


/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void copydisplaybuf()
{
  asm{
	PUSH    DS                      // save DS
	MOV     DI,DISPLAY_Y            // get display y position
	SHL     DI,4
	MOV     BX,DI
	SHL     DI,2
	ADD     DI,BX              	// DI = y*80
	MOV     BX,DISPLAY_X
	SHR     BX,3
	ADD     DI,BX              	// DI= y*80 + x%8

	MOV     BX,DISPLAY_H
	INC     BX                      // lines to be moved

	MOV	SI,OFFSET screen        // screen buffer
	MOV     AX,0xA000
	MOV	ES,AX			// OFFSET display
	MOV     AX,SEG screen
	MOV	DS,AX			// OFFSET screen buffer

	MOV     DX,16               	// 80 - 64
	MOV     AX,32                   // words per line
	CLD

    }loop: asm{
	MOV	CX,AX			// 32 words / line
	REP 	MOVSW                   // move 32 words (64 bytes)
	ADD     DI,DX                   // add 16 for 80 bytes/line
	DEC	BX                      // dec line counter
	JNE	loop                    // if != 0, goto loop
	POP     DS                      // restore DS
    }
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void setcolors()
{
int i;
  for (i=1; i<=15; i++) setpalette(i,i);

  setrgbpalette( 1,10,10,20);
  setrgbpalette( 2,10, 0, 0);
  setrgbpalette( 3,63,30, 0);
  setrgbpalette( 4, 0,43,10);

  setrgbpalette( 6,15,15,16);
  setrgbpalette( 7,25,25,27);
  setrgbpalette( 8,30,30,33);
  setrgbpalette( 9,35,35,38);
  setrgbpalette(10,40,40,44);
  setrgbpalette(11,45,45,49);
  setrgbpalette(12,50,50,55);
  setrgbpalette(13,55,55,60);

  setrgbpalette(15,63,63,63);
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void fbar(int x, int y, int x1, int y1, int c)
{
  setfillstyle(SOLID_FILL,c);
  bar(x,y,x1,y1);
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
int opengraph()
{
  int driver = VGA, mode = VGAHI, codi;

  if(registerbgidriver(EGAVGA_driver)<0) goto error;

//  if(registerfarbgifont(bold_font_far)<0) goto error;
//  if(registerfarbgifont(euro_font_far)<0) goto error;
//  if(registerfarbgifont(gothic_font_far)<0) goto error;
//  if(registerfarbgifont(complex_font_far)<0) goto error;
  if(registerfarbgifont(small_font_far)<0) goto error;
//  if(registerfarbgifont(sansserif_font_far)<0) goto error;
//  if(registerfarbgifont(script_font_far)<0) goto error;
//  if(registerfarbgifont(simplex_font_far)<0) goto error;
//  if(registerfarbgifont(triplex_font_far)<0) goto error;
//  if(registerfarbgifont(triplex_scr_font_far)<0) goto error;

  initgraph(&driver, &mode, "");
  if(graphresult() != grOk) goto error;

  return(TRUE);

  error:
  return(FALSE);
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void kader(int x, int y, int x1, int y1)
{
  setcolor(6);
  rectangle(x,y,x1,y1);
  rectangle(x+1,y+1,x1-1,y1-1);
  setcolor(9);
  line(x+2,y+1,x1-1,y+1);
  line(x1-1,y+1,x1-1,y1-1);
  line(x,y,x,y1-1);
  line(x,y1,x1-1,y1);
}

/****************************************************************************
* GRAPHICS:                                                                    *
*****************************************************************************/
void emboss(int x1,int y1,int x2,int y2)
{
  setcolor(6);
  rectangle(x1,y1,x2,y2);
  setcolor(9);
  line(x1,y1,x1,y2);
  line(x1,y2,x2,y2);
}

/****************************************************************************
* FONT:                                                                     *
*****************************************************************************/
void textxy(int x, int y, unsigned char *s)
{
  int r,p;
  unsigned l;
  unsigned char *hi_l=(unsigned char *)&l;
  unsigned char *lo_l=hi_l+1;

  p=0;
  while (s[p]!=0)
  {
    if((x&7))
    {
      for(r=0; r<8; r++)
      {
	 l=font[s[p]][r] << (8-(x&7));
	 screen[y+r][(x>>3)]|=*lo_l;
	 screen[y+r][(x>>3)+1]|=*hi_l;
      }
    }
    else
      for(r=0; r<8; r++) screen[y+r][(x>>3)]|=font[s[p]][r];
    x+=8;
    p++;
  }
}


/******************************* END ****************************************/








