;/*****************************************************************************
;*                               TASM                                         *
;*                            FFT FUNCTION                                    *
;*                            FFT_ASM.ASM                                     *
;******************************************************************************
;* REMARK:                                                                    *
;*           FFT algoritm, original from  A. J. Anton 			      *
;*           free ware 19/08/1994                                             *
;*                                                                            *
;*           v1.0 Jan 1996                                                    *
;*                                                                            *
;******************************************************************************
;* If you have any questions or remarks please contact me                     *
;* Henk Thomassen, thomass@IAEhv.nl                                           *
;*****************************************************************************/
; int fft(complex x[], unsigned n);
; struct { float re, im; } complex;

	.MODEL large

	.DATA?
b       	dd ?
e       	dd ?
cos     	dd ?
sin     	dd ?
temp_r  	dd ?
temp_i  	dd ?

complex_offset  dw ?
power_of_2     	dw ?
SAMPLES       	dw ?
a       	dw ?
c       	dw ?
f       	dw ?
d       	dw ?
u       	dw ?
g       	dw ?
h       	dw ?
j       	dw ?
p       	dw ?
s       	dw ?

	.DATA
cte2    DW 2

	.386
	.CODE

	PUBLIC _fft

_fft    PROC FAR
	ARG complex:DWORD, power:WORD
	PUSH BP
	MOV BP,SP

	PUSH SI
	PUSH DI
	PUSH DS
	PUSH ES

	LES AX,[complex]
	MOV [complex_offset],AX
	MOV AX,[power]          ; power of 2
	MOV [power_of_2],AX	; save local

	MOV CL,AL
	MOV AX,1
	ROL AX,CL               ; SAMPLES = 2**power
	MOV [SAMPLES],AX

	MOV [a], AX             ; a = SAMPLES

	FINIT                   ; init 387
	FLDPI                   ; pi
	FILD cte2
	FMUL                    ; x 2
	FILD SAMPLES
	FDIV
	FSTP b                  ; save (float) b = 2 * pi / SAMPLES
	FWAIT

	MOV word ptr [c],1      ; for(c = 1; c <= n(==power_of_2); c++)
for1:   MOV AX,[c]
	CMP AX,[power_of_2]
	JLE cont1
	JMP endf1

cont1:  MOV AX,[a]
	MOV [d],AX              ; d = a

	SAR AX,1
	MOV [a],AX              ; a = a / 2

	FLDZ
	FSTP e                  ; e = (float) 0.0
	FWAIT

	MOV word ptr [f],1      ; for(f = 1; f <= a; f++)
for2:   MOV AX,[f]
	CMP AX,[a]
	JLE cont2
	JMP endf2

cont2:  FLD e
	FSINCOS
	FSTP cos                ; cos = cos(e)
	FSTP sin                ; sin = sin(e)

	FLD e
	FADD b
	FSTP e                  ; e = e + b
	FWAIT

	MOV word ptr [u],1      ; u = 1

	MOV AX,[d]              ; for(g = d; g <= SAMPLES; g = u * d)
	MOV [g],AX
for3:   MOV AX,[g]
	CMP AX,[SAMPLES]
	JLE cont3
	JMP endf3

cont3:  INC [u]                 ; u++

	MOV AX,[g]
	ADD AX,[f]
	SUB AX,[d]
	MOV [h],AX              ; h = g - d + f

	ADD AX,[a]
	MOV [j],AX              ; j = h + a

	MOV SI,[h]
	ROL SI,1
	ROL SI,1
	ROL SI,1
	ADD SI,[complex_offset]           ; si = complex_offset + h * 8
	MOV DI,[j]
	ROL DI,1
	ROL DI,1
	ROL DI,1
	ADD DI,[complex_offset]           ; DI = complex_offset + j * 8

	FLD dword ptr ES:[SI]                   ;  x[h].x
	FSUB dword ptr ES:[DI]                  ;  x[j].x
	FSTP dword ptr temp_r                   ; temp_r = x[h].x - x[j].x
	FLD dword ptr ES:[SI + 4]               ;  x[h].y
	FSUB dword ptr ES:[DI + 4]              ;  x[j].y
	FSTP dword ptr temp_i                   ; temp_i = x[h].y - x[j].y

	FLD dword ptr ES:[SI]                   ;  x[h].x
	FADD dword ptr ES:[DI]                  ;  x[j].x
	FSTP dword ptr ES:[SI]                  ;  x[h].x = x[h].x + x[j].x
	FLD dword ptr ES:[SI + 4]               ;  x[h].y
	FADD dword ptr ES:[DI + 4]              ;  x[j].y
	FSTP dword ptr ES:[SI + 4]              ; x[h].y = x[h].y + x[j].y

	FLD cos
	FMUL temp_r                             ; co * t.x
	FLD sin
	FMUL temp_i                             ; si * t.y
	FADD                                    ; (co * t.x) + (si * t.y)
	FSTP dword ptr ES:[DI]                  ; x[j].x = co * t.x + si * t.y

	FLD cos
	FMUL temp_i                             ; co * t.y
	FLD sin
	FMUL temp_r                             ; si * t.x
	FSUB                                    ; (co * t.y) - (si * t.x)
	FSTP dword ptr ES:[DI + 4]              ; x[j].y = co * t.y - si * t.x
	FWAIT

loopf3: MOV AX,[u]
	mul [d]
	MOV [g],AX              ; g = u * d
	JMP for3
endf3:

loopf2: INC [f]                 ; f++
	JMP for2
endf2:

	FLD b
	FILD cte2
	FMUL
	FSTP b                  ; b = b * 2 (float)
	FWAIT

loopf1: INC [c]                 ; c++
	JMP for1
endf1:

	MOV CX,1                ; m = 1         (optz. r=bx, m=cx, q=dx)
	MOV AX,[SAMPLES]
	SAR AX, 1
	MOV [p], AX             ; p = SAMPLES / 2
	MOV DX,[SAMPLES]
	SUB DX,1                ; q = SAMPLES - 1

	MOV BX, 1               ; for(r = 1; r <= q; r++)
for4:   CMP BX,DX
	JLE cont4
	JMP endf4

cont4:  MOV AX,CX
	DEC AX
	CMP AX,BX
	JL label1               ; if(m - 1 < r) goto label1

	MOV SI,BX
	ROL SI,1
	ROL SI,1
	ROL SI,1
	ADD SI,[complex_offset]           ; si = complex_offset + r * 8
	MOV DI,CX
	ROL DI,1
	ROL DI,1
	ROL DI,1
	ADD DI,[complex_offset]           ; di = complex_offset + m * 8

	PUSH CX
	MOV CX,4
lla:    MOV AX,word ptr ES:[SI]
	XCHG AX,word ptr ES:[DI]
	MOV word ptr ES:[SI], AX
	ADD SI,2
	ADD DI,2
	LOOP lla               ; swap x[r], x[m]
	POP CX

label1: MOV AX,[p]
	MOV [s],AX              ; s = p

label3: MOV AX,CX
	DEC AX
	CMP AX,[s]
	JL label2               ; if(m - 1 < s) goto label2
	SUB CX,[s]              ; m = m - s
	MOV AX,[s]
	SAR AX,1
	MOV [s],AX              ; s = s / 2
	JMP label3              ; goto label3

label2: ADD CX,[s]              ; m = m + s
	INC BX                  ; r++
	JMP for4
endf4:

	MOV AX,[SAMPLES]

	POP ES
	POP DS
	POP DI
        POP SI                  ; restore registers
	MOV SP,BP
	POP BP

	RET

_FFT    ENDP

	END
