'       VSPRITES Sprite Programing Demo.
'       (c) 1994 - Chad Alberts

'       To utilize this library type either QBX /L VSPRTB71 for
'       Microsoft PDS 7.1 or QB /L VSPRTQ45 for QuickBASIC 4.5.

'       If you have any questions on how to use this library, just contact
'       me at the address listed in README.DOC.


'       $INCLUDE: 'VSPRITES.BI'
	
	IF NOT VGA THEN PRINT "Sorry, this program will only run on VGA displays.": END

	TYPE ObjectType

	    x     AS INTEGER
	    y     AS INTEGER
	    oldx  AS INTEGER
	    oldy  AS INTEGER
	    xsize AS INTEGER
	    ysize AS INTEGER
	    shape AS INTEGER
	    xdir  AS INTEGER
	    ydir  AS INTEGER

	END TYPE

	CONST NumberOfShapes = 7

	DIM obj(1 TO NumberOfShapes) AS ObjectType

	RANDOMIZE TIMER

	FOR x = 1 TO NumberOfShapes
	   obj(x).x = ((x - 1) * 30) + 50
	   obj(x).oldx = obj(x).x
	   obj(x).y = 80
	   obj(x).oldy = obj(x).y
	   obj(x).xsize = 28
	   obj(x).ysize = 20
	   obj(x).shape = x
	   obj(x).xdir = 3 * RND(1) + 1
	   obj(x).ydir = 2 * RND(1) + 1
	NEXT

' ---------------------------------------------------------------------------

' Allocate memory for sprites and load shape data.

	DIM ShapeBuf(0 TO 1974)

	DEF SEG = VARSEG(ShapeBuf(0))
	BLOAD "SHAPES.DAT", VARPTR(ShapeBuf(0))

' Set sprite pointers to shape data.

	DIM shape(1 TO NumberOfShapes) AS LONG

	FOR x = 1 TO NumberOfShapes
	   index = (x - 1) * 282
	   shape(x) = POINTER(VARSEG(ShapeBuf(index)), VARPTR(ShapeBuf(index)))
	NEXT

' ---------------------------------------------------------------------------

	INITGRAPH
	SETPAGES 0, 1
	PCXLOAD "BWFACE"
	FILLBOX 0, 184, 320, 200, 0
	DRAWBOX 0, 0, 319, 184, 16
	WRITETEXT 16, 192, "VSPRITES 1.0 - 320 x 200 x 256 demo.", 31
	SETPAGES 1, 1
	PAGECOPY 1, 0
	PAGECOPY 1, 2

' ---------------------------------------------------------------------------

	FOR x = 1 TO NumberOfShapes
	   PUTSHAPE obj(x).x, obj(x).y, shape(obj(x).shape)
	NEXT

	TI& = XTIMER
	WHILE XTIMER - TI& < 200: WEND

' Animate sprites.

	DO

	page = (page + 1) AND 1

	SETPAGES page, (page + 1) AND 1

	FOR x = 1 TO NumberOfShapes
	   x1 = (obj(x).oldx) AND NOT 3
	   y1 = obj(x).oldy
	   COPYBLOCK 2, x1, y1, (page + 1) AND 1, x1, y1, obj(x).xsize + 4, obj(x).ysize
	NEXT
	
	FOR x = 1 TO NumberOfShapes
	   IF obj(x).x < 3 OR obj(x).x > 288 THEN obj(x).xdir = 0 - obj(x).xdir
	   IF obj(x).y < 2 OR obj(x).y > 162 THEN obj(x).ydir = 0 - obj(x).ydir
	   obj(x).oldy = obj(x).y
	   obj(x).oldx = obj(x).x
	   obj(x).x = obj(x).x + obj(x).xdir
	   obj(x).y = obj(x).y + obj(x).ydir
	   PUTSHAPE obj(x).x, obj(x).y, shape(obj(x).shape)
	NEXT

	LOOP

