Unit TMHiCol;

{***************************************************************}
{**                                                           **}
{**    TMHICOL - Yet another unit from the PXDTECH series!    **}
{**                 Telemachos^Peroxide 1998                  **}
{**                                                           **}
{**        VBE 2.0 High/Truecolor graphics in TP 7.0          **}
{***************************************************************}


INTERFACE

USES
 crt;

CONST
 MAX_MODES  =  255;

 HEXTABLE : Array[0..15] of char
 = ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

TYPE
ModeRecordT = Record
                 Modenr : word;
                 XResolution  : word;
                 YResolution  : word;
                 BitsPerPixel : byte;
               End;



 ListOfAvailModesT = Array[0..255] of word; {terminated by -1 ($FFFF) }
 ListOfAvailModesP = ^ListOfAvailModesT;

 String2 = String[2];
 String4 = String[4];


{note - new size. Now 512 bytes instead of the 256 bytes block from VBE1.2}
VESAInfoT = record
              VBESignature      : array[0..3] of byte;
              VBEVersion        : word;
              OEMStringPtr      : Pchar;
              Capabilities      : array[0..3] of byte;
              VideoModePtr      : ListOfAvailModesP;
              TotalMemory       : word;
              {here goes the new VBE 2.0 info - new from PXDTUT5}
              OemSoftwareRev    : word;
              OemVendorNamePtr	: Pchar;
              OemProductNamePtr	: Pchar;
              OemProductRevPtr	: Pchar;
              Reserved      : Array[0..221] of byte;
              OEMData       : Array[0..255] of byte;
             end;


             ModeAttributesT =
                  (Available,           {mode avail on current hardware config..}
                   Reserved,            {VESA 1.2 and above this is set to 1}
                   BIOSFunctionsSupport,{Scroll, TTY output and pixel output}
                   color,
                   graphic,
                   bit5,
                   bit6,
                   bit7,
                   bit8);


WindowAttributesT  = (Supported,R,W);  {the rest of the bits are unused...}


{New VbeModeInfo - changed since PXDTUT5 to include vbe20 information     }
{Note that - as I have mentioned many times before - we do not really gain}
{anything big from implementing vbe 2.0 in TP. All we get of extra info is}
{the physical location of the LFB - which we cannot use in TP7.0/real mode}
{Remember that the DirectColor fields are also available in Vbe 1.2!!!    }

{But hey! People has been mailing me constantly requesting Vbe 2.0 info - }
{so, to satisfy the masses the rest of this PXDTECH will be VBE 2.0 code:)}


VESAModeInfoT = record
                   {All Vbe versions}
                   ModeAttributes     : set of ModeAttributesT;
                   WinAAttributes     : set of WindowAttributesT;
                   WinBAttributes     : set of WindowAttributesT;
                   WinGranularity     : word;
                   WinSize            : word;
                   WinASegment        : word;
                   WinBSegment        : word;
                   BankSwitch         : procedure;
                   BytesPerScanLine   : word;

                   {Xtended Information - Vbe 1.2 and above}
                   XResolution        : word;
                   YResolution        : word;
                   XCharSize          : byte;
                   YCharSize          : byte;
                   NumberOfPlanes     : byte;
                   BitsPerPixel       : byte;
                   NumberOfBanks      : byte;
                   MemoryModel        : byte;
                   BankSize           : byte;
                   NumberOfImagePages : byte;
                   Reserved           : byte;

                   {Direct Color fields / YUV-color fields}
                   RedMaskSize        : byte;
                   RedFieldPosition   : byte;
                   GreenMaskSize      : byte;
                   GreenFieldPosition : byte;
                   BlueMaskSize       : byte;
                   BlueFieldPosition  : byte;
                   RsvdMaskSize       : byte;
                   RsvdFieldPosition  : byte;
                   DirectColorModeInfo: byte;

                   {Vbe 2.0 and above}
                   PhysBasePtr        : longint;
                   OffScreenMemOffset : longint;
                   OffScreenMemSize   : word;  {in kb blocks}
                   Foo                : Array[0..205] of byte;
                end;


VAR
 VESAInfo          : VESAInfoT;      {info on VBE and graphics card}
 VESAModeInfo      : VESAModeInfoT;  {info on active mode}
 ModeLookupTable   : Array[0..MAX_MODES] of ModeRecordT;
                                     {A lookup table of all available modes}

 TMVESA_MODE_CORRECTION : Boolean;   {should I correct wrong bit-depths?}

 TMVESA_RGB_MODE          : Boolean; {Are we in direct color mode?}
 TMVESA_INDEXED_MODE      : Boolean; {Are we in 8bit mode?}
 TMVESA_BIT_DEPTH         : byte;    {currently bitdepth}
 TMVESA_NR_MODES          : byte;    {number of available modes}

 TMVESA_CUR_PAGE          : word;    {active page}
 TMVESA_BANKMULT          : word;    {factor to mult on bank-numbers}
                                     {(for granularities < 64K)     }

 TMVESA_BankShiftModifier : word;    {same as above - but for shifts}



{***********************************************************************}
{**                      FUNCTION HEADERS                             **}
{**           Some functions return a boolean succes code             **}
{***********************************************************************}


{***********************************************************************}
{**  ErrorMsg - Displays an error message, then exits to DOS          **}
{***********************************************************************}
PROCEDURE Error(msg : string);

{***********************************************************************}
{** Word2Hex / Byte2Hex - Ret. a string with the ordinal numer in hex!**}
{***********************************************************************}
FUNCTION Byte2Hex(b : byte) : String2;
FUNCTION Word2Hex(w : word) : String4;


{***********************************************************************}
{** WriteModeList - Displays a list of all available modes (textmode) **}
{***********************************************************************}
PROCEDURE WriteModeList;


{***********************************************************************}
{** SetUpVESAModeNr - Sets up a VBE mode based on mode-number         **}
{***********************************************************************}
FUNCTION SetUpVESAModeNr(nr : word) : boolean;


{***********************************************************************}
{** SetUpVESAMode - Sets up a VBE mode based on size and bit-depth    **}
{***********************************************************************}
FUNCTION SetUpVESAMode(Xres, Yres : word; BPP : byte) : boolean;



{***********************************************************************}
{** ShutVESADown - Sets textmode.                                     **}
{***********************************************************************}
PROCEDURE ShutVESADown;



{***********************************************************************}
{** Conv16b / Conv15b - packs 3 RGB bytes into 15 or 16bit            **}
{***********************************************************************}
FUNCTION Conv16b(R,G,B : byte) : word;
FUNCTION Conv15b(R,G,B : byte) : word;


{***********************************************************************}
{** VESAPutPixel - Draws a pixel at x,y in any bitmode, any resolution**}
{**                using R,G,B values. In 8 bit modes pass color to R **}
{***********************************************************************}
PROCEDURE VESAputpixel8b(x, y : WORD; c : BYTE);
PROCEDURE VESAputpixel16b(x, y : WORD; c : WORD);
PROCEDURE VESAputpixel24b(x, y : WORD; r,g,b : byte);
PROCEDURE VESAputpixel32b(x, y : WORD; r,g,b : byte);
PROCEDURE VESAPutPixel(x,y : word; R,G,B : byte);


{***********************************************************************}
{** VESAClearScreen - Clears the screen to black, all modes!          **}
{**                   NOTE : Pretty crude, will clear some off-screen **}
{**                          memory too!!                             **}
{***********************************************************************}
PROCEDURE VESAClearScreen;



IMPLEMENTATION



Procedure Error(msg : string);
begin
 asm
  mov ax,03h
  int 10h
 end;

 Writeln(msg);
 HALT;
end;


function Byte2Hex(b : byte) : String2;
var
 temp : string2;
begin
 temp[1] := HEXTABLE[b shr 4];
 temp[2] := HEXTABLE[b mod 16];
 Byte2Hex := temp;
end;

function Word2Hex(w : word) : String4;
begin
  Word2Hex:=Byte2Hex(hi(w))+Byte2Hex(lo(w));
end;



FUNCTION GetVESAInfo : boolean;
Assembler;
asm
 mov ah,4Fh
 mov al,00h
 push ds
 pop  es
 lea di,VESAInfo
 int 10h
 cmp ah,0
 jne @fail
 mov ax,1
 jmp @out
@fail:
 mov ax,0
@out:
end;

FUNCTION GetVESAModeInfo(mode : word) : boolean;
Assembler;
asm
 mov ah,4Fh
 mov al,01h
 xor cx,cx
 mov cx,mode
 push ds
 pop  es

 lea di,VESAModeInfo
 int 10h
 cmp ah,0
 jne @fail
 mov ax,1
 jmp @out
@fail:
 mov ax,0
@out:
end;



FUNCTION ModeDepthCheck(nr : word) : byte;
BEGIN
 Case nr of  {insert dangerous modes here : }
  $110 : ModeDepthCheck := 15;
  $113 : ModeDepthCheck := 15;
  $116 : ModeDepthCheck := 15;
 else
  ModeDepthCheck := 0;
 end;
END;



FUNCTION ModeInList(nr : word) : boolean;
var
 i : integer;
 found : boolean;
begin
 found := false;
 for i := 0 to TMVESA_NR_MODES do
  if ModeLookUpTable[i].ModeNr = nr then found := true;
 if found then ModeInList := true else ModeInList := false;
end;


PROCEDURE CreateModeLookUpTable;
var
 p : ^word;
 CheckedDepth : byte;
 i : integer;
begin
TMVESA_NR_MODES := 0;
for i := 0 to MAX_MODES do ModeLookUpTable[i].ModeNr := 0;

p := pointer(VESAInfo.VideoModePtr);
while (p^ <> $FFFF) do
 begin
   if Not(ModeInList(P^)) then
    begin
     GetVESAModeInfo(p^);
     ModeLookUpTable[TMVESA_NR_MODES].ModeNr := p^;
     ModeLookUpTable[TMVESA_NR_MODES].Xresolution := VESAModeInfo.Xresolution;
     ModeLookUpTable[TMVESA_NR_MODES].Yresolution := VESAModeInfo.Yresolution;
     ModeLookUpTable[TMVESA_NR_MODES].BitsPerPixel := VESAModeInfo.BitsPerPixel;
     IF TMVESA_MODE_CORRECTION then
      begin
       CheckedDepth := ModeDepthCheck(p^);
       If (CheckedDepth <> 0) then {a potention dangerous mode}
         ModeLookUpTable[TMVESA_NR_MODES].BitsPerPixel := CheckedDepth;
      end;
     Inc(TMVESA_NR_MODES);
    end;
  inc(p);
 end;
END;


Procedure WriteModeList;
var
 i : integer;
 p : ^word;
 CheckedDepth : byte;

begin
Writeln('Modes Available : ');
Writeln;
i := 0;

for i := 0 to TMVESA_NR_MODES-1 do
 begin

     Write('$',Word2Hex(ModeLookUpTable[i].ModeNr));
     GetVESAModeInfo(ModeLookUpTable[i].ModeNr);

     write(' ',VESAModeInfo.Xresolution : 5,' X ',VESAModeInfo.Yresolution:3);
     Write('   BPP : ',VESAModeInfo.BitsPerPixel:2);
     if color in VESAModeInfo.ModeAttributes then Write(' Color') else
        write(' Monocrome');
     if graphic in VESAModeInfo.ModeAttributes then Write('  Graphic') else
        write(' Textmode');

     if supported in VESAModeInfo.WinAAttributes then
      begin
       write(' Win A :');
       if R in VESAModeInfo.WinAAttributes then Write(' R');
       if W in VESAModeInfo.WinAAttributes then Write('W');
       write(' at : $',Word2Hex(VESAModeInfo.WinASegment));
      end;
     if supported in VESAModeInfo.WinBAttributes then
      begin
       write(' Win B :');
       if R in VESAModeInfo.WinBAttributes then Write(' R');
       if W in VESAModeInfo.WinBAttributes then Write('W');
       write(' at : $',Word2Hex(VESAModeInfo.WinASegment));
      end;

     Write('  Gran : ',VESAModeInfo.WinGranularity:2,'Kb');
     Writeln;

     if (i>0) AND (i MOD 23 = 0) then
        begin
         Writeln('Press any key for more modes...');
         readkey;
        end;
 end;

Writeln;
Writeln('Total number of modes available : ',TMVESA_NR_MODES);
end;


Procedure Calc_variables(modenr : word);
var
 CheckedDepth : byte;
begin
Case VESAModeInfo.WinGranularity of
 0  : Error('ERROR - Granularity reported as 0Kb!');
 1  : TMVESA_BankShiftModifier := 6;
 2  : TMVESA_BankShiftModifier := 5;
 4  : TMVESA_BankShiftModifier := 4;
 8  : TMVESA_BankShiftModifier := 3;
 16 : TMVESA_BankShiftModifier := 2;
 32 : TMVESA_BankShiftModifier := 1;
 64 : TMVESA_BankShiftModifier := 0;
end;    {With granularities smaller than 64 but with page-size 64K the
         banknr for each full segment of SVGA graphic will not be 0,1,2,3
         but multiplied with BankMult ( 2^BankShiftModifier for easy bit
         shifting)                                                         }
TMVESA_BankMult := 64 div VESAModeInfo.WinGranularity;

if (VESAModeInfo.MemoryModel = 6) then
begin   {direct color mode}
 if (VESAModeInfo.GreenFieldPosition < VESAModeInfo.RedFieldPosition) and
   (VESAModeInfo.BlueFieldPosition  < VESAModeInfo.GreenFieldPosition)
   then TMVESA_RGB_MODE := true
   else TMVESA_RGB_MODE := false;

   TMVESA_INDEXED_MODE := false;
end;

if (VESAModeInfo.MemoryModel = 4) then
begin  {indexed color mode - 8/4bit}
 TMVESA_RGB_MODE := false;
 TMVESA_INDEXED_MODE := true;
end;

IF TMVESA_MODE_CORRECTION then
      begin
       CheckedDepth := ModeDepthCheck(ModeNr);
       If (CheckedDepth <> 0) then {a potention dangerous mode}
         VESAModeInfo.BitsPerPixel := CheckedDepth;
      end;

TMVESA_BIT_DEPTH := VESAModeInfo.BitsPerPixel;
end;


FUNCTION SetVESAMode(mode : word) : boolean;
Assembler;
asm
 mov ax,03h
 int 10h              {start from textmode}

 mov ah,4Fh
 mov al,02h
 mov bx,mode
 int 10h
 cmp ah,0
 jne @fail           {set the VESA mode through VESA function 02h}

 mov ah,4Fh
 mov al,05h
 xor bx,bx
 mov dx,0
 int 10h
 mov TMVESA_cur_page,0      {initialize global page variable}
 cmp ah,0
 jne @fail          {Set bank 0}

 mov ax,1           {Set call to succesful}
 jmp @out
@fail:
 mov ax,0
@out:
end;


FUNCTION SetUpVESAModeNr(nr : word) : boolean;
begin
SetUpVESAModeNr := true;
if not(GetVESAModeInfo(nr)) then SetUpVESAModeNr := false;
if not(SetVESAMode(nr)) then SetUpVESAModeNr := false;
Calc_Variables(nr);
end;


FUNCTION SetUpVESAMode(Xres, Yres : word; BPP : byte) : boolean;
VAR
 counter : byte;
 found : boolean;
BEGIN
 found := false;
 counter := 0;
 repeat
  if (ModeLookUpTable[counter].Xresolution = Xres) AND
     (ModeLookUpTable[counter].Yresolution = Yres) AND
     (ModeLookUpTable[counter].BitsPerPixel = BPP) then
      found := true;

  inc(counter);
 until (found) or (counter = MAX_MODES);
 if found then
  begin
   SetUpVESAMode := true;
   if not(GetVESAModeInfo(ModeLookUpTable[counter-1].Modenr)) then
     SetUpVESAMode := false;
   if not(SetVESAMode(ModeLookUpTable[counter-1].Modenr)) then
     SetUpVESAMode := false;

   Calc_Variables(ModeLookUpTable[counter-1].Modenr);
  end
   else SetUpVESAMode := false;
END;



PROCEDURE ShutVESADown;
ASSEMBLER;
asm
 mov ax, 03h
 int 10h
end;



FUNCTION Conv16b(R,G,B : byte) : word;
Assembler;  { 16bit colors are 5:6:5 }
asm
 mov bl, [R]
 shr bx, 1
 shl bx,11
 mov ax,bx
 mov bl, [G]
 xor bh,bh
 shl bx, 5
 add ax, bx
 mov bl, [B]
 xor bh,bh
 shr bx, 1
 add ax,bx
END;


FUNCTION Conv15b(R,G,B : byte) : word;
Assembler;  { 15bit colors are 1:5:5:5 }
asm
 xor ax,ax
 mov bl, [R]
 shr bx, 1
 shl bx,10
 mov ax,bx
 mov bl, [G]
 shr bx,1
 xor bh,bh
 shl bx, 5
 add ax, bx
 mov bl, [B]
 xor bh,bh
 shr bx, 1
 add ax,bx
END;


PROCEDURE   VESAputpixel8b(x, y : WORD; c : BYTE);
VAR
  bank   : WORD;
  offs   : longint;
BEGIN

  offs := LONGINT(y) * VESAModeInfo.BytesPerScanline + x;
  bank := offs SHR (16-TMVESA_BankShiftModifier);
  offs := offs - (bank SHL (16-TMVESA_BankShiftModifier));

  IF bank <> TMVESA_Cur_page THEN {page = global var - active page}
  BEGIN
    TMVESA_cur_page := bank;
    ASM
      Xor bl,bl
      mov dx,bank
      call [VESAModeInfo.BankSwitch]
    END;
   END;

  ASM
    MOV AX, $A000
    MOV ES, ax
    MOV DI, WORD(offs)
    MOV AL, c
    MOV ES:[DI], AL
  END;
END;



PROCEDURE   VESAputpixel16b(x, y : WORD; c : WORD);
VAR
  bank   : WORD;
  offs   : longint;
BEGIN

  offs := LONGINT(y) * VESAModeInfo.BytesPerScanLine + x + x;
  bank := offs SHR (16-TMVESA_BankShiftModifier);
  offs := offs - (bank SHL (16-TMVESA_BankShiftModifier));

  IF bank <> TMVESA_Cur_page THEN {page = global var - active page}
  BEGIN
    TMVESA_cur_page := bank;
    ASM
      Xor bl,bl
      mov dx,bank
      call [VESAModeInfo.BankSwitch]
    END;
   END;

  ASM
    MOV AX, $A000
    MOV ES, ax
    MOV DI, WORD(offs)
    MOV AX, [C]
    STOSW
  END;
END;


PROCEDURE  VESAputpixel24b(x, y : WORD; r,g,b : byte);
VAR
  bank   : WORD;
  offs   : longint;

BEGIN

  offs := LONGINT(y) * VESAModeInfo.BytesPerScanLine + x + x + x;
  bank := offs SHR (16-TMVESA_BankShiftModifier);
  offs := offs - (bank SHL (16-TMVESA_BankShiftModifier));

  IF (bank <> TMVESA_Cur_page) THEN {Cur_page = global var - active page}
   BEGIN
    TMVESA_cur_page := bank;
    ASM
      Xor bl,bl
      mov dx,bank
      call [VESAModeInfo.BankSwitch]
    END;
   END;

  if ((offs = 65534) or (offs = 65535)) then
  BEGIN {bankswitch in the middle of the pixel}
     ASM
      MOV AX, $A000
      MOV ES, ax
      MOV DI, WORD(offs)

      CMP DI, 65534
      JE @Change3

      {OK - now we know that bankswitch is at 2 byte}
      MOV AL,[B]
      MOV ES:[DI], AL {Plot B component}

      XOR BL,BL
      MOV DX, [TMVESA_Cur_page]
      ADD DX, [TMVESA_BankMult]
      CALL [VESAModeInfo.BankSwitch]
      MOV [TMVESA_Cur_page], DX
      XOR DI,DI   {switch bank and reset di to 0 = offset in new bank}

      MOV AL, [G]
      MOV AH, [R]
      STOSW {write the last two bytes}
      JMP @OUT
     @Change3:
      {OK - the bankswitch is at 3'rd byte}
      MOV AL, [B]
      STOSB
      MOV AL, [G]
      MOV ES:[DI], AL  {Plot the two first bytes}

      XOR BL,BL
      MOV DX, [TMVESA_Cur_page]
      ADD DX, [TMVESA_BankMult]
      CALL [VESAModeInfo.BankSwitch]
      MOV [TMVESA_Cur_page], DX
      XOR DI,DI   {switch bank and reset di to 0 = offset in new bank}

      MOV AL, [R]
      STOSB    {plot the last byte}
     @Out:
     END;
  END
   else {if no bankswitch in the middle of a pixel}
  ASM   {we just plot the pixel as normal}
    MOV AX, $A000
    MOV ES, ax
    MOV DI, WORD(offs)
    MOV AL, [B]
    MOV AH, [G]
    STOSW
    MOV AL, [R]
    STOSB
  END;
END;



PROCEDURE  VESAputpixel32b(x, y : WORD; r,g,b : byte);
VAR
  bank   : WORD;
  offs   : longint;

BEGIN

  offs := LONGINT(y) * VESAModeInfo.BytesPerScanLine + x + x + x + x;
  bank := offs SHR (16-TMVESA_BankShiftModifier);
  offs := offs - (bank SHL (16-TMVESA_BankShiftModifier));

  IF bank <> TMVESA_Cur_page THEN {page = global var - active page}
  BEGIN
    TMVESA_cur_page := bank;
    ASM
      Xor bl,bl
      mov dx,bank
      call [VESAModeInfo.BankSwitch]
    END;
   END;

  ASM
    MOV AX, $A000
    MOV ES, ax
    MOV DI, WORD(offs)
    MOV AL, [B]
    MOV AH, [G]
    STOSW
    MOV AL, [R]
    STOSW
  END;
END;


PROCEDURE VESAPutPixel(x,y : word; R,G,B : byte);
BEGIN
IF (TMVESA_RGB_MODE) or (TMVESA_INDEXED_MODE) then
 begin {only allow 8bit and direct color modes - no YUV modes!!}
   CASE TMVESA_BIT_DEPTH of
     8 : VESAPutPixel8b(x,y,r);
    15 : VESAPutPixel16b(x,y, conv15b(r,g,b));
    16 : VESAPutPixel16b(x,y, conv16b(r,g,b));
    24 : VESAPutPixel24b(x,y, r,g,b);
    32 : VESAPutPixel32b(x,y, r,g,b);
   END; {Case}
 end;
END;


PROCEDURE VESAClearScreen;
var
 Xres, Yres : longint;
 number_of_segments : longint;
 i : integer;
begin
 Xres := VESAModeInfo.BytesPerScanline;
 Yres := VESAModeInfo.Yresolution;
 number_of_segments:=(Round(((Xres *  Yres)/65536)+0.5)-1)*TMVESA_BankMult;

   asm
     Xor     dx, dx   {bank 0}
     mov     ax, $A000
     mov     es, ax
    @again :
     Xor bl,bl
     call [VESAModeInfo.BankSwitch]

     mov     cx, 32768;
     xor     di, di
     Xor     ax, ax
     rep     stosw
     add     dx, TMVESA_BankMult
     cmp     dx, word (number_of_segments)
     jbe     @again
  end;
end;



BEGIN
TMVESA_MODE_CORRECTION := TRUE;  {set this to false if you don't want this}
                                 {feature}
VESAInfo.VbeSignature[0] := ORD('V');
VESAInfo.VbeSignature[1] := ORD('B');
VESAInfo.VbeSignature[2] := ORD('E');
VESAInfo.VbeSignature[3] := ORD('2');
{remember to preset this field to 'VBE2'}
GetVesaInfo;    {Request VBE 2.0 information}
CreateModeLookUpTable;  {Create the ModeLookUpTable}
END.






