Program PXDTECH2;
uses
  crt,TMHICOL;



VAR
 i,j : integer;
 mode2set : word;
 maxRGB : byte;




FUNCTION SelectAMode : word;
var
 i, valcode : integer;
 nr_modes, testdepth, chval : byte;
 modenrlist : Array[0..MAX_MODES] of word;
 validselect, continue, quit : boolean;
 ch : char;
 selectstr : string;

BEGIN
continue := false;
quit := false;

repeat
ClrScr;
Writeln('         *******************************************************');
Writeln('         **                      PEROXIDE                     **');
Writeln('         **                                                   **');
Writeln('         **       PXDTECH2 - hi-/truecolor with VBE 2.0       **');
Writeln('         *******************************************************');
Writeln;
Writeln('What you should see on your screen is : ');
Writeln('   - Indexed modes (8bit) : The pallette.');
Writeln('   - RGB modes : A colorful Moire using as many colors as possible');
Writeln('                 3 squares in this order : RED, GREEN, BLUE');
Writeln;
Writeln('Select a color depth to test :');
Writeln;
Writeln;
Writeln('   1)  8 bit (256 colors)');
Writeln('   2) 15 bit (32K colors)');
Writeln('   3) 16 bit (64K colors)');
Writeln('   4) 24 bit (16M colors)');
Writeln('   5) 32 bit (16M colors)');
Writeln;
Writeln('   Q) Get me out of here!!');
validselect := false;

repeat
 ch := readkey;
 ch := upcase(ch);
 case ch of
  '1' :begin
        validselect := true;
        testdepth := 8;
       end;
  '2' :begin
        validselect := true;
        testdepth := 15;
       end;
  '3' :begin
        validselect := true;
        testdepth := 16;
       end;
  '4' :begin
        validselect := true;
        testdepth := 24;
       end;
  '5' :begin
        validselect := true;
        testdepth := 32;
       end;
  'Q' :begin
        validselect := true;
        continue := true;
        quit := true;
        SelectAMode := 0;
       end;
  end; {case}
until validselect;

if not(continue) then
begin
ClrScr;
Writeln;
Writeln('Select mode to test : (your monitor might not be able to handle them all!)');
Writeln('640 X 480 is a good mode to test - works on most cards/monitors');
Writeln;
Writeln('Press space to return from a mode (or if your screen fucks up :)');
Writeln;
nr_modes := 0;
for i := 0 to TMVESA_NR_MODES do
 if (ModeLookUpTable[i].bitsperpixel = testdepth) then
    begin
     inc(nr_modes);
     Writeln(nr_modes,') ',ModeLookUpTable[i].Xresolution,' X ',
                           ModeLookUpTable[i].Yresolution);
     ModeNrList[nr_modes] := ModeLookUpTable[i].ModeNr;
    end;

Writeln;
Writeln('B) Back to bit depth selection');
Writeln;
Write('Type your selection here --> ');
validselect := false;

repeat
Readln(selectstr);
for i := 1 to length(selectstr) do selectstr[i] := upcase(selectstr[i]);
if selectstr = 'B' then validselect := true
 else
  begin
   Val(selectStr, chval,valcode);
   if (valcode = 0) and (chval <= nr_modes) then {actually an integer typed}
     begin
       continue := true;
       validselect := true;
     end;
   end;
until validselect;
end;
until continue;

if not(quit) then SelectAmode := ModeNrList[chval];
END;


Procedure WriteVESAInfo;
var
 i : integer;
begin
 for i := 0 to 3 do
 Write(chr(VESAInfo.VBESignature[i]));

 Write(' ');
 Writeln('Version : ',VESAInfo.VBEVersion shr 8,'.',VESAInfo.VBEVersion mod 256);
 Writeln('OEM String : ',VESAInfo.OEMStringPtr);

 Writeln('Vendor name : ',VESAInfo.OEMVendorNamePtr);
 Writeln('Product name : ',VESAInfo.OEMProductNamePtr);
 Writeln('Product Revision : ',VESAInfo.OEMProductRevPtr);
 Writeln('Software version : ',VESAInfo.OEMSoftwareRev shr 8,'.',
                               VESAInfo.OEMSoftwareRev mod 256);

 Writeln('Total Memory : ',VESAInfo.TotalMemory,' X 64Kb = '
         ,VESAInfo.TotalMemory * 65536,' bytes = ',
          VESAInfo.TotalMemory * 65536 div 1048576 ,'MB');
 Writeln;
end;



PROCEDURE Moire;
VAR
 i, j : integer;
 Xres, Yres : word;
 Rdiv, Gdiv, Bdiv : integer;

BEGIN
Xres := VESAModeInfo.Xresolution;
Yres := VESAModeInfo.Yresolution;

if (mode2set = $110) AND (TMVESA_BIT_DEPTH = 16) then TMVESA_BIT_DEPTH := 15;
if (mode2set = $113) AND (TMVESA_BIT_DEPTH = 16) then TMVESA_BIT_DEPTH := 15;

If (TMVESA_BIT_DEPTH = 15) or (TMVESA_BIT_DEPTH = 16) then
begin
 Rdiv := (Xres + Yres) DIV 60+1;
 Gdiv := Yres DIV 60+1;
 Bdiv := Xres DIV 60+1;

  for i := 0 to VESAModeInfo.Xresolution do
   for j := 0 to VESAModeInfo.Yresolution do
     VESAPutPixel(i,j,63 - ((i+j) DIV Rdiv), j DIV Gdiv, i DIV Bdiv);
end;

If (TMVESA_BIT_DEPTH = 24) or (TMVESA_BIT_DEPTH = 32) then
begin
 Rdiv := (Xres + Yres) DIV 250+1;
 Gdiv := Yres DIV 250+1;
 Bdiv := Xres DIV 250+1;

  for i := 0 to VESAModeInfo.Xresolution do
   for j := 0 to VESAModeInfo.Yresolution do
     VESAPutPixel(i,j,255 - ((i+j) DIV Rdiv), j DIV Gdiv, i DIV Bdiv);
end;



END;






BEGIN
clrscr;
Writeln('      ****************************************************************');
Writeln('      *                                                              *');
Writeln('      *                PXDTECH #2 : TMHICOL - A VBE 2.0 unit!        *');
Writeln('      *                    by : Telemachos^Peroxide                  *');
Writeln('      *                                                              *');
Writeln('      ****************************************************************');
Writeln;
Writeln;
Writeln('      Hello fellow programmers! ');
Writeln('      Welcome to the second release in my new PXDTECH series!');
Writeln;
Writeln('      This one is on VBE coding in 8/15/16/24 and 32 bit graphic');
Writeln('      modes. The official name of this tutorial is something with the word');
Writeln('      VBE 2.0 included. Well - this code IS VBE 2.0 code, but it''ll');
Writeln('      work with VBE 1.2 too (see text for more info on this)');
Writeln;
Writeln('      If you have any trouble with this program PLEASE mail me and');
Writeln('      tell me :');
Writeln('           1) What card do you have');
Writeln('           2) What went wrong');
Writeln('           3) Did you have Scitech Display Doctor installed (which version?)');
Writeln;
Writeln('      Well - have fun with hi-/truecolor in Pascal!');
Writeln('      Hit any key to start.....');
readkey;
ClrScr;

Writeln('Your hardware :');
Writeln;

WriteVESAInfo;  { Write information about hardware / software        }
                { NOTE - Scitech Display Doctor will overwrite these }
                { fields to their own strings!!! (shame on them)     }
Writeln('Press any key to see a list of available modes...');
readkey;
Clrscr;
WriteModeList;       {Display a list of available modes}
Writeln('press any key...');
readkey;


repeat
mode2set := SelectAmode;


if (mode2set <> 0) then
begin

{NOTE!! Even though I use the "bad" SetUpVESAModeNr routine to set up
 mode, it does'nt mean that I use hardcoded mode numbers. Remember - I
 got the modenumbers from the ModeLookUpTable (in the SelectAMode proc)}

{You should of course always use SetUpVESAMode(Xres, Yres, BPP)        }
 if not(SetUpVESAModeNr(mode2set)) then
  Error('Error setting mode : $'+Word2Hex(mode2set));


 If (TMVESA_INDEXED_MODE) then
  begin  {indexed color demo}
   For i := 0 to 255 do
    for j := 0 to 100 do
      VESAPutPixel(i,j, i,0,0);

  end
 else
  begin   {simple direct color demo}

   Moire;   {draw some colors}

   IF (TMVESA_BIT_DEPTH = 24) or (TMVESA_BIT_DEPTH = 32) then
   maxRGB := 255 else maxRGB := 63;

   For i := 0 to 150 do
    for j := 0 to 25 do
      VESAPutPixel(i,j, maxRGB,0,0);

   For i := 0 to 150 do
    for j := 0 to 25 do
      VESAPutPixel(i,25+j, 0,maxRGB,0);

   For i := 0 to 150 do
    for j := 0 to 25 do
      VESAPutPixel(i,50+j, 0,0,maxRGB);


  end;

readkey;

ShutVESADown;

end;
until Mode2set = 0;  {repeat until user choose to quit app.}

END.