
/*       PRE-CC 2.42 compiler-compiler   
 *       Copyright Peter Breuer 1989-1994
 *    <ptb@eng.cam.ac.uk> Tel +44 (0)223 68682
 *    <ptb@comlab.ox.ac.uk> <ptb@dit.upm.es>
 */

# define TOKEN char
# define VALUE char*
# define STACKTOKENS 1
# define STACKSIZE 2048

# define BEGIN p_begin()

# include "cc.h"
# include "preccx.h"
# undef UNSETNAME
# include "preamble.h"

char* p_infile,            /* stdin name (eventually "-" if not a file) */
    * p_outfile;           /* stdout name (eventually "-" if not a file) */

int p_begin(){
        static int passes; /* no. of times re-entered MAIN */
        int narg;          /* no of command line args */
        int nswitch;       /* count of command line switches */
        int switches;      /* flag - when doing command line switches */
        int dup2();
        
        if(passes++==0){   /* print motto */
                printf("\n\
/*       PRE-CC %.2f compiler-compiler   \n\
 *       Copyright Peter Breuer 1989-1994\n\
 *    <ptb@eng.cam.ac.uk> Tel +44 (0)223 68682\n\
 *    <ptb@comlab.ox.ac.uk> <ptb@dit.upm.es>\n\
 */\n\
",__PRECC__);
            call_mode=1;/* set no-auto shift in value stack */
            dup2(0,5);  /* save stdin and stdout */
            dup2(1,6);
            nswitch=0;  /* begin command line processing */
            switches=1;
            for (narg=1;narg<p_argc;narg++){
                switch(p_argv[narg][0]){
                case '-':
                    if(!switches) /* mixed switches and files */
                      usage (1);
                    nswitch++;
                    switch(p_argv[narg][1]){
                    case 'r': /* read buffer size in Kb */
                        getkintarg(p_argv[narg]+2,&precc_data.readbuffersize,
                                   sizeof (TOKEN) + sizeof (VALUE));
                        break;
                    case 'p': /* internal program length in Kb */
                        getkintarg(p_argv[narg]+2,&precc_data.maxprogramsize,
                                   sizeof (VALUE));
                        break;
                    case 'v': /* internal VALUE stack size in Kb */
                        getkintarg(p_argv[narg]+2,&precc_data.stacksize,
                                   sizeof (STACKVALUE));
                        break;
                    case 'f': /* internal FRAME stack size in Kb */
                        getkintarg(p_argv[narg]+2,&precc_data.contextstacksize,
                                   sizeof (FRAME));
                    case 'o': /* internal FRAME stack size in Kb */
                        if (0==strcmp(p_argv[narg]+1,"old"))
                            precc_data.oldattributes=1;
                        else
                            precc_data.oldattributes=0;
                        break;
                    default: /* unknown option */
                        usage(3);
                    }
                    break;
                default:
                    switches=0; /* end of switches */
                    break;
                }
            }                   /* now deal with redirects */
            p_infile = p_outfile = "-"; /* in and out file names */
            switch(p_argc-1-nswitch){
            case 2:
                    if (freopen(p_outfile=p_argv[nswitch+2], "w", stdout)==NULL) 
                      usage (2);
            case 1:
                    if (freopen(p_infile=p_argv[nswitch+1], "r", stdin)==NULL) 
                      usage (5);
            case 0: break;
            default: /* too many files named */
                    usage (6);
            }
        }
        return 0;                /* success */
}

char *envs[PSTACKLENGTH];      /*environment stack*/
char *plvs[PSTACKLENGTH];      /*plainenv    stack*/
int  ecount=0;                 /*pointer */
int  countstack[PSTACKLENGTH]; /*stack of number of sequents we have seen */
int  countcount =0;            /*pointer */


void pushenv()
/* save the current environment and begin another */
{
    ecount++;
}

void popenv()
/* release the current env and recall the old */
{
    ecount--;
}

void pushcount()
/* save the current count of sequents and begin another */
{
    countcount++;
    /* the next line disambiguates references in blocks, but that is
     * probably not what is wanted.
     */
    /* count = countcount*PSTACKLENGTH + 1; */
    /* this next line does no disambiguation
     * and therefore causes warnings from C code,
     * but it doesn't matter.
     */
    count = 1;
}
void popcount()
/* release the current count of sequents and recall the old */
{
    countcount--;
}
int getcount()
/* return the current count level for sequents */
{
    return countcount;
}


                /* -- idens with params ------- */

static VOID hid0(){
VV(2)=V(1);
}
static STATUS hid1(){
PARSER rdbrktargs;ACTION hid0;
return p_attach0n(TOPARSER rdbrktargs,0,hid0,0);
}
static STATUS hid2(){
PARSER hid1;
return p_option0n(TOPARSER hid1,0);
}
static STATUS hid3(){
PARSER IDENTIFIER, hid2;
static STATUS p_tok;
P_PAND((TOPARSER IDENTIFIER)(),(TOPARSER hid2)());
return p_tok;
}
STATUS nameplusargs(){
PARSER hid3;
return((TOPARSER hid3)());
}

static VOID hid4(){
VV(2)=V(1);
}
static STATUS hid5(){
PARSER rdbrktvars;ACTION hid4;
return p_attach0n(TOPARSER rdbrktvars,0,hid4,0);
}
static STATUS hid6(){
PARSER hid5;
return p_option0n(TOPARSER hid5,0);
}
static STATUS hid7(){
PARSER IDENTIFIER, hid6;
static STATUS p_tok;
P_PAND((TOPARSER IDENTIFIER)(),(TOPARSER hid6)());
return p_tok;
}
STATUS nameplusvars(){
PARSER hid7;
return((TOPARSER hid7)());
}

static STATUS hid8(){
PARSER WHITESPACE, closebracket;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER closebracket)());
return p_tok;
}
static STATUS hid9(){
PARSER someargs, hid8;
static STATUS p_tok;
P_PAND((TOPARSER someargs)(),(TOPARSER hid8)());
return p_tok;
}
static STATUS hid10(){
PARSER WHITESPACE, hid9;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid9)());
return p_tok;
}
static STATUS hid11(){
PARSER openbracket, hid10;
static STATUS p_tok;
P_PAND((TOPARSER openbracket)(),(TOPARSER hid10)());
return p_tok;
}
static VOID hid12(){
VV(5)=V(3);
}
static STATUS hid13(){
PARSER hid11;ACTION hid12;
return p_attach0n(TOPARSER hid11,0,hid12,0);
}
static STATUS hid14(){
PARSER hid13, p_nothing0;
static STATUS p_tok;
P_PAND((TOPARSER hid13)(),(TOPARSER p_nothing0)());
return p_tok;
}
STATUS sqbrktargs(){
PARSER hid14;
return((TOPARSER hid14)());
}

static STATUS hid15(){
PARSER WHITESPACE, closeparen;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER closeparen)());
return p_tok;
}
static STATUS hid16(){
PARSER theargs, hid15;
static STATUS p_tok;
P_PAND((TOPARSER theargs)(),(TOPARSER hid15)());
return p_tok;
}
static STATUS hid17(){
PARSER WHITESPACE, hid16;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid16)());
return p_tok;
}
static STATUS hid18(){
PARSER openparen, hid17;
static STATUS p_tok;
P_PAND((TOPARSER openparen)(),(TOPARSER hid17)());
return p_tok;
}
static VOID hid19(){
VV(5)=V(3);
}
static STATUS hid20(){
PARSER hid18;ACTION hid19;
return p_attach0n(TOPARSER hid18,0,hid19,0);
}
static STATUS hid21(){
PARSER hid20, p_nothing0;
static STATUS p_tok;
P_PAND((TOPARSER hid20)(),(TOPARSER p_nothing0)());
return p_tok;
}
STATUS rdbrktargs(){
PARSER hid21;
return((TOPARSER hid21)());
}

static STATUS hid22(){
PARSER WHITESPACE, closeparen;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER closeparen)());
return p_tok;
}
static STATUS hid23(){
PARSER thevars, hid22;
static STATUS p_tok;
P_PAND((TOPARSER thevars)(),(TOPARSER hid22)());
return p_tok;
}
static STATUS hid24(){
PARSER WHITESPACE, hid23;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid23)());
return p_tok;
}
static STATUS hid25(){
PARSER openparen, hid24;
static STATUS p_tok;
P_PAND((TOPARSER openparen)(),(TOPARSER hid24)());
return p_tok;
}
static VOID hid26(){
VV(5)=V(3);
}
static STATUS hid27(){
PARSER hid25;ACTION hid26;
return p_attach0n(TOPARSER hid25,0,hid26,0);
}
static STATUS hid28(){
PARSER hid27, p_nothing0;
static STATUS p_tok;
P_PAND((TOPARSER hid27)(),(TOPARSER p_nothing0)());
return p_tok;
}
STATUS rdbrktvars(){
PARSER hid28;
return((TOPARSER hid28)());
}

/* these are token-driven writes */

static VOID hid29(){
 VV(1) = putchar(T(1)); 
}
static STATUS hid30(){
PARSER OPENPAREN;ACTION hid29;
return p_attach0n(TOPARSER OPENPAREN,0,hid29,0);
}
STATUS openparen(){
PARSER hid30;
return((TOPARSER hid30)());
}

static VOID hid31(){
 VV(1) = putchar(T(1)); 
}
static STATUS hid32(){
PARSER CLOSEPAREN;ACTION hid31;
return p_attach0n(TOPARSER CLOSEPAREN,0,hid31,0);
}
STATUS closeparen(){
PARSER hid32;
return((TOPARSER hid32)());
}

static VOID hid33(){
 VV(1) = putchar(T(1)); 
}
static STATUS hid34(){
PARSER OPENBRACKET;ACTION hid33;
return p_attach0n(TOPARSER OPENBRACKET,0,hid33,0);
}
STATUS openbracket(){
PARSER hid34;
return((TOPARSER hid34)());
}

static VOID hid35(){
 VV(1) = putchar(T(1)); 
}
static STATUS hid36(){
PARSER CLOSEBRACKET;ACTION hid35;
return p_attach0n(TOPARSER CLOSEBRACKET,0,hid35,0);
}
STATUS closebracket(){
PARSER hid36;
return((TOPARSER hid36)());
}



static VOID hid37(){
 VV(0)=""; 
}
static STATUS hid38(){
PARSER p_nothing0;ACTION hid37;
return p_attach0n(TOPARSER p_nothing0,0,hid37,0);
}
static STATUS hid39 (){
PARSER someargs, hid38;
static STATUS p_tok;
p_tok = (TOPARSER someargs) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid38) ();
}
STATUS theargs(){
PARSER hid39;
return((TOPARSER hid39)());
}

static VOID hid40(){
 VV(0)=""; 
}
static STATUS hid41(){
PARSER p_nothing0;ACTION hid40;
return p_attach0n(TOPARSER p_nothing0,0,hid40,0);
}
static STATUS hid42 (){
PARSER somevars, hid41;
static STATUS p_tok;
p_tok = (TOPARSER somevars) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid41) ();
}
STATUS thevars(){
PARSER hid42;
return((TOPARSER hid42)());
}

static VOID hid43(){
 VV(1)=putchar(','); 
}
static STATUS hid44(){
PARSER COMMA;ACTION hid43;
return p_attach0n(TOPARSER COMMA,0,hid43,0);
}
STATUS comma(){
PARSER hid44;
return((TOPARSER hid44)());
}

static STATUS hid45(){
PARSER WHITESPACE, expr;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER expr)());
return p_tok;
}
static STATUS hid46(){
PARSER comma, hid45;
static STATUS p_tok;
P_PAND((TOPARSER comma)(),(TOPARSER hid45)());
return p_tok;
}
static STATUS hid47(){
PARSER WHITESPACE, hid46;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid46)());
return p_tok;
}
static VOID hid48(){
VV(5)=V(1);
}
static STATUS hid49(){
PARSER hid47;ACTION hid48;
return p_attach0n(TOPARSER hid47,0,hid48,0);
}
static STATUS hid50(){
PARSER hid49;
return p_many0n(TOPARSER hid49,0);
}
static STATUS hid51(){
PARSER expr, hid50;
static STATUS p_tok;
P_PAND((TOPARSER expr)(),(TOPARSER hid50)());
return p_tok;
}
STATUS someargs(){
PARSER hid51;
return((TOPARSER hid51)());
}


static STATUS hid52(){
PARSER WHITESPACE, var;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER var)());
return p_tok;
}
static STATUS hid53(){
PARSER comma, hid52;
static STATUS p_tok;
P_PAND((TOPARSER comma)(),(TOPARSER hid52)());
return p_tok;
}
static STATUS hid54(){
PARSER WHITESPACE, hid53;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid53)());
return p_tok;
}
static VOID hid55(){
VV(5)=V(1);
}
static STATUS hid56(){
PARSER hid54;ACTION hid55;
return p_attach0n(TOPARSER hid54,0,hid55,0);
}
static STATUS hid57(){
PARSER hid56;
return p_many0n(TOPARSER hid56,0);
}
static STATUS hid58(){
PARSER var, hid57;
static STATUS p_tok;
P_PAND((TOPARSER var)(),(TOPARSER hid57)());
return p_tok;
}
STATUS somevars(){
PARSER hid58;
return((TOPARSER hid58)());
}


static VOID hid59(){
if(*putargs(""))putargs(",");putargs("PARAM ");putargs(V(1));                 if(*putmeta(""))putmeta(",");putmeta(V(1));
}
static STATUS hid60(){
PARSER IDENTIFIER;ACTION hid59;
return p_attach0n(TOPARSER IDENTIFIER,0,hid59,0);
}
STATUS var(){
PARSER hid60;
return((TOPARSER hid60)());
}


                /* -- parser identifiers --- */

/* collect IDENTIFIERs from buffers */

void SETENV()
/* seal the current environment to be whats in the buffers now */
{
  environment=putargs("");
  plainenv=putmeta("");
  getargs(&environment);
  getmeta(&plainenv);
}

char *LASTVAR()
/* last variable in the current environment */
{
char *s;
if (ecount<0)
  return NULL;
s = strchr(plainenv,',');
if (!s)
  return plainenv;
return s+1;
}

/* first item written in a declaration block */
static VOID hid61(){
getname(&V(1));SETENV();
}
static STATUS hid62(){
PARSER nameplusvars;ACTION hid61;
return p_attach0n(TOPARSER nameplusvars,0,hid61,0);
}
STATUS declname(){
PARSER hid62;
return((TOPARSER hid62)());
}

/* to make #line references to definitions immediately before the
   FIRST STATUS foo line in the emitted code, insert P_LINE; before the
   getname above */


/* collect a domain IDENTIFIER in the same way */

static VOID hid63(){
getname(&V(1));
}
static STATUS hid64(){
PARSER nameplusargs;ACTION hid63;
return p_attach0n(TOPARSER nameplusargs,0,hid63,0);
}
STATUS exprname(){
PARSER hid64;
return((TOPARSER hid64)());
}


                /* -- start of precc defn ----   */


static STATUS hid65(){
PARSER declerr;
return p_uerror0n(TOPARSER declerr,0);
}
static STATUS hid66(){
PARSER expression, WHITESPACE;
static STATUS p_tok;
P_PAND((TOPARSER expression)(),(TOPARSER WHITESPACE)());
return p_tok;
}
static STATUS hid67(){
PARSER WHITESPACE, hid66;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid66)());
return p_tok;
}
static STATUS hid68(){
PARSER EQUALS, hid67;
static STATUS p_tok;
P_PAND((TOPARSER EQUALS)(),(TOPARSER hid67)());
return p_tok;
}
static STATUS hid69(){
PARSER WHITESPACE, hid68;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid68)());
return p_tok;
}
static STATUS hid70(){
PARSER declname, hid69;
static STATUS p_tok;
P_PAND((TOPARSER declname)(),(TOPARSER hid69)());
return p_tok;
}
static STATUS hid71(){
PARSER WHITESPACE, hid70;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid70)());
return p_tok;
}
static STATUS hid72(){
PARSER hid65, hid71;
static STATUS p_tok;
P_PAND((TOPARSER hid65)(),(TOPARSER hid71)());
return p_tok;
}
static STATUS hid73(){
PARSER AT, hid72;
static STATUS p_tok;
P_PAND((TOPARSER AT)(),(TOPARSER hid72)());
return p_tok;
}
static STATUS hid74(){
PARSER p_first0, hid73;
static STATUS p_tok;
P_PAND((TOPARSER p_first0)(),(TOPARSER hid73)());
return p_tok;
}
static VOID hid75(){
VV(10) = P_REN(V(5),V(9));countcount=0;RESET;
}
static STATUS hid76(){
PARSER hid74;ACTION hid75;
return p_attach0n(TOPARSER hid74,0,hid75,0);
}
STATUS declaration(){
PARSER hid76;
return((TOPARSER hid76)());
}

void ADDVAR(char *x)
/* make a new environment with one more var. save the old. */
{
  char *n;
                 /* finish off current env */
  getargs(&n);
  getmeta(&n);
                 /* copy old to new - start by buffering it */
  putargs(environment);
  putmeta(plainenv);
                 /* increment env count */
  pushenv();
                 /* point env at buffer */
  environment=putargs("");
  plainenv=putmeta("");
                 /* add new var */

  if (is_in(x,plainenv))
      return;    /* unless already there */

  if(*environment){
    putargs(",");
    putmeta(",");
  }
  putargs("PARAM ");
  putargs(x);
  putmeta(x);
                 /* note that the buffer is still unterminated */
}



/* to make #line references to definitions immediately before the
   STATUS foo line in the emitted code, insert P_LINE; before the
   VV above */

static STATUS hid77(){
PARSER printdeclerr, passthrough;
static STATUS p_tok;
P_PAND((TOPARSER printdeclerr)(),(TOPARSER passthrough)());
return p_tok;
}
static VOID hid78(){
VV(2)=V(1);
}
static STATUS hid79(){
PARSER hid77;ACTION hid78;
return p_attach0n(TOPARSER hid77,0,hid78,0);
}
STATUS declerr(){
PARSER hid79;
return((TOPARSER hid79)());
}

static VOID hid80(){
VV(0)="@";                 printf("line %d error: malformed declaration\n@?",yylineno);
}
static STATUS hid81(){
PARSER p_nothing0;ACTION hid80;
return p_attach0n(TOPARSER p_nothing0,0,hid80,0);
}
STATUS printdeclerr(){
PARSER hid81;
return((TOPARSER hid81)());
}

                /* that was it. Now the top level (MAIN) parse. */

static STATUS hid82(){
PARSER notanat, passthrough;
static STATUS p_tok;
P_PAND((TOPARSER notanat)(),(TOPARSER passthrough)());
return p_tok;
}
static VOID hid83(){
VV(0)="";printf("\n");
}
static STATUS hid84(){
PARSER p_nothing0;ACTION hid83;
return p_attach0n(TOPARSER p_nothing0,0,hid83,0);
}
static STATUS hid85 (){
PARSER hid82, hid84;
static STATUS p_tok;
p_tok = (TOPARSER hid82) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid84) ();
}
static STATUS hid86 (){
PARSER declaration, hid85;
static STATUS p_tok;
p_tok = (TOPARSER declaration) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid85) ();
}
STATUS line(){
PARSER hid86;
return((TOPARSER hid86)());
}

static VOID hid87(){
 VV(1)=putchar(T(1)); 
}
static STATUS hid88(){
PARSER NOTANAT;ACTION hid87;
return p_attach0n(TOPARSER NOTANAT,0,hid87,0);
}
STATUS notanat(){
PARSER hid88;
return((TOPARSER hid88)());
}

/* this is a deliberate pop of the value 'behind'  if we get none */

static VOID hid89(){
 VV(2)=V(1); 
}
static STATUS hid90(){
PARSER anychar;ACTION hid89;
return p_attach0n(TOPARSER anychar,0,hid89,0);
}
static STATUS hid91(){
PARSER hid90;
return p_many0n(TOPARSER hid90,0);
}
static VOID hid92(){
getname(&V(1));printf("%s\n",V(1)); RESET;
}
static STATUS hid93(){
PARSER hid91;ACTION hid92;
return p_attach0n(TOPARSER hid91,0,hid92,0);
}
STATUS passthrough(){
PARSER hid93;
return((TOPARSER hid93)());
}

static VOID hid94(){
 VV(1)=putchar(T(1)); 
}
static STATUS hid95(){
PARSER ANYTHING;ACTION hid94;
return p_attach0n(TOPARSER ANYTHING,0,hid94,0);
}
STATUS anychar(){
PARSER hid95;
return((TOPARSER hid95)());
}

                /* ----  parser expressions -------- */

static STATUS hid96 (){
PARSER alternates, empty;
static STATUS p_tok;
p_tok = (TOPARSER alternates) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER empty) ();
}
STATUS expression(){
PARSER hid96;
return((TOPARSER hid96)());
}

/* a <'|'> separated series, at least one <'|'>  - note the overpull 
   I prefer the order which results from recursion */

static STATUS hid97(){
PARSER WHITESPACE, alternates;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER alternates)());
return p_tok;
}
static STATUS hid98(){
PARSER OR, hid97;
static STATUS p_tok;
P_PAND((TOPARSER OR)(),(TOPARSER hid97)());
return p_tok;
}
static STATUS hid99(){
PARSER WHITESPACE, hid98;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid98)());
return p_tok;
}
static VOID hid100(){
char *n;                 VV(5)=(GETNEWNAME(&n,plainenv,NULL),P_ALT(n,V(1),V(5)));
}
static STATUS hid101(){
PARSER hid99;ACTION hid100;
return p_attach0n(TOPARSER hid99,0,hid100,0);
}
static STATUS hid102(){
PARSER hid101, p_nothing0;
static STATUS p_tok;
P_PAND((TOPARSER hid101)(),(TOPARSER p_nothing0)());
return p_tok;
}
static STATUS hid103(){
PARSER hid102;
return p_option0n(TOPARSER hid102,0);
}
static STATUS hid104(){
PARSER sequence, hid103;
static STATUS p_tok;
P_PAND((TOPARSER sequence)(),(TOPARSER hid103)());
return p_tok;
}
STATUS alternates(){
PARSER hid104;
return((TOPARSER hid104)());
}

/* appending is much more efficient than prepending because I don't waste
  C-stack space with MARK before a parse */

/* this is a command separated sequence of sequents which are not commands
*/

static STATUS hid105(){
PARSER SOMESPACE, manysequents;
static STATUS p_tok;
P_PAND((TOPARSER SOMESPACE)(),(TOPARSER manysequents)());
return p_tok;
}
static STATUS hid106(){
PARSER command, hid105;
static STATUS p_tok;
P_PAND((TOPARSER command)(),(TOPARSER hid105)());
return p_tok;
}
static STATUS hid107(){
PARSER SOMESPACE, hid106;
static STATUS p_tok;
P_PAND((TOPARSER SOMESPACE)(),(TOPARSER hid106)());
return p_tok;
}
static VOID hid108(){
char *n;                  VV(3)=(GETNEWNAME(&n,plainenv,NULL),P_AND(n,V(1),V(3)));
}
static STATUS hid109(){
PARSER hid107;ACTION hid108;
return p_attach0n(TOPARSER hid107,0,hid108,0);
}
static STATUS hid110(){
PARSER hid109, p_nothing0;
static STATUS p_tok;
P_PAND((TOPARSER hid109)(),(TOPARSER p_nothing0)());
return p_tok;
}
static STATUS hid111(){
PARSER hid110;
return p_many0n(TOPARSER hid110,0);
}
static STATUS hid112(){
PARSER WHITESPACE, command;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER command)());
return p_tok;
}
static STATUS hid113(){
PARSER hid112;
return p_option0n(TOPARSER hid112,0);
}
static STATUS hid114(){
PARSER hid111, hid113;
static STATUS p_tok;
P_PAND((TOPARSER hid111)(),(TOPARSER hid113)());
return p_tok;
}
static STATUS hid115(){
PARSER manysequents, hid114;
static STATUS p_tok;
P_PAND((TOPARSER manysequents)(),(TOPARSER hid114)());
return p_tok;
}
STATUS sequence(){
PARSER hid115;
return((TOPARSER hid115)());
}

 /* here we attach to the manysequents which this follows */

static STATUS hid116(){
PARSER c_code, COLONorEOL;
static STATUS p_tok;
P_PAND((TOPARSER c_code)(),(TOPARSER COLONorEOL)());
return p_tok;
}
static STATUS hid117(){
PARSER COLON, hid116;
static STATUS p_tok;
P_PAND((TOPARSER COLON)(),(TOPARSER hid116)());
return p_tok;
}
static VOID hid118(){
 char *n,*m;             VV(5)=(GETNEWNAME(&n,plainenv,NULL),GETNEWNAME(&m,plainenv,NULL),P_ATT(m,V(1),n,V(4))); 
}
static STATUS hid119(){
PARSER hid117;ACTION hid118;
return p_attach0n(TOPARSER hid117,0,hid118,0);
}
STATUS command(){
PARSER hid119;
return((TOPARSER hid119)());
}

/* commands can't be treated as ordinary atoms at the moment, because they
 * are required to end a sequence of 'and's and force a stack shift */

static VOID hid120(){
 VV(1)=V(1); getname(&V(1)); 
}
static STATUS hid121(){
PARSER cstuffs;ACTION hid120;
return p_attach0n(TOPARSER cstuffs,0,hid120,0);
}
STATUS c_code(){
PARSER hid121;
return((TOPARSER hid121)());
}

/* the stuff inside a command is a sequence of C constants or C tokens */

static VOID hid122(){
 VV(2) = V(1); 
}
static STATUS hid123(){
PARSER cstuff;ACTION hid122;
return p_attach0n(TOPARSER cstuff,0,hid122,0);
}
static STATUS hid124(){
PARSER hid123;
return p_many0n(TOPARSER hid123,0);
}
static STATUS hid125(){
PARSER cstuff, hid124;
static STATUS p_tok;
P_PAND((TOPARSER cstuff)(),(TOPARSER hid124)());
return p_tok;
}
static VOID hid126(){
 VV(0) =""; 
}
static STATUS hid127(){
PARSER p_nothing0;ACTION hid126;
return p_attach0n(TOPARSER p_nothing0,0,hid126,0);
}
static STATUS hid128 (){
PARSER hid125, hid127;
static STATUS p_tok;
p_tok = (TOPARSER hid125) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid127) ();
}
STATUS cstuffs(){
PARSER hid128;
return((TOPARSER hid128)());
}

/* all the component tokens are accumulating in the cbuff */

static VOID hid129(){
 VV(1) = putchar(T(1)); 
}
static STATUS hid130(){
PARSER NOTACOLON;ACTION hid129;
return p_attach0n(TOPARSER NOTACOLON,0,hid129,0);
}
static STATUS hid131 (){
PARSER COMMENT, hid130;
static STATUS p_tok;
p_tok = (TOPARSER COMMENT) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid130) ();
}
static STATUS hid132 (){
PARSER DOLLARID, hid131;
static STATUS p_tok;
p_tok = (TOPARSER DOLLARID) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid131) ();
}
static STATUS hid133 (){
PARSER CHARCONST, hid132;
static STATUS p_tok;
p_tok = (TOPARSER CHARCONST) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid132) ();
}
static STATUS hid134 (){
PARSER STRING, hid133;
static STATUS p_tok;
p_tok = (TOPARSER STRING) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid133) ();
}
STATUS cstuff(){
PARSER hid134;
return((TOPARSER hid134)());
}

/* manysequents is a 0 or more long list of nonempty non-commands */

/* start a new count */

/* do the pulling in moresequents, if it happens */

static STATUS hid135(){
PARSER moresequents;
return p_option0n(TOPARSER moresequents,0);
}
static STATUS hid136(){
PARSER firstsequent, hid135;
static STATUS p_tok;
P_PAND((TOPARSER firstsequent)(),(TOPARSER hid135)());
return p_tok;
}
static VOID hid137(){
 popcount();
}
static STATUS hid138(){
PARSER hid136;ACTION hid137;
return p_attach0n(TOPARSER hid136,0,hid137,0);
}
STATUS manysequents(){
PARSER hid138;
return((TOPARSER hid138)());
}

/* need "empty newvar empty" and "sequent newvar empty" to make the
   above complete, but it's too much bother right now */

static STATUS hid139 (){
PARSER sequent, empty;
static STATUS p_tok;
p_tok = (TOPARSER sequent) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER empty) ();
}
static VOID hid140(){
pushcount();
}
static STATUS hid141(){
PARSER hid139;ACTION hid140;
return p_attach0n(TOPARSER hid139,0,hid140,0);
}
STATUS firstsequent(){
PARSER hid141;
return((TOPARSER hid141)());
}

        /* overpull again in the option 
           again, I prefer to use recursion for better output order */

/* without a parameterized spec, I can't prevent repetitions */

static STATUS hid142(){
PARSER BACKSLASH, IDENTIFIER;
static STATUS p_tok;
P_PAND((TOPARSER BACKSLASH)(),(TOPARSER IDENTIFIER)());
return p_tok;
}
static VOID hid143(){
VV(2)=V(2);getname(&V(2));ADDVAR(V(2));
}
static STATUS hid144(){
PARSER hid142;ACTION hid143;
return p_attach0n(TOPARSER hid142,0,hid143,0);
}
STATUS newvar(){
PARSER hid144;
return((TOPARSER hid144)());
}

/* moresequents is a 1 or more long list of sequents, or an attr decl
 * followed by a 1 or more long list. It is not empty. It is not
 * (presently) a newvar on its own, though it might eventually be */

static STATUS hid145(){
PARSER moresequents;
return p_option0n(TOPARSER moresequents,0);
}
static STATUS hid146(){
PARSER sequent, hid145;
static STATUS p_tok;
P_PAND((TOPARSER sequent)(),(TOPARSER hid145)());
return p_tok;
}
static STATUS hid147(){
PARSER SOMESPACE, hid146;
static STATUS p_tok;
P_PAND((TOPARSER SOMESPACE)(),(TOPARSER hid146)());
return p_tok;
}
static STATUS hid148(){
PARSER newvar, hid147;
static STATUS p_tok;
P_PAND((TOPARSER newvar)(),(TOPARSER hid147)());
return p_tok;
}
static VOID hid149(){
 char *n; VV(4)=V(1);popenv();          GETNEWNAME(&n,plainenv,NULL);V(1)=P_STAR(n,V(1),V(4),V(2));
}
static STATUS hid150(){
PARSER hid148;ACTION hid149;
return p_attach0n(TOPARSER hid148,0,hid149,0);
}
static STATUS hid151(){
PARSER hid150, p_nothing0;
static STATUS p_tok;
P_PAND((TOPARSER hid150)(),(TOPARSER p_nothing0)());
return p_tok;
}
static STATUS hid152(){
PARSER moresequents;
return p_option0n(TOPARSER moresequents,0);
}
static STATUS hid153(){
PARSER sequent, hid152;
static STATUS p_tok;
P_PAND((TOPARSER sequent)(),(TOPARSER hid152)());
return p_tok;
}
static STATUS hid154(){
PARSER SOMESPACE, hid153;
static STATUS p_tok;
P_PAND((TOPARSER SOMESPACE)(),(TOPARSER hid153)());
return p_tok;
}
static STATUS hid155(){
PARSER dummyvar, hid154;
static STATUS p_tok;
P_PAND((TOPARSER dummyvar)(),(TOPARSER hid154)());
return p_tok;
}
static VOID hid156(){
 char *n; VV(4)=V(1);          if (precc_data.oldattributes){popenv();          GETNEWNAME(&n,plainenv,NULL);V(1)=P_STAR(n,V(1),V(4),V(2));}          else{          GETNEWNAME(&n,plainenv,NULL);V(1)=P_AND(n,V(1),V(4));}
}
static STATUS hid157(){
PARSER hid155;ACTION hid156;
return p_attach0n(TOPARSER hid155,0,hid156,0);
}
static STATUS hid158 (){
PARSER hid151, hid157;
static STATUS p_tok;
p_tok = (TOPARSER hid151) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid157) ();
}
STATUS moresequents(){
PARSER hid158;
return((TOPARSER hid158)());
}

/* in the above, have to be careful to avoid allowing a trailing "empty"
   because that wrecks the returned value from an @foo@ */

static VOID hid159(){
/*empty*/ VV(0)=V(1);             if(precc_data.oldattributes){             getname(&V(1));             GETANAME(&V(1),"p_","",count++);             V(1)=GNAME(V(1));putname(V(1));             getname(&V(1));             ADDVAR(V(1)); }
}
static STATUS hid160(){
PARSER p_nothing0;ACTION hid159;
return p_attach0n(TOPARSER p_nothing0,0,hid159,0);
}
STATUS dummyvar(){
PARSER hid160;
return((TOPARSER hid160)());
}
        /* Don't overpull now because ... */

static STATUS hid161(){
PARSER postfix;
return p_option0n(TOPARSER postfix,0);
}
static STATUS hid162(){
PARSER seqoperand, hid161;
static STATUS p_tok;
P_PAND((TOPARSER seqoperand)(),(TOPARSER hid161)());
return p_tok;
}
STATUS sequent(){
PARSER hid162;
return((TOPARSER hid162)());
}

        /* in each of these cases the postfix must behave as though the
        seqoperand were before it and overpull its arguments and write into
        the stack position to the left of itself */

static STATUS hid163 (){
PARSER plusop, hideop;
static STATUS p_tok;
p_tok = (TOPARSER plusop) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hideop) ();
}
static STATUS hid164 (){
PARSER starop, hid163;
static STATUS p_tok;
p_tok = (TOPARSER starop) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid163) ();
}
STATUS postfix(){
PARSER hid164;
return((TOPARSER hid164)());
}

static STATUS hid165(){
PARSER WHITESPACE, CLOSEBRACE;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER CLOSEBRACE)());
return p_tok;
}
static STATUS hid166(){
PARSER expression, hid165;
static STATUS p_tok;
P_PAND((TOPARSER expression)(),(TOPARSER hid165)());
return p_tok;
}
static STATUS hid167(){
PARSER WHITESPACE, hid166;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid166)());
return p_tok;
}
static STATUS hid168(){
PARSER OPENBRACE, hid167;
static STATUS p_tok;
P_PAND((TOPARSER OPENBRACE)(),(TOPARSER hid167)());
return p_tok;
}
static VOID hid169(){
 VV(5) = V(3); 
}
static STATUS hid170(){
PARSER hid168;ACTION hid169;
return p_attach0n(TOPARSER hid168,0,hid169,0);
}
STATUS bracket(){
PARSER hid170;
return((TOPARSER hid170)());
}

static STATUS hid171(){
PARSER WHITESPACE, CLOSEBRACKET;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER CLOSEBRACKET)());
return p_tok;
}
static STATUS hid172(){
PARSER expression, hid171;
static STATUS p_tok;
P_PAND((TOPARSER expression)(),(TOPARSER hid171)());
return p_tok;
}
static STATUS hid173(){
PARSER WHITESPACE, hid172;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid172)());
return p_tok;
}
static STATUS hid174(){
PARSER OPENBRACKET, hid173;
static STATUS p_tok;
P_PAND((TOPARSER OPENBRACKET)(),(TOPARSER hid173)());
return p_tok;
}
static VOID hid175(){
 char *n;VV(5)=(GETNEWNAME(&n,plainenv,NULL),P_OPT(n,V(3))); 
}
static STATUS hid176(){
PARSER hid174;ACTION hid175;
return p_attach0n(TOPARSER hid174,0,hid175,0);
}
STATUS option(){
PARSER hid176;
return((TOPARSER hid176)());
}

static VOID hid177(){
 VV(0)= "p_nothing0"; 
}
static STATUS hid178(){
PARSER p_nothing0;ACTION hid177;
return p_attach0n(TOPARSER p_nothing0,0,hid177,0);
}
STATUS empty(){
PARSER hid178;
return((TOPARSER hid178)());
}


static STATUS hid179(){
PARSER WHITESPACE, AT;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER AT)());
return p_tok;
}
static STATUS hid180(){
PARSER expr, hid179;
static STATUS p_tok;
P_PAND((TOPARSER expr)(),(TOPARSER hid179)());
return p_tok;
}
static STATUS hid181(){
PARSER WHITESPACE, hid180;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid180)());
return p_tok;
}
static STATUS hid182(){
PARSER AT, hid181;
static STATUS p_tok;
P_PAND((TOPARSER AT)(),(TOPARSER hid181)());
return p_tok;
}
static VOID hid183(){
char *n; VV(5)=(getname(&V(3)),                  GETNEWNAME(&n,plainenv,NULL),P_ATA(n,V(3))); 
}
static STATUS hid184(){
PARSER hid182;ACTION hid183;
return p_attach0n(TOPARSER hid182,0,hid183,0);
}
STATUS result(){
PARSER hid184;
return((TOPARSER hid184)());
}

                /* here is one overpull */

int starflag=0;
char *starqual;

static VOID hid185(){
starflag=1;VV(2)=(getname(&V(2)),V(2));
}
static STATUS hid186(){
PARSER expr;ACTION hid185;
return p_attach0n(TOPARSER expr,0,hid185,0);
}
static STATUS hid187(){
PARSER hid186;
return p_option0n(TOPARSER hid186,0);
}
static STATUS hid188(){
PARSER STAR, hid187;
static STATUS p_tok;
P_PAND((TOPARSER STAR)(),(TOPARSER hid187)());
return p_tok;
}
static VOID hid189(){
 char *n;if(starflag){                  VV(2)=(GETNEWNAME(&n,plainenv,NULL),P_ITR(n,V(1),V(3)));                   }  else {                  VV(2)=(GETNEWNAME(&n,plainenv,NULL),P_INF(n,V(1)));                  }  starflag=0; 
}
static STATUS hid190(){
PARSER hid188;ACTION hid189;
return p_attach0n(TOPARSER hid188,0,hid189,0);
}
STATUS starop(){
PARSER hid190;
return((TOPARSER hid190)());
}

static VOID hid191(){
 VV(1)="p_anything0"; 
}
static STATUS hid192(){
PARSER QUESTION;ACTION hid191;
return p_attach0n(TOPARSER QUESTION,0,hid191,0);
}
STATUS anymatch(){
PARSER hid192;
return((TOPARSER hid192)());
}

/* recall that exprnames get saved in the cbuff */

static STATUS hid193 (){
PARSER plingmatch, exprname;
static STATUS p_tok;
p_tok = (TOPARSER plingmatch) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER exprname) ();
}
static STATUS hid194 (){
PARSER plingexpr, hid193;
static STATUS p_tok;
p_tok = (TOPARSER plingexpr) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid193) ();
}
static STATUS hid195 (){
PARSER finishmatch, hid194;
static STATUS p_tok;
p_tok = (TOPARSER finishmatch) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid194) ();
}
static STATUS hid196 (){
PARSER dollarplingmatch, hid195;
static STATUS p_tok;
p_tok = (TOPARSER dollarplingmatch) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid195) ();
}
static STATUS hid197 (){
PARSER eofmatch, hid196;
static STATUS p_tok;
p_tok = (TOPARSER eofmatch) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid196) ();
}
static STATUS hid198 (){
PARSER beginmatch, hid197;
static STATUS p_tok;
p_tok = (TOPARSER beginmatch) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid197) ();
}
static STATUS hid199 (){
PARSER anymatch, hid198;
static STATUS p_tok;
p_tok = (TOPARSER anymatch) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid198) ();
}
static STATUS hid200 (){
PARSER untilmatch, hid199;
static STATUS p_tok;
p_tok = (TOPARSER untilmatch) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid199) ();
}
static STATUS hid201 (){
PARSER result, hid200;
static STATUS p_tok;
p_tok = (TOPARSER result) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid200) ();
}
static STATUS hid202 (){
PARSER phantom, hid201;
static STATUS p_tok;
p_tok = (TOPARSER phantom) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid201) ();
}
static STATUS hid203 (){
PARSER test, hid202;
static STATUS p_tok;
p_tok = (TOPARSER test) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid202) ();
}
static STATUS hid204 (){
PARSER range, hid203;
static STATUS p_tok;
p_tok = (TOPARSER range) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid203) ();
}
static STATUS hid205 (){
PARSER antiliteral, hid204;
static STATUS p_tok;
p_tok = (TOPARSER antiliteral) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid204) ();
}
static STATUS hid206 (){
PARSER literal, hid205;
static STATUS p_tok;
p_tok = (TOPARSER literal) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid205) ();
}
static STATUS hid207 (){
PARSER option, hid206;
static STATUS p_tok;
p_tok = (TOPARSER option) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid206) ();
}
static STATUS hid208 (){
PARSER bracket, hid207;
static STATUS p_tok;
p_tok = (TOPARSER bracket) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid207) ();
}
STATUS seqoperand(){
PARSER hid208;
return((TOPARSER hid208)());
}

static STATUS hid209(){
PARSER PLING, bracket;
static STATUS p_tok;
P_PAND((TOPARSER PLING)(),(TOPARSER bracket)());
return p_tok;
}
static VOID hid210(){
 char *n;   VV(2)=(GETNEWNAME(&n,plainenv,NULL),P_ERR(n,V(2))); 
}
static STATUS hid211(){
PARSER hid209;ACTION hid210;
return p_attach0n(TOPARSER hid209,0,hid210,0);
}
STATUS plingexpr(){
PARSER hid211;
return((TOPARSER hid211)());
}

static STATUS hid212(){
PARSER WHITESPACE, OPENBRACKET;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER OPENBRACKET)());
return p_tok;
}
static STATUS hid213(){
PARSER expression, hid212;
static STATUS p_tok;
P_PAND((TOPARSER expression)(),(TOPARSER hid212)());
return p_tok;
}
static STATUS hid214(){
PARSER WHITESPACE, hid213;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER hid213)());
return p_tok;
}
static STATUS hid215(){
PARSER CLOSEBRACKET, hid214;
static STATUS p_tok;
P_PAND((TOPARSER CLOSEBRACKET)(),(TOPARSER hid214)());
return p_tok;
}
static VOID hid216(){
char *n;VV(5)=(GETNEWNAME(&n,plainenv,NULL),P_PHA(n,V(3))); 
}
static STATUS hid217(){
PARSER hid215;ACTION hid216;
return p_attach0n(TOPARSER hid215,0,hid216,0);
}
STATUS phantom(){
PARSER hid217;
return((TOPARSER hid217)());
}

/* a literal is anything inside angle brackets.
 * an antiliteral is anything inside anti angle brackets.
 * anglebrackets inside may be escaped to protect them
 */

static VOID hid218(){
 VV(1) = putchar(T(1)); 
}
static STATUS hid219(){
PARSER NOTARIGHTANGLEBRACKET;ACTION hid218;
return p_attach0n(TOPARSER NOTARIGHTANGLEBRACKET,0,hid218,0);
}
static STATUS hid220 (){
PARSER COMMENT, hid219;
static STATUS p_tok;
p_tok = (TOPARSER COMMENT) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid219) ();
}
static STATUS hid221 (){
PARSER CHARCONST, hid220;
static STATUS p_tok;
p_tok = (TOPARSER CHARCONST) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid220) ();
}
static STATUS hid222 (){
PARSER STRING, hid221;
static STATUS p_tok;
p_tok = (TOPARSER STRING) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid221) ();
}
STATUS lstuff(){
PARSER hid222;
return((TOPARSER hid222)());
}

static VOID hid223(){
 VV(1) = putchar(T(1)); 
}
static STATUS hid224(){
PARSER NOTALEFTANGLEBRACKET;ACTION hid223;
return p_attach0n(TOPARSER NOTALEFTANGLEBRACKET,0,hid223,0);
}
static STATUS hid225 (){
PARSER COMMENT, hid224;
static STATUS p_tok;
p_tok = (TOPARSER COMMENT) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid224) ();
}
static STATUS hid226 (){
PARSER CHARCONST, hid225;
static STATUS p_tok;
p_tok = (TOPARSER CHARCONST) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid225) ();
}
static STATUS hid227 (){
PARSER STRING, hid226;
static STATUS p_tok;
p_tok = (TOPARSER STRING) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid226) ();
}
STATUS alstuff(){
PARSER hid227;
return((TOPARSER hid227)());
}

static VOID hid228(){
 VV(2) = V(1); 
}
static STATUS hid229(){
PARSER lstuff;ACTION hid228;
return p_attach0n(TOPARSER lstuff,0,hid228,0);
}
static STATUS hid230(){
PARSER hid229;
return p_many0n(TOPARSER hid229,0);
}
static STATUS hid231(){
PARSER lstuff, hid230;
static STATUS p_tok;
P_PAND((TOPARSER lstuff)(),(TOPARSER hid230)());
return p_tok;
}
static VOID hid232(){
 VV(0)=""; 
}
static STATUS hid233(){
PARSER p_nothing0;ACTION hid232;
return p_attach0n(TOPARSER p_nothing0,0,hid232,0);
}
static STATUS hid234 (){
PARSER hid231, hid233;
static STATUS p_tok;
p_tok = (TOPARSER hid231) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid233) ();
}
STATUS lstuffs(){
PARSER hid234;
return((TOPARSER hid234)());
}

/* close the accumulator for lstuffs */

static VOID hid235(){
VV(1)=V(1);getname(&V(1));
}
static STATUS hid236(){
PARSER lstuffs;ACTION hid235;
return p_attach0n(TOPARSER lstuffs,0,hid235,0);
}
STATUS lits(){
PARSER hid236;
return((TOPARSER hid236)());
}

static VOID hid237(){
 VV(2) = V(1); 
}
static STATUS hid238(){
PARSER alstuff;ACTION hid237;
return p_attach0n(TOPARSER alstuff,0,hid237,0);
}
static STATUS hid239(){
PARSER hid238;
return p_many0n(TOPARSER hid238,0);
}
static STATUS hid240(){
PARSER alstuff, hid239;
static STATUS p_tok;
P_PAND((TOPARSER alstuff)(),(TOPARSER hid239)());
return p_tok;
}
static VOID hid241(){
 VV(0)=""; 
}
static STATUS hid242(){
PARSER p_nothing0;ACTION hid241;
return p_attach0n(TOPARSER p_nothing0,0,hid241,0);
}
static STATUS hid243 (){
PARSER hid240, hid242;
static STATUS p_tok;
p_tok = (TOPARSER hid240) ();
return (GOODSTATUS(p_tok))?p_tok:(TOPARSER hid242) ();
}
STATUS alstuffs(){
PARSER hid243;
return((TOPARSER hid243)());
}

/* close the accumulator for alstuffs */

static VOID hid244(){
VV(1)=V(1);getname(&V(1));
}
static STATUS hid245(){
PARSER alstuffs;ACTION hid244;
return p_attach0n(TOPARSER alstuffs,0,hid244,0);
}
STATUS alits(){
PARSER hid245;
return((TOPARSER hid245)());
}

static STATUS hid246(){
PARSER lits, RIGHTANGLEBRACKET;
static STATUS p_tok;
P_PAND((TOPARSER lits)(),(TOPARSER RIGHTANGLEBRACKET)());
return p_tok;
}
static STATUS hid247(){
PARSER LEFTANGLEBRACKET, hid246;
static STATUS p_tok;
P_PAND((TOPARSER LEFTANGLEBRACKET)(),(TOPARSER hid246)());
return p_tok;
}
static VOID hid248(){
 VV(3) = V(2); 
}
static STATUS hid249(){
PARSER hid247;ACTION hid248;
return p_attach0n(TOPARSER hid247,0,hid248,0);
}
STATUS LITERAL(){
PARSER hid249;
return((TOPARSER hid249)());
}

static STATUS hid250(){
PARSER alits, LEFTANGLEBRACKET;
static STATUS p_tok;
P_PAND((TOPARSER alits)(),(TOPARSER LEFTANGLEBRACKET)());
return p_tok;
}
static STATUS hid251(){
PARSER RIGHTANGLEBRACKET, hid250;
static STATUS p_tok;
P_PAND((TOPARSER RIGHTANGLEBRACKET)(),(TOPARSER hid250)());
return p_tok;
}
static VOID hid252(){
 VV(3) = V(2) ; 
}
static STATUS hid253(){
PARSER hid251;ACTION hid252;
return p_attach0n(TOPARSER hid251,0,hid252,0);
}
static STATUS hid254(){
PARSER hid253, p_nothing0;
static STATUS p_tok;
P_PAND((TOPARSER hid253)(),(TOPARSER p_nothing0)());
return p_tok;
}
STATUS ANTILITERAL(){
PARSER hid254;
return((TOPARSER hid254)());
}


static VOID hid255(){
char *n;VV(1)=(GETNEWNAME(&n,plainenv,NULL),P_LIT(n,V(1))); 
}
static STATUS hid256(){
PARSER LITERAL;ACTION hid255;
return p_attach0n(TOPARSER LITERAL,0,hid255,0);
}
STATUS literal(){
PARSER hid256;
return((TOPARSER hid256)());
}

static VOID hid257(){
char *n;VV(1)=(GETNEWNAME(&n,plainenv,NULL),P_ALI(n,V(1))); 
}
static STATUS hid258(){
PARSER ANTILITERAL;ACTION hid257;
return p_attach0n(TOPARSER ANTILITERAL,0,hid257,0);
}
STATUS antiliteral(){
PARSER hid258;
return((TOPARSER hid258)());
}

static STATUS hid259(){
PARSER expr, CLOSEPAREN;
static STATUS p_tok;
P_PAND((TOPARSER expr)(),(TOPARSER CLOSEPAREN)());
return p_tok;
}
static STATUS hid260(){
PARSER OPENPAREN, hid259;
static STATUS p_tok;
P_PAND((TOPARSER OPENPAREN)(),(TOPARSER hid259)());
return p_tok;
}
static VOID hid261(){
char *n;VV(3)=(getname(&V(2)),GETNEWNAME(&n,plainenv,NULL),P_RAN(n,V(2)));
}
static STATUS hid262(){
PARSER hid260;ACTION hid261;
return p_attach0n(TOPARSER hid260,0,hid261,0);
}
STATUS range(){
PARSER hid262;
return((TOPARSER hid262)());
}

static STATUS hid263(){
PARSER expr, OPENPAREN;
static STATUS p_tok;
P_PAND((TOPARSER expr)(),(TOPARSER OPENPAREN)());
return p_tok;
}
static STATUS hid264(){
PARSER CLOSEPAREN, hid263;
static STATUS p_tok;
P_PAND((TOPARSER CLOSEPAREN)(),(TOPARSER hid263)());
return p_tok;
}
static VOID hid265(){
char *n;VV(3)=(getname(&V(2)),GETNEWNAME(&n,plainenv,NULL),P_TST(n,V(2)));
}
static STATUS hid266(){
PARSER hid264;ACTION hid265;
return p_attach0n(TOPARSER hid264,0,hid265,0);
}
STATUS test(){
PARSER hid266;
return((TOPARSER hid266)());
}

static VOID hid267(){
 VV(1)="p_first0"; 
}
static STATUS hid268(){
PARSER CARET;ACTION hid267;
return p_attach0n(TOPARSER CARET,0,hid267,0);
}
STATUS beginmatch(){
PARSER hid268;
return((TOPARSER hid268)());
}

static VOID hid269(){
 VV(1)="p_last0"; 
}
static STATUS hid270(){
PARSER DOLLAR;ACTION hid269;
return p_attach0n(TOPARSER DOLLAR,0,hid269,0);
}
STATUS finishmatch(){
PARSER hid270;
return((TOPARSER hid270)());
}

static VOID hid271(){
 VV(1)="p_uniq0"; 
}
static STATUS hid272(){
PARSER PLING;ACTION hid271;
return p_attach0n(TOPARSER PLING,0,hid271,0);
}
STATUS plingmatch(){
PARSER hid272;
return((TOPARSER hid272)());
}

static STATUS hid273(){
PARSER DOLLAR, PLING;
static STATUS p_tok;
P_PAND((TOPARSER DOLLAR)(),(TOPARSER PLING)());
return p_tok;
}
static VOID hid274(){
 VV(2)="p_lastuniq0"; 
}
static STATUS hid275(){
PARSER hid273;ACTION hid274;
return p_attach0n(TOPARSER hid273,0,hid274,0);
}
STATUS dollarplingmatch(){
PARSER hid275;
return((TOPARSER hid275)());
}

static STATUS hid276(){
PARSER DOLLAR, DOLLAR;
static STATUS p_tok;
P_PAND((TOPARSER DOLLAR)(),(TOPARSER DOLLAR)());
return p_tok;
}
static VOID hid277(){
 VV(2)="p_eof0"; 
}
static STATUS hid278(){
PARSER hid276;ACTION hid277;
return p_attach0n(TOPARSER hid276,0,hid277,0);
}
STATUS eofmatch(){
PARSER hid278;
return((TOPARSER hid278)());
}

                /* another overpull */

static VOID hid279(){
 char *n;VV(2)=(GETNEWNAME(&n,plainenv,NULL),P_SOM(n,V(1))); 
}
static STATUS hid280(){
PARSER PLUS;ACTION hid279;
return p_attach0n(TOPARSER PLUS,0,hid279,0);
}
STATUS plusop(){
PARSER hid280;
return((TOPARSER hid280)());
}

static STATUS hid281(){
PARSER expr, CLOSEPAREN;
static STATUS p_tok;
P_PAND((TOPARSER expr)(),(TOPARSER CLOSEPAREN)());
return p_tok;
}
static STATUS hid282(){
PARSER OPENPAREN, hid281;
static STATUS p_tok;
P_PAND((TOPARSER OPENPAREN)(),(TOPARSER hid281)());
return p_tok;
}
static STATUS hid283(){
PARSER SLASH, hid282;
static STATUS p_tok;
P_PAND((TOPARSER SLASH)(),(TOPARSER hid282)());
return p_tok;
}
static VOID hid284(){
char *n;   VV(5)=(getname(&V(4)),GETNEWNAME(&n,plainenv,NULL),P_HID(n,V(1),V(4)));
}
static STATUS hid285(){
PARSER hid283;ACTION hid284;
return p_attach0n(TOPARSER hid283,0,hid284,0);
}
STATUS hideop(){
PARSER hid285;
return((TOPARSER hid285)());
}

static STATUS hid286(){
PARSER WHITESPACE, seqoperand;
static STATUS p_tok;
P_PAND((TOPARSER WHITESPACE)(),(TOPARSER seqoperand)());
return p_tok;
}
static STATUS hid287(){
PARSER ELLIPSIS, hid286;
static STATUS p_tok;
P_PAND((TOPARSER ELLIPSIS)(),(TOPARSER hid286)());
return p_tok;
}
static VOID hid288(){
 char *n;VV(3)=(GETNEWNAME(&n,plainenv,NULL),P_UNT(n,V(3))); 
}
static STATUS hid289(){
PARSER hid287;ACTION hid288;
return p_attach0n(TOPARSER hid287,0,hid288,0);
}
STATUS untilmatch(){
PARSER hid289;
return((TOPARSER hid289)());
}


                /* ------- finis -------- */

MAIN(line)










