/* PRECC library
 *
 *This file contains functions which precc requires to build ITSELF and
 *cannot be generated from the precc code in precc*.y (except as drop
 *through inclusions).
 *
 *These routines should not be required for other compilations
 *(the cc.c routines in the kernel suffice).
 *
 */

# include "preamble.h"

# undef UNSETNAME

/* startup functions */
void usage(int n)
{

    switch (n){
    case 1: fprintf(stderr,"mixed swiches and files\n");
            break;
    case 2: fprintf(stderr,"error opening %s for writing\n",p_outfile);
            break;
    case 3: fprintf(stderr,"unknown option\n");
            break;
    case 4: fprintf(stderr,"bad numerical option\n");
            break;
    case 5: fprintf(stderr,"error opening %s for reading\n",p_infile);
            break;
    }

    fprintf(stderr,"usage %s [options] [infile [outfile]]\n",p_argv[0]);
    fprintf(stderr,"options : -r<read buffer size in kb>      (%d)\n",
      (int)(precc_data.readbuffersize*(sizeof (TOKEN) + sizeof (VALUE))/1024));
    fprintf(stderr,"          -p<program buffer size in kb>   (%d)\n",
      (int)(precc_data.maxprogramsize*sizeof(VALUE)/1024));
    fprintf(stderr,"          -v<attribute buffer size in kb> (%d)\n",
      (int)(precc_data.stacksize*sizeof(STACKVALUE)/1024));
    fprintf(stderr,"          -f<context buffer size in kb>   (%d)\n",
      (int)(precc_data.contextstacksize*sizeof(FRAME)/1024));
    fprintf(stderr,"          -old                       (not set)\n");
    p_exit (n);
}

int getkintarg(char *s,int *t,size_t n)
/* read a number in kbytes and translate it to calloc units */
{
    if (1 != sscanf(s,"%u",t))
        usage(4);
    *t *= 1000; /* kbytes */
    *t /= n;    /* the unit size */
    return 0;
}


/* agents are buffers, safe places to put characters to be able to refer back to
   them later. One can 

   Concatenate a word to a buffer
   and close off the slot:            nputagent(A,word);getagent(A,&place)

   Concatenate a char to a buffer
   and close off the slot:          putagent(A,char);getagent(A,&place)

   Initialize the buffer:           initagent(A,buffer)

   Reset the buffer, old data is
   now unsafe:                      resetagent(A)
*/

CHAR cbuff[CBUFFSIZE];                    /* read buffer*/
AGENT chars = {cbuff,cbuff,cbuff};        /* read agent */
CHAR nbuff[NBUFFSIZE];                    /* name buffer*/
AGENT namE  = {nbuff,nbuff,nbuff};        /* name agent */
static CHAR abuff[NBUFFSIZE];             /* args buffer*/
AGENT args  = {abuff,abuff,abuff};        /* args agent */
static CHAR kbuff[NBUFFSIZE];             /* keys buffer*/
AGENT keys  = {kbuff,kbuff,kbuff};        /* keys agent */
static CHAR mbuff[NBUFFSIZE];             /* keys buffer*/
AGENT meta  = {mbuff,mbuff,mbuff};        /* meta agent */

void resetall ()
{
  CHARS resetagent();

  resetagent(&chars);
  resetagent(&namE);
  resetagent(&args);
  resetagent(&meta);
  resetagent(&keys);
}


/* methods on agents */
VOID initagent(AGENT *x,CHARS y){
x->buffer=y;
x->in=y;
x->out=y;
*y=0;
}

CHARS putagent(AGENT *x,char y){
*x->in++=y;                /* move the in pointer on one place */
*x->in=0;
return(x->in-1);
}

CHARS nputagent(AGENT *x,CHARS y){
*(x->in= p_scpy(x->in,y))=0;
return(x->out);            /* the current out-pointer is returned */
}                          /* which points to the start of the current word */

CHARS getagent(AGENT *x,CHARS *y){
*x->in++=0;                /* finish the current in word */
*y=x->out;                 /* report the out pointer */
*x->in=0;                  /* zero next word */
return(x->out=x->in);      /* set the out pointer to next incoming word */
}

CHARS resetagent(AGENT *x){
*x->buffer=0;              /* zero first word */
return(x->out=x->in=x->buffer);
}

/* in particular */

CHARS myputchar(char c){
return(putagent(&chars,c));
}

CHARS getname(CHARS *x){
return(getagent(&chars,x));
}

CHARS putname(CHARS x){
return(nputagent(&chars,(x)));
}

CHARS putint(int x){
static char shortbuf[32];
sprintf(shortbuf,"%d",x);
return(putname(shortbuf));
}

CHARS putargs(CHARS x){
return(nputagent(&args,x));
}

CHARS getargs(CHARS *x){
return(getagent(&args,x));
}

CHARS putmeta(CHARS x){
return(nputagent(&meta,x));
}

CHARS getmeta(CHARS *x){
return(getagent(&meta,x));
}


CHARS putkeys(CHARS x){
return(nputagent(&keys,x));
}

CHARS getkeys(CHARS *x){
return(getagent(&keys,x));
}



/* end of methods on agents */


# include <ctype.h>
 

        /* these are here to do char-int argument conversions */

BOOLEAN p_isalpha(c)
char c;
{
        return(isalpha((int)c) || (c=='_'));
}
 
BOOLEAN p_isdigit(c)
char c;
{
        return(isdigit((int)c));
}

BOOLEAN p_isspace(c)
char c;
{
        return((c==' ') || (c== *"\t"));
}

BOOLEAN p_isalnum(c)
char c;
{
        return(isalnum((int)c) || (c=='_'));
}

        /* this returns the address of the LAST char copied */
 
char *p_scpy(char *x,char *y)
{
        while((*x++ = *y++) != 0);
        return(&x[-1]);
}

int yytchar;
int yylen;
CHARS yylloc; /* this is the address of the LAST token
               * I returned from the readahead buffer, if it's not NULL,
               * which means the buffer is empty. */
int  yylineno;/* I need to supply this for precc */
VALUE yylval; /* ditto */

 
int yylex()
/*
 * Read ahead lines into yybuffer until EOL,
 * but ignore escaped End-Of-Lines (either escaped by
 * trailing `\' or by `@' at beginning of next line after this line began
 * with one.
 *
 * Dole out characters one at a time.
 *
 * Return 0!=TOKEN for a good read and 0=FAILURE when an EOF is encountered.
 */
{         

    int n;
    CHARS buff = yybuffer;
    static int atsignalled, linecount;
    static char c; extern int yytchar; extern int yylen;
    static int nbuff;

         /* gets returns nonzero EITHER if given ^^Z OR on the next
            call after a ^foo^Z - which is all OK for nonzero=EOF
          */

    if(NULL!=yylloc) {

        if (nbuff>0) {/* we can use a token we read ahead for */
            yylen=1;
            nbuff--;
            return(yytchar=(int)(yylval=(VALUE)(int) *++yylloc));
        }

         /* otherwise we ask for more TOKENS next time and return the EOL
            (0) now and it'll be used to terminate a string. */

        yylloc=NULL;
        yylen=0;    
        nbuff=0;
        return (yytchar=(int)(yylval=(VALUE)0));
        
    }


    /*if(NULL==yylloc){*/   /* we have to load the readahead buff  */
    
        yylloc=buff-1;      /* we will return a token at *buff ... */
        *buff=yytchar=0;    /* ... but we start clean              */
        nbuff=0;            /* length of readahead buffer          */
        atsignalled=0;      /* we're not in an @ sequence yet      */
        linecount=0;        /* we've read no sequence of lines yet */

        /* and carry on */

    
        /* we're here because the readahead buffer was empty and so
           the initialization conditions hold: yylloc=buff-1, etc. */

        while (gets((char*)buff)!=NULL) { 

          yylineno++;
          linecount++;

          n = (int)strlen((char*)buff);  /* count the booty */
          nbuff+=n;         /* keep count of the buffer contents */

          if (n==0) {       /* we got a linefeed only  and it's time to start
                             * feeding out stuff from the buffer */
            
          if (nbuff>0){
                 yylen=1;
                 nbuff--;
                 return(yytchar=(int)(yylval=(VALUE)(int) *++yylloc));
          }
                
                             /* here we've got no tokens, now or before */
          yylen=0;        
          yylloc=NULL;       /* signal to read ahead again next time round */
          return (yytchar=(int)(yylval=(VALUE)0));   /* return the 0 string
                              * terminator */
        }


        /* we're here with nbuff>0 already, and with n>0 */

                             /* check to see if this is an @ seq start */

        if ((linecount==1) && (*buff=='@'))
          atsignalled=1;

                             /* if it is, allow escaped linefeeds */

        if (atsignalled && (buff[n-1]=='\\')){
                             /* escaped newline, so .. 
                              * .. chop off the escape and .. */
          buff += --n;       /* .. we go round again */

          nbuff--;           /* we knock off one from our buffer count */
          continue;
        }

        if (!atsignalled) {
                              /* ordinary token return. just ... 
                               * ... crank our buffer */
            nbuff--;          /* remember that nbuff>0 so this is OK */
            yylen=0;

            return (yytchar=(int)(yylval=(VALUE)(int) *++yylloc));

         }

              /* we're here because we're in an @ sequence without an
                 escaped linefeed */

          switch (c=getchar()){
            default:          /* we peeked at the next line ... */
                              /* and it didn't start with @, so ... */
              ungetc((int)c,stdin);
                              /* we finished the readahead, and ... */
                              /* can start unloading tokens */
              nbuff--;        /* remember that nbuff>0 so this is OK */
              yylen=1;

              return (yytchar=(int)(yylval=(VALUE)(int) *++yylloc));        

            case '@':          /* or it did start @, so eat the '@' --
                                * now it won't be seen next time */
                        
              buff += n;
              continue;   /* and go round again */
          }

        } /* endwhile*/

        /*  we're here because gets() failed */

        yytchar=EOF;                          /*  EOF encountered */
        yylloc=NULL;          /* signal that readahead buffer is empty */
        yylen=0;
        return ((int)(yylval=(VALUE)0));
}

CHARS GNAME(CHARS x)
/*
        Return "f" from "f(a,b,c)". Return "f" from "f".
        The returned pointer is safe until  UNSETNAME.
*/
{
        static char *a;
        getname(&a);        /* finish off last name */
        a=strchr(x,'(');
        if (a) {
                *a = 0;
                putname(x);
                *a = '(';
                }
        else
                putname(x);
        getname(&x);
        return(x);
}


CHARS findbrkt(a, x, b, s, nargs)
/*
if *x is '(' then find the matching ')' and return its address.
If there is no match, return 0. If *x is not '(', find the
closing bracket which matches the first open bracket encountered.

Also count the 1st level true separators s encountered in nargs.
*/
register char a, b, s;
CHARS x;
int *nargs;
{
        register char c;
        static int n;               /* the level count */
        n=0;

    if(nargs) *nargs=0;

        while(0!=(c=*x++)){
                if(c=='"') {       /* get to the end of the string */
                        while(0!=(c=*x++)) {
                                if(c=='\\') {
                                    if(0!=(c=*x++))
                                        continue;
                                    else
                                        return --x; /* with prejudice */
                                }
                                if(c=='"')
                                        break;
                                /* else keep looking */
                        }
                        /* now x is one beyond the end of the string */
                        continue;  /* now look for a comma */
                }
                else if(c=='\'') {
                        while(0!=(c=*x++)) {
                                if(c=='\\') {
                                     if(0!=(c=*x++))
                                          continue;
                                     else
                                        return --x; /* with prejudice */
                                }
                                if(c=='\'')
                                        break;
                                /* else keep looking */
                        }
                        /* now x is one beyond the end of the quote */
                        continue;
                }
                else if (c==a) {
                        /* found an open bracket */
                        n++;
                        /* now x is one beyond the end of the quote */
                        continue;
                 }
                else if(c==b) {
                        if(--n<0)
                            return --x;    /* bad news */
                }
                else if(c==s) {
                        /* found a seperator */
                        if(n==0)
                             if(nargs) (*nargs)++;
                        /* now x is one beyond the seperator */
                        continue;
                }
                                 
        }

        return(NULL);
}


CHARS GARGS(CHARS x)
/*
        Return "a,b,c" from "f(a,b,c)". Return "" from "f".
        The returned pointer is safe until  UNSETNAME.
*/
{
        static CHARS a, b; static int nargs;

        getname(&a);                /* finish off the last word */
        a=strchr(x,'(');
        if (a) {
                b = findbrkt('(',++a,')',',',&nargs);
                if (b)  {
                        *b=0;
                        putname(a);
                        *b = ')';
                        }
                /* else
                        putname(a); */
                }
        getname(&x);
        return(x);
}

CHARS CATFUNCARGS(CHARS x)
/*
        Turn "f(a,b,c,d)" into "f,4,a,b,c,d". Turn "f" into "f,0".
        The returned pointer is safe until  UNSETNAME.
*/
{
        static CHARS brkt1, brkt2, arg1; static int nargs;
        static char numbuff[32];

        brkt1=(CHARS)strchr(x,'(');
        if ((int)brkt1!=(int)NULL) {
                *brkt1=0;
                putname(x);  /* write the function name */
                *brkt1='(';
                            

        /* this is where we want to find the corresponding ')'.
           We are sure that we start at a '(', so we can't
           get b=a back again. */

        arg1=brkt1;
        while(0!=*++arg1)
             if((*arg1!=' ')||(*arg1!='\t')) break; 
                brkt2 = findbrkt('(',arg1,')',',',&nargs);
                
                if ((int)brkt2!=(int)NULL)  {/* there is a 2nd bracket */
                        *brkt2=0;
                        if((int)brkt2!=(int)arg1){
                                         /* & it wasn't an empty one */
                                putname(",");
                sprintf(numbuff,"%d",nargs+1); /* (int)%d maybe? */
                putname(numbuff);
                                putname(",");
                                putname(arg1);
                        }
            else                     /* it was empty */
                putname(",0");       /* (int)0 maybe? */
                        *brkt2 = ')';
            
                }
                else                  /* no second bracket!! IMPOSSIBLE */
                            /*putname(brkt1);*/
                putname(",0");       /* (int)0 maybe? */
        }

        else    {            /* there are no args */
                putname(x);
                putname(",0");      /* (int)0 maybe? */
        }

        getname(&x);
        return(x);
}

CHARS UNSETNAME(CHARS x)
/* identity action on x with side-effect of resetting agents */
{
        /*CHARS resetagent();

        resetall();*/
        return(x);
}

VOID GETANAME(CHARS *n, CHARS x, CHARS z, int nid)
/* use list z for vars and write "x<nid>(var1,...,vark)" in n */
{
        static CHARS y;
        static char mybuff[SMALLBUFFERSIZE];

        sprintf(&mybuff[0],"%s%d",x,nid);
        y = putname((CHARS)&mybuff[0]); /* y is the beginning of the cache */

        putname((CHARS)"(");
        y+=strlen(y);                 /* now we're where the args start */
        putname(z);

        putname((CHARS)")");
        getname(n);
}

VOID GETNEWNAME(CHARS *n, CHARS x)
/* use list x for vars and write "newname(var1,...,vark)" in n */
{
 
        static int nid;                                /* new id counter */

        GETANAME(n, "hid", x, nid++);

}
                 

int is_in(CHARS x,CHARS y)
/*
  y should be a comma separated list, with y[-1]='('.
  x is a simple name.
*/
{
        register CHARS z;
        int n;

        n=strlen(x);
        while (1)
        {

        /* look for substring matching x in y */

                z = strstr((char*)y,(char*)x);

                if (z==NULL)

        /* I didn't see any */

                        return(0);

                if ((z==y || z[-1]==',') &&

         /* hmm. Possible. It starts off right.  */

                        (z[n]==0 || z[n]==',' ))

        /* and it ends ok too. Accept the match. */

                        return(1);

        /* No match. Try again. Increase y to next comma position+1 */

                y = strchr((char*)y,',');
                if (y++ == NULL)
                        break;
        }
        return(0);
}

