
# define TOKEN char
# define VALUE char*
# define STACKTOKENS 1
# define STACKSIZE 2048

# include "cc.h"
# include "preccx.h"
# undef UNSETNAME
# include "preamble.h"

/* in order to be able to parse .. = <'>'>   !! */
/*                          or  .. = >'<'<      */
# define RIGHT_ANGLE_BRACKET '>'
# define LEFT_ANGLE_BRACKET '<'
/* and use  .. = <RIGHT_ANGLE_BRACKET> instead */
/* or       .. = >LEFT_ANGLE_BRACKET< */

                /* -------- spaces ---------- */

@ SPACE = (p_isspace)
@       | COMMENT

@ WHITESPACE =  SOMESPACE
@            | : VV(0)=""; :

@ SOMESPACE = SPACE {SPACE : VV(2) = V(1); :}*

                /* -- simple identifiers ------ */

/* read character into the cbuff */
@ alpha     = (p_isalpha)        : VV(1) = putchar(T(1)); :

/* append characters to the cbuff */
@ IDENTIFIER      = alpha { alnum    : VV(2) = V(1); : }*
  
@ digit     = (p_isdigit) : VV(1)=putchar(T(1)); :

@ alnum     = (p_isalnum) : VV(1)=putchar(T(1)); :

/* and these are absorbing */

@ OPENBRACKET  = <'['>

@ CLOSEBRACKET = <']'>

@ OPENPAREN   = <'('>

@ CLOSEPAREN  = <')'> 

@ OPENBRACE   = <'{'>

@ CLOSEBRACE  = <'}'>

@ NUMBER = integer optmantissa optexponent : VV(3) = V(1); :

@ digits = somedigits
@        | : VV(0)=""; :

@ optsign = sign
@         | : VV(0)=""; :

@ somedigits = digit {digit : VV(2) = V(1); :}*

@ sign = {<'-'> | <'+'>} : VV(1)=putchar(T(1)); :

@ mantissa = point [ somedigits : VV(2) = V(1); : ]

@ optmantissa = mantissa
@             | : VV(0)=""; :

@ point = <'.'> : VV(1)=putchar('.'); :

@ E = { <'e'> | <'E'> } : VV(1)=putchar(T(1)); :

@ exponent = E integer : VV(2) = V(1); :

@ optexponent = exponent
@             | : VV(0)=""; :

@ singlequote = <'\''> : VV(1)=putchar('\''); :

@ escape = <'\\'> 

@ ANYTHING = ? 

@ notasinglequote = >'\''< 

@ chr = escape ANYTHING : VV(2)=V(1);putchar('\\');putchar(T(2)); :
@     | notasinglequote : VV(1)=putchar(T(1));:

@ CHARCONST = singlequote chr singlequote : VV(3)=V(1); :

@ STRING = doublequote strchrs doublequote : VV(3)=V(1); :

@ doublequote = <'\"'> : VV(1)=putchar('\"'); :

@ strchar = escape ANYTHING : VV(2) = V(1);putchar('\\');putchar(T(2)); :
@         | notadoublequote : VV(1) = putchar(T(1)); :

@ notadoublequote = >'\"'< 

@ strchrs = strchar {strchar : VV(2)=V(1); :}*
@         | : VV(0)=""; :

@ BACKSLASH = <'\\'>

@ DOLLAR = <'$'>

@ CARET = <'^'>

@ PLING = <'!'>

@ PLUS = <'+'>

@ DOLLARID = <'$'> <'$'> :VV(2)=putname("(TOVALUE p_1)");:
@          | { <'$'> :putname("(TOVALUE )p_");
@                   /*putint((1+getcount())*PSTACKLENGTH/10); */
@                    : } integer :VV(2)=V(2);putchar(')');:
@          | { <'$'> :putname("(TOVALUE ");:} IDENTIFIER :VV(2)=putchar(')');:

@ integer  = optsign somedigits :VV(2)=V(2);:

@BINOPCHAR = { <'+'>
@            | <'-'>
@            | <'*'>
@            | <'/'>
@            | <'%'>
@            | <'&'>
@            | <'|'>
@            | <'!'>
@            | <'='>
@            | <'<'>
@            | <RIGHT_ANGLE_BRACKET>
@            }

@ PLUSPLUS = <'+'> <'+'>

@ MINUSMINUS = <'-'> <'-'>

@ MONOPCHAR= { <'+'>
@            | <'-'>
@            | <'&'> 
@            | <'*'> 
@            | <'!'>
@            }

@ LEFTANGLEBRACKET = <'<'>

@ RIGHTANGLEBRACKET = <RIGHT_ANGLE_BRACKET>

@ NOTARIGHTANGLEBRACKET= escape ANYTHING :VV(2)=V(2);:
@                      | >'>'<

@ NOTALEFTANGLEBRACKET = escape ANYTHING :VV(2)=V(2);:
@                      | >LEFT_ANGLE_BRACKET<

@ SLASH = <'/'>

@ STAR = <'*'>

@ AT = <'@'>

@ EQUALS = <'='>

@ NOTANAT = >'@'< 

@ OR = <'|'>

@ COLON = <':'>

@ COLONorEOL =  COLON
@            | $

@ COMMA = <','>

@ NOTACOLON = escape ANYTHING :VV(2)=V(2);:
@           | >':'<

@ QUESTION = <'?'>

@ slashstar= SLASH STAR :VV(2)=putname("/*");:

@ starslash= STAR SLASH :VV(2)=putname("*/");:

@ COMMENT  = slashstar
@            { commentchr :VV(2)=V(1);: }*
@            starslash :VV(2)=V(1);:

/* $!{foo} ought to try and recover at foo */

@ commentchr = NOTASTAR       : VV(1) = putchar(T(1));:
@            | $!             : VV(1) = putchar('\n');:
@            | STAR NOTASLASH : VV(2) = (putchar('*'),putchar(T(2)));:

@ NOTASTAR = >'*'<

@ NOTASLASH = >'/'<

@ SEMICOLON = <';'>

@ ELLIPSIS  = <'.'> <'.'> <'.'> : VV(3) = V(1);:



/*   finis   */


