
/*
   parser suite - and / or / nothing / something  parsers

   parser = [token] -> ([token],status)
    
   implemented as sideeffecting on [token], returns status.
*/


# include "cc.h"

STATUS  p_andparse (p, q, o)
PARSER *p, *q;
ACTION *o;
{
    status tok;

    tok = p_andparse0 (p, q);
    if (GOODSTATUS(tok))
        pushACTION(o);
    return tok;
}


STATUS   p_nothing0 ()
/*
p_parser succeeds without looking at any tokens from
the input stream.
*/
{

    pushINCR;

    return SUCCESS;
}

STATUS   p_nothing (k)
ACTION *k;
{
    PARSER p_nothing0;

    return p_attach(p_nothing0,k);
}


STATUS   p_anything0 ()
/*
Parser which takes any token at all - except 0 - and places it as
a constant on the program stack.  This p_parser only fails at EOS.
*/
{
    TOKEN c;
    VALUE v;

        c = *pstr;
        v = lvbuff[(int)(pstr-buffer)];
        if (c)
        {
           MOVEON;
        pushVALUE(v);
        return OK(v);    /* so CAN'T use attribute 0 */
        }
        return FAILURE;
}

STATUS  p_anything (k)
ACTION *k;
{
    PARSER p_anything;

    return p_attach (p_anything0,k);
}

STATUS   p_first0 ()
/*
This p_parser only succeeds at BOS and does nothing
*/
{    /* pstr CAN'T be < buffer. I am just being careful */
    if ((void*)pstr <= (void*)buffer || pstr[-1]==(TOKEN)0) {
        pushVALUE(SUCCESS);
        return SUCCESS;
        }
    /* doesnt move on */
    return FAILURE;
}

STATUS   p_first (k)
ACTION *k;
{
    PARSER p_first0;

    return p_attach(p_first0,k);
}

STATUS  p_eof0 ()
{
    if (yytchar==EOF) {
       pushVALUE(SUCCESS);
       return SUCCESS;
    }
    return FAILURE;
}

STATUS  p_uerror0  (p)  
/* return OK but set a frame boundary and an error handler parser p */
PARSER *p;
{
        pushEXIT;

        pc=0;
        pc=p_evaluate ();
        pc=0;   /* we have to write the next program in the right place */

        /* we can't reset the pstr at present. Only when we get a backtrack
           can we seem to be able to do it, perhaps because that's like an escape to top level, where
           we do reset the pstr every time. The problem is MAYBE that earlier
           sequents are holding frame info which points into the pstr as
           it is now. OK, we can't backtrack to them, but still ...
           -- hmm. this may be past history now.
         */


        /* why am I looking to skip the 0 token here? Surely it is
         * just like any other token?
         */

        if (yytchar!=EOF &&  0==*pstr)  /* then we can ask for more */
        /* we are at the end of what we have read so far with pstr=maxp,
           I think ... BUT this case is never reached, it seems! */
            /*getatoken(buffer,lvbuff)==0 */ /* not EOF */
        {   /*isn't this a MOVEON ?*/
            /* if(getatoken(buffer,lvbuff)==0)*/ /* not an EOF */
            /* skip the 0 token */

            if (get1token() != EOF)
            {
                /* now we restart */
                realignbuffer();
            }

        }
        /* it beats me why this causes crashes, but it XdoesX Used To! */
# define DUMPACORE
# ifdef DUMPACORE
        else
        /* theres an ordinary token up ahead. Lets' play with it. */
        {
                realignbuffer();
        }
# endif
        passcount++;  /* that means that a backtrack error will be
                         signalled if we try and backtrack through here */

        p_enargs= 0;
        p_entry = p;  /* set the btck_error reentry pt */

        /* Uh, not at all sure about the next, folks! - we won't backtrack
         * but we are still inside various andparse things that will all
         * try and pop the frame stack as they exit!!
         */
# ifdef DUMPCOREFORSURE
        fptr = fstack+1; /* reset the frame pointer - we won't backtrack */
# endif

        return (SUCCESS);

   /* and don't reset STACKVALUE *value because we may later backtrack
    * to earlier stack values  - hey, that's past history now too!
    * We don't have an attribute stack any more. */
}

STATUS  p_uniq0  ()
{
    return p_uerror0(0);
}


STATUS  p_lastuniq0  ()
{
    if (yytchar==EOF) /* we saw EOF already so don't try again */
        return FAILURE;

    /* the problem here is that we want to execute what we have
     * before pulling more characters so we can't call p_last0(),
     * which pulls, before p_uniq, which executes. So we just
     * have to duplicate the p_uniq0 code early.
     */

    if (0 == *pstr)   /* we're in the right place to try & move on  */
    {
        pushEXIT;    /* remember to execute before pulling ...*/
        pc=0;
        pc=p_evaluate ();
        pc=0;        /* ... a new line */

        if (get1token()!=(TOKEN)EOF)
        {            /* we got a new token and we restart */
            realignbuffer();
            pushVALUE(p_lastuniq0);
            passcount++;
            return SUCCESS;
        }
                     /* at EOF */

                return SUCCESS;
   }

                /* not at EOL */

   return FAILURE;

}

STATUS   p_last0 ()
/*
This p_parser only succeeds at EOS.
*/
{
    if ((yytchar!=EOF) && (0 == *pstr))  /* does move on */
        {
            MOVEON;
            pushVALUE(EOF);

         /* the MOVEON did the pull of a token into the lookahead buff */
            
            return OK(EOF);
        }
    return FAILURE;
}


STATUS   p_last (k)
ACTION *k;
{
    PARSER p_last0;

    return p_attach (p_last0, k);
}

STATUS   p_exactly0 (c)
/*
this parser only succeeds when given token c.
It places the token's attribute as a literal on the program stack,
but not on the value stack. It gets put onto the latter at
runtime. It's also the return value, and a NULL attrib is changed
according to the OK macro to prevent a FAIL return in those cases.
*/
TOKEN   c;
{
    VALUE v;

    if (*pstr && *pstr == c)
    {                     /* read the attribute value */
        v=lvbuff[(int)(pstr-buffer)];
        MOVEON;
        pushVALUE(v); /* save the attribute on the program stack */
        return OK(v);
    }
    return FAILURE;
}

STATUS   p_notexactly0 (c)
/*
this p_parser only succeds when given a TOKEN not equal to c.
It places the token's attribute as a literal on the program stack.
*/
TOKEN   c;
{
    VALUE v;
    if (*pstr && *pstr != c)
    {
        c=*pstr;
        v=lvbuff[(int)(pstr-buffer)];
        MOVEON;
        pushVALUE(v);
        return OK(v);
    }
    return FAILURE;
}

STATUS   p_exactly (c,k)
TOKEN c;
ACTION *k;
{
    PARSER p_exactly0;
    status tok;

    tok = p_exactly0 (c);
    if (GOODSTATUS(tok))
        pushACTION(k);
    return tok;
}

STATUS  p_attach0 (p)
PARSER *p;
{
    return (*p) ();
}


STATUS  p_range (p,f)
PREDICATE *p;
ACTION *f;
{
    status tok;

    tok = p_range0 (p);

    if (GOODSTATUS(tok))
        pushACTION(f);

    return tok;
}

VOID  p_nop()
/*
a very trivial stack manipulation action
*/
{
}

#undef p_atch0
STATUS  p_atch0 (v)
PARAM v;
/*
trivial parser which returns a fixed value
*/
{
    return OK((VALUE)v);
}

