
/*
 * parser suite - and / or / nothing / something  parsers
 *
 * parser = [token] -> ([token],status)
 *
 * implemented as sideeffecting on [token], returns status.
 */

#include "cc.h"
#include <stdlib.h>

#ifdef __MSDOS__
#include <alloc.h>
#define INDOS 1
#else
#define INDOS 0
#endif

static VOID mkgen(void**, void**, int, int);
static VOID freegen(void**);

static VOID mkgen (s,v,n,m)
void **s, **v;
int n;
int m;
/* if *s, make a generic item of size n*m and put it in *v and *s */
{
    if (*s != NULL)
      return;
    *s = (void *) p_calloc (n, m);
    *v = *s;
}


VOID mkstack ()
/* make the attribute stack of the right sizes and install it */
{
    mkgen ((void**)&stack, (void**)&value, precc_data.stacksize, sizeof(STACKVALUE));
}

static VOID freegen (s)
void **s;
{
    if (*s == NULL)
      return;
    p_free (*s);
    *s = NULL;        /* so that we don't try freeing it twice */
}

VOID freestack ()
{
    freegen ((void**)&stack);
}

VOID  p_creat_data ()
/* we think one of the stacks at least is NULL, and we try and alloc it */
{
    long            bytesfree;

    bytesfree = p_memleft ();

    /* but which stack is it? */

    /* compilation warnings for maybe losing digits from the args of
     * p_calloc should always be ignored. The numbers can't be that big! */

    mkgen ((void**)&buffer, (void**)&buffer, precc_data.readbuffersize,sizeof(TOKEN));
    mkgen ((void**)&lvbuff, (void**)&lvbuff, precc_data.readbuffersize,sizeof(VALUE));
    mkgen ((void**)&program, (void**)&program, precc_data.maxprogramsize,
                                           sizeof(INSTRUCTION));
    mkgen ((void**)&stack, (void**)&value, precc_data.stacksize, sizeof(STACKVALUE));
    mkgen ((void**)&fstack, (void**)&fptr, precc_data.contextstacksize,sizeof(FRAME));

    if (buffer == NULL || lvbuff == NULL ||
       program == NULL || stack  == NULL || fstack == NULL)
    {
        fprintf (stderr,
        "error; not enough memory (%lu) for internal stacks\n", bytesfree);
        p_exit (1);
    }
    return;
}

VOID            p_destr_data ()
{
    freegen ((void**)&buffer);
    freegen ((void**)&lvbuff);
    freegen ((void**)&program);
    freegen ((void**)&stack);
    freegen ((void**)&fstack);
}


/* globals */

int             p_argc;
char          **p_argv;
TOKEN          *buffer;        /* where the pstr points to */
TOKEN          *yybuffer;      /* internal name for buffer */
VALUE          *lvbuff;        /* the parallel stack of yylvals */
char           * p_infile,     /* stdin name (eventually "-" if not a file) */
               * p_outfile;    /* stdout name (eventually "-" if not a file) */


INSTRUCTION    *program;
STACKVALUE     *stack;        /* the evaluation stack - either values or
                               * tokens */
STACKVALUE     *value;
FRAME           p_frame;      /* all one needs to know for a rewind */
FRAME          *fstack;
FRAME          *fptr;

 /* this IS a frame */

TOKEN          *pstr;         /* parsed stream */
int             pc;           /* program counter - counts up from 0 */
int             passcount;    /* input lines counted here */

 /* end of frame */

INSTRUCTION     instr;        /* instruction cache */
TOKEN          *maxp;        /* maximum number parsed so far */
int             call_mode = 0;    /* flag for call convention. 1 = pascal
                              * (manual), 0 = C (auto) */
jmp_buf         jmpb;        /* environment */
jmp_buf         p_jmpb;      /* or environments */
int             optimize = 0;    /* flag for flying program optimization */
int             msdos = INDOS;    /* 1 if we're in MSDOS */
PARSER         *p_entry;    /* entry point set by p_run & btck_error */
int             p_enargs;
PARAM           p_eargv[MAXARGS];

PRECC_DATA      precc_data;

