#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef __MSDOS__
/* for close() prototype */
#include <io.h>
#endif



#ifndef ATEXIT_MAX
#define ATEXIT_MAX 32
#endif
#ifndef NULL
#define NULL 0
#endif

#ifdef USEOWNATEXIT
void   exithandler(void);
static atexit_t flist[ATEXIT_MAX];
static int fptr;

int atexit(f)
    /* f is to be executed just before program termination */
atexit_t f;
{
    if(fptr>=ATEXIT_MAX)
        return(1);
    flist[fptr++]=f;
    signal(SIGABRT,exithandler);
    signal(SIGSEGV,exithandler);
    signal(SIGILL, exithandler);
    signal(SIGFPE, exithandler);
    signal(SIGTERM,exithandler);

    /* SIGINT is left free */
    return 0;
}

void exithandler()
{
    while (--fptr)
    {
        flist[fptr]();
    }
    /* and go home happy? */
}

# endif /* USEOWNATEXIT */

void p_fcloseall(void)
{
    extern char *p_infile, *p_outfile;

    if (p_infile &&
       *p_infile!='-')
      {
        fclose(stdin);/* close the in file */
        dup2(5,0);    /* restore stdin */
        close(5);
      }
    p_infile = 0;
    if (p_outfile &&
       *p_outfile!='-')
      {
	fclose(stdout);
	dup2(6,1);   /* restore stdout */
	close(6);
      }
    else
      {
	fflush(stdout);
	  /* at least clear stdout */
      }
    p_outfile = 0;
}

void p_exit(n)
int n;
{
    p_fcloseall();

#if defined(__MSDOS__)
    /* use default handler, which exits */
    signal(SIGTERM, SIG_DFL);
    /* this avoids a normal exit, which can crash for unknown reasons */
    raise(SIGTERM);
    /* but the exit code is 1 */
#endif

    /* ok to exit normally under unix */
       exit(n);
    /* exit code is n */
}
