
#ifndef CC_H
#define CC_H


#ifdef __MSDOS__
#define p_memleft()    coreleft()
#else
#define p_memleft()    32000
#endif


/* standard clib */
#include <stdio.h>
#define p_gets(x) gets(x)
#define p_calloc(x,y) calloc((size_t)(x),(size_t)(y))
#define p_free(x) free((VOID *)(x))
#include <stdarg.h>
#include <string.h>
#include <setjmp.h>


/* default defs */
#ifndef VALUE
#define VALUE char*        /* make sure you define VALUE !! */
#endif
#ifndef TOKEN
#define TOKEN char        /* and TOKEN, if not int and char */
#endif
#ifndef PARAM
#define PARAM long        /* VALUE=synthetic, PARAM=inherited */
#endif
#ifndef MAXPROGRAMSIZE
#define MAXPROGRAMSIZE 4096    /* 20K (chars) is often too big in DOS */
#endif                /* but this is ~3x line length, at least */
#ifndef READBUFFERSIZE
#define READBUFFERSIZE 2048    /* ditto */
#endif                /* because this IS the line length */
#ifndef STACKSIZE
#define STACKSIZE 4096        /* Very difficult to overun 2K ! */
#endif                /* because this is nesting depth. Approx line length. */

                            /* msdos defns */
#ifndef CONTEXTSTACKSIZE
#define CONTEXTSTACKSIZE 1024
#endif
#ifndef C_STACKSIZE
#define C_STACKSIZE 0x7FFF
#endif

#define MAXARGS 16        /* number of params catered for */
/* DON'T change it! */


extern int      yytchar;    /* the last thing yylex saw     */
extern int      yylineno;    /* line count */
/* I'll put in the decls for the yystuff here, in case they're needed */
extern int      yylen;
extern int      yylex();
extern char    *yylloc;
extern VALUE    yylval;
extern TOKEN   *yybuffer;    /* yyoutput can be written here */

#ifndef BAD_ERROR        /* failed parse marked at deepest pt */
#define BAD_ERROR(x) fprintf(stderr,"(line %d) failed parse:\
 probable error near ..<>%s\nSkipping ...\n",yylineno,maxp);\
 while(get1token());get1token();\
 yylloc=NULL;
#endif

#ifndef ZER_ERROR        /* incomplete parse shows least remainder */
#define ZER_ERROR(x) fprintf(stderr,"(line %d) incomplete parse:\
 possible error near ..<>%s\nSkipping ...\n",yylineno,maxp);\
 while(get1token());get1token();\
 yylloc=NULL;
#endif

/* if p_entry is set, use that as handler, else print message. */

#ifndef BTK_ERROR        /* backtracking across a parse boundary */
#define BTK_ERROR(x) if (!p_entry){\
 fprintf(stderr,"(line %d) error:\
 parse backtracked across cut from point near <>%s\n\
",yylineno,maxp);}\
yylloc=NULL;\
longjmp(jmpb,1); /* should be to the ! we're backtracking across */
#endif


#ifndef ON_ERROR        /* default error mechanism */
#define ON_ERROR(x) switch(x){\
case  1:BAD_ERROR(1);break;\
case  0:ZER_ERROR(0);break;\
case -1:BTK_ERROR(-1);break;\
}
#endif

/* local defs */
#define OPCODE char
#define VOID void

/* typedefs */
typedef PARAM  status;       /* STATUS is returned by a PARSER */
#define STATUS status
typedef STATUS  PARSER();    /* PARSER returns a STATUS */
#define TOPARSER             /* *(PARSER*) */
#define TOVALUE (VALUE)
typedef VOID    ACTION();    /* VALUE stack manipulation */
typedef int     boolean;     /* BOOLEAN is returned by a PREDICATE */
#define BOOLEAN boolean
typedef BOOLEAN PREDICATE(); /* PREDICATE returns a BOOLEAN */

typedef struct {             /* an INSTRUCTION consists of ... */
    OPCODE          opcode;  /* an OPCODE as opcode and ... */
    union {                  /* an ACTION or  ... */
    ACTION         *act;     /* a literal as operand. */
    TOKEN           tok;     /* The opcode selects the */
    VALUE           val;
    PARAM           par;
    }               operand;    /* interpretation of the operand. */
}               INSTRUCTION;
typedef union {            /* The VALUE stack actually contains */
    VALUE           val;    /* STACKVALUES, which may be either */
    TOKEN           tok;    /* VALUEs or TOKENs. TOKENs are */
    PARAM           par;    /* ... */
}               STACKVALUE;    /* pushed when literals are hit. */
typedef struct {        /* all the info required for a REWIND */
    TOKEN          *pstr;
    STACKVALUE     *value;
    int             pc;
    int             lineno;
    /* INSTRUCTION instr;*/ /* to track optimization */
}               FRAME;
typedef struct {
int     readbuffersize,
        maxprogramsize,
        stacksize,
        contextstacksize,
        stacktokens,         /* (boolean) support tokens as attrs for old code*/
        oldattributes;       /* (boolean) generate yacc style attr. refs */
}       PRECC_DATA;



/* instruction destructors and constructors */
#define Action(x) (x).operand.act
#define Token(x)  (x).operand.tok
#define Param(x)  (x).operand.par
#define Opcode(x) (x).opcode
#define Value(x)  (x).operand.val

/* status macros */
#define BADSTATUS(x)  (!(x))    /* BADSTATUS(x) is a PREDICATE */
#define GOODSTATUS(x) (x)       /* as is GOODSTATUS(x) */
# define INSTATUS(x) ( (PARAM) ( (long)(x) - ( (0>(int)(x)) ? 0 : 1 ) ) )
                                     /* success deconstructor */
# define OK(x) ( (STATUS) ( ( (0>(int)(x)) ? 0 : 1 ) + (long)(x) ) )
                                     /* success constructor */
#define KO(x)  0
#define SUCCESS OK(1)
#define FAILURE KO(0)


/* input stream manipulations */

/* MARK has to be first line in a  routine.
 * The MARK saves the current parse frame.
 */

#define MARK {\
fsave(p_frame);\
fpush(p_frame);\
}

/* REWIND resets the parse point to the MARK at the head of the fn. 
 * provided that the read buffer hasn't been overwritten, in which case 
 * just go back as far as possible
 */

#define REWIND {\
fpop(p_frame);\
frestore(p_frame);\
}

/* RELEASE will destroy the temporary references */

# define RELEASE fpop(p_frame)

/*
 * maxp+1 is the first address I have not yet written into. The TOKEN space
 * should be occupied by a 0. maxp is the last position  I have written into.
 * 
 * pstr is the current TOKEN position. Notice that I am going to have to read
 * one TOKEN into *pstr to start up?
 * 
 * We start with pstr=maxp=&buffer, and *buffer=first token.
 */

#ifdef OLDSTYLEMOVEON
#define MOVEON if(++pstr>maxp){  /* this next space not written into */\
                    *pstr=(TOKEN)yylex();\
                    lvbuff[(int)(pstr-buffer)]=yylval;\
                    maxp=pstr;\
                }
#else
#define MOVEON get1token()
#endif


/* the secret parse string and stacks */
extern TOKEN     *pstr;        /* parsed stream */
extern TOKEN     *maxp;        /* maximal parse point in stream */
extern TOKEN     *buffer;    /* where the pstr points to */
extern VALUE     *lvbuff;   /* the corresponding yylvals*/
extern VALUE     *plval;    /* and pointer */
extern INSTRUCTION *program;
extern int      pc;        /* program counter - counts up from 0 */
extern int      passcount;    /* count cuts */
extern STACKVALUE  *stack;    /* the evaluation stack - either
                     * VALUEs or TOKENs */
extern STACKVALUE *value;   /* top of evaluation stack */
extern FRAME     *fstack;   /* top of frame stack ... */
extern FRAME     *fptr;     /* and pointer */
extern FRAME      p_frame;  /* a frame cache */
extern INSTRUCTION instr;   /* single instruction cache */
extern int      call_mode;  /* 0 for auto-calling convention, 1=manual */
extern int      optimize;   /* 1 for flying optimization */
extern jmp_buf  jmpb;
extern int      p_argc;     /* command line argument count */
extern char   **p_argv;     /* command line argument array */
extern PRECC_DATA precc_data;
extern int      msdos;
extern PARSER  *p_entry;    /* the current entry point */
extern int     p_enargs;
extern PARAM   p_eargv[];
extern char   *p_infile,    /* stdin name (eventually "-" if not a file) */
              *p_outfile;   /* stdout name (eventually "-" if not a file) */

/* opcodes */
#define INCR   5        /* increment value stack */
#define PARM   4        /* parameter to a function call */
#define FUNC   3        /* That's got an ACTION operand */
#define EXIT   2
#define CNST   1        /* That's got a VALUE operand. */
#define NOP    0        /* Saves time. */

/* program stack manipulation */
#define push(x) {if(pc>=precc_data.maxprogramsize-1){\
                 fprintf(stderr,"precc: program stack overflow (%d)\n",pc);\
                 p_exit(1);\
                 }\
                 program[pc++]=(x);\
                }
#define pull(n) (pc-=(n))
#define pop(x)  (x=program[--pc])
#define ppeek(x) (pc>0?x=program[pc-1]:((x).opcode=EXIT,(x)))
#define ppoke(x) {if(pc>0)program[pc-1]=(x);}

/* frame stack manipulation */
# define fpush(x) (*fptr++=(x))
# define fpop(x)  (x=*--fptr)
# define fpull(n) (fptr-=(n))
# define fsave(x) \
x.pstr=pstr;\
/*x.value=value;*/\
x.pc=pc;\
x.lineno=passcount
/*;\ ppeek(x.instr)*/
# define frestore(x) \
pstr=(x.lineno==passcount)?x.pstr:(btk_error(),buffer);\
pc=x.pc\
/*; value=x.value*/
/*; ppoke(x.instr)*/

/* load and unlaod the current instruction */
#define getinstruction(n,x)   {Opcode(instr)=(n);Action(instr)=(x);}
#define pushinstruction(n,x)  {getinstruction(n,x);push(instr);}
#define getTOKEN(x)           {Opcode(instr)=(CNST);Token(instr)=(TOKEN)(x);}
#define getPARAM(x)           {Opcode(instr)=(PARM);Param(instr)=(PARAM)(x);}
#define getMANIP(x)           {Opcode(instr)=(INCR);Param(instr)=(PARAM)(x);}
#define getVALUE(x)           {Opcode(instr)=(CNST);Value(instr)=(VALUE)(x);}
#define pushTOKEN(x)          {getTOKEN(x);push(instr);}
#define pushPARAM(x)          {getPARAM(x);push(instr);}
#define pushVALUE(x)          {getVALUE(x);push(instr);}
#define pushACTION(x)         pushinstruction(FUNC,(x))
#define pushEXIT              pushinstruction(EXIT,0)
/* don't allow extra stack manips if call_mode=1 */
/* let's try some on-the-fly optimisation        */

/* Now let's disallow stack manipulations altogether !! */
#ifdef STACKMANIPS
#define pushMANIP(x)          if(0==call_mode){\
                               if(optimize&&(Opcode(ppeek(instr))==(INCR))){\
                                   Param(instr) += (PARAM)(x);\
                                   ppoke(instr);\
                               } else{\
                                   getMANIP(x);\
                                   push(instr);\
                               }\
                              }
# else
#define pushMANIP(x)
# endif
#define pushINCR              pushMANIP(1)
#define pushDECR              pushMANIP(-1)
#define pushNOP               pushinstruction(NOP,0)

/* evaluation stack manipulation */
#define pushvalue(x) ((*value++).val)=(x)
#define pushparam(x) ((*value++).par)=(x)
#define pushtoken(x) ((*value++).val)=(TOKEN)(x)
#define popvalue(x)  (x=(*--value).val)
#define poptoken(x)  (x=(TOKEN)((*--value).val))
#define popparam(x)  (x=(*--value).par)
/*
 * # define pullvalue(n) &stack[(int)(value-=(n))-(int)stack].val # define
 * pullparam(n) &stack[(int)(value-=(n))-(int)stack].par # define
 * pulltoken(n) &stack[(int)(value-=(n))-(int)stack].tok
 */
#define pullvalue(n) &((value-=(n))->val)
#define pullparam(n) &((value-=(n))->par)
#define pulltoken(n) (TOKEN)(&((value-=(n))->val))

#ifndef DOS
/* SUNUNIX versions */
#define setvalue(n)  pullvalue(call_mode?(n)-1:0);refvalue(1)
#define settoken(n)  pullvalue(call_mode?(n)-1:0);reftoken(1)
#define refvalue(n)  (value[(n)-2].val)
#define reftoken(n)  (TOKEN)(long)(value[(n)-2].val)
#define refpar(n)    (value[(n)-2].par)
#else
/* BORLAND versions */
#define setvalue(n)  ((pullvalue(call_mode?(n)-1:0))[-1].val)
#define settoken(n)  (TOKEN)((pullvalue(call_mode?(n)-1:0))[-1].val)
#define refvalue(n)  (value[(n)-2].val)
#define reftoken(n)  (TOKEN)(value[(n)-2].val)
#define refpar(n)    (value[(n)-2].par)
#endif

/* program-interpreter
 * in engine.c */
extern int      p_evaluate();

/* read and run parser, interpret resulting program
 * in engine.c */
extern ACTION   p_run;

/* parsers without actions */
/* defined in cc.c */
extern PARSER   p_andparse0;
extern PARSER   p_orparse0;
extern PARSER   p_many0;
extern PARSER   p_iter0;
extern PARSER   p_some0;
extern PARSER   p_option0;
extern PARSER   p_range0;
extern PARSER   p_hidden0;
extern PARSER   p_atch0;


/* defined in common.c */
extern PARSER   p_nothing0;
extern PARSER   p_anything0;
extern PARSER   p_first0;
extern PARSER   p_last0;
extern PARSER   p_exactly0;
extern PARSER   p_notexactly0;
extern PARSER   p_attach0;
extern PARSER   p_uerror0;

/* parsers with actions attached */
/* in cc.c */
extern PARSER   p_attach;
extern PARSER   p_prepend;
/* in common.c */
extern PARSER   p_andparse;
extern PARSER   p_orparse;
extern PARSER   p_nothing;
extern PARSER   p_option;
extern PARSER   p_many;
extern PARSER   p_some;
extern PARSER   p_anything;
extern PARSER   p_first;
extern PARSER   p_last;
extern PARSER   p_exactly;
extern PARSER   p_notexactly;
extern PARSER   p_range;


/* parsers taking a variable number of arguments */
extern STATUS   p_andparse0n(PARSER *,...);
extern STATUS   p_starparse0n(VALUE *,PARSER *,...);
extern STATUS   p_orparse0n (PARSER *,...);
extern STATUS   p_option0n  (PARSER *,...);
extern STATUS   p_hidden0n  (PARSER *,...);
extern STATUS   p_many0n    (PARSER *,...);
extern STATUS   p_iter0n    (int, PARSER *,...);
extern STATUS   p_some0n    (PARSER *,...);
extern STATUS   p_uniq0n    (PARSER *,...);
extern STATUS   p_attach0n  (PARSER *,...);
extern STATUS   p_prepend0n (PARSER *,...);
extern STATUS   p_range0n   (PREDICATE *,...);
extern STATUS   p_uerror0n  (PARSER *,...);
extern STATUS   p_until0n   (PARSER *,...);
extern PARSER   p_test0;

/* but replaced by macros here - args ignored */

#define p_andparse0n(p,a,q,b) p_andparse0(p,q)
#define p_orparse0n(p,a,q,b)  p_orparse0 (p,q)
#define p_option0n(p,a)       p_option0  (p)
#define p_hidden0n(p,a)       p_hidden0  (p)
#define p_many0n(p,a)         p_many0    (p)
#define p_iter0n(n,p,a)       p_iter0    (n,p)
#define p_some0n(p,a)         p_some0    (p)
#define p_uniq0n(p,a)         p_uniq0    (p)
#define p_attach0n(p,a,f,b)   p_attach   (p,f)
#define p_prepend0n(p,a,f,b)  p_prepend  (p,f)
#define p_range0n(p,a)        p_range0   (p)
#define p_uerror0n(p,a)       p_uerror0  (p)
#define p_until0n(p,a)        p_until0   (p)

/* actions */
/* in common.c */
extern ACTION   nop;

/* aux */
extern char     *p_scpy();
extern void     p_exit(int);
/* in engine.c */
extern TOKEN    get1token();
extern ACTION   realignbuffer;
extern VOID     callerror(int);
    /* (in on_error.c) */
extern ACTION   zer_error;
extern ACTION   bad_error;
extern ACTION   btk_error;
extern ACTION   precc_begin;
extern ACTION   precc_end;

#ifndef BEGIN
#define BEGIN
#endif
#ifndef END
#define END
#endif


#define P_PSTAR(X,CALL1,CALL2) \
  MARK;  p_tok = CALL1;\
  if (BADSTATUS(p_tok)) {RELEASE;return p_tok;}\
  X = (PARAM)INSTATUS(p_tok); /* decode */\
  p_tok = CALL2;\
  if (BADSTATUS(p_tok)) {REWIND;} else {RELEASE;}



#define MAIN(x) \
int main(argc,argv)\
int argc; char **argv;\
{\
PARSER x;ACTION p_run;\
ACTION precc_free, precc_alloc, p_exit; int brk(), atexit();\
if (msdos) brk((void*)C_STACKSIZE); /* set the C stack to 32K */\
p_argc=argc;p_argv=argv;\
precc_alloc();                       /* set data as per params */\
p_run (x);\
precc_free();                       /* release memory, close files */\
p_exit(0);\
return 0;\
}\
 VOID  zer_error(){ON_ERROR(0);}\
 VOID  bad_error(){ON_ERROR(1);}\
 VOID  btk_error(){ON_ERROR(-1);}\
 VOID  precc_begin(){BEGIN;}\
 VOID  precc_end(){END;}\
 VOID  precc_alloc(){ACTION p_creat_data;\
 precc_data.readbuffersize=READBUFFERSIZE;\
 precc_data.maxprogramsize=MAXPROGRAMSIZE;\
 precc_data.stacksize=STACKSIZE;\
 precc_data.contextstacksize=CONTEXTSTACKSIZE;\
 precc_data.stacktokens=STACKTOKENS;\
 precc_data.oldattributes=OLDATTRIBUTES;\
 p_creat_data();}\
 VOID  precc_free(){\
 ACTION p_destr_data; static n;\
 if (!n++) p_destr_data();\
 }


#define V(n)  refvalue(n)   /* n'th argument */
#define T(n)  reftoken(n)   /* n'th argument */
#define VV(n) setvalue(n)   /* result from n args */
#define TT(n) settoken(n)   /*result of n args */

#endif
