MODULE WinDemo;
  (*
    MULTIGRAPH: Graphics Support Library - Window Level
    -----------------------------------------------------
    Copyright (C) 1993-1995, Alex Iakovlev & Dimon Maslov
    -----------------------------------------------------
    Demonstration Program, Ver M.36
  *)
  (*
    **************************************************************************
    Compiler:   TopSpeed / Stony Brook Modula-2
    --------------------------------------------------------------------------
    A.Iakovlev  Ver  M.0   Initial version                       February 89
    A.Iakovlev  Ver  M.1   Chronometers                          March 89
    A.Iakovlev  Ver  M.2   Timing through DOS                    March 89
    A.Iakovlev  Ver  M.3   New WinGraphics                       March 89
    A.Iakovlev  Ver  M.4   Running line                          April 89
    A.Iakovlev  Ver  M.5   Pause                                 June 89
    A.Iakovlev  Ver  M.6   New BuffKeyboard                      June 89
    A.Iakovlev  Ver  M.7   Using of menus                        July 89
    A.Iakovlev  Ver  M.8   Windows                               July 89
    A.Iakovlev  Ver  M.9   Use M2VERS utility                    August 89
    A.Iakovlev  Ver  M.10  Transportability layer                September 89
    A.Iakovlev  Ver  M.11  JPI-only version                      January 90
    A.Iakovlev  Ver  M.12  Renaming                              January 90
    A.Iakovlev  Ver  M.13  New module Win                        February 90
    A.Iakovlev  Ver  M.14  New atttributes                       February 90
    A.Iakovlev  Ver  M.15  Messages                              April 90
    A.Iakovlev  Ver  M.16  System redesign                       June 90
    A.Iakovlev  Ver  M.17  Separate screen level                 November 90
    A.Iakovlev  Ver  M.18  Changes in input modules              January 91
    A.Iakovlev  Ver  M.19  Use plexes for messages/menu          April 91
    A.Iakovlev  Ver  M.20  Texts in separate file                August 91
    A.Iakovlev  Ver  M.21  Automatic demo                        August 91
    A.Iakovlev  Ver  M.22  Simplified ScrTxOut                   October 91
    A.Iakovlev  Ver  M.23  Renaming RunLine -> WinRLine          January 92
    A.Iakovlev  Ver  M.24  View heap table                       February 92
    A.Iakovlev  Ver  M.25  Changes in Polyline/Polygon           June 92
    A.Iakovlev  Ver  M.26  Dynamic graphics modes in Scr         August 92
    A.Iakovlev  Ver  M.27  Renaming                              June 93
    A.Iakovlev  Ver  M.28  Import from SYSTEM                    January 94
    A.Iakovlev  Ver  M.29  Use modules Strings, Terminal, InOut  January 94
    A.Iakovlev  Ver  M.30  No recursion                          February 94
    A.Iakovlev  Ver  M.31  Separate structured constants         April 94
    A.Iakovlev  Ver  M.32  High and true colors                  November 94
    A.Iakovlev  Ver  M.33  Colors adjustment                     March 95
    A.Iakovlev  Ver  M.34  No structured constants               March 95
    A.Iakovlev  Ver  M.35  Modified plexes                       March 95
    A.Iakovlev  Ver  M.36  United modules ScrOut/ScrCur/ScrInp   March 95
    **************************************************************************
    TopSpeed Compiler dependencies:
    ------ predefined type LONGCARD
    ------ options
    Stony Brook Compiler dependencies:
    ------ predefined type LONGCARD
    ------ options
    TopSpeed library dependencies:
    ------ import from Strings: Assign, Delete, Copy, CompareStr, Concat, Length
    ------ import from Terminal: Write, WriteString, WriteLn
    ------ import from InOut: WriteCard
    Stony Brook library dependencies:
    ------ import from Strings: Assign, Delete, Copy, CompareStr, Concat, Length
    ------ import from Terminal: Write, WriteString, WriteLn
    ------ import from InOut: WriteCard
  *)

  IMPORT
    SYSTEM, Strings, Terminal, InOut,
    Geo, Res, SrvLex, DrvMem, DrvKbd, DrvSnd, DrvClk, DrvDsk,
    Scr, ScrOut, ScrFnt, ScrInp, Win, WinOut, WinCur, WinInp,
    Dlg, DlgInp;

  (* ================================================== Main constants *)

  CONST
    WinMark = "#";
    TextStrLen = 64;
    HeapBuffLen = 65000;
    KeysNmb = 4000;
    ModeStrNmb = 21;
    TimeOut = 5;
    XDivisor = 80;
    YDivisor = 50;
    (* ------------------- box numbers in the plex *)
    MainMenu = 0;
    HeaderMsg = 100;
    HelpWinOpenMsg = 103;
    HelpWinSelectMsg = 104;
    NoOpenedWinMsg = 110;
    NoVisibleWinMsg = 111;
    NotFullyVisMsg = 112;
    NoMemoryMsg = 113;
    FaceErrorMsg = 114;
    (* ------------- running line numbers *)
    MainLine = 150;
    GeometryLine = 151;
    SelectLine = 152;

  (* ========================================== Global types and variables *)

  TYPE
    Info =
    (
      adapter, press,
      noFile, largeFile, badFile, emptyFile,
      noMemory, otherError,
      initString
    );

  TYPE
    TextString = ARRAY [0 .. TextStrLen - 1] OF CHAR;
    ExecWin = PROCEDURE(Win.WINDOW);

  VAR
    vpm: Scr.PIXMAP;
    viewV: Scr.View;
    colNmb: LONGCARD;
    mainFont, hatchFont: ScrOut.FONT;
    scrnWdt, scrnHgt: CARDINAL;
    sx, sxMax, sy, syMax, key, j: CARDINAL;
    charWdt, charHgt, fontsNmb, hatchesNmb: CARDINAL;
    invalidRect, cursRect: Geo.Rectangle;
    invalidPt, cursPt, nullPt: Geo.Point;
    heapBuffPtr: SYSTEM.ADDRESS;
    fully, endMain: BOOLEAN;
    infoStr: ARRAY Info OF TextString;
    modeStr: ARRAY [0 .. ModeStrNmb - 1] OF TextString;
    (* ---------------------------------------------------- *)
    winNmb, winHiddenNmb, winCounter: CARDINAL;
    loadKey: ARRAY [0 .. KeysNmb - 1] OF CARDINAL;
    loadKeysNmb: CARDINAL;
    plx: Dlg.PLEX;

  (* ========================================= Errors reporting *)

  PROCEDURE Error
    (
      file, msg: ARRAY OF CHAR;
      errNo: CARDINAL;
      errTxt: ARRAY OF CHAR;
      halt: BOOLEAN
    );
    VAR
      key: CARDINAL;
    BEGIN
      IF Scr.Graph() THEN Scr.Clear(vpm, 0); Scr.TermGraph() END;
      Terminal.WriteLn();
      Terminal.WriteString(file);
      Terminal.WriteString(msg);
      IF errNo # 0 THEN InOut.WriteCard(errNo, 2) END;
      Terminal.WriteLn();
      IF Strings.CompareStr(errTxt, "") # 0 THEN
        Terminal.WriteString(errTxt);
        Terminal.WriteLn();
      END;
      Terminal.WriteString("To continue press any key");
      Terminal.WriteLn();
      REPEAT UNTIL DrvKbd.Get(key);
      IF halt THEN HALT() END;
    END Error;

  (* ====================================================== Files loading *)

  PROCEDURE LoadString(filename: ARRAY OF CHAR; VAR str: ARRAY OF CHAR);
    CONST
      NoFileMsg = " --- file not found";
      LargeFileMsg = " --- file too large";
      BadFileMsg = " --- bad file";
      WordShift = 10000H;
    VAR
      f: DrvDsk.File;
      low, hgh, read: CARDINAL;
      size: LONGCARD;
    BEGIN
      f := DrvDsk.Open(filename);
      IF DrvDsk.result = 0 THEN
        size := DrvDsk.Size(f);
        hgh := VAL(CARDINAL, size DIV WordShift);
        low := VAL(CARDINAL, size MOD WordShift);
        IF (hgh = 0) AND (low <= HIGH(str) + 1) THEN
          read := DrvDsk.Read(f, SYSTEM.ADR(str), low);
          IF read = low THEN
            IF low <= HIGH(str) THEN str[low] := 0C END;
            DrvDsk.Close(f);
          ELSE
            Error(filename, BadFileMsg, 0, "", TRUE);
          END;
        ELSE
          Error(filename, LargeFileMsg, 0, "", TRUE);
        END;
      ELSE
        Error(filename, NoFileMsg, 0, "", TRUE);
      END;
    END LoadString;

  PROCEDURE LoadTexts();
    CONST
      TxtFileLen = 2000;
      TxtFileName = "WINDEMO.T";
      InfoNmb = 10;
    VAR
      str: ARRAY [0 .. TxtFileLen - 1] OF CHAR;
      len, i0, i1, itemNo: CARDINAL;
    BEGIN
      LoadString(TxtFileName, str);
      len := Strings.Length(str);
      i0 := 0;
      WHILE i0 < len - 1 DO
        i0 := SrvLex.Skip(str, i0);
        i1 := SrvLex.ExtractTypedNumber(str, i0, SrvLex.dec, itemNo);
        i0 := SrvLex.Skip(str, i1) + 1;
        i1 := SrvLex.PosLineBreak(str, i0);
        IF i1 > len THEN i1 := len END;
        IF itemNo < InfoNmb THEN
          Strings.Copy(str, i0, i1 - i0, infoStr[VAL(Info, itemNo)]);
        ELSIF itemNo < InfoNmb + ModeStrNmb THEN
          Strings.Copy(str, i0, i1 - i0, modeStr[itemNo - InfoNmb]);
        END;
        i0 := i1 + 2;
      END;
    END LoadTexts;

  (* ========================================================= Randoms *)

  (*
     ------ Sorry, the code for randoms was taken from JPI's library
     ------ as Stony Brook doesn't contain them...
  *)

  CONST
    HistoryMax = 54;

  VAR
    history: ARRAY [0 .. HistoryMax] OF CARDINAL;
    historyPtr, lowerPtr: CARDINAL;

  (*$O-*)
  (*/NOCHECK:O*)

  PROCEDURE SetUpHistory(seed: CARDINAL);
    VAR
      x: LONGCARD;
      i: CARDINAL;
    BEGIN
      historyPtr := HistoryMax;
      lowerPtr := 23;
      x := VAL(LONGCARD, seed);
      i := 0;
      REPEAT
        x := x * 3141592621 + 17;
        history[i] := VAL(CARDINAL, x DIV 10000H);
        INC(i);
      UNTIL i > HistoryMax;
    END SetUpHistory;

  PROCEDURE CardRandom(range: CARDINAL): CARDINAL;
    VAR
      res: CARDINAL;
    BEGIN
      IF historyPtr = 0 THEN
        IF lowerPtr = 0 THEN
          SetUpHistory(12345);
        ELSE
          historyPtr := HistoryMax;
          DEC(lowerPtr);
        END;
      ELSE
        DEC(historyPtr);
        IF lowerPtr = 0 THEN
          lowerPtr := HistoryMax;
        ELSE
          DEC(lowerPtr);
        END;
      END;
      res := history[historyPtr] + history[lowerPtr];
      history[historyPtr] := res;
      IF range = 0 THEN
        RETURN res;
      ELSE
        RETURN res MOD range;
      END;
    END CardRandom;

  (*/REVERT*)
  (*$O=*)

  PROCEDURE LongCardRandom(range: LONGCARD): LONGCARD;
    VAR
      res: LONGCARD;
    BEGIN
      IF range <= 10000H THEN
        RETURN VAL(LONGCARD, CardRandom(VAL(CARDINAL, range)));
      ELSE
        res := VAL(LONGCARD, CardRandom(0)) * 10000H + VAL(LONGCARD, CardRandom(0));
        RETURN res MOD range;
      END;
    END LongCardRandom;

  PROCEDURE Randomize();
    BEGIN
      SetUpHistory(DrvClk.Time());
    END Randomize;

  (* ======================================= Colors determination *)

  PROCEDURE RandomColor(): Scr.Pixel;
    BEGIN
      RETURN VAL(Scr.Pixel, 1 + LongCardRandom(colNmb - 1));
    END RandomColor;

  PROCEDURE RandomColorNotEqual(c: Scr.Pixel): Scr.Pixel;
    VAR
      temp: Scr.Pixel;
    BEGIN
      REPEAT temp := RandomColor() UNTIL temp # c;
      RETURN temp;
    END RandomColorNotEqual;

  PROCEDURE BackColor(): Scr.Pixel;
    BEGIN
      RETURN Scr.RGBColor(128, 128, 128);
    END BackColor;

  PROCEDURE CursColor(): Scr.Pixel;
    BEGIN
      RETURN Scr.RGBColor(255, 255, 0);
    END CursColor;

  PROCEDURE AuxCursColor(): Scr.Pixel;
    BEGIN
      RETURN Scr.RGBColor(0, 255, 255);
    END AuxCursColor;

  (* =================================================== Plexes loading *)

  PROCEDURE LoadPlexes();
    CONST
      PlxFileLen = 8000;
      PlxFileName = "WINDEMO.PLX";
      PlxLeftGap = 0; PlxRightGap = 0; PlxTopGap = 1; PlxBottomGap = 1;
      PlxXBasePt = 1; PlxYBasePt = 1;
      PlxRunStep = 1;
    VAR
      str: ARRAY [0 .. PlxFileLen - 1] OF CHAR;
      a: Dlg.Attrs;
      e: Dlg.ErrParams;
      basePt: Geo.Point;
      res: Res.Status;
      s: TextString;
    BEGIN
      LoadString(PlxFileName, str);
      (* ----------------------- set attributes *)
      a.font := mainFont;
      a.backColor := BackColor();
      a.textColor := 0;
      a.itemColor := RandomColorNotEqual(a.backColor);
      a.frameAttrs.frameStyle := Win.frameLine;
      a.frameAttrs.frameColor := 0;
      a.titleAttrs.titleStyle := Win.titleEmpty;
      a.leftGap := PlxLeftGap;
      a.rightGap := PlxRightGap;
      a.topGap := PlxTopGap;
      a.bottomGap := PlxBottomGap;
      a.runCharsNmb := 0;
      a.runStep := PlxRunStep;
      (* ---------------------------------------------- create a plex *)
      res := Dlg.New(str, a, e, plx);
      CASE res OF
      | Res.done:
        basePt.ix := PlxXBasePt;
        basePt.iy := PlxYBasePt;
        res := Dlg.Move(plx, MainMenu, basePt);
        res := Dlg.Move(plx, SelectLine, basePt);
        res := Dlg.Move(plx, GeometryLine, basePt);
        basePt.iy := scrnHgt - charHgt - PlxTopGap - PlxBottomGap - 1;
        res := Dlg.Move(plx, MainLine, basePt);
        RETURN;
      | Res.noMemory:
        s := infoStr[noMemory];
      ELSE
        s := infoStr[otherError];
      END;
      (* ------------------------------- errors processing *)
      Strings.Copy(str, e.inx, e.len, str);
      Error(PlxFileName, s, ORD(res), str, TRUE);
    END LoadPlexes;

  (* ========================================= Key program loading *)

  CONST
    ExtNmb = 28;
    ExtStrLen = 10;

  TYPE
    ExtLine =
      RECORD
        key: CARDINAL;
        name: ARRAY [0 .. ExtStrLen - 1] OF CHAR;
      END;

  VAR ext: ARRAY [0 .. ExtNmb - 1] OF ExtLine;

  PROCEDURE InitEntry(n, k: CARDINAL; s: ARRAY OF CHAR);
    BEGIN
      WITH ext[n] DO
        Strings.Assign(s, name);
        key := k;
      END;
    END InitEntry;

  PROCEDURE InitKeyMapping();
    BEGIN
      InitEntry( 0, DrvKbd.Escape        , "Esc"      );
      InitEntry( 1, DrvKbd.Enter         , "Enter"    );
      InitEntry( 2, DrvKbd.Tab           , "Tab"      );
      InitEntry( 3, DrvKbd.BackSpace     , "BackSp"   );
      InitEntry( 4, DrvKbd.Home          , "Home"     );
      InitEntry( 5, DrvKbd.UpArrow       , "Up"       );
      InitEntry( 6, DrvKbd.PageUp        , "PgUp"     );
      InitEntry( 7, DrvKbd.LeftArrow     , "Left"     );
      InitEntry( 8, DrvKbd.RightArrow    , "Right"    );
      InitEntry( 9, DrvKbd.CtrlLeftArrow , "CtrlLeft" );
      InitEntry(10, DrvKbd.CtrlRightArrow, "CtrlRight");
      InitEntry(11, DrvKbd.End           , "End"      );
      InitEntry(12, DrvKbd.DownArrow     , "Dn"       );
      InitEntry(13, DrvKbd.PageDown      , "PgDn"     );
      InitEntry(14, DrvKbd.Insert        , "Ins"      );
      InitEntry(15, DrvKbd.Delete        , "Del"      );
      InitEntry(16, DrvKbd.CtrlQ         , "CtrlQ"    );
      InitEntry(17, DrvKbd.CtrlW         , "CtrlW"    );
      InitEntry(18, DrvKbd.CtrlE         , "CtrlE"    );
      InitEntry(19, DrvKbd.CtrlA         , "CtrlA"    );
      InitEntry(20, DrvKbd.CtrlD         , "CtrlD"    );
      InitEntry(21, DrvKbd.CtrlZ         , "CtrlZ"    );
      InitEntry(22, DrvKbd.CtrlX         , "CtrlX"    );
      InitEntry(23, DrvKbd.CtrlC         , "CtrlC"    );
      InitEntry(24, DrvKbd.CtrlV         , "CtrlV"    );
      InitEntry(25, DrvKbd.CtrlT         , "CtrlT"    );
      InitEntry(26, DrvKbd.CtrlK         , "CtrlK"    );
      InitEntry(27, DrvKbd.CtrlY         , "CtrlY"    );
    END InitKeyMapping;

  PROCEDURE FindKey(s: ARRAY OF CHAR; VAR k: CARDINAL): BOOLEAN;
    VAR
      j: CARDINAL;
    BEGIN
      FOR j := 0 TO ExtNmb - 1 DO
        IF Strings.CompareStr(s, ext[j].name) = 0 THEN
          k := ext[j].key;
          RETURN TRUE;
        END;
      END;
      RETURN FALSE;
    END FindKey;

  PROCEDURE Ctrl(ch: CHAR): BOOLEAN;
    BEGIN
      RETURN (ch < " ") OR ("~" < ch);
    END Ctrl;

  PROCEDURE Digit(ch: CHAR): BOOLEAN;
    BEGIN
      RETURN ("0" <= ch) AND (ch <= "9");
    END Digit;

  PROCEDURE LoadKeys();
    CONST
      KeysFileLen = 6000;
      KeysFileName = "WINDEMO.KEY";
      LeftSeparator = "<";
      RightSeparator = ">";
    VAR
      str: ARRAY [0 .. KeysFileLen - 1] OF CHAR;
      len, i0, i1, k, j, n, p: CARDINAL;
      s: TextString;
    BEGIN
      InitKeyMapping();
      LoadString(KeysFileName, str);
      (* -------------------- init parameters *)
      len := Strings.Length(str);
      i0 := 0;
      k := 0;
      (* ------------------------------------ main loop *)
      LOOP
        IF i0 < len THEN
          IF Ctrl(str[i0]) THEN
            (* ----------------------------- skip control characters *)
            REPEAT INC(i0) UNTIL (i0 = len) OR NOT Ctrl(str[i0]);
          ELSIF str[i0] = LeftSeparator THEN
            (* ------------- extract extended key: unknown keys are ignored *)
            INC(i0);
            IF Digit(str[i0]) THEN
              n := 0;
              REPEAT
                n := n * 10 + ORD(str[i0]) - ORD("0");
                INC(i0);
              UNTIL NOT Digit(str[i0]);
            ELSE
              n := 1;
            END;
            i1 := SrvLex.PosChar(str, i0, RightSeparator);
            Strings.Copy(str, i0, i1 - i0, s);
            IF FindKey(s, p) THEN
              FOR j := 1 TO n DO
                IF k < KeysNmb THEN
                  loadKey[k] := p;
                  INC(k);
                END;
              END;
            END;
            i0 := i1 + 1;
          ELSE
            (* ------ extract key sequence: control characters are ignored *)
            i1 := SrvLex.PosChar(str, i0, LeftSeparator);
            WHILE i0 < i1 DO
              IF (k < KeysNmb) AND NOT Ctrl(str[i0]) THEN
                loadKey[k] := ORD(str[i0]);
                INC(k);
              END;
              INC(i0);
            END;
          END;
        ELSIF k = 0 THEN
          (* ---------------------------------------- no keys loaded *)
          Error(KeysFileName, infoStr[emptyFile], 0, "", TRUE);
        ELSE
          (* ------------- normal exit *)
          EXIT;
        END;
      END;
      loadKeysNmb := k;
    END LoadKeys;

  (* ============================================== Font utilities *)

  PROCEDURE Font(): ScrOut.FONT;
    CONST
      MinLinesNmb = 25;
      MaxLinesNmb = 30;
    VAR
      n, j, w, h, ln: CARDINAL;
      fnt: ScrOut.FONT;
    BEGIN
      FOR j := 2 TO fontsNmb - 1 DO
        fnt := ScrOut.StdFont(j);
        ScrOut.Dims(fnt, w, h);
        ln := scrnHgt DIV h;
        IF (MinLinesNmb <= ln) AND (ln <= MaxLinesNmb) THEN
          RETURN fnt;
        END;
      END;
      RETURN ScrOut.StdFont(0);
    END Font;

  PROCEDURE RandomFont(): ScrOut.FONT;
    BEGIN
      IF fontsNmb > 2 THEN
        RETURN ScrOut.StdFont(CardRandom(fontsNmb - 2) + 2);
      ELSE
        RETURN ScrOut.StdFont(0);
      END;
    END RandomFont;

  PROCEDURE CharsNmb(f: ScrOut.FONT): CARDINAL;
    VAR
      s: ScrOut.CharSet;
      count: CARDINAL;
      ch: CHAR;
    BEGIN
      ScrOut.Chars(f, s);
      count := 0;
      FOR ch := MIN(CHAR) TO MAX(CHAR) DO
        IF ch IN s THEN INC(count) END;
      END;
      RETURN count;
    END CharsNmb;

  (* ====================================================== String utilities *)

  PROCEDURE StrToCard(s: ARRAY OF CHAR; VAR ok: BOOLEAN): CARDINAL;
    VAR
      res: CARDINAL;
    BEGIN
      ok := SrvLex.ExtractTypedNumber(s, 0, SrvLex.dec, res) > 0;
      RETURN res;
    END StrToCard;

  PROCEDURE LongCardToStr(x: LONGCARD; VAR s: ARRAY OF CHAR; VAR ok: BOOLEAN);
    VAR
      x0: LONGCARD;
      j, len: CARDINAL;
    BEGIN
      x0 := x;
      len := 0;
      WHILE x0 > 0 DO x0 := x0 DIV 10; INC(len) END;
      IF len = 0 THEN INC(len) END;
      IF len - 1 <= HIGH(s) THEN
        IF len - 1 < HIGH(s) THEN s[len] := 0C END;
        FOR j := len - 1 TO 0 BY -1 DO
          s[j] := CHR(VAL(CARDINAL, x MOD 10) + ORD("0"));
          x := x DIV 10;
        END;
        ok := TRUE;
      ELSE
        ok := FALSE;
      END
    END LongCardToStr;

  PROCEDURE CardToStr(x: CARDINAL; VAR s: ARRAY OF CHAR; VAR ok: BOOLEAN);
    BEGIN
      LongCardToStr(VAL(LONGCARD, x), s, ok);
    END CardToStr;

  (* ========================================== Search for private windows *)

  PROCEDURE SearchWindows(VAR s: ARRAY OF Win.WINDOW; VAR n: CARDINAL);
    VAR
      u: Win.WINDOW;
      a: Win.Attrs;
      j: CARDINAL;
    BEGIN
      j := 0;
      u := Win.Top();
      WHILE Win.Exist(u) DO
        Win.Attributes(u, a);
        IF
          (a.titleAttrs.titleStyle = Win.titleText) AND
          (a.titleAttrs.titleTextStr[0] = WinMark) AND
          (j <= HIGH(s))
        THEN
          s[j] := u;
          INC(j);
        END;
        u := Win.Next(u);
      END;
      n := j;
    END SearchWindows;

  (* =================================== Autodemo control *)

  TYPE
    DemoMode = (manual, intermediate, automatic);

  VAR
    demoMode: DemoMode;
    waitMark, loadKeyCurrent: CARDINAL;

  PROCEDURE Auto();
    CONST
      WaitRange = 12;   (* --- check wait mark with probability 1/12 *)
    BEGIN
      CASE demoMode OF
      | manual:
        (* ----------------------------------- manual demo control *)
        waitMark := DrvClk.Time() + TimeOut * 8;
        demoMode := intermediate;
      | intermediate:
        (* ---------------------------------------------- wait mark was set *)
        IF (CardRandom(WaitRange) = 0) AND (DrvClk.Time() >= waitMark) THEN
          loadKeyCurrent := 0;
          demoMode := automatic;
        END;
      | automatic:
        (* ---------------------------------- automatic demo control *)
        DrvKbd.Write(loadKey[loadKeyCurrent]);
        loadKeyCurrent := (loadKeyCurrent + 1) MOD loadKeysNmb;
      END;
    END Auto;

  PROCEDURE CheckDosKbd();
    BEGIN
      IF DrvKbd.KeyHit() THEN demoMode := manual END;
    END CheckDosKbd;

  (* ==================================================== User input *)

  PROCEDURE GetPos(wait: PROC; VAR dx, dy: INTEGER): ScrInp.Action;
    VAR
      key, count: CARDINAL;
    BEGIN
      LOOP
        (* ---------------- check keys in DOS buffer *)
        CheckDosKbd();
        (* --------------------------- get keys sequence *)
        IF DrvKbd.GetSequence(key, count) THEN
          (* ------------------------------- keyboard actions *)
          CASE key OF
          | DrvKbd.Home:
            dx := - VAL(INTEGER, count * sx);
            dy := - VAL(INTEGER, count * sy);
            RETURN ScrInp.move;
          | DrvKbd.UpArrow, DrvKbd.CtrlE:
            dx :=   0;
            dy := - VAL(INTEGER, count * sy);
            RETURN ScrInp.move;
          | DrvKbd.PageUp:
            dx :=   VAL(INTEGER, count * sx);
            dy := - VAL(INTEGER, count * sy);
            RETURN ScrInp.move;
          | DrvKbd.LeftArrow, DrvKbd.CtrlS:
            dx := - VAL(INTEGER, count * sx);
            dy :=   0;
            RETURN ScrInp.move;
          | DrvKbd.RightArrow, DrvKbd.CtrlD:
            dx :=   VAL(INTEGER, count * sx);
            dy :=   0;
            RETURN ScrInp.move;
          | DrvKbd.End:
            dx := - VAL(INTEGER, count * sx);
            dy :=   VAL(INTEGER, count * sy);
            RETURN ScrInp.move;
          | DrvKbd.DownArrow, DrvKbd.CtrlX:
            dx :=   0;
            dy :=   VAL(INTEGER, count * sy);
            RETURN ScrInp.move;
          | DrvKbd.PageDown:
            dx :=   VAL(INTEGER, count * sx);
            dy :=   VAL(INTEGER, count * sy);
            RETURN ScrInp.move;
          | DrvKbd.Enter:
            RETURN ScrInp.enter;
          | DrvKbd.Escape:
            RETURN ScrInp.escape;
          | DrvKbd.CtrlV:
            sx := sxMax + 1 - sx;
            sy := syMax + 1 - sy;
          | DrvKbd.CtrlH:
            RETURN ScrInp.toggleWhole;
          | DrvKbd.Tab:
            RETURN ScrInp.nextCorner;
          ELSE
            DrvSnd.Error();
          END;
        ELSE
          (* ------------- no actions: wait *)
          wait();
        END;
      END;
    END GetPos;

  PROCEDURE GetTxt(wait: PROC; VAR ch: CHAR; VAR dx, dy: INTEGER): ScrInp.Action;
    VAR
      key, count: CARDINAL;
    BEGIN
      LOOP
        (* ---------------- check keys in DOS buffer *)
        CheckDosKbd();
        (* --------------------------- get keys sequence *)
        IF DrvKbd.GetSequence(key, count) THEN
          (* --------------------------- keyboard actions *)
          CASE key OF
            (* ----------------------------- position moving *)
          | DrvKbd.CtrlE:
            dx :=   0;
            dy := - VAL(INTEGER, count * sy);
            RETURN ScrInp.move;
          | DrvKbd.CtrlS:
            dx := - VAL(INTEGER, count * sx);
            dy :=   0;
            RETURN ScrInp.move;
          | DrvKbd.CtrlD:
            dx :=   VAL(INTEGER, count * sx);
            dy :=   0;
            RETURN ScrInp.move;
          | DrvKbd.CtrlX:
            dx :=   0;
            dy :=   VAL(INTEGER, count * sy);
            RETURN ScrInp.move;
            (* ------------------------ cursor moving *)
          | DrvKbd.LeftArrow:
            RETURN ScrInp.prevChar;
          | DrvKbd.RightArrow:
            RETURN ScrInp.nextChar;
          | DrvKbd.CtrlLeftArrow:
            RETURN ScrInp.prevWord;
          | DrvKbd.CtrlRightArrow:
            RETURN ScrInp.nextWord;
          | DrvKbd.Home:
            RETURN ScrInp.home;
          | DrvKbd.End:
            RETURN ScrInp.end;
            (* ----------------------- exit *)
          | DrvKbd.Enter:
            RETURN ScrInp.enter;
          | DrvKbd.Escape:
            RETURN ScrInp.escape;
            (* ------------------------ toggles *)
          | DrvKbd.Insert:
            RETURN ScrInp.toggleInsMode;
          | DrvKbd.CtrlV:
            sx := sxMax + 1 - sx;
            sy := syMax + 1 - sy;
            (* --------------------------- deletion *)
          | DrvKbd.Delete:
            RETURN ScrInp.delChar;
          | DrvKbd.BackSpace:
            RETURN ScrInp.delLeftChar;
          | DrvKbd.CtrlT:
            RETURN ScrInp.delRightWord;
          | DrvKbd.CtrlK:
            RETURN ScrInp.delRightStr;
          | DrvKbd.CtrlY:
            RETURN ScrInp.delStr;
            (* ------------------------ characters *)
          | ORD(" ") .. ORD(MAX(CHAR)):
            ch := CHR(key);
            RETURN ScrInp.char;
          ELSE
          END;
        ELSE
          (* ------------- no actions: wait *)
          wait();
        END;
      END;
    END GetTxt;

  PROCEDURE GetFace(wait: PROC): DlgInp.Action;
    VAR
      key: CARDINAL;
    BEGIN
      LOOP
        (* ---------------- check keys in DOS buffer *)
        CheckDosKbd();
        (* ------------------------------------- get key *)
        IF DrvKbd.Get(key) THEN
          (* ----------------------------- keyboard actions *)
          CASE key OF
          | DrvKbd.Home:
            RETURN DlgInp.first;
          | DrvKbd.UpArrow:
            RETURN DlgInp.up;
          | DrvKbd.LeftArrow:
            RETURN DlgInp.left;
          | DrvKbd.RightArrow:
            RETURN DlgInp.right;
          | DrvKbd.End:
            RETURN DlgInp.last;
          | DrvKbd.DownArrow:
            RETURN DlgInp.down;
          | DrvKbd.Enter:
            RETURN DlgInp.enter;
          | DrvKbd.Escape:
            RETURN DlgInp.escape;
          ELSE
            DrvSnd.Error();
          END;
        ELSE
          (* ------------- no actions: wait *)
          wait();
        END;
      END;
    END GetFace;

  (* ================================================== Timing *)

  VAR
    endMark: CARDINAL;

  PROCEDURE SetEndMark(i: CARDINAL);
  (* --------------- set time mark in future for end of repeating *)
    BEGIN
      endMark := DrvClk.Time() + i;
    END SetEndMark;

  PROCEDURE EndRepeat(): BOOLEAN;
    CONST
      TimeRange = 20;  (* --- check time with probability 1/20 *)
    VAR
      key: CARDINAL;
    BEGIN
      CheckDosKbd();
      RETURN
        DrvKbd.Get(key) OR
        ((CardRandom(TimeRange) = 0) AND (DrvClk.Time() >= endMark));
    END EndRepeat;

  (* ====================================== "No memory" situation *)

  VAR
    buffAllocated: BOOLEAN;

  PROCEDURE Alloc();
    BEGIN
      IF NOT buffAllocated AND DrvMem.Alloc(heapBuffPtr, HeapBuffLen) THEN
        buffAllocated := TRUE;
      END;
    END Alloc;

  PROCEDURE Free();
    BEGIN
      IF buffAllocated THEN
        DrvMem.Free(heapBuffPtr, HeapBuffLen);
        buffAllocated := FALSE;
      END;
    END Free;

  PROCEDURE NoMemory();
    CONST
      WinNmb = 120;
    VAR
      n: CARDINAL;
      u: ARRAY [0 .. WinNmb - 1] OF Win.WINDOW;
      res: Res.Status;
    BEGIN
      Free();
      REPEAT
        (* ----------------- show the message *)
        res := Dlg.Show(plx, NoMemoryMsg);
        SetEndMark(TimeOut * 2);
        REPEAT UNTIL EndRepeat();
        res := Dlg.Hide(plx, NoMemoryMsg);
        (* ----------- search and dispose the first created window *)
        IF winNmb > 0 THEN
          SearchWindows(u, n);
          res := Win.Dispose(u[n - 1]);
          DEC(winNmb);
        END;
        (* -------------- alllocate the buffer again *)
        Alloc();
      UNTIL buffAllocated;
    END NoMemory;

  (* ===================================== Heap-unsensible procedure calls *)

  PROCEDURE InCall(res: Res.Status): BOOLEAN;
    BEGIN
      CASE res OF
      | Res.done:     RETURN TRUE;
      | Res.noMemory: NoMemory(); RETURN FALSE;
      ELSE            RETURN FALSE;
      END;
    END InCall;

  PROCEDURE Call(res: Res.Status);
    BEGIN
      IF res = Res.noMemory THEN NoMemory() END;
    END Call;

  (* ================================== Running/hiding lines *)

  PROCEDURE Run(i: CARDINAL);
    BEGIN
      Auto();
      Call(Dlg.Show(plx, i));
    END Run;

  PROCEDURE LineHide(i: CARDINAL);
    BEGIN
      Call(Dlg.Hide(plx, i));
    END LineHide;

  (* ========================================= Background procedures *)

  PROCEDURE Empty(); BEGIN Auto() END Empty;

  PROCEDURE MainRun(); BEGIN Run(MainLine) END MainRun;

  PROCEDURE GeometryRun(); BEGIN Run(GeometryLine) END GeometryRun;

  PROCEDURE SelectRun(); BEGIN Run(SelectLine) END SelectRun;

  (* ========================================================== Messages *)

  PROCEDURE DisplayMsg(n: CARDINAL);
    BEGIN
      Call(Dlg.Show(plx, n));
      SetEndMark(TimeOut * 2);
      REPEAT UNTIL EndRepeat();
      Call(Dlg.Hide(plx, n));
    END DisplayMsg;

  (* ================================ Initialization of parameters *)

  PROCEDURE InitParams();
    CONST
      WinNmb = 120;
    VAR
      n, j: CARDINAL;
      u: ARRAY [0 .. WinNmb - 1] OF Win.WINDOW;
    BEGIN
      IF winNmb > 0 THEN
        SearchWindows(u, n);
        FOR j := 0 TO n - 1 DO
          Call(Win.Dispose(u[j]));
          IF NOT Win.Exist(u[j]) THEN DEC(winNmb) END;
        END;
      END;
      winCounter := 0;
      cursPt := invalidPt;
      cursRect := invalidRect;
      winHiddenNmb := 0;
      sx := sxMax;
      sy := syMax;
      DrvKbd.Clear();
    END InitParams;

  (* ================================================ Input *)

  PROCEDURE InPoint(VAR p: Geo.Point; wait: PROC): BOOLEAN;
    CONST
      MarkerSize = 1000;
    VAR
      a: ScrOut.Attrs;
    BEGIN
      ScrOut.SetMarkAttrs(a, Scr.xor, CursColor(), ScrOut.plus, MarkerSize);
      RETURN InCall(ScrInp.Marker(vpm, a, p, wait, GetPos));
    END InPoint;

  PROCEDURE InRect(VAR r: Geo.Rectangle; wait: PROC): BOOLEAN;
    CONST
      MarkerSize = 10;
    VAR
      a: ScrOut.Attrs;
    BEGIN
      a.function := Scr.xor;
      a.color := CursColor();
      a.auxColor := AuxCursColor();
      a.markerStyle := ScrOut.cross;
      a.markerSize := MarkerSize;
      a.fillStyle := ScrOut.fillSolid;
      RETURN InCall(ScrInp.Rectangle(vpm, a, r, wait, GetPos))
    END InRect;

  (* ================================================ Window preparation *)

  PROCEDURE PrepareWin(VAR u: Win.WINDOW; VAR w, h: CARDINAL): BOOLEAN;
    VAR
      wa: Win.Attrs;
    BEGIN
      IF winNmb = 0 THEN
        DisplayMsg(NoOpenedWinMsg);
        RETURN FALSE;
      ELSIF winNmb = winHiddenNmb THEN
        DisplayMsg(NoVisibleWinMsg);
        RETURN FALSE;
      ELSIF InPoint(cursPt, SelectRun) THEN
        LineHide(SelectLine);
        u := Win.Find(cursPt);
        IF Win.Exist(u) THEN
          WinOut.Clear(u, 0);
          Win.Attributes(u, wa);
          w := wa.wdt;
          h := wa.hgt;
          fully := Win.FullyVisible(u);
          IF NOT fully THEN
            Call(Dlg.Show(plx, NotFullyVisMsg));
          END;
          RETURN TRUE;
        ELSE
          RETURN FALSE;
        END;
      ELSE
        LineHide(SelectLine);
        RETURN FALSE;
      END;
    END PrepareWin;

  PROCEDURE ReleaseWin(VAR u: Win.WINDOW);
    BEGIN
      IF (winNmb # 0) AND NOT fully THEN
        Call(Dlg.Hide(plx, NotFullyVisMsg));
        Call(Win.Update(u));
      END;
    END ReleaseWin;

  (* ============================================== Boxes *)

  TYPE
    Box =
      RECORD
        s0: CARDINAL;
        r0: Geo.Rectangle;
        dx, dy: [-1 .. +1];
      END;

  PROCEDURE InitBox(w, h, s: CARDINAL; VAR p: Geo.Point; VAR b: Box);
    VAR
      wx, wy, dmax, d0: CARDINAL;
    BEGIN
      Geo.SetRect(b.r0, 0, w - 1, 0, h - 1);
      (* ---------- set initial point *)
      p.ix := CardRandom(w);
      p.iy := CardRandom(h);
      (* ---------- determine rectangle halfsizes *)
      wx := w DIV 2;
      wy := h DIV 2;
      (* ---------- dmax is maximum width of return zone! *)
      IF wx < wy THEN
        dmax := wx;
      ELSE
        dmax := wy;
      END;
      (* -------- find width of return zone *)
      IF s - 1 <= dmax THEN
        d0 := s - 1;
      ELSE
        d0 := dmax;
      END;
      (* --------- correct rectangle *)
      INC(b.r0.ixMin, d0);
      DEC(b.r0.ixMax, d0);
      INC(b.r0.iyMin, d0);
      DEC(b.r0.iyMax, d0);
      (* ------------ set maximum step *)
      b.s0 := d0 + 1;
      (* ------------------ set initial directions *)
      b.dx := 2 * VAL(INTEGER, CardRandom(2)) - 1;
      b.dy := 2 * VAL(INTEGER, CardRandom(2)) - 1;
    END InitBox;

  PROCEDURE ChangePoint(VAR p: Geo.Point; VAR b: Box);
    CONST
      ProbDirChange = 60;
    BEGIN
      IF p.ix < b.r0.ixMin THEN
        b.dx := + 1;
      ELSIF p.ix > b.r0.ixMax THEN
        b.dx := - 1;
      ELSIF CardRandom(ProbDirChange) = 0 THEN
        b.dx := - b.dx;
      END;
      IF p.iy < b.r0.iyMin THEN
        b.dy := + 1;
      ELSIF p.iy > b.r0.iyMax THEN
        b.dy := - 1;
      ELSIF CardRandom(ProbDirChange) = 0 THEN
        b.dy := - b.dy;
      END;
      INC(p.ix, b.dx * VAL(INTEGER, CardRandom(b.s0)));
      INC(p.iy, b.dy * VAL(INTEGER, CardRandom(b.s0)));
    END ChangePoint;

  (* ============================================ Demo procedures *)

  PROCEDURE Markers(mt: ScrOut.MarkerStyle);
    CONST
      MarkerColorMaxLen = 20;
      SizeFactor = 16;
    VAR
      u: Win.WINDOW;
      p: Geo.Point;
      a: ScrOut.Attrs;
      wdt, hgt, j, sizeMax: CARDINAL;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        (* ------------------------ init attributes *)
        ScrOut.SetMarkAttrs(a, Scr.copy, 0, mt, 0);
        (* ---------------- set limits for random numbers *)
        IF wdt < hgt THEN
          sizeMax := wdt DIV SizeFactor + 1;
        ELSE
          sizeMax := hgt DIV SizeFactor + 1;
        END;
        (* ------------------------------------------- drawing *)
        SetEndMark(TimeOut);
        REPEAT
          (* ------------------------------------ set attributes *)
          a.color := RandomColor();
          a.markerSize := 1 + CardRandom(sizeMax);
          IF a.markerStyle = ScrOut.dot THEN
            a.function := Scr.xor;
          END;
          (* ---------------------------------------------- output *)
          FOR j := 0 TO CardRandom(MarkerColorMaxLen) DO
            p.ix := CardRandom(wdt);
            p.iy := CardRandom(hgt);
            WinOut.Marker(u, a, p);
          END;
        UNTIL EndRepeat();
        ReleaseWin(u);
      END;
    END Markers;

  PROCEDURE Polylines();
    CONST
      LineColorMaxLen = 30;
      LineSpeed = 5;
      NodesNmb = 6;
    VAR
      u: Win.WINDOW;
      bs: ARRAY [0 .. NodesNmb - 1] OF Box;
      ps: ARRAY [0 .. NodesNmb - 1] OF Geo.Point;
      st: Res.Status;
      a: ScrOut.Attrs;
      wdt, hgt, j, k: CARDINAL;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        (* -------------------- init attributes *)
        ScrOut.SetLineAttrs(a, Scr.copy, 0);
        (* ---------------------------------- set boxes *)
        FOR k := 0 TO NodesNmb - 1 DO
          InitBox(wdt, hgt, LineSpeed, ps[k], bs[k]);
        END;
        (* -------------------------- drawing *)
        SetEndMark(TimeOut);
        REPEAT
          (* ----------------------------- set attributes *)
          a.color := RandomColor();
          (* -------------------------------------------- output *)
          FOR j := 0 TO CardRandom(LineColorMaxLen) DO
            st := WinOut.Polyline(u, a, ps, 0, NodesNmb - 1, TRUE);
            FOR k := 0 TO NodesNmb - 1 DO
              ChangePoint(ps[k], bs[k]);
            END;
          END;
        UNTIL EndRepeat();
        ReleaseWin(u);
      END;
    END Polylines;

  PROCEDURE Rectangles();
    CONST
      RectSpeed = 12;
    VAR
      u: Win.WINDOW;
      rect: Geo.Rectangle;
      b1, b2: Box;
      p1, p2: Geo.Point;
      wdt, hgt: CARDINAL;
      a: ScrOut.Attrs;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        (* --------------- init attributes *)
        ScrOut.SetLineAttrs(a, Scr.copy, 0);
        (* -------------------------- set boxes *)
        InitBox(wdt, hgt, RectSpeed, p1, b1);
        InitBox(wdt, hgt, RectSpeed, p2, b2);
        Geo.SetRectPt(rect, p1, p2);
        (* ------------------ drawing *)
        SetEndMark(TimeOut);
        REPEAT
          (* ------------------- set attributes *)
          a.color := RandomColor();
          (* ----------------------------------- output *)
          WinOut.Rectangle(u, a, rect);
          (* ------------------- set next rectangle *)
          ChangePoint(p1, b1);
          ChangePoint(p2, b2);
          Geo.SetRectPt(rect, p1, p2);
        UNTIL EndRepeat();
        ReleaseWin(u);
      END;
    END Rectangles;

  PROCEDURE Ellipses();
    CONST
      EllipseColorMaxLen = 10;
      RadFactor = 4;
    VAR
      u: Win.WINDOW;
      p: Geo.Point;
      wdt, hgt, j, a0, b0, radMax: CARDINAL;
      a: ScrOut.Attrs;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        (* ---------------- init attributes *)
        ScrOut.SetLineAttrs(a, Scr.copy, 0);
        (* ------------------ set limits for radius *)
        IF wdt < hgt THEN
          radMax := wdt DIV RadFactor + 1;
        ELSE
          radMax := hgt DIV RadFactor + 1;
        END;
        (* --------------------------- drawing *)
        SetEndMark(TimeOut);
        REPEAT
          (* --------------------------- set attributes *)
          a.color := RandomColor();
          (* ----------------------------------------- output *)
          FOR j := 0 TO CardRandom(EllipseColorMaxLen) DO
            p.ix := CardRandom(wdt);
            p.iy := CardRandom(hgt);
            a0 := CardRandom(radMax);
            b0 := CardRandom(radMax);
            WinOut.Ellipse(u, a, p, a0, b0);
          END;
        UNTIL EndRepeat();
        ReleaseWin(u);
      END;
    END Ellipses;

  PROCEDURE Texts();
    CONST
      TextColorMaxLen = 10;
      String = "AbCdEfGhIjKlMnOpQrStUvWxYz";
      StrMax = 28;
    VAR
      u: Win.WINDOW;
      p: Geo.Point;
      str: ARRAY [0 .. StrMax] OF CHAR;
      wdt, hgt, j: CARDINAL;
      a: ScrOut.Attrs;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        (* --------------------- init attributes *)
        ScrOut.SetTextAttrs
        (
          a,
          Scr.copy, 0, 0,
          ScrOut.fillStippled, ScrOut.FONT(NIL)
        );
        (* ------------------------------------- drawing *)
        SetEndMark(TimeOut);
        REPEAT
          (* ---------------------------------- set attributes *)
          a.font := RandomFont();
          a.color := RandomColor();
          (* ------------------------------ get random part of string *)
          Strings.Copy(String, CardRandom(StrMax), CardRandom(StrMax), str);
          (* ------------------------------------------------ output *)
          FOR j := 0 TO CardRandom(TextColorMaxLen) DO
            p.ix := CardRandom(wdt);
            p.iy := CardRandom(hgt);
            WinOut.String(u, a, p, str);
          END;
        UNTIL EndRepeat();
        ReleaseWin(u);
      END;
    END Texts;

  PROCEDURE FillRectangles(ft: ScrOut.FillStyle);
    CONST
      RectSpeed = 12;
    VAR
      u: Win.WINDOW;
      rect: Geo.Rectangle;
      b1, b2: Box;
      p1, p2: Geo.Point;
      wdt, hgt: CARDINAL;
      a: ScrOut.Attrs;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        (* --------------- init attributes *)
        ScrOut.SetFillAttrs
        (
          a,
          Scr.copy, 0, 0,
          ft, hatchFont, nullPt, 0
        );
        (* -------------------------- set boxes *)
        InitBox(wdt, hgt, RectSpeed, p1, b1);
        InitBox(wdt, hgt, RectSpeed, p2, b2);
        Geo.SetRectPt(rect, p1, p2);
        (* -------------------------------- drawing *)
        SetEndMark(TimeOut);
        REPEAT
          (* -------------------- set fill attributes *)
          a.color := RandomColor();
          a.fillStippleNo := CardRandom(hatchesNmb);
          (* ---------------------------------- output *)
          WinOut.FillRectangle(u, a, rect);
          (* -------------------- set next rectangle *)
          ChangePoint(p1, b1);
          ChangePoint(p2, b2);
          Geo.SetRectPt(rect, p1, p2);
        UNTIL EndRepeat();
        ReleaseWin(u);
      END;
    END FillRectangles;

  PROCEDURE FillEllipses(ft: ScrOut.FillStyle);
    CONST
      RadFactor = 4;
    VAR
      u: Win.WINDOW;
      p: Geo.Point;
      wdt, hgt, j, a0, b0, radMax: CARDINAL;
      a: ScrOut.Attrs;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        (* --------------- init attributes *)
        ScrOut.SetFillAttrs
        (
          a,
          Scr.copy, 0, 0,
          ft, hatchFont, nullPt, 0
        );
        (* ---------------- set limits for radius *)
        IF wdt < hgt THEN
          radMax := wdt DIV RadFactor + 1;
        ELSE
          radMax := hgt DIV RadFactor + 1;
        END;
        (* ----------------------------------- drawing *)
        SetEndMark(TimeOut);
        REPEAT
          (* ---------------------- set fill attributes *)
          a.color := RandomColor();
          a.fillStippleNo := CardRandom(hatchesNmb);
          (* --------------------------------- output *)
          p.ix := CardRandom(wdt);
          p.iy := CardRandom(hgt);
          a0 := CardRandom(radMax);
          b0 := CardRandom(radMax);
          WinOut.FillEllipse(u, a, p, a0, b0);
        UNTIL EndRepeat();
        ReleaseWin(u);
      END;
    END FillEllipses;

  PROCEDURE FillPolygons(ft: ScrOut.FillStyle);
    CONST
      NodesNmb = 5;
    VAR
      u: Win.WINDOW;
      ps: ARRAY [0 .. NodesNmb - 1] OF Geo.Point;
      st: Res.Status;
      a: ScrOut.Attrs;
      wdt, hgt, k: CARDINAL;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        (* --------------- init attributes *)
        ScrOut.SetFillAttrs
        (
          a,
          Scr.copy, 0, 0,
          ft, hatchFont, nullPt, 0
        );
        (* --------------------------------- drawing *)
        SetEndMark(TimeOut);
        REPEAT
          (* ------------------------ set fill attributes *)
          a.color := RandomColor();
          a.fillStippleNo := CardRandom(hatchesNmb);
          (* -------------------------------------------- set nodes *)
          FOR k := 0 TO NodesNmb - 1 DO
            ps[k].ix := CardRandom(wdt);
            ps[k].iy := CardRandom(hgt);
          END;
          (* ------------------------------------------- output *)
          st := WinOut.FillPolygon(u, a, ps, 0, NodesNmb - 1);
        UNTIL EndRepeat();
        ReleaseWin(u);
      END;
    END FillPolygons;

  PROCEDURE InPoints(mt: ScrOut.MarkerStyle);
    CONST
      MarkerSize = 10;
    VAR
      u: Win.WINDOW;
      p: Geo.Point;
      a: ScrOut.Attrs;
      wdt, hgt, key: CARDINAL;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        p := invalidPt;
        (* ----------------------------------------- init attributes *)
        ScrOut.SetMarkAttrs(a, Scr.xor, CursColor(), mt, MarkerSize);
        (* --------------------------------------------------- point input *)
        IF fully THEN
          IF InCall(WinInp.Marker(u, a, p, Empty, GetPos)) THEN
            WinOut.Marker(u, a, p);
          END;
        ELSE
          SetEndMark(TimeOut);
          REPEAT UNTIL EndRepeat();
        END;
        (* ------------------ epilogue *)
        ReleaseWin(u);
      END;
    END InPoints;

  PROCEDURE InRectangles();
    CONST
      MarkerSize = 10;
    VAR
      u: Win.WINDOW;
      r: Geo.Rectangle;
      a: ScrOut.Attrs;
      wdt, hgt, key: CARDINAL;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        r := invalidRect;
        (* ------------------------ init attributes *)
        a.function := Scr.xor;
        a.color := CursColor();
        a.auxColor := AuxCursColor();
        a.markerStyle := ScrOut.cross;
        a.markerSize := MarkerSize;
        a.fillStyle := ScrOut.fillSolid;
        (* ---------------------------------------------------------- rectangle input *)
        IF fully THEN
          IF InCall(WinInp.Rectangle(u, a, r, Empty, GetPos)) THEN
            WinOut.Rectangle(u, a, r);
          END;
        ELSE
          SetEndMark(TimeOut);
          REPEAT UNTIL EndRepeat();
        END;
        (* ---------------- epilogue *)
        ReleaseWin(u);
      END;
    END InRectangles;

  PROCEDURE InStrings();
    CONST
      StrLen = 256;
      XBasePt = 1;
      YBasePt = 1;
    VAR
      u: Win.WINDOW;
      p: Geo.Point;
      a: ScrOut.Attrs;
      wdt, hgt, key: CARDINAL;
      s: ARRAY [0 .. StrLen - 1] OF CHAR;
    BEGIN
      IF PrepareWin(u, wdt, hgt) THEN
        Strings.Assign(infoStr[initString], s);
        (* ----------------------------------- init attributes *)
        ScrOut.SetTextAttrs
        (
          a,
          Scr.xor, CursColor(), AuxCursColor(),
          ScrOut.fillStippled, mainFont
        );
        a.fillStippleNo := ScrInp.Underbar;
        (* ----------------------------------------------- string input *)
        IF fully THEN
          p.ix := XBasePt;
          p.iy := YBasePt;
          IF InCall(WinInp.String(u, a, p, s, Empty, GetTxt)) THEN
            WinOut.String(u, a, p, s);
          END;
        ELSE
          SetEndMark(TimeOut);
          REPEAT UNTIL EndRepeat();
        END;
        (* -------------- epilogue *)
        ReleaseWin(u);
      END;
    END InStrings;

  PROCEDURE WinOpen();
    CONST
      TextGap = 1;
    VAR
      u: Win.WINDOW;
      wa: Win.Attrs;
      s: TextString;
      col: Scr.Pixel;
      ok: BOOLEAN;
    BEGIN
      IF InRect(cursRect, GeometryRun) THEN
        (* ------------------- hide geometry running line *)
        LineHide(GeometryLine);
        (* --------------------------------------- set color *)
        col := RandomColor();
        (* --------------------------------------- set rectangle *)
        wa.basePt.ix := cursRect.ixMin;
        wa.basePt.iy := cursRect.iyMin;
        wa.wdt := cursRect.ixMax - cursRect.ixMin + 1;
        wa.hgt := cursRect.iyMax - cursRect.iyMin + 1;
        (* --------------------------------------- set frame attributes *)
        wa.frameAttrs.frameStyle := Win.frameLine;
        wa.frameAttrs.frameColor := col;
        (* ------------------------------------------- set title attributes *)
        wa.titleAttrs.titleStyle := Win.titleText;
        INC(winCounter);
        CardToStr(winCounter, s, ok);
        Strings.Concat(WinMark, s, wa.titleAttrs.titleTextStr);
        wa.titleAttrs.titleColor := 0;
        wa.titleAttrs.titleAuxColor := col;
        wa.titleAttrs.titleFont := mainFont;
        wa.titleAttrs.titleTextGap := TextGap;
        (* ------------------------- create and show the window *)
        Call(Win.New(wa, u));
        IF Win.Exist(u) THEN
          Call(Win.Show(u));
          INC(winNmb);
        END;
      ELSE
        LineHide(GeometryLine);
      END;
    END WinOpen;

  PROCEDURE WinExec(proc: ExecWin);
    VAR
      key: CARDINAL;
      u: Win.WINDOW;
    BEGIN
      IF winNmb = 0 THEN
        DisplayMsg(NoOpenedWinMsg);
      ELSIF winNmb = winHiddenNmb THEN
        DisplayMsg(NoVisibleWinMsg);
      ELSIF InPoint(cursPt, SelectRun) THEN
        LineHide(SelectLine);
        u := Win.Find(cursPt);
        IF Win.Exist(u) THEN proc(u) END;
      ELSE
        LineHide(SelectLine);
      END;
    END WinExec;

  PROCEDURE WinClose(u: Win.WINDOW);
    BEGIN
      Call(Win.Dispose(u));
      IF NOT Win.Exist(u) THEN DEC(winNmb) END;
    END WinClose;

  PROCEDURE PutOnTop(u: Win.WINDOW);
    BEGIN
      Call(Win.PutOnTop(u));
    END PutOnTop;

  PROCEDURE Hide(u: Win.WINDOW);
    BEGIN
      Call(Win.Hide(u));
      IF Win.Hidden(u) THEN INC(winHiddenNmb) END;
    END Hide;

  PROCEDURE ClearAndUpdate(u: Win.WINDOW);
    BEGIN
      WinOut.Clear(u, 0);
      Call(Win.Update(u));
    END ClearAndUpdate;

  PROCEDURE Change(u: Win.WINDOW);
    VAR
      wa: Win.Attrs;
      pt: Geo.Point;
      dx, dy: INTEGER;
    BEGIN
      (* ------------ get attributes *)
      Win.Attributes(u, wa);
      (* -------------------- initialize the cursor *)
      cursRect.ixMin := wa.basePt.ix;
      cursRect.iyMin := wa.basePt.iy;
      cursRect.ixMax := wa.basePt.ix + VAL(INTEGER, wa.wdt) - 1;
      cursRect.iyMax := wa.basePt.iy + VAL(INTEGER, wa.hgt) - 1;
      (* ------------------------------ get new geometry parameters *)
      IF InRect(cursRect, GeometryRun) THEN
        (* -------------------------------- hide geometry running line *)
        LineHide(GeometryLine);
        (* ----------------------------- set geometry parameters *)
        pt.ix := cursRect.ixMin;
        pt.iy := cursRect.iyMin;
        dx := cursRect.ixMax - cursRect.ixMin + 1;
        dy := cursRect.iyMax - cursRect.iyMin + 1;
        (* -------------------- create and show the window *)
        Call(Win.Hide(u));
        Call(Win.Move(u, pt));
        Call(Win.Resize(u, dx, dy));
        Call(Win.Show(u));
      ELSE
        (* ---------------- break: only hide *)
        LineHide(GeometryLine);
      END;
    END Change;

  PROCEDURE Reframe(u: Win.WINDOW);
    VAR
      wa: Win.Attrs;
    BEGIN
      Win.Attributes(u, wa);
      WITH wa.frameAttrs DO
        CASE frameStyle OF
        | Win.frameEmpty:
          frameStyle := Win.frameLine;
          frameColor := RandomColor();
        | Win.frameLine:
          frameStyle := Win.frameText;
          IF CardRandom(2) = 0 THEN
            frameTextStr := Win.SingleFrame;
          ELSE
            frameTextStr := Win.DoubleFrame;
          END;
          frameAuxColor := RandomColor();
        | Win.frameText:
          frameStyle := Win.frameEmpty;
        END;
      END;
      Call(Win.Reframe(u, wa.frameAttrs));
    END Reframe;

  PROCEDURE Retitle(u: Win.WINDOW);
    VAR
      wa: Win.Attrs;
    BEGIN
      Win.Attributes(u, wa);
      WITH wa.titleAttrs DO
        CASE titleStyle OF
        | Win.titleEmpty:
          titleStyle := Win.titleText;
        | Win.titleText:
          titleStyle := Win.titleEmpty;
        END;
      END;
      Call(Win.Retitle(u, wa.titleAttrs));
    END Retitle;

  PROCEDURE ShowAll();
    CONST
      WinNmb = 120;
    VAR
      n, j: CARDINAL;
      u: ARRAY [0 .. WinNmb - 1] OF Win.WINDOW;
    BEGIN
      IF winHiddenNmb > 0 THEN
        SearchWindows(u, n);
        FOR j := 0 TO n - 1 DO
          IF Win.Hidden(u[j]) THEN
            Call(Win.Show(u[j]));
            DEC(winHiddenNmb);
          END;
        END;
      END;
    END ShowAll;

  (* ============================ Numbers of demo procedures *)

  CONST
    ExitNmb = 1;
    (* ---------------- *)
    HelpWinOpenNmb = 3;
    HelpWinSelectNmb = 4;
    (* -------------------- *)
    MarkersDotNmb = 40;
    MarkersPlusNmb = 41;
    MarkersAsteriskNmb = 42;
    MarkersCircleNmb = 43;
    MarkersCrossNmb = 44;
    MarkersSquareNmb = 45;
    (* ------------------------ *)
    PolylinesNmb = 10;
    RectanglesNmb = 11;
    EllipsesNmb = 12;
    (* --------------------------- *)
    SolidRectanglesNmb = 14;
    StippledRectanglesNmb = 15;
    SolidEllipsesNmb = 16;
    StippledEllipsesNmb = 17;
    SolidPolygonsNmb = 18;
    StippledPolygonsNmb = 19;
    (* ----------------------- *)
    TextsNmb = 2;
    (* ------------------- *)
    InDotNmb = 50;
    InPlusNmb = 53;
    InAsteriskNmb = 56;
    InCircleNmb = 59;
    InCrossNmb = 62;
    InSquareNmb = 65;
    InRectanglesNmb = 70;
    InStringsNmb = 80;
    (* -------------------- *)
    WinOpenNmb = 20;
    WinCloseNmb = 21;
    WinTopNmb = 22;
    WinHideNmb = 23;
    WinClearNmb = 24;
    WinShowAllNmb = 25;
    WinChangeNmb = 26;
    WinReframeNmb = 28;
    WinRetitleNmb = 29;
    (* ------------------- *)
    PalInitNmb = 130;
    PalNextNmb = 131;
    PalPrevNmb = 132;
    (* ------------------------- *)
    ViewWidthNmb = 140;
    ViewHeightNmb = 141;
    ViewColorsNmb = 142;
    EditPaletteNmb = 143;

  PROCEDURE DoFunc();
    BEGIN
      CASE key OF
      (* ------------------------------------- *)
      | PolylinesNmb:
        Polylines();
      | RectanglesNmb:
        Rectangles();
      | EllipsesNmb:
        Ellipses();
      | TextsNmb:
        Texts();
      (* ------------------------- *)
      | MarkersDotNmb:
        Markers(ScrOut.dot);
      | MarkersPlusNmb:
        Markers(ScrOut.plus);
      | MarkersAsteriskNmb:
        Markers(ScrOut.asterisk);
      | MarkersCircleNmb:
        Markers(ScrOut.circle);
      | MarkersCrossNmb:
        Markers(ScrOut.cross);
      | MarkersSquareNmb:
        Markers(ScrOut.square);
      (* --------------------------------- *)
      | SolidRectanglesNmb:
        FillRectangles(ScrOut.fillSolid);
      | StippledRectanglesNmb:
        FillRectangles(ScrOut.fillStippled);
      | SolidEllipsesNmb:
        FillEllipses(ScrOut.fillSolid);
      | StippledEllipsesNmb:
        FillEllipses(ScrOut.fillStippled);
      | SolidPolygonsNmb:
        FillPolygons(ScrOut.fillSolid);
      | StippledPolygonsNmb:
        FillPolygons(ScrOut.fillStippled);
      (* -------------------------------------------- *)
      | InDotNmb:
        InPoints(ScrOut.dot);
      | InPlusNmb:
        InPoints(ScrOut.plus);
      | InAsteriskNmb:
        InPoints(ScrOut.asterisk);
      | InCircleNmb:
        InPoints(ScrOut.circle);
      | InCrossNmb:
        InPoints(ScrOut.cross);
      | InSquareNmb:
        InPoints(ScrOut.square);
      | InRectanglesNmb:
        InRectangles();
      | InStringsNmb:
        InStrings();
      (* ------------------------- *)
      | WinOpenNmb:
        WinOpen();
      | WinCloseNmb:
        WinExec(WinClose);
      | WinTopNmb:
        WinExec(PutOnTop);
      | WinHideNmb:
        WinExec(Hide);
      | WinClearNmb:
        WinExec(ClearAndUpdate);
      | WinShowAllNmb:
        ShowAll();
      | WinChangeNmb:
        WinExec(Change);
      | WinReframeNmb:
        WinExec(Reframe);
      | WinRetitleNmb:
        WinExec(Retitle);
      ELSE
      END;
    END DoFunc;

  (* =============================== Interface procedures *)

  PROCEDURE Init(u: Win.WINDOW; n: CARDINAL);
    VAR
      v: Scr.View;
      p: Geo.Point;
      s: TextString;
      a: ScrOut.Attrs;
      ok: BOOLEAN;
    BEGIN
      (* ------------------------ translate data into string *)
      CASE n OF
      | ViewWidthNmb:
        CardToStr(scrnWdt, s, ok);
      | ViewHeightNmb:
        CardToStr(scrnHgt, s, ok);
      | ViewColorsNmb:
        LongCardToStr(colNmb, s, ok);
      | EditPaletteNmb:
        CardToStr(Scr.Palette(), s, ok);
      ELSE
        RETURN;
      END;
      (* ----------------------------- draw string into the window *)
      Win.Viewport(u, v);
      Geo.RectBasePt(v.port, p);
      ScrOut.SetTextAttrs
      (
        a,
        Scr.copy, 0, BackColor(),
        ScrOut.fillOpaqueStippled, mainFont
      );
      WinOut.String(u, a, p, s);
    END Init;

  PROCEDURE CallProc(u: Win.WINDOW; n: CARDINAL);
    VAR
      v: Scr.View;
      p: Geo.Point;
      s: TextString;
      a: ScrOut.Attrs;
      m: CARDINAL;
      ok: BOOLEAN;
    BEGIN
      CASE n OF
      | ExitNmb:
        (* ----------------------- exit *)
        endMain := TRUE;
      | HelpWinOpenNmb:
        (* ------------------ help for window opening *)
        DisplayMsg(HelpWinOpenMsg);
      | HelpWinSelectNmb:
        (* ---------------------- help for window selection *)
        DisplayMsg(HelpWinSelectMsg);
      | PalInitNmb:
        (* -------------------------------------- init palette *)
        Scr.SetPalette(0);
      | PalNextNmb:
        (* ---------------------------------------- next palette *)
        Scr.SetPalette(Scr.Palette() + 1);
      | PalPrevNmb:
        (* ----------------------------------- previous palette *)
        Scr.SetPalette(Scr.Palette() + Scr.PalettesNmb() - 1);
      | EditPaletteNmb:
        (* ---------------------- edit palette number *)
        Win.Viewport(u, v);
        Geo.RectBasePt(v.port, p);
        WinOut.Clear(u, 0);
        ScrOut.SetTextAttrs
        (
          a,
          Scr.xor, CursColor(), AuxCursColor(),
          ScrOut.fillStippled, mainFont
        );
        a.fillStippleNo := ScrInp.Underbar;
        CardToStr(Scr.Palette(), s, ok);
        REPEAT
          IF InCall(WinInp.String(u, a, p, s, MainRun, GetTxt)) THEN
            m := StrToCard(s, ok);
          END;
        UNTIL ok;
        Scr.SetPalette(m);
        WinOut.Clear(u, BackColor());
        Init(u, EditPaletteNmb);
      ELSE
        (* ----------- store the item key *)
        key := n;
      END;
    END CallProc;

  PROCEDURE Tour();
    CONST
      FaceHorShift = 6;
      FaceVerShift = 6;
      FaceDepth = 10;
      FaceHide = FALSE;
    VAR
      a: DlgInp.Attrs;
    BEGIN
      (* ---------------- prologue *)
      Randomize();
      nullPt.ix := 0;
      nullPt.iy := 0;
      invalidPt.ix := -1;
      invalidPt.iy := -1;
      Geo.SetRect(invalidRect, -1, -1, -1, -1);
      vpm := Scr.PagePixmap();
      colNmb := Scr.ColorsNmb();
      Scr.Dims(scrnWdt, scrnHgt);
      fontsNmb := ScrOut.StdFontsNmb();
      mainFont := Font();
      ScrOut.Dims(mainFont, charWdt, charHgt);
      Geo.SetRect(viewV.port, 0, scrnWdt - 1, 0, scrnHgt - 1);
      viewV.clip := TRUE;
      Scr.SetViewport(vpm, viewV);
      hatchFont := ScrOut.StdFont(1);
      hatchesNmb := CharsNmb(hatchFont);
      sxMax := scrnWdt DIV XDivisor;
      syMax := scrnHgt DIV YDivisor;
      buffAllocated := FALSE;
      demoMode := manual;
      winNmb := 0;
      Win.Init();
      InitParams();
      Alloc();
      (* ---------------------- enter graphics mode *)
      IF Scr.InitGraph() = Res.done THEN
        (* -------------------------- header and files loading *)
        Scr.SetPalette(0);
        Scr.SetDirectPaletteShades(0);
        LoadPlexes();
        Call(Dlg.Show(plx, HeaderMsg));
        LoadKeys();
        SetEndMark(TimeOut);
        REPEAT UNTIL EndRepeat();
        Call(Dlg.Hide(plx, HeaderMsg));
        (* ----------------------------------------------- main cycle *)
        a.cursColor := AuxCursColor();
        a.horShift := FaceHorShift;
        a.verShift := FaceVerShift;
        a.depth := FaceDepth;
        a.hide := FaceHide;
        endMain := FALSE;
        LOOP
          CASE DlgInp.Act(plx, MainMenu, a, Init, CallProc, MainRun, GetFace) OF
          | Res.done:
            (* ---------------------- hide main running line *)
            LineHide(MainLine);
            (* ------------------------------------ exit iff need *)
            IF endMain THEN EXIT END;
            (* ---------------------------- execute delayed function *)
            DoFunc();
          | Res.break:
            (* -------------- initialize all the changeable parameters *)
            InitParams();
          | Res.noMemory:
            (* ---------------- signal no memory error *)
            NoMemory();
          ELSE
            (* ---------- signal other error *)
            DisplayMsg(FaceErrorMsg);
          END;
        END;
        (* ------------------------------------------------- epilogue *)
        DrvMem.Free(heapBuffPtr, HeapBuffLen);
        Dlg.Dispose(plx);
        Win.Term();
        Scr.Clear(vpm, 0);
        Scr.TermGraph();
      ELSE
        Error(infoStr[adapter], "", 0, "", FALSE);
      END;
    END Tour;

  (* ========================================= Main *)

  VAR
    lineNo: CARDINAL;
    mode: INTEGER;

  BEGIN
    (* --------------- load texts *)
    LoadTexts();
    (* ----------------------- main loop *)
    LOOP
      (* ------------------------ write header *)
      Terminal.Write(033C);
      Terminal.WriteString("[2J");
      FOR lineNo := 0 TO ModeStrNmb - 1 DO
        Terminal.WriteLn();
        Terminal.WriteString(modeStr[lineNo]);
      END;
      (* ---------------------------------- request the mode *)
      REPEAT
        REPEAT UNTIL DrvKbd.Get(key);
        IF key = DrvKbd.Escape THEN
          EXIT;
        ELSE
          mode := VAL(INTEGER, ORD(key)) - VAL(INTEGER, ORD("a"));
        END;
      UNTIL (0 <= mode) AND (mode <= VAL(INTEGER, ORD(MAX(Scr.Type))));
      (* ------------------------------ set the mode and run the demo *)
      Scr.SetMode(VAL(Scr.Type, mode));
      Tour();
    END;
  END WinDemo.
