#include <stdio.h>
#include <math.h>
#include "dislin.h"

float xray[100], yray[100], y1ray[100], y2ray[100], zmat[50][50];

main()
{ int iopt;
  char cdev[20];

L1: header(cdev);
L2: iopt = option(); 

  metafl(cdev);
  setpag("da4l");

  switch (iopt)
  { case  1: exa_1();
             break;
    case  2: exa_2();
             break;
    case  3: exa_3();
             break;
    case  4: exa_4();
             break;
    case  5: exa_5();
             break;
    case  6: exa_6();
             break;
    case  7: exa_7();
             break;
    case  8: exa_8();
             break;
    case  9: exa_9();
             break;
    case 10: exa_10();
             break;
    case 11: exa_11();
             break;
    case 12: exa_12();
             break;
    case 13: ex13_1();
             break;
    case 14: ex13_2();
             break;
    case 15: ex13_3();
             break;
    case 16: ex13_4();
             break;
    case 17: ex10_1();
             break;
    case 18: ex10_2();
             break;
    case 19: ex14_1();
             break;
    case 20: ex14_2();
             break;
    case 21: ex6_1();
             break;
    case 22: ex11_1();
             break;
    case 23: exa_13();
             break;
    case 24: exa_14();
             break;
    case 30: goto L1;
             break;
    case  0: exit();
  }

  printf("\n    Press RETURN to continue ...");
  while (getchar() != '\n')
       ;
  getchar();
  printf("\n");
  goto L2;
}

/* >>>>>>>>>> EXA_1  <<<<<<<<<< */
exa_1()
{ int n = 100, i;
  double fpi = 3.1415926/180., step, x;

  step = 360. / (n-1);

  for (i = 0; i < n; i++)
  { xray[i] = i * step;
    x = xray[i] * fpi;
    y1ray[i] = sin(x);
    y2ray[i] = cos(x);
  }

  disini();
  pagera();
  complx();
  axspos(450,1800);
  axslen(2200,1200);

  name("X-axis","x");
  name("Y-axis","y");

  digits(-1,"x");
  ticks(10,"xy");

  titlin("Demonstration of CURVE",1);
  titlin("SIN(X), COS(X)",3);

  graf(0.,360.,0.,90.,-1.,1.,-1.,0.5);
  title();

  color("red");
  curve(xray,y1ray,n);
  color("green");
  curve(xray,y2ray,n);

  color("white");
  dash();
  xaxgit();
  disfin();
}

/* >>>>>>>>>> EXA_2  <<<<<<<<<< */
exa_2()
{ int nl, ny, i, nxp;
  static char ctit[] = "Symbols", cstr[3];

  setpag("da4p");
  disini();
  pagera();
  color("yellow");
  complx();
/*  paghdr("H. Michels  (",")",2,0); */

  height(60);

  nl = nlmess(ctit);
  messag(ctit,(2100-nl)/2,200);

  height(50);
  hsymbl(120);

  ny = 150;

  for (i = 0; i < 22; i++)
  { if ((i % 4) == 0) 
    { ny  += 400;
      nxp  = 550;
    }
    else
    { nxp += 350;
    }

    sprintf(cstr,"%d",i); 
    nl = nlmess(cstr)/2;
    messag(cstr,nxp-nl,ny+150);
    symbol(i,nxp,ny);
  }

  disfin();
}

/* >>>>>>>>>> EXA_3  <<<<<<<<<< */
exa_3()
{ int nya, i;
  static char    ctit[] =  "Logarithmic Scaling", cstr[60],
                *clab[3] = {"LOG", "FLOAT", "ELOG"};

  setpag("da4p");
  disini();
  pagera();
  complx();

  axslen(1400,500);
  name("X-axis","x");
  name("Y-axis","y");
  scale("log","xy");

  titlin(ctit,2);

  for (i = 1; i <= 3; i++)
  { nya = 2650 - (i-1) * 800;
    digits(-1,"xy");
    if (i == 2)
    { digits(1,"y");
      name(" ","x");
    }

    axspos(500,nya);
    color("yellow");
    strcpy(cstr, "Labels: ");
    strcat(cstr,clab[i-1]);
    messag(cstr,600,nya-400);
    color("white");
    labels(clab[i-1],"xy");
    graf(0.,3.,0.,1.,-1.,2.,-1.,1.);

    if (i == 3)
    { height(50);
      title();
    }

    endgrf();
  }
  disfin();
}

/* >>>>>>>>>> EXA_4  <<<<<<<<<< */
exa_4()
{ int nya = 2700, i, nx, ny;
  static float
        x[] = {0.,1.,3.,4.5,6.,8.,9.,11.,12.,12.5,13.,15.,16.,17.,19.,20.},
        y[] = {2.,4.,4.5,3.,1.,7.,2.,3.,5.,2.,2.5,2.,4.,6.,5.5,4.};
  static char 
       *cpol[4] = {"SPLINE", "BARS", "STEP", "LINEAR"},
       *ctit    = "Interpolation Methods";

  setpag("da4p");
  disini();
  complx();
  pagera();
  incmrk(1);
  hsymbl(25);
  titlin(ctit,1);
  axslen(1500,500);
  setgrf("line","line","line","line");

  for (i=0; i<4; i++)
  { axspos(350,nya-i*500);
    polcrv(cpol[i]);
    marker(0);

    graf(0.,20.,0.,5.,0.,10.,0.,5.);
    nx=nxposn(1.);
    ny=nyposn(8.);
    color("yellow");
    messag(cpol[i],nx,ny);
    curve(x,y,16);
    color("white");

    if (i == 3)
    { height(50);
      title();
    }
    endgrf();
  }

  disfin();
}

/* >>>>>>>>>> EXA_5  <<<<<<<<<< */
exa_5()
{ int i, ny, nx;
  static float    x[2] = {3.,9.}, y[2];
  static char *ctyp[8] = {"SOLID",  "DOT",   "DASH", "CHNDSH",
                          "CHNDOT", "DASHM", "DOTL", "DASHL"};

  setpag("da4p");
  disini();
  pagera();
  center();
  chncrv("both");
  setvlt("small");
  complx();

  name("X-axis","x");
  name("Y-axis","y");

  titlin("Demonstration of Curve",1);
  titlin("Line Styles",3);

  graf(0.,10.,0.,2.,0.,10.,0.,2.);
  title();

  for (i = 1; i <= 8; i++)
  { y[0] = 9.5-i;
    y[1] = 9.5-i;
    ny = nyposn(y[0]);
    nx = nxposn(1.0);
    messag(ctyp[i-1],nx,ny-20);
    curve(x,y,2);
  }

  disfin();
}

/* >>>>>>>>>> EXA_6  <<<<<<<<<< */
exa_6()
{ int n = 100, i, nx, ny;
  double fpi = 3.1415926/180., step, x;
  char   cbuf[20];

  step = 360./(n-1);
  for (i=0; i<n; i++)
  { xray[i] = i * step;
    x=xray[i] * fpi;
    y1ray[i] = sin(x);
    y2ray[i] = cos(x);
  }

  disini();
  complx();
  pagera();

  axspos(450,1800);
  axslen(2200,1200);

  name("X-axis","x");
  name("Y-axis","y");
  digits(-1,"x");
  ticks(10,"xy");

  titlin("Demonstration of Curve",1);
  titlin("Legend",3);

  graf(0.,360.,0.,90.,-1.,1.,-1.,0.5);
  title();
  xaxgit();

  chncrv("both");
  curve(xray,y1ray,n);
  curve(xray,y2ray,n);

  legini(cbuf,2,7);
  nx = nxposn(190.);
  ny = nyposn(0.75);
  legpos(nx,ny);
  leglin(cbuf,"sin (x)",1);
  leglin(cbuf,"cos (x)",2);
  legtit("Legend");
  legend(cbuf,3);

  disfin();
}

/* >>>>>>>>>> EXA_7  <<<<<<<<<< */
exa_7()
{ int   ixp[4], iyp[4], nl, nx, nx0 = 335, ny0 = 350, ny, i, j, ii, k, iclr;
  static int  ix[4] = {0, 300, 300, 0},
              iy[4] = {0, 0, 400, 400};
  static char *ctit = "Shading Patterns (AREAF)", cstr[3];

  disini();
  pagera();
  complx();
  setvlt("small");

  height(50);
  nl = nlmess(ctit);
  nx = (2970-nl)/2;
  messag(ctit,nx,200);

  iclr = 0;
  for (i = 0; i < 3; i++)
  { ny = ny0+i*600;
    for (j = 0; j < 6; j++)
    { nx = nx0+j*400;
      ii = i*6+j;
      shdpat((long) ii);
      sprintf(cstr,"%d",ii);

      iclr = iclr % 16;
      iclr++;
      setclr(iclr);

      for (k=0; k<4; k++)
      { ixp[k] = ix[k] + nx;
        iyp[k] = iy[k] + ny;
      }
      areaf(ixp,iyp,4);

      nl  = nlmess(cstr);
      nx += (300-nl)/2;
      messag(cstr,nx,ny+460);
    }
  }

  disfin();
}

/* >>>>>>>>>> EXA_8  <<<<<<<<<< */
exa_8()
{ int nl, nx, ny, i;
  static int ivec[20]   = {   0,1111,1311,1421,1531,1701,1911,3111,3311,3421,
                           3531,3703,4221,4302,4413,4522,4701,5312,5502,5703};
  static char *ctit = "Vectors", cnum[5];

  disini();
  color("cyan");
  pagera();
  complx();

  height(60);
  nl = nlmess(ctit);
  nx = (2970-nl)/2;
  messag(ctit,nx,200);

  height(50);
  nx = 300;
  ny = 400;

  for (i = 0; i < 20; i++)
  { if (i == 10) 
    { nx += 2970/2;
      ny  = 400;
    }

    sprintf(cnum,"%d",ivec[i]);
    nl = nlmess(cnum);
    messag(cnum,nx-nl,ny-25 );

    vector(nx+100,ny,nx+1000,ny,ivec[i]);
    ny += 160;
  }

  disfin();
}

/* >>>>>>>>>> EXA_9  <<<<<<<<<< */
exa_9()
{ int i;
  char cbuf[40], cstr[4];

  for (i = 0; i < 18; i++)
    xray[i] = 1.;

  setpag("da4p");
  disini();
  pagera();
  complx();
  setvlt("small");

  axspos(250,2700);
  axslen(1600,2200);
  titlin("Shading Patterns (PIEGRF)",3);
  height(50);

  legini(cbuf,18,2);

  for (i = 0; i < 18; i++)
  { sprintf(cstr,"%d",i);
    leglin(cbuf,cstr,i+1);
  }

  chnpie("both");
  labels("none","pie");
  piegrf(cbuf,1,xray,18);
  title();

  disfin();
}

/* >>>>>>>>>> EXA_10 <<<<<<<<<< */
exa_10()
{ int n = 50 ,i, j;
  double fpi=3.1415927/180., step, x, y;

  step = 360./(n-1);
  for (i = 0; i < n; i++)
  { x = i*step;
    for (j = 0; j < n; j++)
    { y = j*step;
      zmat[i][j] = 2*sin(x*fpi)*sin(y*fpi);
    }
  }

  setpag("da4p");
  disini();
  pagera();
  complx();
  axspos(200,2600);
  axslen(1800,1800);

  name("X-axis","x");
  name("Y-axis","y");
  name("Z-axis","z");

  titlin("Surface Plot (SURMAT)",2);
  titlin("F(X,Y) = 2*SIN(X)*SIN(Y)",4);

  view3d(-5.,-5.,4.,"abs");
  graf3d(0.,360.,0.,90.,0.,360.,0.,90.,-3.,3.,-3.,1.);
  height(50);
  title();

  color("green");
  surmat((float *) zmat,50,50,1,1);
  disfin();
}

/* >>>>>>>>>> EXA_11 <<<<<<<<<< */
exa_11()
{ int n = 50 ,i, j;
  static int ixp[4] = {200,1999,1999,200},
             iyp[4] = {2600,2600,801,801};

  double fpi = 3.1415927/180., step, x, y;

  step = 360./(n-1);
  for (i = 0; i < n; i++)
  { x = i*step;
    for (j = 0; j < n; j++)
    { y = j*step;
      zmat[i][j] = 2*sin(x*fpi)*sin(y*fpi);
    }
  }

  setpag("da4p");
  disini();
  pagera();
  complx();

  axspos(200,2600);
  axslen(1800,1800);

  name("X-axis","x");
  name("Y-axis","y");
  name("Z-axis","z");

  titlin("Surface Plot (SURMAT)",2);
  titlin("F(X,Y) = 2*SIN(X)*SIN(Y)",4);

  graf3d(0.,360.,0.,90.,0.,360.,0.,90.,-3.,3.,-3.,1.);
  height(50);
  title();
  shlsur();
  color("green");
  surmat((float *) zmat,n,n,1,1);

  color("white");
  grfini(-1.,-1.,-1.,1.,-1.,-1.,1.,1.,-1.);
  nograf();
  graf(0.,360.,0.,90.,0.,360.,0.,90.);
  dashl();
  grid(1,1);
  grffin();

  grfini(-1.,-1.,-1.,-1.,1.,-1.,-1.,1.,1.);
  graf(0.,360.,0.,90.,-3.,3.,-3.,1.);
  grid(1,1);
  grffin();

  grfini(-1.,1.,-1.,1.,1.,-1.,1.,1.,1.);
  shdpat(7L);
  solid();
  areaf(ixp,iyp,4);
  grffin();

  disfin();
}

/* >>>>>>>>>> EXA_12 <<<<<<<<<< */
exa_12()
{ int i, nxp, nyp;
  float  xp, yp;
  static float   xc[9] = {-22.,18.,37.5,0.,2.5,12.5,23.5,-3.75,14.25},
                 yc[9] = {64.,59.6,56.,51.5,48.5,42.,38.,40.3,50.1};
  static char *cstr[9] = {"REYKJAVIK", "STOCKHOLM", "MOSKAU", "LONDON",
                          "PARIS", "ROM", "ATHEN", "MADRID", "PRAG"};

  disini();
  pagera();
  hwfont();

  axspos(500,1850);
  axslen(2200,1400);

  digits(-1,"xy");
  ticks(1,"xy");
  name("Longitude","x");
  name("Latitude","y");

  titlin("Map Plot",3);
  incmrk(-1);

  labels("map","xy");
  projct("lambert");
  frame(3);
  grafmp(-40.,60.,-40.,20.,35.,70.,40.,10.);

  color ("green"); 
  world();
  color ("fore");
  curvmp(xc,yc,9);

  for (i = 0; i < 9; i++)
  { pos2pt(xc[i],yc[i],&xp,&yp);
    nxp = xp+30;
    nyp = yp;
    messag(cstr[i],nxp,nyp);
  }

  gridmp(1,1);
  height(50);
  title();
  disfin();
}

/* >>>>>>>>>> EX13_1 <<<<<<<<<< */
ex13_1()
{ setpag("da4l");
  disini();
  pagera();
  complx();

  frame(3);
  axspos(400,1850);
  axslen(2400,1400);

  name("Longitude","x");
  name("Latitude","y");
  titlin("World Coastlines and Lakes",3);

  labels("map","xy");
  grafmp(-180.,180.,-180.,90.,-90.,90.,-90.,30.);

  gridmp(1,1);
  color("green");
  world();
  color("white");

  height(50);
  title();
  disfin();
}

/* >>>>>>>>>> EX13_2 <<<<<<<<<< */
ex13_2()
{ int nya, i;
  static char *cproj[3] = {"Sanson","Winkel","Hammer"};
  char   ctit[61];

  setpag("da4p");
  disini();
  complx();
  pagera();

  height(40);
  axslen(1600,750);

  nya=3850;
  for (i=0; i<3; i++)
  { nya=nya-950;
    axspos(250,nya);

    projct(cproj[i]);
    noclip();
    grafmp(-180.,180.,-180.,30.,-90.,90.,-90.,15.);

    sprintf(ctit,"%s%s","Elliptical Projection of ",cproj[i]);
    titlin(ctit,4);
    title();
    color("green");
    world();
    color("white");

    gridmp(1,1);
    endgrf();
  }

  disfin();
}

/* >>>>>>>>>> EX13_3 <<<<<<<<<< */
ex13_3()
{ int    nl, nx, i;
  static int   nxa[4]  = {200,1150,200,1150},
               nya[4]  = {1600,1600,2700,2700};
  static float xpol[4] = {0.,0.,0.,0.},
               ypol[4] = {0.,45.,90.,-45.};
  static char  *ctit   = "Azimuthal Lambert Projections";

  setpag("da4p");
  disini();
  complx();
  pagera();

  height(50);
  nl = nlmess(ctit);
  nx = (2250-nl)/2.;
  messag(ctit,nx,300);

  axslen(900,900);
  projct("lambert");

  for(i = 0; i < 4; i++)
  { axspos(nxa[i],nya[i]);
    mappol(xpol[i],ypol[i]);
    grafmp(-180.,180.,-180.,30.,-90.,90.,-90.,30.);

    color("green");
    world();
    color("white");
    gridmp(1,1);
    endgrf();
  }

  disfin();
}

/* >>>>>>>>>> EX13_4 <<<<<<<<<< */
ex13_4()
{ int n = 32, inray[32], icray[32], i;
  long ipray[32];

  for (i=0; i<32; i++)
  { inray[i] = i+1;
    ipray[i] = 0;
    icray[i] = 1;
  }

  setpag("da4p");
  disini();
  pagera();
  complx();
  setvlt("small");

  intax();
  ticks(1,"xy");
  frame(3);
  axslen(1600,2200);
  axspos(400,2700);

  name("Longitude","x");
  name("Latitude","y");
  titlin("Conformal Conic Projection",3);

  labels("map","xy");
  projct("conf");
  grafmp(-10.,30.,-10.,5.,35.,70.,35.,5.);

  gridmp(1,1);
  shdeur(inray,ipray,icray,n);

  height(50);
  title();
  disfin();
}

/* >>>>>>>>>> EX14_1 <<<<<<<<<< */
ex14_1()
{ int n = 50, i, j;
  double   fpi = 3.14159/180., step, x, y;
  float  zlev;

  step = 360./(n-1);

  for (i = 0; i < n; i++)
  { xray[i] = i*step;
    yray[i] = i*step;
  }

  for (i = 0; i < n; i++)
  { for (j = 0; j < n; j++)
    { x = xray[i]*fpi;
      y = yray[j]*fpi;    
      zmat[i][j] = 2*sin(x)*sin(y);
    }
  }

  setpag("da4p");
  disini();
  complx();
  pagera();

  titlin("Contour plot",1);
  titlin("F(X,Y) = 2 * SIN(X) * SIN(Y)",3);

  name("X-axis","x");
  name("Y-axis","y");

  intax();
  axspos(450,2670);
  graf(0.,360.,0.,90.,0.,360.,0.,90.);

  height(30);
  for (i = 0; i < 9; i++)
  { zlev = -2.+i*0.5;
    setclr ((i+1) * 25);
    if (i == 4)
      labels("none","contur"); 
    else
      labels("float","contur");

    contur(xray,n,yray,n,(float *) zmat,zlev);
  }

  height(50);
  color("white");
  title();

  disfin();
}

/* >>>>>>>>>> EX14_2 <<<<<<<<<< */
ex14_2()
{ int n = 50, i, j;
  double step, x, y;
  float zlev[12];

  step = 1.6/(n-1);
  for (i = 0; i < n; i++)
  { x = 0.0+i*step;
    xray[i] = x;
    for (j = 0; j < n; j++)
    { y = 0.0+j*step;
      yray[j] = y;
      zmat[i][j] = (x*x-1.)*(x*x-1.) + (y*y-1.)*(y*y-1.);
    }
  }

  setpag("da4p");
  disini();
  pagera();
  complx();

  mixalf();
  titlin("Shaded Contour Plot",1);
  titlin("F(X,Y) = (X[2$ - 1)[2$ + (Y[2$ - 1)[2$",3);
  name("X-axis","x");
  name("Y-axis","y");

  shdmod("poly", "contur");
  axspos(450,2670);
  graf(0.0,1.6,0.0,0.2,0.0,1.6,0.0,0.2);

  for (i = 1; i <= 12; i++)
    zlev[12-i] = 0.1+(i-1)*0.1;

  conshd(xray, n, yray, n, (float *) zmat,zlev,12);

  height(50);
  title();
  disfin();
}

/* >>>>>>>>>> EX6_1  <<<<<<<<<< */
ex6_1()
{ int ny = 1100, nl;
  static char *ctit = "Instruction Alphabet",
  *ct1 = 
   "{m2}C{m4}(x) = {m3p}v{m4}e{e}-t{r}t{e}x-1{r}dt{gdh0.4f-1}0{u1.4m3f3}l",
  *ct2 =
   "lim{gdhc}x{m3cd1.1}a{c}l{rm} (1 + {puh} 1 {rvgd0.5h} x {r}){u1.2h}x{r} = e",
  *ct0 = 
   "Character{h0.5} height{rz-30}  incli{z30}nation {zw0.5} ratio {wk} fixed width",
  *ct3 = "Underscoring{l}    {p}twice{j}    vectors {pa8v}";

  setpag("da4l");
  disini();
  pagera();
  complx();
  color("cyan");

  height(50);
  nl=nlmess(ctit);
  messag(ctit,(2970-nl)/2,250);

  height(36);
  messag("1.)",300,450);
  messag(ct0,500,450);

  height(50);
  smxalf("inst","{","}",1);
  messag(ct0,500,550);

  reset("smxa");
  height(36);
  messag("2.)",300,750);
  messag(ct3,500,750);

  height(50);
  smxalf("inst","{","}",1);
  messag(ct3,500,850);

  reset("smxalf");
  height(36);
  messag("3.)",300,ny);
  messag(ct1,500,ny);

  smxalf("inst","{","}",1);
  height(80);
  messag(ct1,900,ny+150);

  height(36);
  reset("smxa");
  messag("4.)",300,ny+450);
  messag(ct2,500,ny+450);

  height(80);
  smxalf("inst","{","}",1);
  messag(ct2,900,ny+600);
  disfin();
}

/* >>>>>>>>>> EX10_1 <<<<<<<<<< */
ex10_1()
{ int nya = 2700, i;
  static char   *ctit = "Bar Graphs (BARS)", cbuf[25];

  static float x[9]  = {1.,2.,3.,4.,5.,6.,7.,8.,9.},
               y[9]  = {0.,0.,0.,0.,0.,0.,0.,0.,0.},
               y1[9] = {1.,1.5,2.5,1.3,2.0,1.2,0.7,1.4,1.1},
               y2[9] = {2.,2.7,3.5,2.1,3.2,1.9,2.0,2.3,1.8},
               y3[9] = {4.,3.5,4.5,3.7,4.,2.9,3.0,3.2,2.6};

  setpag("da4p");
  disini();
  pagera();
  complx();
  ticks(1,"x");
  intax();;
  axslen(1600,700);
  titlin(ctit,3);

  legini(cbuf,3,8);
  leglin(cbuf,"FIRST",1);
  leglin(cbuf,"SECOND",2);
  leglin(cbuf,"THIRD",3);
  legtit(" ");
  shdpat(5L);
  for (i = 1; i <= 3; i++)
  { if (i >  1) labels("none","x");
    axspos(300,nya-(i-1)*800);

    graf(0.,10.,0.,1.,0.,5.,0.,1.);

    if (i == 1)
    { bargrp(3,0.15);
      color("red");
      bars(x,y,y1,9);
      color("green");
      bars(x,y,y2,9);
      color("blue");
      bars(x,y,y3,9);
      color("white");
      reset("bargrp");
    }
    else if (i == 2)
    { height(30);
      labels("delta","bars");
      labpos("center","bars");
      color("red");
      bars(x,y,y1,9);
      color("green");
      bars(x,y1,y2,9);
      color("blue");
      bars(x,y2,y3,9);
      color("white");
      reset("height"); 
    }
    else if (i == 3)
    { labels("second","bars");
      labpos("outside","bars");
      color("red");
      bars(x,y,y1,9);
      color("white");
    }

    if (i != 3) legend(cbuf,7);

    if (i == 3)
    { height(50);
      title();
    }

    endgrf();
  }

  disfin();
}

/* >>>>>>>>>> EX10_2 <<<<<<<<<< */
ex10_2()
{ int nya = 2800, i;
  static char    *ctit = "Pie Charts (PIEGRF)", cbuf[41];
  static float xray[5] = {1.,2.5,2.,2.7,1.8};

  setpag("da4p");
  disini();
  pagera();
  complx();
  axslen(1600,1000);
  titlin(ctit,2);
  chnpie("both");

  legini(cbuf,5,8);
  leglin(cbuf,"FIRST",1);
  leglin(cbuf,"SECOND",2);
  leglin(cbuf,"THIRD",3);
  leglin(cbuf,"FOURTH",4);
  leglin(cbuf,"FIFTH",5);

  patcyc(1,7L);
  patcyc(2,4L);
  patcyc(3,13L);
  patcyc(4,3L);
  patcyc(5,5L);

  for (i = 0; i < 2; i++)
  { axspos(250,nya-i*1200);
    if (i == 1)
    { labels("data","pie");
      labpos("external","pie");
    }

    piegrf(cbuf,1,xray,5);

    if (i == 1)
    { height(50);
      title();
    }
    endgrf();
  }
  disfin();
}

/* >>>>>>>>>> EX11_1 <<<<<<<<<< */
ex11_1()
{ int n = 50, i, j;
  double   fpi = 3.1415927/180., step, x, y;
  char   *cdev;

  step = 360./(n-1);
  for (i = 0; i < n; i++)
  { x = i*step;
    for (j = 0; j < n; j++)
    { y = j*step;
      zmat[i][j] = 2*sin(x*fpi)*sin(y*fpi);
    }
  }

  disini();
  pagera();
  cdev = getmfl();
  hwfont();

  titlin("3-D Colour Plot of the Function",2);
  titlin("F(X,Y) = 2 * SIN(X) * SIN(Y)",4);

  name("X-axis","x");
  name("Y-axis","y");
  name("Z-axis","z");

  intax();
  autres(n,n);
  axspos(300,1850);
  ax3len(2200,1400,1400);

  graf3(0.,360.,0.,90.,0.,360.,0.,90.,-2.,2.,-2.,1.);
  crvmat((float *) zmat,n,n,1,1);

  height(50);
  if (strcmp(cdev,"POST") == 0)
        psfont("palatino-bolditalic");
  title();
  mpaepl(3);
  disfin();
}

/* >>>>>>>>>> EXA_13 <<<<<<<<<< */
exa_13()
{ int n = 7, i;
  char cdev[5];
  static char *clr[7]  = {"white","red","gree","oran","yello","cyan","blue"},
              *cont[7] = {"anta","afri","eura","nort","sout","aust","lake"};

  disini();
  complx();
  setvlt("small");
  pagera();

  projct("hammer");
  noclip();
  grafmp(-180.,180.,-180.,30.,-90.,90.,-90.,30.);

  shdpat(16L);
  for (i = 0; i < n; i++)
  { color(clr[i]);
    shdmap(cont[i]);
  }

  color("white");
  gridmp(1,1);

  disfin();
}

/* >>>>>>>>>> EXA_14 <<<<<<<<<< */
exa_14()
{ int ncol = 0, ny, i, j, nx, nb = 100, nh = 80, nl;
  float xcol;
  char   cvlt[5];

  printf(" Give colour table (SMALL, RAIN, SPEC, GREY, VGA): ");
  scanf("%s",cvlt);

  disini();
  pagera();
  setvlt(cvlt);

  height(30);
  for (i = 1; i <= 13; i++)
  { ny = i*150;
    nx = -50;
    for (j = 1; j <= 20; j++)
    { nx += 145;
      if (ncol <= 255)
      { point(nx,ny,nb,nh,ncol);
        xcol=ncol;
        nl=nlnumb(xcol,-1);
        setclr(255);
        number(xcol,-1,nx-nl/2,ny+50);
        ncol++;
      }
    }
  }
  disfin();
}

/* >>>>>>>>>> HEADER <<<<<<<<<< */
header(char *cdev)
{ int n = 15, i;

  static char *c0 = 
    "**********************************************************";

  static char *c1[15] = {
    "                      DISLIN-Examples",
    " ",
    "C Demo Program of the Data Plotting Library DISLIN.",
    "Author: H. Michels,  Max-Planck-Institut fuer Aeronomie,",
    "                D-37189 Katlenburg-Lindau, Postfach 20",
    " ",
    "Device:      defines the metafile format.",
    "   = CONS    VGA ( 640 * 480 *  16, mode: 18). Additional",
    "             graphic modes can be defined with DISVID.",
    "   = GKSL    a GKSLIN metafile will be created.",
    "   = CGM     a CGM metafile will be created.",
    "   = HPGL    a HPGL file will be created.",
    "   = POST    a PostScript file will created.",
    "   = PSCL    a coloured PostScript file will created.",
    "   = KYOC    a Prescribe file will be created."};

  printf("\n    /****%s****/\n",c0);
  for (i=0; i<n; i++)
  { printf("    /**  %-58s  **/\n",c1[i]);
  } 
  printf("    /****%s****/\n",c0);

  printf("\n    _Device: ");
  scanf("%s",cdev);
  printf("\n");
}

/* >>>>>>>>>> OPTION <<<<<<<<<< */
option()
{ int n = 15, i, iopt;

  static char *c0 = 
    "**********************************************************";

  static char *c1[15] = {
    "                      DISLIN-Examples                     ",
    "                                                          ",
    " 0: Program end                  13: World Coastlines     ",
    " 1: Demo of CURVE                14: Elliptical Proj.     ",
    " 2: Symbols                      15: Azimuthal Proj.      ",
    " 3: Logarithmic Axes             16: Conical  Proj.       ",
    " 4: Interpolation Methods        17: Bar Graphs           ",
    " 5: Line Styles                  18: Pie Charts           ",
    " 6: Legend                       19: Contours             ",
    " 7: Shading Patterns (AREAF)     20: Shaded Contours      ",
    " 8: Vectors                      21: Instruction Alphabet ",
    " 9: Shading Patterns (PIEGRF)    22: 3-D Colour Plot      ",
    "10: Surface Plot                 23: Shaded World         ",
    "11: Surface Plot                 24: Colour Tables        ",
    "12: Map Plot                     30: Menue end            " };

  printf("\n    /****%s****/\n",c0);
  for (i = 0; i < n; i++)
  { printf("    /**  %s  **/\n",c1[i]);
  }
  printf("    /****%s****/\n",c0);

  printf("\n    _Option: ");
  scanf("%d",&iopt);
  return iopt;
}

