
 PCPS(V8.40)                                                        PCPS(V8.40)
 ------------------------------------------------------------------------------

NAME
        MSDOS/OS/2:       PCPS.EXE   |
        WINDOWS 95/98/NT: PCPS32.EXE |=>  convert text to PostScript
        UNIX:             pcps       |


SYNOPSIS
        PCPS [-arg1 -arg2 -arg3 ... -argn] [filename(s)]

DESCRIPTION
        PCPS reads in text files (now including support of the full IBM/PC
        character set), converts them to PostScript and outputs them to a
        PostScript printer, a file or stdout.  If no input files are
        specified, PCPS will take its input from stdin.  Many attributes
        such as fonts, headings, orientation, various formatting options
        etc. may be specified.

        ****************
        *   NOTE FOR   *  PCPS defaults to using European A4 paper size, so
        *NORTH AMERICAN*  you must specify "-szlt" if you are using US letter
        *     USERS    *  paper (8.5" x 11")
        ****************

        The various arguments are detailed below.  Any field enclosed in <>
        is mandatory for that argument but those enclosed in [] are
        optional:

        -he or (no arguments AND no stdin pipe)
                This will give you a multiple page help screen.

        -ls     List available font codes.  ALL other arguments are ignored
                when -ls is used.

        -2c[r]  Print in 2 columns.  This can allow two normal pages to fit
                on one.

                NOTE: This argument no longer affects the orientation of
                the paper, thus allowing 2 column in portrait mode as well
                as landscape.  The optional "r" specifies the orientation
                to be landscape and is identical to specifying "-2c -ro".

*       -2c-    Print in a single column.

        -ap<o|e>
                Print alternate pages where o = ODD and e = EVEN.  This is
                useful when double sided printing is required.  For further
                double sided support, see "-sm" below.

                EXAMPLE: -apo    print only odd pages.

*       -ap-    Turn OFF alternate page printing - print both odd and even.

        -bx     Draw a BoX around the printable area on the page.

*       -bx-    Disable Boxing.

        -cd     The first and last characters output by PCPS will be ^D
                (0x04) characters.  This is required by some printers to
                signify end of job.

*       -cd-    Do not output ^D (0x04) characters.

        -cp<n>  Print <n> copies of every page.

*       -cp-    Print one copy of every page.

        -cz     Suppress the printing of Ctl-Z characters.  This is useful
                for printing those text files created by editors that
                insist on terminating the file with the DOS EOF character.

*       -cz-    Print the Ctl-Z character as a right arrow (if font is
                IBMPCFont).

        -df<s|o|p>
                Default action to take when a file already in PostScript
                format is encountered, where s = Skip file altogether, o =
                Output file as it is and p = process the PostScript into
                PostScript.

*       -df-    Reset default action - if a file is encountered that is
                already in PostScript format, the user will be prompted for
                the action to take.

        -dk     Denmark fix for the IBM/PC character set - this maps the
                characters oslash and Oslash to decimal 155 and 157
                respectively.

*       -dk-    If the IBM/PC character set is the active font, it will be
                unmodified.

        -dl     Delete the input file(s) after successful processing.
                **************** USE WITH CAUTION *******************
                PCPS will consider the file processed successfully if it
                receives no errors during the processing and will delete
                the input file.  Be aware that print jobs can sometimes get
                lost, especially on networks.

*       -dl-    Do NOT delete the input file.

        -dp[t]  Enable DUPLEX mode printing for those printers that support
                it.  The optional "t" may be specified if tumble is desired.

*       -dp-    Non-DUPLEX mode - printing will be single sided if the
                printer defaults to this.

        -dt[1|2|3]
                Date format to use in the banner where the formats are:
                        1 - yyyy/mm/dd
                        2 - mm/dd/yy   (U.S.)
                        3 - dd/mm/yy   (Australia & Europe)

*       -dt-    Use the default date format (yyyy/mm/dd).

        -eh     Download the extended PostScript error handler to the
                printer before the print job.  This error handler causes
                the printer to output any errors on paper as well as back
                along its comms line.

                Use this option carefully as, on many printers, this causes
                a permanent change to its error handling routine.

                This option should only be used as a last resort if, for
                any reason, your printer refuses to print the output from
                PCPS and you are unable to monitor your printers errors;
                E.g. Most spoolers have a log file and any errors output by
                the printer are normally placed into this file, but access
                to this file may be impractical.

*       -eh-    Disable debug mode.

        -en<o|e>
                Select character set encoding scheme, where:

                        o = OSI-8859-1 (aka OSI-Latin-1)
                        e = Old style PCPS European encoding scheme

                The OSI-8859-1 encoding is now the default of PCPS as this
                is the encoding scheme adopted by the Internet.

*       -en-    Set the character encoding scheme to ISO-8859-1.

        -es<b|i|c>
                Select the enhanced print style for modes 2 through 6
                where:

                        b = bold (default)
                        i = italic
                        c = combination (bold/italic)

*       -es-    Reset enhanced style back to the default bold.

        -fn<text>
                Replace the file name in the banner with "text".

                ****See TEXT ARGUMENT RULES.

*       -fn-    Just use the file name as is in the banner.

        -fo<[font code][size]>
                This argument is used to set the font type and/or the font
                size.  The "font code" is the abbreviated code for the font
                which is listed by the "-ls" option.  The size is in points
                and may have a decimal point with one only decimal number.
                See SUPPORTED FONTS.

                EXAMPLE: -foc12  set font to Courier at size 12 point.
                         -foh7.5 set font to Helvetica at size 7.5 point.

*       -fo-     Set the font and size to the default IBMPCFont at 10 point.

        -ga[text]
                Print a gaudy banner at the top of the page containing the
                files last modification date, the current page number, the
                file name.  If the optional "text" is included, it will
                printed above the filename in the banner.

                ****See TEXT ARGUMENT RULES.

                This argument over-rides any previous -nb argument.

*       -ga-    Disable the gaudy banner.

        -g1[text]
                Gaudy banner for page 1 - the same as "-ga" but only prints
                the banner on page 1.

                ****See TEXT ARGUMENT RULES.

*       -g1-    Disable the gaudy banner.

        -id[n]  Attempt to identify the originator of the print job by
                printing the User ID and Host name at the bottom corner of
                each page.  The default font size for this string is 4 but
                may be changed to "n" where "n" must be greater than or
                equal to 3 and may have up to one decimal place.

                On DOS or OS/2 systems, this may not work as each different
                LAN environment has as different standard of storing such
                information, but PCPS looks for some key environment
                variable combinations such as:

                USER & HOSTNAME                 (typical of OS/2 TCP/IP)
                USERNAME & USERDOMAIN           (typical of Windows/NT)
                USERID & NFSPATH/NFSDRIVE       (PCNFS).

                Under Unix, the LOGNAME variable is used, and `hostname` is
                executed.

*       -id-    Disable user identification.

        -in[f|o]
                Inverse page order (ie. Output the last page first).

                "-in" uses the default mode and is the fastest.  The pages
                will be sorted in memory if there is sufficient memory
                to do so.  If there is insufficient memory then the "-inf"
                mode is automatically selected.

                "-inf" is the default temporary file method and is the new
                "fast" mode which, although slower than memory sorting, is
                far more efficient than the old temporary file sorting
                method, especially with large files.

                "-ino" may be specified if either of the above arguments are
                giving you trouble - this mode requires no additional
                memory but is verrrrrry slooooooow.

*       -in-    Normal page order.

        -lf<n>  Set the line feed spacing to n% of the font size.  The
                default is 105%.

*       -lf-    Set line feed spacing back to the default 105%.

        -ll[n]  Set Line length:  If "n" is not specified, this sets an
                (almost) unlimited line length (65535 chars).  If "n" is
                specified, set line length to "n" characters.  Normally
                PCPS calculates the maximum line length using the font
                size and the available printing area but this calculation
                is made assuming the non-proportional default IBMPCFont font
                and is not necessarily accurate for other fonts other than
                Courier.  This argument allows the user to over-ride the
                calculated maximum.

                EXAMPLE: -ll     set maximum char per line to 65,535
                         -ll60   set maximum char per line to 60

*       -ll-     Use the default calculated maximum line length.

        -ln[n]  Print line numbers.  The default is for the line numbers to
                be shown with 4 digits but should an optional number also
                be specified, the line numbers will start with "n" digits
                where "n" can be a maximum of 6.  The number of digits is
                automatically increased should the line numbers exceed the
                number able to be specified by the current number of
                digits.

                EXAMPLE: -ln     print line numbers and start with 4 digits.
                         -ln3    print line numbers and start with 3 digits.

                NOTE: For those not liking leading zeros, see -nz.

*       -ln-    Do NOT print line numbers.

        -lp<n>  Set lines per page to "n" lines.

                EXAMPLE: -lp66   set the pages to 66 lines.

        -lp-    Set lines per page to the default which is to print
                whatever will fit on the page or until Form Feed characters
                are encountered.

        -ma<l|r|t|b><n>
                Set the specified margin to be "n" points (1/72 inch)
                where l = Left, r = Right, t = Top and b = Bottom.

                EXAMPLE: -mal72  set the left margin to 1 inch.

                The default margins are as follows:


                           | Left       Right      Top        Bottom
                 ------------------------------------------------------
                 Portrait  | 36p(.50")  22p(.31")  36p(.50")  36p(.50")
                 Landscape | 22p(.31")  22p(.31")  36p(.50")  22p(.31")


*       -ma-     Set the margins back to their defaults.

        -mf     Enable manual paper feed - useful if you wish to use
                different paper than that loaded into the paper tray(s).

        -mf1    Enable manual paper feed on the first page printed only -
                useful if the first page needs to be printed on letter head
                and you are not fortunate enough to have two paper trays.

*       -mf-    Disable all manual paper feeding.

        -mo<1|2|3|4|5|6|7>
                Enable one of seven special processing modes:

                Mode 1 => -mo1     (Man Page Mode)
                 Enable man page printing mode where a backspace physically
                 executes a backspace rather than printing a white dot.
                 This mode automatically selects the Courier (which is
                 non-proportional) in man mode and over-rides any previously
                 specified font.  Any subsequent attempt to change the font
                 to anything other than Courier will result in an error.

                Mode 2 => -mo2     (Mail Message Mode)
                 Enable Mail mode which will print mail headers in an
                 enhanced font.  This mode automatically selects Courier
                 font, but the user may follow this argument with a "-fo"
                 argument to change the font to another.

                 Be aware that the IBMPCFont does not have an equivalent
                 enhanced font so Courier is used as a base for the
                 enhanced styles.

                 Any line that contains a colon with some white-space but
                 only after the colon will be treated as a header, apart
                 from the first line of the file which will be printed bold
                 unconditionally.

                Modes 3 through 7 are designed for program developers who
                wish to enhance their printouts by distinguishing the
                comments from the rest of the program.  Comments will be
                printed in an enhanced style as specified by -es or default
                bold print.

                The styles (bold, italic, combination) simply toggle the
                normal font attribute - For example if you select
                Courier-Bold as your normal font, then the enhanced print
                will toggle the bold attribute, making the ehanced font
                Courier.  The resultant printout will have the code being
                printed in bold, and the comments being printed non-bold.

                A description of comment character sequences follows.

                Mode    Description     Start Seq       End Seq

                3       C/C++           /*              */
                3       C/C++           //              EOL
                4       4GL             {               }
                4       4GL             #               EOL
                4       4GL             --              EOL
                5       Shell/PERL      #               EOL
                6       Pascal          (*              *)
                6       Pascal          {               }
                7       Fortran         * (col 1 or 2)  EOL

                Only one mode may be active at a time, so if more than one
                is specified in the arguments, the last one specified will
                be the active mode.

                NOTE:  The algorithm to handle the logic of determination
                of comments is pretty basic and can easily be fooled; of
                this the author is aware (E.g. nested comments, quoted
                comments), but if you find any particular "bugs", please
                let him know.  Maybe he can improve the algorithm for the
                next version...

*       -mo-    Disable all special processing modes.

        -nb     Disable banner printing.

*       -nb-    Enable banner printing.

        -nf     No Flush - Do not flush out the sheet of paper currently
                being printed upon between files if that sheet of paper has
                any valid new printable page areas.  In duplex mode, such
                an area will be the blank backside of the sheet, and in
                2-up or 4-up mode, it will be the next unused page area.

                E.g.: if 4 1-page documents were printed in 4-up with no
                      flush, all 4 files would be printed on the same sheet
                      of paper.

*       -nf-    Flush pages between files ie.  even if only one character
                has been printed on the last sheet of paper for the file,
                this sheet will be flushed before starting on the next
                file.

        -nz     No Zeros - Replace leading zeros in Line Numbers with space
                characters.

*       -nz-    Use leading zeros in Line Numbers.

        -of<path>
                Output PostScript to <path> instead of the default output
                file, where <path> may be a filename (E.g. c:\example.ps)
                or the name of another device (E.g. LPT1 or COM1).

                EXAMPLE: -ofC:\TEMP\EXAMPLE.PS  output the PostScript to
                                                the specified file.

                See PRINTERS below.

                PLEASE NOTE
                If PCPS detects that its output is being piped to another
                program it will automatically send the PostScript to stdout
                and totally ignore any output file specified with this
                argument.  In this mode, PCPS sends the screen information
                to stderr.  This feature maybe over-ridden with -of-


*       -of-    Use the default output file ie. for DOS and OS/2 it is
                LPT2 and is piped to lpr for Unix.

                PLEASE NOTE
                This argument over-rides the autosensing of piped output
                and may be followed by a -of<file> or -P<printer> argument
                to force the output to a particular destination


**      -P<printer name>
                Specify a printer name other than the default for output.
                The default may be defined in the makefile.

                See PRINTERS below.

**      -P-     Set printer name back to the default.

        -pp<file path>
                Get printer preparation data from the file specified by
                <file path>.  The contents of this file are sent to the
                printer prior to any other output from PCPS. See SUPPORT
                FILES.

                EXAMPLE: -ppC:\PRINT.PRP Use the file PRINT.PRP under the
                                         directory C:\

                NOTE:  As a default, PCPS will look for printer preparation
                       data from the file PCPS.PPF as specified in SUPPORT
                       FILES.

        -pp-    Do not use any printer preparation file.

        -pr<n[-|,|$>
                Specify page ranges to print where a range may be a single
                page (n), a range of pages (n1-n2) or from a page to the
                end of the document (n-$).  Each separate range
                specification should be separated by a comma.

                EXAMPLE: -pr1-12,35,50-$ print pages 1 through 12, 35 and 50
                                         through to the end of the document.

*       -pr-    Print all pages.

        -pt     Add timing code to the PostScript to cause the printer to
                dump timing information back out its comms line so that it
                may be captured (to a log file for instance).  This
                information can be useful when analysing printer performance.

*       -pt-    Disable PostScript timing code.

        -qu     Quiet mode - no fancy information is displayed.  For each
                file processed, only the number of pages printed is
                displayed.

        -qut    Quiet Total mode - no screen output at all.

*       -qu-    Noisy :-) mode with lots of information displayed.  This
                argument will cancel both -qu and -qut.

        -ro     Rotate the print 90 degrees to Landscape orientation.

*       -ro-    Use portrait orientation.

        -sh[s<x>][l<y>]
                Shade lines with a grey background - useful to make
                listings or tables more readable.  By default, every second
                line will be shaded (ie. y=1) and the shading will be done
                at 96% white (ie. x=96).

                EXAMPLE: -shl3    Shade 3 lines, leave 3 lines etc.
                         -shl3s90 As above but with 90% white shading.

*       -sh-    Do not background shade any lines.

        -sm<o|e>
                Enable margin swapping for double sided printing on (O)dd
                or (E)ven pages.

                In Portrait mode the Left and Right margins will be swapped
                on the specified pages as well as the Page-number and File-
                -time boxes in the Gaudy header if gaudy mode is enabled.

                In Landscape mode the Top and Bottom margins are swapped on
                the specified pages.  No change is performed on the Gaudy
                banner.

*       -sm-    Disable margin swapping.

        -sz<xx> Use paper size "xx" which can be any of the following
                codes.

                VALID CODES:  a0 = A0 paper size
                              a1 = A1 paper size
                              a2 = A2 paper size
                              a3 = A3 paper size
                              a4 = A4 paper size
                              lt = US letter paper size
                              ex = Executive paper size
                              lg = Legal paper size
                              mo = Monarch envelope size
                              co = COM10 envelope size
                              dl = DL envelope size

                EXAMPLE: -szlt    set the paper size to US letter (11" x 8.5")

*       -sz-    Use default paper size (A4).

*       -tb[n]  Expand tab characters to spaces.  If "n" is specified, tabs
                will be expanded to "n" spaces, otherwise they will be
                expanded to 8 spaces.

                EXAMPLE: -tb   expand all tab characters to 8 spaces (default).
                         -tb4  expand all tab characters to 4 spaces.

        -tb-    Do NOT expand tab characters; pass them through untouched.

        -tr     Truncate lines longer than the maximum number of
                characters allowed in the current mode.

*       -tr-    Disable truncation of lines - wrap them instead.

        -ty<x>[,n,y]
                Specify the paper tray to start with where "x" may be a
                number between 0 and 2, or one of the codes below. This
                may be followed by an optional number which specifies
                the number of pages "n" to print from this tray before
                switching to the tray "y".  If both "x" and "y" are
                specified, they must both be numbers or both be codes -
                you cannot mix codes and numbers.

                VALID CODES:  a4 = A4 paper tray
                              lt = US letter paper tray
                              ex = Executive paper tray
                              lg = Legal paper tray
                              mo = Monarch envelope tray
                              co = COM10 envelope tray
                              dl = DL envelope tray

                VALID NUMBERS: 0 = Top tray on most printers
                               1 = Middle tray on 3 tray or bottom on 2 tray
                               2 = Bottom on most 3 tray printers

                EXAMPLE: -ty0,1,2 print the first page from tray 0 (the top
                                  tray), then switch to tray 2 (the bottom
                                  tray on a printer with 3 trays).

*       -ty-    Do NOT specify any trays - use the printers default.

        -up<n>  Print n-up pages on every sheet of paper, where n can be 2
                or 4.  This argument may be used in conjunction with 2
                column mode (-2c) to give up to 8 pages per sheet, though
                you would want to have a very good printer and great eyes
                to read the text :-)  Unlike 2 column mode, this mode
                treats each page as separate, so each gets its own banner
                etc.

                Be aware that each page is treated as full size when it is
                created on the virtual page, but then rescaled, repositioned
                and possibly re-oriented before actually being printed.
                Consequently, if you selected a font size of 10.0 and 4-up,
                the actual font size will end up being a tad less than 5.0.

                WARNING:  Though this mode works fine for normal printing
                scenarios, it has not been extensively tested with all
                possible combinations of arguments (E.g. those involving
                printing odd or even pages etc.) and so is not guaranteed
                to work under all circumstances.  If you use any unusual
                combination of arguments, the author would be interested in
                hearing your results either way :-)

*       -up-    Do not use n-up pages, just print 1 page per sheet.

        -wm<text>
                Print "text"  as a WaterMark in grey on the background
                of each page where "text" may be up to 40 characters.

                ****See TEXT ARGUMENT RULES.

*       -wm-    Disable WaterMark printing.


      * All arguments preceded by * reflect the default conditions for PCPS.

     ** Arguments only apply to the UNIX version of PCPS.

        Normal DOS style wildcards (* and ?) are allowed when specifying
        the input files under DOS, OS/2 and Windows.

        Under UNIX, wildcard expansion is done by the shell you are
        utilising at that time.

PRINTERS

        The order of precedence for determining the printer is:
                1. Command line with arguments -of or -P
                2. pcps.cfg file with above arguments
                3. PRINTER environment variable
                4. pcps.adm file
                5. Default printer

TEXT ARGUMENT RULES
        Any text that is attached to any argument accepting text input
        (-fn, -ga, -g1 and -wm) must obey the following rules:

        -if it is one word with no white-space, it may just follow the
         argument:

         E.g. -gaOne_Word_Comment


        -if it includes white-space, the whole argument should be enclosed
         in double quotes:

         E.g. "-wmMulti word comment"


        -if the character sequence "##id" is included anywhere in the
         text, it will be replaced with the "user@host" string as is used
         in the -id argument, where "user" will be the userid of the person
         running the job, and "host" will be the hostid of the machine upon
         which the job is running, as determined by PCPS (see -id argument):

         E.g. "-fnFrom the desk of ##id"


ENVIRONMENT
        PCPSCFG
                Points to a directory containing a PCPS configuration file
                (See SUPPORT FILES).

        PCPSPPF
                Points to a directory containing a PCPS printer prep file
                (See SUPPORT FILES).

        PRINTER
                In the absence of a printer being specified on the command
                line, or in a pcps.cfg file in the local directory, PCPS
                will then check for the presence of this variable and
                attempt to send the output to the printer specified by this
                variable.

SUPPORT FILES
        PCPS can have three support files:  pcps.adm, pcps.cfg and pcps.ppf

        pcps.adm
                This is the Administrator config file which must exist in
                the same directory as the PCPS executable, and will be
                processed before any other support file or the command
                line.  This file can contain arguments just the same as
                command line arguments, and is therefore useful for System
                Administrators to specify local system defaults in a
                network environment.

        The other two files are more intended for the users and are
        described below:

        pcps.cfg
                This file can contain arguments in the same way that the
                command line can have arguments.  The arguments may be
                spread over several lines and will be processed
                sequentially.

                PCPS processes arguments from this file first, should it
                exist in the current directory, and then from the command
                line, so the command line arguments may over-ride the
                arguments in this file or even negate them.

        pcps.ppf
                Some PostScript printers require some setup or preparation
                information sent to them before the output of PCPS.  This
                support file is provided for such purposes.

                Any characters contained in this file will sent to the
                output file before any PostScript output from PCPS.

        The Printer Preparation file (PPF) may be explicitly specified by
        the -pp argument or explicitly disabled by -pp- but if not, the
        method for locating both of the above files is identical:

        For each file, if the related environment variable is set (See
        ENVIRONMENT), the file is sought from the directory specified by
        the variable.  If the variable is not set or the file is not found
        in this directory, the file is sought in the current directory and
        if that fails, it is sought in the directory from which the PCPS
        executable originated.

SCREEN SUPPORT
        PCPS can support differing numbers of lines per screen and provides
        a "more" feature when listing font codes or showing usage.  At the
        [more] prompt you may view the next screen by pressing any key
        other than the "q" key which will quit the output.

        The Unix version no longer tries to handle the "more" functionality
        as too many different Unix flavours handle CURSES with differing
        amounts of success, so pcps now opens a pipe to the command "more"
        or any command as defined by the user within the makefile.

SUPPORTED FONTS
        PCPS currently supports the default fonts built into an Apple
        Laserwriter and assumes that the target printer will "know" these
        fonts.  PCPS additionally supports its own font named IBMPCFont.
        Listed below are the fonts and the code for each that may be used
        with the -fo argument:


                FontCode   Font

                AGB        AvantGarde-Book
                AGBO       AvantGarde-BookOblique
                AGD        AvantGarde-Demi
                AGDO       AvantGarde-DemiOblique
                BD         Bookman-Demi
                BDI        Bookman-DemiItalic
                BL         Bookman-Light
                BLI        Bookman-LightItalic
                C          Courier
                CB         Courier-Bold
                CBO        Courier-BoldOblique
                CO         Courier-Oblique
                H          Helvetica
                HB         Helvetica-Bold
                HBO        Helvetica-BoldOblique
                HN         Helvetica-Narrow
                HNB        Helvetica-Narrow-Bold
                HNBO       Helvetica-Narrow-BoldOblique
                HNO        Helvetica-Narrow-Oblique
                HO         Helvetica-Oblique
                IBM        IBMPCFont <===========(default)
                NCSB       NewCenturySchlbk-Bold
                NCSBI      NewCenturySchlbk-BoldItalic
                NCSI       NewCenturySchlbk-Italic
                NCSR       NewCenturySchlbk-Roman
                PB         Palatino-Bold
                PBI        Palatino-BoldItalic
                PI         Palatino-Italic
                PR         Palatino-Roman
                S          Symbol
                TB         Times-Bold
                TBI        Times-BoldItalic
                TI         Times-Italic
                TR         Times-Roman
                ZCMI       ZapfChancery-MediumItalic
                ZD         ZapfDingbats


        PCPS now supports most European characters in all text fonts and
        the full IBM/PC character set with its own default font IBMPCFont.
        The default encoding for all fonts other than IBMPCFont is
        ISO-Latin-1.

INPUT FILES
        If the input file is found to be already in PostScript format, PCPS
        will prompt the user for one of three possible actions:

                1. [S]kip the file      - Self explanatory.
                2. [O]utput unchanged   - Send the file to the output as it
                                          is.
                3. [P]rocess it         - Process the file as text resulting
                                          in a printout of the PostScript.

REQUIREMENTS

        FAMILY MODE VERSION
                For running under DOS, V2.1 is the minimum required
                version.
                For running under OS/2 the user should require OS/2 1.0 or
                higher though currently PCPS has only been confirmed
                running under OS/2 1.3.1, 2.0, 2.1 and 3.0.  The author
                would appreciate confirmation that it runs under any other
                version.

        WINDOWS 95/98/NT VERSION
                This version has been tested on Windows 95 including the
                "B" build (commonly referred to as Windows 97) and Windows
                98.  It has also been tested on Windows NT versions 3.51
                and 4.0.

        UNIX VERSIONS
                PCPS is available for UNIX.  It has been confirmed to run
                on a wide range of platforms including:

                        AIX
                        HP/UX
                        SunOS
                        Solaris
                        Ultrix
                        FreeBSD
                        NetBSD
                        Linux
                        DGUX


DIAGNOSTICS
        These should be fairly self-explanatory.

AUTHOR
        Paul Carapetis
        Internet: Paul_Carapetis@iname.com

BUGS
        Far too many arguments, but all of these have been requested by
        users, so I guess some-one is using them :-)

        Hopefully there are no others but sometimes they manage to sneak
        their ugly little heads through, so the author would be extremely
        grateful to hear from anyone encountering any of these little
        beasties!

NOTES
        PostScript is a trademark of Adobe Systems Incorporated.

