/*	MDICT:	Main Dictionary processing for MicroSPELL 2.0
		Spell Checker and Corrector

		(C)opyright May 1987,1992 by Daniel Lawrence
		All Rights Reserved
*/

#include	<stdio.h>
#include	"dopt.h"
#include	"dstruct.h"
#include	"ddef.h"
#include	"dsfx.h"

/* compression function globals */
char lastword[NSTRING];		/* last word from dictionary */

mopen()		/* open the main dicionary */

{

	/* if it is already open, close it down */
	if (mdptr != NULL)
		fclose(mdptr);

	/* open up the main dictionary... */
	if ((mdptr = popen(mdfile, "rb")) == NULL) {
		printf("%%Can not find main dictionary\n");
		return(FALSE);
	}

	/* and read the letter offset table */
	fread((char *)&(letter_offset[0]), sizeof(long), ALPHASIZE, mdptr);

	return(TRUE);
}

mclose()	/* close the dictionary down */

{
	/* if it is already open, close it down */
	if (mdptr != NULL)
		fclose(mdptr);
	mdptr = NULL;
}

char *lastmword()	/* get the last word gotten again! */

{
	return(lastword);
}

char *nxtmword()	/* get the next word from the main dictionary */

{
	static char word[NSTRING];	/* word to return */
	char *gcword();

	/* is it already closed? */
	if (mdptr == NULL)
		return(hivalue);

	/* get the next word */
	if (gcword(word) == NULL) {

		/* no more left!!!! close out */
		fclose(mdptr);
		mdptr = NULL;
		return(hivalue);
	}

	/* all's well, dump the return and return the word */
	return(word);
}

char *skipdict(first_char)	/* position us at the first word with this letter */

char first_char;

{
	register int offset;	/* index into letter offset table */

	/* is it already closed? */
	if (mdptr == NULL)
		return(hivalue);

	/* lookup the correct offset */
	offset = lcase[first_char] - 'a';

	/* position us at the right offset in the file */
	fseek(mdptr, letter_offset[offset], 0);

	strcpy(lastword, "");
}

char *gcword(word)	/* get the next compressed word */

char *word;	/* buffer to place word in */

{
	register int c;		/* current character from file */
	register char *wptr;	/* ptr into word to return */
	register char *lptr;	/* pointer int last word */
	int same;		/* # of common characters from last word */
	int suffix;		/* index of common suffix */
	int fgetc();
	int upper_flag;		/* is this word upper case? */

	/* first grab the #same count */
	same = fgetc(mdptr);
	if (same == EOF)	/* at EOF... return NULL */
		return(NULL);
	upper_flag = FALSE;
	if (same > 127) {
		upper_flag = TRUE;
		same |= 127;
	}
	same -= 'A';

	/* and copy things across */
	wptr = word;
	lastword[0] = lcase[lastword[0]];
	lptr = lastword;
	while (same-- > 0)
		*wptr++ = *lptr++;

	c = fgetc(mdptr);
#if     EBCDIC
	/* opposite high bit flags */
        while (c > 128) {
#else
        while (c < 128) {
#endif
		*wptr++ = c;
		c = fgetc(mdptr);
	}

	*wptr = 0;

	/* calculate the suffix to add... */
	suffix = c & 127;
	if (suffix != NSUFFIX)
		strcpy(wptr, sfx[suffix]);

	/* upper cased? */
	if (upper_flag)
		word[0] += 'A' - 'a';

	/* save the current uncompressed word */
	strcpy(lastword, word);

	/* and return the word */
	return(word);
}
