# Schedule operators post processing

$SHIFTS = 4;

open(POSE, $ARGV[0]);

# Read in site names
$site = 0;
for (;;)
{
  $_ = <POSE>;
  chop;
  last if /^$/;
  $siteName[$site++] = $_;
}

# Read in operator names
$opIndex = 0;

while (<POSE>)
{
  # Get operator name
  /^([A-Za-z ]+)/;
  $opName[$opIndex] = $1;

  # Skip shift preferences
  for ($d=0; $d < 7; $d += 1)
  {
    $_ = <POSE>;
  }

  $opIndex += 1;
}

close POSE;

# Read in solution and format results

open(SOLUTION, $ARGV[1]);

@shiftName = ("8am", "noon", "4pm", "8pm");

for ($b = 0; $b < $site; $b += 1)
{
  print "$siteName[$b]\n\n";
  for ($s = 0; $s < $SHIFTS; $s += 1)
  {
    $shift = $shiftName[$s];

    for ($d = 0; $d < 7; $d += 1)
    {
      $_ = <SOLUTION>;          # get one operator assignment
      chop;
      /^x....(\d\d)/;           # last two digits are operator number
      $operator = $opName[$1];
      eval "\$d$d = \$operator;";
    }
    write;
  }
  print "\n\n";
}

close SOLUTION;
  

format top =
        S         M         T         W         T         F         S
.

format =
@<<<  @<<<<<<<< @<<<<<<<< @<<<<<<<< @<<<<<<<< @<<<<<<<< @<<<<<<<< @<<<<<<<<
$shift, $d0,    $d1,      $d2,      $d3,      $d4,      $d5,      $d6
.
