# Schedule operators given shift and site preferences

$SHIFTS = 4;

# Count sites
$site = 0;
for (;;)
{
  $_ = <>;
  last if /^$/;
  $site += 1;
}

# Read in operator preferences         # Output objective function

$opIndex = 0;                          print "min:\n";

while (<>)
{
  # Get operator name
  s/^([A-Za-z ]+)//;
  $opName[$opIndex] = $1;

  # Get site preferences
  @sitePref = split;

  # Read in shift preferences for each day
  for ($d=0; $d < 7; $d += 1)
  {
    $_ = <>;
    @pref = split;
    for ($b = 0; $b < $site; $b += 1)
    {
      for ($s = 0; $s <= $SHIFTS; $s += 1)
      {
        $varName = &varName($b, $d, $s, $opIndex);
        $coef = 10*$pref[$s] + $sitePref[$b];
        print "$plus $coef $varName\n";
        $plus = '+';
      }
    }
  }

  $opIndex += 1;
}

print ";\n";

# Each operator can work up to 5 shifts
for ($o = 0; $o < $opIndex; $o += 1)
{
  $plus = '';
  for ($b = 0; $b < $site; $b += 1)
  {
    for ($d = 0; $d < 7; $d += 1)
    {
      for ($s = 0; $s < $SHIFTS; $s += 1)
      {
        $v = &varName($b, $d, $s, $o);
        print "$plus $v\n";
        $plus = '+';
      }
    }
  }
  print "<= 5;\n";
}

# No operator works more than once per day

for ($d = 0; $d < 7; $d += 1)
{
  for ($o = 0; $o < $opIndex; $o += 1)
  {
    $plus = '';
    for ($b = 0; $b < $site; $b += 1)
    {
      for ($s = 0; $s < $SHIFTS; $s += 1)
      {
        $v = &varName($b, $d, $s, $o);
        print "$plus $v\n";
        $plus = '+';
      }
    }
    print "<=1;\n";
  }
}

# Must fill all shifts
#$plus = '';
#for ($b = 0; $b < $site; $b += 1)
#{
#  for ($d = 0; $d < 7; $d += 1)
#  {
#    for ($s = 0; $s < $SHIFTS; $s += 1)
#    {
#      for ($o = 0; $o < $opIndex; $o += 1)
#      {
#        $v = &varName($b, $d, $s, $o);
#        print "$plus $v\n";
#        plus = '+';
#      }
#    }
#  }
#}
#$allShifts = $SHIFTS * $site * 7;
#print "= $allShifts;\n";

# Only one person per shift and site
for ($b = 0; $b < $site; $b += 1)
{
  for ($d = 0; $d < 7; $d += 1)
  {
    for ($s = 0; $s < $SHIFTS; $s += 1)
    {
      $plus = '';
      for ($o = 0; $o < $opIndex; $o += 1)
      {
        $v = &varName($b, $d, $s, $o);
        print "$plus $v\n";
        $plus = '+';
      }
      print "= 1;\n";
    }
  }
}

sub varName
{
  local($site, $day, $shift, $operator) = @_;
  sprintf('x%02d%d%d%02d', $site, $shift, $day, $operator);
}
