program RandTest;
  uses CRT,NoiseKey;

function HexStr(x: byte): string; assembler;
const HexTabl:string[16] = '0123456789abcdef';
asm
   mov  dx, es
   mov si, Offset HexTabl+1
   les di, @Result
   xor bx, bx
   cld
   mov al, 2
   stosb
   mov al, x
   aam 16
   xchg ax, cx
   mov bl, ch
   mov al, [si+bx]
   mov bl, cl
   mov ah, [si+bx]
 {  mov bl, x
   and bl, $0F
   mov ah, [si+bx]
   mov bl, x
   mov cl, 4
   shr bl, cl
   mov al, [si+bx] }
   stosw
   mov  es, dx
end;

procedure ShowKeyPresses;
var
  C: Char;
  P: ^String;
  j: Word;
begin
  P := GetRandPoolAddr;
  WriteLn;
  WriteLn('"NoiseKey" random pool test.');
  WriteLn('Use <Esc> to exit.');
  WriteLn;
  repeat
    for j := 0 to Pred(RandPoolSize)
      do Write(HexStr(Ord(P^[j])));
    WriteLn(NumRandBits:5,' bits.');
    C := ReadKey;
  until C=#27;
  WriteLn;
end;


begin
  if not InstallKbdISR
    then WriteLn('Unable to install handler.')
    else begin
        WriteLn('Hander installed Ok.');
        ShowKeyPresses;
        If not UnInstallKbdISR
          then WriteLn('Unable to uninstall handler: We''ve got problems...')
          else WriteLn('Handler uninstalled Ok.');
      end;
end.
