COMMENT |
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
| = Routines to handle the random noise pool ===============================
; Note: these are similar to those used by KeyRand.Asm

; - Sample IRQ0 Timer -----------------------------------------------------

; (Based on the pctimer0() function in noise.c from the pgp 2.6.2 sources.)

PcTimer0            PROC        NEAR
                    push        bx                  ; save registers
                    IFNDEF      __for286
                      push        cx
                    ENDIF
                    in          al,         Timer0  ; get timing value
                    mov         al,         0c2h
                    out         TimerCntl,  al
                    in          al,         Timer0
                    and         al,         80h
                    mov         bx,         ax
                    IFNDEF      __for286     
                      mov       cl,         8 
                      shl       bx,         cl    
                    ELSE
                      shl       bx,         8     
                    ENDIF
                    xor         al,         al
                    out         TimerCntl,  al
                    in          al,         Timer0
                    and         ax,         0ffh
                    shr         ax,         1
                    or          bx,         ax
                    in          al,         Timer0
                    and         ax,         0ffh
                    IFNDEF      __for286
                      mov       cl,         7             
                      shl       ax,         cl           
                    ELSE
                      shl       ax,         7              
                    ENDIF
                      or        ax,         bx
                    IFNDEF      __for286
                      pop       cx
                    ENDIF
                    pop         bx
                    ret         
PcTimer0            ENDP        

LastTick            LABEL       WORD  ; save value of last call to PcTimer0
                    DW          (?)

Noise           PROC  NEAR            ; added v1.3.3, RRWO
              IFNDEF    __USERNDBITS                
                  mov   si,     (RandPoolSize-1)
                  xor   bl,     BYTE PTR cs:[RandomPool][si]
 @AddRandBytes:   mov   al,     BYTE PTR cs:[RandomPool][si-1]
                  mov   BYTE PTR cs:[RandomPool][si], al
                  dec   si
                  or    si,     si
                  jnz   SHORT @AddRandBytes
                  mov   BYTE PTR cs:[RandomPool], bl
                  add   WORD PTR cs:[BitsInPool], 8
               ELSE                   ; def'd __USERNDBITS may be useless(?)
                  xor   si,     si
                  push  cx
                  mov   cx,     RandPoolSize
                  rcr   bx,     1
 @AddRandBits:    rcr   BYTE PTR cs:[RandomPool][si], 1
                  inc   si
                  loop  @AddRandBits
                  inc   WORD PTR cs:[BitsInPool]
                  pop   cx
               ENDIF
                ret
Noise           ENDP

; -------------------------------------------------------------------------
; samples keyboard timings
; -------------------------------------------------------------------------
SampleNoise      PROC  NEAR                  
                 push  si
 @ReSample:      call  PcTimer0
                 mov   bx,     ax
                 xchg  ax,     WORD PTR cs:[LastTick]
                 sub   bx,     ax
                 jz    SHORT @ReSample ; added v1.3.3 to limit duplicate
                 call  Noise           ; samplings, RRWO
                 cmp   WORD PTR cs:[BitsInPool], (RandPoolSize*8)
                 jna   SHORT @NoAdjustCount
                 mov   WORD PTR cs:[BitsInPool], (RandPoolSize*8)
 @NoAdjustCount: pop   si
                 ret
SampleNoise      ENDP                  

; - The Random-Noise Pool -------------------------------------------------

; Note: one should maintain a random-seed file and load RandPoolSize bytes
;       into the RandomPool (prior to initializing the handler, pref.) or
;       use the __INITRANDPOOL define to "auto-fill" the random pool.

RandomPool            LABEL BYTE
                      DB        RandPoolSize dup (?)

BitsInPool            LABEL WORD  ; no. bits in random Number pool
                      DW    0

; - Routine to return the no. of random bits in the pool ------------------
                    
                    PUBLIC Numrandbits
Numrandbits         PROC   FAR
                    mov    ax, WORD PTR cs:[BitsInPool]
                    ret
Numrandbits         ENDP

; - Returns the address of the Random-Noise Pool --------------------------

; Note: it's probably a good idea to wipe the random pool when you are                    
;       done with it. (the uninstall procedure doesn't do that!)

                    PUBLIC  GetRandPoolAddr
GetRandPoolAddr     PROC    FAR
                    mov     ax, cs
                    mov     dx, ax
                    mov     ax, OFFSET RandomPool
                    ret
GetRandPoolAddr     ENDP

; - Initialize the Random-Noise Pool --------------------------------------

              IFDEF    __INITRANDPOOL
InitRandPool     PROC  NEAR          ; added v1.3.3, RRWO
                 mov   di,      cs
                 mov   es,      di
                 mov   di,      OFFSET RandomPool
                 mov   cx,      RandPoolSize
  @InitRandLoop: cmp   WORD PTR cs: [BitsInPool], (RandPoolSize*8)
                 je    @DoneInitRand
                 call  SampleNoise
                 jmp   SHORT @InitRandLoop
  @DoneInitRand: 
                 ret
InitRandPool     ENDP
              ENDIF

