COMMENT |
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
| = Routines to map which keys are pressed ================================

; This is useful for applications (such as games) which require the ability
; to determine is multiple keys are pressed at once.

MarkKeyPress    PROC    NEAR        ; Called by ISR to mark a depressed key
                mov     bl, al      ; Convert scan code to an index for the
                and     bl, not ReleaseBit ; "map"
                xor     bh, bh
                mov     cl, bh             ; set "mark" to zero
                test    al, ReleaseBit     ; if key is not released
                jnz     @NotPressed        ; then change mark to -1
                not     cl
 @NotPressed:   mov     cs:[Map_KeyPress][bx], cl ; set flag for scan code
                ret
MarkKeyPress    ENDP

; - Public routine to return address of Key-Press Map to the user ---------

                PUBLIC  GetKeyPrMapAddr
GetKeyPrMapAddr PROC    FAR       
                mov     ax, cs
                mov     dx, ax
                mov     ax, OFFSET Map_KeyPress
                ret
GetKeyPrMapAddr ENDP

; - Key-Press Map ---------------------------------------------------------

Map_KeyPress    LABEL   BYTE
                DB      128 DUP (0)
                    
; Note: The table is of scan codes. When Map_KeyPress[code]<>0, key "code"
;       is depressed. Note that the program must take care to empty keys
;       from the buffer unless __DONTDECODE is defined.


