COMMENT |
============================================================================
  
  KeyHand.Asm v1.3.3, Keyboard Data Ready ISR (18 January 1995)
  (c) Copyright 1994-1995 Robert Rothenburg Walking-Owl
  
  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
 
  Thanks to:
    David Kotchan <dkotchan@physics.utoronto.ca> for help with LED toggles
  
  Geek Notes (Things that still need to be added or fixed):
 
   o Improve sound and timing of beep when keyboard queue is full
   o Add handling of Cntl-Break, SysReq, Cntl-Alt-Del, Pause, Shift-PrtSc
     [ allow for use to separately define these, or to call interrupts?
       the handler could process PrtScr separately from Int 05 so one
       could use the BOUND instruction... ]
   o Add handling of enhanced keyboard codes? (I don't have one to test with)
   o Add handling of keyboard errors (ACK, RESEND, TIMEOUT, etc...)
   o Option to use BIOS Data Area, so handler could function as a TSR that
     adds some goodies?
   o Sampling of random noise should check for repeated samples (esp. since
     paranoids may say that pctimer irq can be tampered with?) Also, make it
     a separate routine to add noise, and allow external proggie to also add
     noise from other sources w/that routine (such as mouse position,
     current video scan lines, etc...).
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
============================================================================
| Note: source has been assembled successfully with MASM 5.0 and TASM 3.2

;= Constants ===============================================================
                  
                  IFNDEF RandPoolSize     ; if RandPoolSize not defined,
RandPoolSize        EQU   0               ; set it to 0
                  ENDIF

                  IFNDEF KeyQueueSize
KeyQueueSize        EQU   16
                  ENDIF

DOS                 EQU         21h  ; DOS interrupt vector                   

BIOS_DataSeg        EQU         40h  ; BIOS Data Segment
BIOS_KbdFlags       EQU         17h  ; Offset of Keyboard Status Flags 1&2
BIOS_AltWorkSpace   EQU         19h  ; Keyboard <Alt>nnn keypad workspace
BIOS_QueueEnd       EQU         1ah
BIOS_QueueStart     EQU         1ch
BIOS_KeyQueue       EQU         1eh
BIOS_KeybdStatus    EQU         96h

PortCntl        EQU     20h               ; Interrupt Control Port
Timer0          EQU     40h               ;
Timer2          EQU     42h               ; Speaker Port
TimerCntl       EQU     43h
Keybd0          EQU     60h               ; Keyboard Data Port
KeybdCntl       EQU     61h               ; Keyboard Control Port
KeybdStatus     EQU     64h               ; Keyboard Status Port

ReleaseBit      EQU     80h               ; bit 7 set = key released

Flag_RShift     EQU     0000000000000001b ; right Shift key depressed
Flag_LShift     EQU     0000000000000010b ; left Shift key depressed
Flag_Cntl       EQU     0000000000000100b ; either control key depressed
Flag_Alt        EQU     0000000000001000b ; either Alt key depressed
Flag_ScrollE    EQU     0000000000010000b ; Scroll-Lock enabled
Flag_NumE       EQU     0000000000100000b ; Num-Lock enabled
Flag_CapsE      EQU     0000000001000000b ; Caps-Lock enabled
Flag_InsertE    EQU     0000000010000000b ; Insert key Toggled
                    
Flag_Shift      EQU     Flag_RShift or Flag_LShift

EndOfInterrupt  EQU     20h

             IFDEF   __ENHANCED
Key_LeftSlash   EQU      56h
PrefixCode0     EQU     0E0h
PrefixCode1     EQU     0E1h
                    
Flag_PrefixE0   EQU     0000000000000010b ; Prefix-Code 0xE0 was last code
Flag_PrefixE1   EQU     0000000000000001b ; Prefix-Code 0xE1 was last code
             ENDIF

InFl_8BitCode   EQU     0000001000000000b ; scan code > 7Fh
                     
; - Scan-Codes for Certain Keys -------------------------------------------

Key_Esc         EQU     01
Key_One         EQU     02
Key_Two         EQU     03
Key_Six         EQU     07
Key_Dash        EQU     0ch
Key_EqualSign   EQU     0dh
Key_Tab         EQU     0fh
Key_LtBracket   EQU     1ah
Key_Enter       EQU     1ch
Key_LtCntl      EQU     1dh
Key_Colon       EQU     27h
Key_BackQuote   EQU     29h
Key_LtShift     EQU     2ah
Key_BackSlash   EQU     2bh
Key_Comma       EQU     33h
Key_Slash       EQU     35h
Key_RtShift     EQU     36h
Key_ltAlt       EQU     38h
Key_Caps        EQU     3ah
Key_F1          EQU     3bh
Key_F10         EQU     44h
Key_Num         EQU     45h
Key_Scroll      EQU     46h
Key_Home        EQU     47h
Key_PgDn        EQU     51h
Key_Insert      EQU     52h
Key_Del         EQU     53h
KeybdErrorCode  EQU     7Ah    ; this occurs after several LED toggles
KeybdTestCode   EQU    0EEh 

; = Installation-related Routines =========================================
                    
                    IFDEF       __for286
                      .286
                    ENDIF

CODE                SEGMENT     BYTE PUBLIC
                    ASSUME      cs: CODE
                    ASSUME      ds: NOTHING, es: NOTHING, ss: NOTHING

               INCLUDE KeyHand.Mac               ; include macros
               
               INCLUDE AsciiTbl.Inc

; - Routine to check for installation (returns nz. if installed) ----------

                PUBLIC  CheckForInstall
CheckForInstall PROC    FAR
                pushf
                cli
                mov     dx,    -1
              IFNDEF    __TSR  
                xor     ax,    ax
                mov     es,    ax
                mov     ax,    OFFSET NewKeybdISR
                cmp     WORD PTR es: [ 0024h ], ax
                jne     SHORT @Latch
                mov     ax,    cs
                cmp     WORD PTR es: [ 0026h ], ax
                je      @NoLatch
              ELSE
                push    ds
                mov     ax, 3509h
                int     DOS
                mov     di, bx
                mov     si, cs
                mov     ds, si
                mov     si, OFFSET TSR_Marker
                mov     cx, NewKeybdISR-TSR_Marker
                sub     di, cx
                repe    cmpsb
                je      @NoLatch
              ENDIF
 @Latch:        not     dx
 @NoLatch:      mov     ax,    dx
              IFDEF     __TSR  
                pop     ds
              ENDIF
                popf
                ret
CheckForInstall ENDP

; - Routine to wipe keyboard buffer ---------------------------------------
              
              IFNDEF    __DONTDECODE
               IFNDEF   __USEBIOS 
ResetQueue      PROC    NEAR
                push    ax
                mov     bx,  OFFSET KeyQueue
                mov     cx,  KeyQueueSize
                xor     ax,  ax
 @WipeKeyLoop:  mov     WORD PTR cs:[bx], ax
                inc     bx
                loop    @WipeKeyLoop
                xor     ax,     ax            
                mov     WORD PTR cs:[QueueStart], ax
                mov     WORD PTR cs:[QueueEnd], ax
                pop     ax
                ret
ResetQueue      ENDP
               ENDIF
              ENDIF

; - Installation Routine --------------------------------------------------
                
                PUBLIC  InstallKbdISR
InstallKbdISR   PROC    FAR
                pushf
                cli
                push    ds
                call    cs:[CheckForInstall]
                or      ax,     ax
                jnz     @IsInstalled
          IFNDEF   __DONTDECODE      
                mov     ax,     BIOS_DataSeg
                mov     es,     ax
                mov     ax,     WORD PTR es:[BIOS_KbdFlags]
                mov     WORD PTR cs:[KeybdFlags], ax ; save Flags
                mov     WORD PTR cs:[InternFlags], 0
            IFDEF  __HOOKINT16
                mov     ax,  3516h
                int     DOS
                mov     WORD PTR cs:[OldInt16Vector+2], es
                mov     WORD PTR cs:[OldInt16Vector], bx
                mov     ax,  2516h
                mov     dx,  cs
                mov     ds,  dx
                mov     dx,  OFFSET NewInt16Handler
                int     DOS
            ENDIF
          ENDIF     
                mov     ax,  3509h ; get int 09 address
                int     DOS
                
                cmp     bx, OFFSET NewKeybdISR ; double check!
                jne     @NotInstalled
                mov     ax, es
                mov     dx, cs
                cmp     ax, dx
                jne     @NotInstalled
 @IsInstalled:  xor     ax,     ax
                jmp     SHORT   @ExitInstall
 @NotInstalled: 
                mov     WORD PTR cs:[OldInt09KbdISR+2], es
                mov     WORD PTR cs:[OldInt09KbdISR], bx
                mov     ax,             2509h ; set new int 09 address
                mov     dx,             cs
                mov     ds,             dx
                mov     dx,             OFFSET NewKeybdISR
                int     DOS
                IFDEF   __INITRANDPOOL
                  call  InitRandPool
                ENDIF
                call    cs:[CheckForInstall] ; verify install
@ExitInstall:   pop     ds
                popf
                ret
InstallKbdISR   ENDP

; - Uninstallation Routine ------------------------------------------------

; Note: rememer to have Cntl-Break or critical-error routines call this                
;       procedure!

                PUBLIC  UnInstallKbdISR
UnInstallKbdISR PROC   FAR
                pushf
                cli
                push    ds
                
                call    cs:[CheckForInstall]  ; are we installed?
                or      ax,  ax
                jz      @CantUnInstall

                mov     ax,             2509h
                mov     dx,             WORD PTR cs:[OldInt09KbdISR]
                mov     ds,             WORD PTR cs:[OldInt09KbdISR+2]
                int     DOS
            IFNDEF      __DONTDECODE    
                mov     ax,     BIOS_DataSeg
                mov     es,     ax
                mov     ax,     WORD PTR cs:[KeybdFlags]
                and     al,     0F0h
                mov     WORD PTR es:[BIOS_KbdFlags], ax
              IFNDEF    __USEBIOS
                call    ResetQueue
              ENDIF
              IFDEF     __HOOKINT16
                mov     ax,             2516h
                mov     dx,             WORD PTR cs:[OldInt16Vector]
                mov     ds,             WORD PTR cs:[OldInt16Vector+2]
                int     DOS
              ENDIF
            ENDIF   
                call    cs:[CheckForInstall] ; verify it!
                not     ax
@CantUnInstall: pop     ds
                popf
                ret
UnInstallKbdISR ENDP

OldInt09KbdISR  LABEL   DWORD     ; where the original vector is
                DD      (?)

           IFNDEF __DONTDECODE

; = Misc. buffers, poiunters, status flags, etc. ==========================

    IFNDEF __USEBIOS

KeyQueue   LABEL WORD
           DW    KeyQueueSize dup (?)

QueueStart LABEL WORD
           DW    0
QueueEnd   LABEL WORD
           DW    0

Alt_ASCII  LABEL BYTE
           DB 000

    ELSE
     %OUT  __USEBIOS define has not been implemented!
     .ERR    ; not yet implemented!
    ENDIF

KeybdFlags LABEL WORD   ; Keyboard Flags
           DW    (?)

InternFlags LABEL WORD  ; Internal Flags
           DW    (?)

; - Initial decoding routine ----------------------------------------------

DeCodeScan      PROC    NEAR
                mov     ah, al
                IFDEF   __ENHANCED
                  cmp   al, PrefixCode0
                  jne   @NotEnhanced
                  or    WORD PTR cs:[InternFlags], Flag_PrefixE0
                  jmp   @IgnoreCode
 @NotEnhanced:  ENDIF
                and     al, not ReleaseBit
                cmp     al, KeybdErrorCode
                je      @IgnoreCode
                mov     cl, 1
                mov     bx, OFFSET Flag_Table
 @FlagTblScan:  cmp     al, BYTE PTR cs:[bx]
                je      @MatchFlag
                inc     bx
                shl     cl, 1
                jnc     @FlagTblScan
 @MatchFlag:    mov     al, cl
                or      al, al
                jz      @NoToggle
                test    ah, ReleaseBit 
                jz      @DepressedFlag
 @ReleasedFlag: cmp     al, Flag_Alt
                ja      @ToggleFlag
                not     al
                and     BYTE PTR cs:[KeybdFlags], al
                jmp     @IgnoreCode
 @ToggleFlag:   xor     BYTE PTR cs:[KeybdFlags], al
 @CheckForDupes: cmp     al, Flag_InsertE
                je      @NoToggle
                call    SetKeybdLED
                jmp     SHORT @IgnoreCode
 @DepressedFlag: cmp     al, Flag_Alt
                ja      @CheckForDupes
                or      BYTE PTR cs:[KeybdFlags], al
 @IgnoreCode:   mov     al, ah
                clc
                ret
 @NoToggle:     mov     al, ah
                and     al, not ReleaseBit
                cmp     al,     Key_F1          ; < F1 ?
                jb      @NotfunctionKey
                cmp     al,     Key_F10         ; > F10 ?
                ja      @NotfunctionKey
 @fKeyScanCode: test    WORD PTR cs:[KeybdFlags], Flag_Shift
                jz      @NotShiftedf
                add     ah,     25
                jmp     @DoneDecode
 @NotShiftedf:  test    WORD PTR cs:[KeybdFlags], Flag_Cntl
                jz      @NotCntlf
                add     ah,     35
                jmp     @DoneDecode
 @NotCntlf:     test    WORD PTR cs:[KeybdFlags], Flag_Alt
                jz      @NotAltf
                add     ah,     45
                jmp     @DoneDecode
 @NotAltf:      
 @NotfunctionKey:
                cmp     al,     Key_Home
                jb      @NotAltASCII
                cmp     al,     Key_Del
                ja      @NotAltASCII
             IFDEF      __CNTLNUMPAD   
                test    WORD PTR cs:[KeybdFlags], Flag_Cntl
                jz      @NotCntlPad
                cmp     al,     Key_Del
                ja      @IgnoreCode
                test    WORD PTR cs:[KeybdFlags], Flag_Alt or Flag_LShift
;;              jnz     @IgnoreCode
                jnz     @NotCntlPad  ; BIOS accepts <Alt><Cntl>nnn codes
                test    ah,     ReleaseBit
                jnz     @IgnoreCode
                call    DoCntlAlt
                or      ah,     ah
                jnz     @DoneDecode
                jmp     SHORT @IgnoreCode
             ELSE
;;              test    WORD PTR cs:[KeybdFlags], Flag_Cntl
;;              jnz     @IgnoreCode
             ENDIF
 @NotCntlPad:   test    WORD PTR cs:[KeybdFlags], Flag_Alt
                jz      @NotAltASCII
                test    WORD PTR cs:[KeybdFlags], Flag_LShift
              IFDEF     __SUPERKEY
                jnz     @AltASCIIhndl
                test    ah,     ReleaseBit
                jnz     @IgnoreCode0
                call    DoSuperKey
                jmp     SHORT @DoneDecode
              ELSE
                jnz     @IgnoreCode
              ENDIF
 @AltASCIIhndl: test    ah,     ReleaseBit
                jz      @IgnoreCode0
                call    DoAltASCII
 @IgnoreCode0:  jmp     @IgnoreCode
 
 @NotAltASCII:   
 @DoneDecode:
                mov     al, ah
                stc
                ret

; the codes in this table are in order for their corresponding Flag
; bit positions.

Flag_Table LABEL BYTE
           DB Key_RtShift, Key_LtShift, Key_LtCntl, Key_ltAlt
           DB Key_Scroll,  Key_Num,     Key_Caps,   Key_Insert

DeCodeScan      ENDP

             IFDEF      __CNTLNUMPAD
DoCntlAlt       PROC    NEAR         ; decode <Cntl>NumPad keys
                xor     bh,     bh
                mov     bl,     al
                mov     al,     BYTE PTR cs:[Map_NumLockCntl][bx-Key_Home]
                and     ah,     ReleaseBit
                or      ah,     al
                or      WORD PTR cs:[InternFlags], InFl_8BitCode
                ret
DoCntlAlt       ENDP
              ENDIF

              IFDEF     __SUPERKEY
DoSuperKey      PROC    NEAR         ; decode SuperKey combinations     
                and     ah,  not ReleaseBit
                add     ah,  67h   
                or      WORD PTR cs:[InternFlags], InFl_8BitCode
                ret
DoSuperKey      ENDP
              ENDIF

DoAltASCII      PROC    NEAR         ; decode <Alt>nnn keys
                xor     bh,     bh
                mov     bl,     al
                push    cx
                mov     cl, BYTE PTR cs:[Map_AltASCII][bx-Key_Home]
                cmp     cl,      9
                ja      @BadCode
@GoodCode:      xor     ax,     ax
                mov     al,     BYTE PTR cs:[Alt_ASCII]
                mov     bl,     10
                mul     bl
                add     al,     cl
                mov     BYTE PTR cs:[Alt_ASCII], al
@BadCode:       pop     cx
                ret
DoAltASCII      ENDP

; - Set keyboard LEDs -----------------------------------------------------

; Note: calling this when unnecessary seems to cause the keyboard to belch 
;       out a lot of 0x7a bytes.

SetKeybdLED   PROC    NEAR
                push    ax
                mov     ah,     BYTE PTR cs:[KeybdFlags]
                IFDEF   __for286
                  shr   ah, 4
                ELSE
                  mov   cl, 4
                  shr   ah, cl
                ENDIF
                and     ah, 07h
                mov     al, 0edh
                out     Keybd0, al
@WaitClear0:    in      al, KeybdStatus 
                test    al, 02h
                jnz     @WaitClear0
                mov     al, ah
                out     Keybd0, al
                pop     ax
                ret
SetKeybdLED   ENDP

; - Secondary decoding routine (also does ASCII conversion) ---------------
; (this should probably be merged with the primary routine...)


ReCodeScan      PROC    NEAR
                push    si
                
                mov     ah,     al
                mov     bl,     al
                and     bl,     not ReleaseBit
                xor     bh,     bh
                
                mov     si,     OFFSET Map_Normal
                test    WORD PTR cs:[KeybdFlags], Flag_Shift
                jz      @NotShifted
                mov     si,     OFFSET Map_Shift
@NotShifted:
                test    WORD PTR cs:[KeybdFlags], Flag_Cntl
                jz      @NotCntl
                mov     si,     OFFSET Map_Cntl
                IFDEF   __STRICT
                  cmp   BYTE PTR cs:[si][bx], 0
                  jne   @CntlValid
                  JWITHIN bl, Key_Colon, Key_BackQuote, @CntlNotValid
                  JWITHIN bl, Key_Comma, Key_Slash, @CntlNotValid
                  cmp   bl, Key_Tab
                  ja    @CntlValid
                  cmp   bl, Key_Two
                  je    @CntlValid
 @CntlNotValid:   jmp   @IgnoreThis
 @CntlValid:
                ENDIF
@NotCntl:
                cmp     bl,     Key_Home
                jb      @NotKeyPad
                cmp     bl,     Key_Del
                ja      @NotKeyPad
                IFDEF   __ENHANCED  
                  test  WORD PTR cs:[InternFlags], Flag_PrefixE0
                  jnz   @NotKeyPad
                ENDIF
                test    WORD PTR cs:[KeybdFlags], Flag_RShift
                jnz     @NotKeyPad
                test    WORD PTR cs:[KeybdFlags], Flag_NumE
                jz      @NotKeyPad
                mov     si,     (OFFSET Map_NumLockadj)-47h
                IFDEF   __STRICT
;;                jmp   SHORT @GetASCII
                ENDIF
@NotKeyPad:     
                IFDEF   __STRICT
;;                jmp   SHORT @IgnoreThis
                ENDIF
@GetASCII:                
                test    WORD PTR cs:[KeybdFlags], Flag_Alt
                jz      @NotAlt
@ForceCode:               
                cmp     bl,     Key_One       ; below '1' key?
                IFDEF   __STRICT
                  jb    @IgnoreThis 
                ELSE
                  jb    @NotUpperRow
                ENDIF
                cmp     bl,     Key_EqualSign ; above '=' key?
                ja      @NotUpperRow
                add     ah,     118
 @NotUpperRow:  
                IFDEF   __STRICT
                  JWITHIN bl, Key_LtBracket, Key_Enter, @IgnoreThis
                  JWITHIN bl, Key_Colon, Key_BackSlash, @IgnoreThis
                  JWITHIN bl, Key_Comma, Key_Slash, @IgnoreThis
                ENDIF
                xor     al,     al
                jmp     @NotCaps
@NotAlt:
                mov     al,     BYTE PTR cs:[si][bx]
                test    WORD PTR cs:[KeybdFlags], Flag_CapsE
                jz      @NotCaps
                call    SwitchCharCase
@NotCaps:
@ExitReCode:                
                IFDEF   __ENHANCED
                  and WORD PTR cs:[InternFlags], not Flag_PrefixE0
                ENDIF
                pop     si
                IFDEF   __STRICT
                  clc
                ENDIF
                ret
                IFDEF   __STRICT
 @IgnoreThis:    
                 IFDEF   __ENHANCED
                   and WORD PTR cs:[InternFlags], not Flag_PrefixE0
                 ENDIF
                 pop     si
                 stc
                 ret
                ENDIF

ReCodeScan      ENDP

; Note: modification will be necessary to handle international character 
;       sets.

SwitchCharCase  PROC    NEAR
                cmp     al,     'a'
                jb      @NotLower
                cmp     al,     'z'
                ja      @NotLower
                sub     al,     20h
                ret
;               jmp     SHORT   @NoSwitch
@NotLower:      cmp     al,     'A'
                jb      @NotUpper
                cmp     al,     'Z'
                ja      @NotUpper
                add     al,     20h
@NotUpper:
@NoSwitch:      ret
SwitchCharCase  ENDP

; - Local procedure to put keycodes in queue ------------------------------
; Note: returns CF=0 if ok, CF=1, if buffer full. 

PutKey          PROC    NEAR              
                mov     bx,  WORD PTR cs:[QueueEnd]
                ROLLOVER
                cmp     bx,  WORD PTR cs:[QueueStart]
                jne     @BuffNotfull
                stc
                ret
 @BuffNotfull:  mov     bx,  WORD PTR cs:[QueueEnd]
                mov     WORD PTR cs:[KeyQueue][bx], ax
                ROLLOVER
                mov     WORD PTR cs:[QueueEnd], bx
                clc
                ret
PutKey          ENDP

            ENDIF 

; - Make sound on PC Speaker ----------------------------------------------
             
Beep         PROC       NEAR              ; added v1.3.3, RRWO
             pushf
             sti
             in         al,     KeybdCntl    
             test       al,     3
             jnz        @Clear1
             or         al,     3
             out        KeybdCntl, al
             mov        al,    0B6h
             out        TimerCntl, al
  @Clear1:   xor        al,     al      ; lo(Sound)
             out        Timer2, al
             mov        al,     02h     ; hi(Sound)
             out        Timer2, al
             push       es                       ; beep delay
             mov        ax,     44h              ; yep, it's a kludge but
             mov        es,     ax               ; calling PcTimer0 does
             mov        al,     BYTE PTR es:[00] ; not give consistent
             dec        al                       ; timings...
  @WaitMs:   cmp        al,     BYTE PTR es:[00]
             jne        @WaitMs
             pop        es
             in         al,     KeybdCntl
             and        al,     0FCh
             out        KeybdCntl, al
             popf
             ret
Beep         ENDP


             IFDEF __TSR
TSR_Marker      LABEL   BYTE
                DB      'An arbitrary TSR marker for KeyHand v1'
                DB      ' (c)1994 Robert Rothenburg Walking-Owl'
             ENDIF

; - The handler itself (well, sort of) ------------------------------------

NewKeybdISR   PROC    FAR
                pushf
               IFDEF    __for286 
                pusha                      ; save registers
               ELSE
                push    ax
                push    bx
                push    cx
               ENDIF 
               IF      RandPoolSize
                 call SampleNoise          ; sample noise for random pool
               ENDIF
                cli                        ; clear IF
                in      al,     Keybd0     ; get scan code
               IFDEF    __MULTIKEYMAP
                call    MarkKeyPress       ; map pressed keys
               ENDIF
               IFNDEF   __DONTDECODE 
                call    DeCodeScan         ; initial decoding of scan
                jnc     @IgnoreScan        ; if CF=1, ignore code
@ProcessScan:                
                test    cs:[InternFlags], InFl_8BitCode
                jz      @NormalScan        ; if 7-bit code, treat normally
                xor     al,     al         ; if 8-bit code, don't recode it
                jmp     SHORT @AddKey
  @NormalScan:
                test    ah,     ReleaseBit ; is key pressed or released?
                jnz     @IgnoreScan        ; if released, ignore
                call    ReCodeScan         ; recode to ASCII
                IFDEF   __STRICT
                  jc    @IgnoreScan        ; if CF=1, ignore code
                ENDIF
  @AddKey:                
                call    PutKey             ; add scan-code to queue
                jnc     @SuccessAdd
                call    Beep
  @SuccessAdd:
  @IgnoreScan:                             ; clear temporary flags
                and     WORD PTR cs:[InternFlags], not InFl_8BitCode
                cmp     BYTE PTR cs:[Alt_ASCII], 0  ; <Alt>nnn code waiting?
                jz      @NoCodeWaiting              ; if not, ignore
                test    WORD PTR cs:[KeybdFlags], Flag_Alt ; <Alt> key?
                jnz     @NoCodeWaiting              ; ignore until released
                xor     ax, ax                      ; scan = 00
                xchg    al, BYTE PTR cs:[Alt_ASCII] ; get <Alt>nnn code
                call    PutKey                      ; add scan-code to queue
@NoCodeWaiting:
              ENDIF
               mov     al, EndOfInterrupt           ; send end-of-interrupt
               out     PortCntl, al                 ; to controller
              IFDEF     __for286
                popa                                ; restore stack
              ELSE
                pop     cx
                pop     bx
                pop     ax
              ENDIF
                popf
                iret
NewKeybdISR   ENDP
                
        IFNDEF    __DONTDECODE
          INCLUDE Interfac.Inc        ; include interface routines
          IFDEF   __HOOKINT16
            INCLUDE Int16.Inc         ; include keyboard interrupt hooks
          ENDIF
         ENDIF

        IFDEF     __MULTIKEYMAP
          INCLUDE PressMap.Inc        ; include mapping routines
        ENDIF

        IF        RandPoolSize
          INCLUDE RandPool.Inc        ; include random-pool routines
        ENDIF

CODE              ENDS        
                  END         
