COMMENT |
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
| = A mini-handler for Int 16 =============================================

; Note: a possible "security" modification would be to use a different
;       interrupt for the keyboard (provided that appropriate programs
;       are modified to call the interrupt).

OldInt16Vector  LABEL   DWORD        ; old Int 16 vector (for uninstall)
                DD      (?)

NewInt16Handler PROC    FAR
                or      ah, ah       ; is it func. 00?
                jnz     @NF00        ;
  @FReadKey:    call    OurReadKey   ; yes: read a key
                iret                 ;
  @NF00:        cmp     ah, 01       ; is it func. 01?
                jne     @NF01        ;
  @FCheckKey:   call    OurCheckKey  ; yes: check queue
                ret     02           ; don't iret! (ZF used as a flag)
  @NF01:        cmp     ah, 02       ; is it func. 02?
                jne     @NF02
  @F02:         mov     al, BYTE PTR cs:[ KeybdFlags ] ; get 8-bit flags
                iret
  @NF02:
                IFDEF   __ENHANCED
                  cmp   ah, 10h      ; is it func. 10h?
                  je    @FReadKey    ; yes: go to ReadKey
                  cmp   ah, 11h      ; is it func. 11h?
                  je    @FCheckKey   ; yes: go to CheckKey
                  cmp   ah, 05       ; is it func. 05?
                  jne   @NF05
  @F05:           xchg  ax, cx       ; yes: switch ax and cx
                  push  bx           ; save bx
                  call  PutKey       ; put key on queue
                  pop   bx           ; restore bx
                  jc    @OF05        ; is CF=1 (buffer full)? (*)
                  xchg  ax, cx       ; if not, restore ax and cx
                  iret
  @OF05:          mov   al,  1       ; otherwise al=1 (error)
                  iret               ; return
  @NF05:
                ENDIF

                neg     ah           ; unrecognized function, set CF
                ret     02
NewInt16Handler ENDP
