%{
#include <string.h>

YY_CHAR current_letter = 0;
int started = 0;
int allow_para = 1;
int in_para = 0;

#define INTRO   1
#define WORKS   2
#define USE     3
#define LEXICON 4
#define APP_A   5
#define APP_B   6
#define APP_C   7
#define CONSTR  8

int section = 0;
int first_topic = 0;

char *legal_topic(char *);
char *list_name();
void end_topic();
void topic(char *, char *, char *);

#define PARAGRAPH       { if (allow_para) { printf(".PAR ALIGN JUSTIFY\n"); \
			  allow_para = 0; in_para = 1; } }
#define END_PARAGRAPH   { if (in_para) printf(".ENDPAR\n"); \
			  in_para = 0; }

%}

%%

\":\"|\"::\"|\"\{\"|\"\}\"|\"\{\{\"|\"\}\}\"|\{\ \}|\{seismo    ECHO;

^\n                     {
			  printf("\n");
			  END_PARAGRAPH;
			  allow_para = 1;
			}

^" "                    {
			  if (section != LEXICON)
			    allow_para = 0; /* C-Code or the like */
			  REJECT;
			}

^"    "                 {
			  if (section == LEXICON)
			    allow_para = 0; /* C-Code or the like */
			  REJECT;
			}

^"   "                  {
			  if (section != LEXICON) /* outside lexicon */
			    REJECT;
			}

^#=.*=#\n               {
			  if (!started) {
			    printf(".TOPIC OVERVIEW\n"
				   ".TITLE The Jargon File\n");
			    first_topic = 1;
			  } else
			    printf(".END-TOPIC\n");
			  started = 1;
			}

^":Introduction:\n"      {
			  end_topic();
			  section = INTRO;
			  topic("Introduction", NULL, NULL);
			}

^":How Jargon Works:\n"  {
			  end_topic();
			  section = WORKS;
			  topic("How Jargon Works", NULL, NULL);
			}

^":Jargon Construction:\n"       {
			  end_topic();
			  topic("Jargon Construction", NULL, list_name());
			  section = CONSTR;
			}
^":Hacker Writing Style:\n"      {
			  section = WORKS;
			  goto topic;
			}

^":How to Use the Lexicon:\n"    {
			  end_topic();
			  section = USE;
			  topic("Hot to Use the Lexicon", NULL, NULL);
			}

^"The Jargon Lexicon\n"  {
			  end_topic();
			  section = LEXICON;
			  topic("The Jargon Lexicon", NULL, NULL);
			}

^":(Lexicon Entries End Here):\n"        { /* End of Lexicon */
			  current_letter = 0;
			}

^":Appendix A: Hacker Folklore\n"        {
			  end_topic();
			  section = LEXICON;
			  topic("Appendix A: Hacker Folklore", "Appendix A", list_name());
			  section = APP_A;
			}

^":Appendix B: A Portrait of J. Random Hacker\n" {
			  end_topic();
			  section = LEXICON;
			  topic("Appendix B: A Portrait of J. Random Hacker", "Appendix B", list_name());
			  section = APP_B;
			}

^":Appendix C: Bibliography\n"   {
			  end_topic();
			  section = LEXICON;
			  topic("Appendix C: Bibliography", "Appendix C", list_name());
			  section = APP_C;
			}

^=\ .+\ =\n             {
			  yytext[yyleng-3] = '\0';
			  end_topic();
			  current_letter = legal_topic(yytext)[2];
			  printf(".TOPIC _%s_\n"
				 ".TITLE %s\n"
				 ".GROUPS LEXICON_LIST\n"
				 ".INSERT GROUP %c_LIST\n",
				 legal_topic(yytext+2),
				 yytext+2,
				 current_letter);
			}

^:[^:\n]+::?[ -]*[ \n]       {
			topic: {
			  int l = yyleng-2;
			  while (yytext[l] == '-')
			    yytext[l--] = '\0';
			  while (yytext[l] == ' ')
			    yytext[l--] = '\0';
			  while (yytext[l] == ':')
			    yytext[l--] = '\0';
			  end_topic();
			  printf(".TOPIC %s\n"
				 ".TITLE %s\n",
			  legal_topic(yytext+1), yytext+1);
			  if (section == LEXICON)
			    printf(".GROUPS %c_LIST\n",
				   current_letter);
			  else
			    printf(".GROUPS %s_LIST\n", list_name());
			} }

\{\{[^{}()\n]+\n?[^{}()\n]*\}\} {
			  int l;
			  PARAGRAPH;
			  l = strip_newline();
			  yytext[l-2] = '\0';
			  printf("~%s~%s~", yytext+2, legal_topic(yytext+2));
			}

\{[^{}()\n]+\n?[^{}()\n]*\}     {
			  int l;
			  PARAGRAPH;
			  l = strip_newline();
			  yytext[l-1] = '\0';
			  printf("~%s~%s~", yytext+1, legal_topic(yytext+1));
			}

=====+\n                {}

-----+\n                {}

^\*+\n                  {}

~                       printf("~~");

.                       {
			  PARAGRAPH;
			  printf("%c", *yytext);
			}

\n                      printf("\n");

%%

char *legal_topic(char *s)
{
  static char t[100];
  char *p = t;
  strcpy(t, s);
  for (p = t; *p; p++)
    if (!isalnum(*p))
      *p = '_';
  return t;
}

char *list_name()
{
  return section == INTRO ? "INTRO" :
	 section == WORKS ? "WORKS" :
	 section == CONSTR ? "CONSTR" :
	 section == USE ? "USE" :
	 section == LEXICON ? "LEXICON" :
	 section == APP_A ? "APP_A" :
	 section == APP_B ? "APP_B" :
	 section == APP_C ? "APP_C" :
	 section == CONSTR ? "CONTRUCT" : "GLOBAL";
}


void end_topic()
{
  END_PARAGRAPH;

  if (first_topic) {
    if (current_letter == 0)
      printf(".INSERT GROUP %s_LIST\n", list_name());
    first_topic = 0;
  }
				   
  printf(".END-TOPIC\n");
}

void topic(char *title, char *topic, char *list)
{
  if (list == NULL)
    list = "GLOBAL";
  if (topic == NULL)
    topic = title;
  printf(".TOPIC %s\n"
	 ".TITLE %s\n"
	 ".GROUPS %s_LIST\n",
	 legal_topic(topic), title, list);
  first_topic = 1;
}

int strip_newline()
{
  char *p;
  int len = yyleng;

  while ((p = strchr(yytext, '\n')) != NULL) {
    strcpy(p,p+3);
    len -= 3;
  }

  return len;
}

main()
{
  fprintf(stderr,
	  "\n\tjarg2hdk version 0.92 - Jargon file 3.0.0 to helpdk compiler\n"
	  "\t(C)opyright SaPiD Software by Soren Pingel Dalsgaard. Compiled on "__DATE__"\n\n");
  yylex();
  return 0;
}
