#include <dos.h>	/* for inportb() */
#include <stdio.h>	/* for standard i/o */

#include "uniinp.h"	/* tgd keyboard and joystick functions */

#define INP_ST1 0x03da	/* VGA port to query vertical retrace */

#define UNIKEY_ESC 1	/* uniinp keycode of ESC key */
#define UNIKEY_J 36	/* uniinp keycode of j key */
#define UNIKEY_K 37     /* uniinp keycode of k key */

void keyfind(void)
{ /* key states */
  const char keyreleased[]="RELEASED",keypressed[]="PRESSED ";
  const char *keyaction[2];
  /* last used key */
  ubyte key;

  /* init keystates */
  keyaction[0]=keyreleased; keyaction[1]=keypressed;

  printf("\n\n>>> uniinp keycode find selected <<<\n"
	 "now press the key(s) of which you want to know the\n"
	 "uniinp key code returned by uniinp's lastkey() function.\n"
	 "press 'ESC' (uniinp key code 01) to abort.\n\n");

  /* break on ESC */
  while ((key=lastkey())!=UNIKEY_ESC)
  { if (key) printf("last uniinp key code:  %3u   key status: %s\r",key,keyaction[keystatus(key)&1]);
  };
}

/* this procedure waits for the end of a vertical retrace */
void waitvret(void)
{
  while (!(inportb(INP_ST1)&8));
  while (inportb(INP_ST1)&8);
}

void joytest(void)
{ /* bitfield (indicates connected joysticks) */
  ubyte stickconnect=0;
  /* joystick positions */
  joypos *sticks;

  /* wait until user has released 'j' key */
  while (!lastkey());

  printf("\n\n>>> uniinp joystick test selected <<<\n"
	 "determining which joysticks are connected...\n");

  /* check if joystick #0 is connected */
  printf("joystick #0: ");
  /* it is not allowed to call readstick() during a vertical retrace
   * so wait for the end of one.
   */
  waitvret();
  if (readstick(1)) { printf("ok.\n"); stickconnect=1; }
  else { printf("not connected.\n"); };

  /* check if joystick #1 is connected */
  printf("joystick #1: ");
  /* it is not allowed to call readstick() during a vertical retrace
   * so wait for the end of one.
   */
  waitvret();
  if (readstick(2)) { printf("ok.\n"); stickconnect|=2; }
  else { printf("not connected.\n"); };

  if (!stickconnect) { printf("\nno joysticks connected."); return; };

  printf("\nnow querying joystick(s). press ANY key to abort.\n");
  while (!lastkey())
  { waitvret();
    if (stickconnect&1) { sticks=readstick(1); printf("x0:%3u  y0:%3u    ",sticks->joy0xpos,sticks->joy0ypos); };
    if (stickconnect&2) { sticks=readstick(2); printf("x1:%3u  y1:%3u    ",sticks->joy1xpos,sticks->joy1ypos); };
    printf("buttons:%3u",readjbutton()&0xf0);
    printf("\r");
  };
}

main()
{ /* last used key */
  ubyte key;

  printf("uniinp key code find / joystick test V1.0a\n"
	 "==========================================\n\n"
	 "please select input device to test: k)eyboard\n"
	 "                                    j)oystick\n"
	 "anything else aborts.");

  /* force keyboard to generate 'native' key scan codes */
  keyboardled(0);
  /* install uniinp keyboard handler */
  getkeyboard();

  /* wait for a selection */
  while (!(key=lastkey()));
  if (key==UNIKEY_K) keyfind();
  if (key==UNIKEY_J) joytest();

  /* re-install BIOS keyboard handler */
  freekeyboard();
  /* restore old BIOS keyboard LED state */
  keyboardled(sysled());

  printf("\n");
  return(0);
}
